<!DOCTYPE html>
<html>
    <head>
        <title>Stock Ledger</title>
    </head>
    <body>
    
        <div class="heading">
             <div class="logo col-6">
                <img src="images/pdf/logo.png">
            </div> 
            <div class="col-12 text-center" style="margin: 0 auto;">
                <h1><u>RACKWISE STOCK REPORT</u></h1>
            </div>
            <div class="col-12">
                    <div class="details-box">

                        <table class="table" style="width:100%">
                            <?php
                            if($part_no != ''){
                            ?>
                                <tr>
                                    <td><b>Part No</b></td>
                                    <td>
                                        <?php echo $part_no; ?>
                                    </td>
                                </tr>
                            <?php
                            }
                            ?>
                            <?php
                            if($warehouse >0){
                                $mod_ware= MasInventoryWarehouse::model()->findByPK($warehouse);
                                
                            ?>
                                <tr>
                                    <td><b>Warehouse</b></td>
                                    <td>
                                        <?php echo $mod_ware->warehouse_name; ?>
                                    </td>
                                </tr>
                            <?php
                            }
                            ?>
                            <?php
                            if($fromrack >0){
                                $mod_rac= MasInvRack::model()->findByPK($fromrack);
                                
                            ?>
                                <tr>
                                    <td><b>Rack</b></td>
                                    <td>
                                        <?php echo $mod_rac->name; ?>
                                    </td>
                                </tr>
                            <?php
                            }
                            ?>
                            <?php
                            if($brand_id != '') {
                                $modelBrand  = ProductClass::model()->findByPk($brand_id);
                            ?>
                                <tr>
                                    <td><b>Brand /Class</b></td>
                                    <td>
                                        <?php echo $modelBrand->product_class; ?>
                                    </td>
                                </tr>
                            <?php
                            }
                            ?>
                        </table>


                </div>
            </div>
        </div>
            
            
            
            <div class="panel">
   
    <div class="panel-body"> 
        <div class="table-responsive"> 
        
        <table id="tbl_inventory_table" class="table table-fixed table-bordered table-primary dataTable">
	<thead>
   		<tr>
   		<th>No</th>
                <th>Product</th>
                <th>Brand</th>
                <th>Description</th>
                <?php if(!($warehouse >0)){?>
                <th>Warehouse</th>
                <?php } ?>
                <th>Rack</th>
                <th>Quantity</th>
                </tr>
        </thead>
        <tbody>
                <?php 
                $model_location=new ProductLocation();
                 $condition = 'quantity >0  '; ;
                if($part_no != ''){                 
                    $condition .= ' AND S.part_number LIKE "%'.$part_no.'%" ';
                }
                if($warehouse >0){                 
                    $condition .= ' AND PL.warehouse_id='.$warehouse;
                }
                if($fromrack != ''){                 
                    $condition .= ' AND PL.rack_id="'.$fromrack.'"';
                }
                if($brand_id != ''){    
                    $condition .= ' AND S.brand_class_id="'.$brand_id.'"';
                }
                $condition .= ' AND S.inventory_item_type="1" AND PL.isActive="Y"';
                $sql='
                        SELECT S.brand_class_id,S.part_number,S.description,IFNULL(W.warehouse_name,"None") AS warehouse,IFNULL(R.name,"None") AS rack,IFNULL(SUM(PL.quantity),0)AS quantity 
                        FROM erp_product_location_details  PL
                        LEFT JOIN erp_store S
                        ON S.id=PL.product_id
                        LEFT JOIN erp_mas_inv_rack R
                        ON R.id=PL.rack_id
                        LEFT JOIN erp_mas_inv_warehouse W
                        ON W.id=PL.warehouse_id
                        WHERE '.$condition.'
                        GROUP BY PL.warehouse_id,PL.rack_id,PL.product_id
                        ';
                $model_location = Yii::app()->db->createCommand($sql)->queryAll();
                if(!empty($model_location)){
                foreach($model_location as $i=>$eachItem){
                    
                     $brand_class_id     = $eachItem['brand_class_id'];
                    $model_brand  = ProductClass::model()->findByPk( $brand_class_id);
                    
                    ?>
                    <tr>
                        <td><?php echo $i+1;?></td>
                        <td><?php echo $eachItem['part_number'];?></td>
                        <td><?php echo $model_brand['product_class']; ?></td>                        
                        <td> <?php echo $eachItem['description'];?></td>
                        <?php if(!($warehouse >0)){?>
                        <td> <?php echo $eachItem['warehouse'];?></td>
                        <?php } ?>
                        <td> <?php echo $eachItem['rack'];?></td>
                        <td class="text-right"> <?php echo number_format((float)$eachItem['quantity'], 2, '.', '');?></td>
                    </tr>
                    
                    
                <?php } }else{?>
                <tr>
                    <td colspan="5" class=" bg-total"><b>No Details Found</b></td>
                    <?php if(!($warehouse >0)){?>
                        <td class=" bg-total"></td>
                        <?php } ?>
                </tr>
                <?php } ?>
               
                       
        </tbody>
        </table>
          
        </div>
    </div>
    
</div>
