<?php

class ReportsController extends Controller {

    public function accessRules() {

        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'MasterReport', 'LoadMasterReportFilter',
//                    'PrintEnquiryReport', 'PrintEnquiryReportPDF'MasterReport, 'PrintEnquiryExcel', 'PrintEnquiryExcelId', 'PrintProposalReport',
//                    'PrintCustomerExcel', 'PrintCustomerReportPDF', 'PrintCustomerContactReportPDF', 'PrintProposalReportPDF', 'PrintProposalExcel',
//                    'PrintProjectReport', 'PrintActivityReport', 'PrintExpenseReport', 'PrintTimesheetReport','PrintCustomerReport', 'PrintCustomerContactReport'
//                    'PrintContractReportPDF','PrintMaterialRequest', 'PrintMaterialRequestReportPDF', 'PrintMaterialRequestExcel', 'PrintMaterialUsedRequest',
//                    'PrintMaterialUsedReportPDF', 'PrintMaterialUsedtExcel',
//                    'getSubledgerById', 'PrintServiceReportPDF', 'PrintServiceReport', 'PrintGroupServiceReportPDF', 'PrintGroupServiceReport',
//                    'PrintGroupServiceExcel', 'PrintGroupServiceExcelId',
                    'PrintLeadReport', 'PrintQuoteReport', 'PrintLeadExcel', 'PrintDeliveryReport', 'excelLeadList', 'PrintexcelLeadList', 'PrintDeliveryListExcel', 'PrintCreditnoteExcel',
                    'PrintOrderReport', 'PrintContractReport', 'PrintLeadReportPDF', 'PrintQuoteReportPDF', 'PrintOrderReportPDF', 'PrintexcelInvoiceList', 'PrintDirectsale',
                    'PrintQuoteExcel', 'PrintOrderExcel', 'PrintContractExcel', 'PrintServiceExcel', 'PrintNetsaleList', 'PrintGrossprofitList', 'CustomerbrandsaleExcel',
                    'PrintRegistrationInvoiceRequest', 'PrintInvoiceReport', 'PrintDeliveryReportPDF', 'Customersalesreport', 'Customernosalesreport',
                    'PrinRegistrationInvoiceReportPDF', 'PrintMaterialRegistrationInvoiceExcel', 'Report', 'PrintInvoiceExcel', 'PrintInvoiceReportPDF',
                    'PrintJobsheetOverwise', 'PrintOverViewReportPDF', 'PrintDailySchedule', 'PrintdailySchedulePDF', 'PrintTimeSchedule', 'PrintInventoryReport', 'PrintRequistionReportPDF',
                    'PrintCustomerReport', 'PrintCustomerContactReportPDF', 'PrintCustomerContactReport', 'PrintEnquiryReport', 'IndexReport', 'PrintCustomerReportPDF', 'PrintCustomerExcel',
                    'PrintInventoryReportPDF', 'PrintQuoteReport1', 'PrintGLReport', 'PrintGLStatementReport', 'PrintGLSummaryReport', 'Printexcelinvreport',
                    'PrintAgeingReport', 'report', 'PrintDayBook', 'PrintTrialBalance', 'PrintProfitLoss', 'PrintPurchaseOrderReport',
                    'PrintPurchaseOrderReportPDF', 'PrintPurchaseOrderPendingReport', 'PrintMaterialReceiptsReport',
                    'PrintInvoiceListReport', 'PrintPurchaseRegisterReport', 'PrintPurchaseDebitNotesReport', 'PrintPurchaseOrderPendingReportPDF',
                    'PrintMaterialReceiptsReportPDF', 'PrintInvoiceListReportPDF', 'PrintPurchaseRegisterReportPDF', 'PrintPurchaseDebitNotesReportPDF', 'PendingPurchaseDetail'
                    , 'SearchPurchaseOrderNo', 'PrintInventoryReceiveReport', 'PrintInventorytransferReceiveReportPDF',
                    'PrintDirectTransferReport', 'PrintDirectTransferReportPDF', 'PrintDamagedReport', 'PrintInTransistReport', 'PrintInTransistReportPDF'
                    , 'PrintCreditNoteReport', 'PrintNetSalesReport', 'PrintCreditNoteReportPDF', 'PrintNetSalesReportPDF', 'PrintVatSummary'
                    , 'PrintVatFinalSummary', 'PrintDirectSalesReport', 'PrintCustomerSalesReport', 'PrintCustomerSalesReportPDF',
                    'PrintCustomerNoSalesReport', 'PrintNoCustomerNoSalesReport', 'PrintListItemsOrdered', 'PrintCustomerBrandSalesReport', 'PrintGrossProfitReport', 'PrintUnInvoiceReport', 'PrintGrossProfitNew', 'PrintDirectSalesReportPDF', 'PrintGrossProfitReportPDF'
                    , 'PrintPurchaseOrderExcel', 'PrintPurchaseInvoiceExcel', 'PrintPurchaseMaterialReceiptsExcel', 'PrintPurchaseDebiteNoteExcel', 'PrintPurchaseOrderedListItemsExcel', 'PrintNetPurchaseExcel', 'PrintPurchaseRegisterExcel', 'PrintPurchaseOrderPendingExcel'
                    , 'PrintInventoryListExcel', 'PrintInventoryMinStockExcel', 'PrintCommissionIncentiveReport', 'PrintInvoiceCommissionIncentiveReport'
                ),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionIndex() {

//        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false );
        $frm = Yii::app()->request->getParam('frm');
        $this->render('master_report', array('frm' => $frm));
    }

    public function actionPrintGrossProfitNew() {

//        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false );
        $frm = Yii::app()->request->getParam('frm');
        $this->render('gross_profit_list', array('frm' => $frm));
    }

    public function actionIndexReport() {
        $report_from = Yii::app()->request->getParam('report_from');
        $pagetitle = Yii::app()->request->getParam('pagetitle');
        $id = Yii::app()->request->getParam('id');

        if ($id == 1) {
            $frm = $report_from;
            $title = 'Lead List';
        } else if ($id == 2) {
            $frm = $report_from;
            $title = 'Quotation List';
        } else if ($id == 3) {
            $frm = $report_from;
            $title = 'Order List';
        } else if ($id == 4) {
            $frm = $report_from;
            $title = 'Delivery Note List';
        } else if ($id == 5) {
            $frm = $report_from;
            $title = 'Invoice List';
        } else if ($id == 6) {
            $frm = $report_from;
            $title = 'Inventory List';
        }

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('master_report_1', array('frm' => $frm, 'title' => $title));
    }

//    public function actionMasterReport() {
//         Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
//        $this->render('master_report');
//    }
    public function actionReport() {
        $id = Yii::app()->request->getParam('id');
        if ($id == 1) {
            $frm = 'leadlist';
            $title = 'Lead List';
        } else if ($id == 2) {
            $frm = 'quotelist';
            $title = 'Quotation List';
        } else if ($id == 3) {
            $frm = 'orderlist';
            $title = 'Order List';
        } else if ($id == 4) {
            $frm = 'contractlist';
            $title = 'Contract List';
        } else if ($id == 5) {
            $frm = 'invoicelist';
            $title = 'Invoice List';
        }

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('master_report_1', array('frm' => $frm, 'title' => $title));
    }

    public function actionLoadMasterReportFilter() {
        $report_from = Yii::app()->request->getparam('report_from');

        if ($report_from == 'inventoryindirecttransferlist') {

            $this->renderPartial('//reports/filter_inventorytransferlist', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'directtransferlist') {

            $this->renderPartial('//reports/filter_directtransferlist', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'damagedlist') {

            $this->renderPartial('//reports/filter_damagedlist', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'intransistlist') {

            $this->renderPartial('//reports/filter_intransistlist', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'inventorystockledgerlist') {

            $this->renderPartial('//reports/filter_invstockledgerlist', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'inventoryreportlist') {

            $this->renderPartial('//reports/filter_invreportlist', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'inventoryledgerlist') {

            $this->renderPartial('//reports/filter_invledgerlist', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'inventorystockmovsummarylist') {

            $this->renderPartial('//reports/filter_invstockmovsummarylist', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'inventorystockmovhislist') {

            $this->renderPartial('//reports/filter_invstockmovhislist', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'inventorywarehouse') {

            $this->renderPartial('//reports/filter_invwarehouse', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'inventoryrack') {

            $this->renderPartial('//reports/filter_invrack', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'customerlist') {

            $this->renderPartial('//reports/filter_customerlist', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'customercontactlist') {

            $this->renderPartial('//reports/filter_customercontactlist', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'vendorlist') {

            $this->renderPartial('//reports/filter_vendorlist', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'vendorcontactlist') {

            $this->renderPartial('//reports/filter_vendorcontactlist', array('report_from' => $report_from), false, true);
        }

        if ($report_from == 'enquirylist') {

            $this->renderPartial('//reports/filter_enquirylist', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'leadlist') {

            $this->renderPartial('//reports/filter_leadlist', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'inventorylist') {

            $this->renderPartial('//reports/filter_inventorylist', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'quotelist') {

            $this->renderPartial('//reports/filter_quotelist', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'quotelist1') {

            $this->renderPartial('//reports/filter_quotelist1', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'orderlist') {

            $this->renderPartial('//reports/filter_orderlist', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'contractlist') {

            $this->renderPartial('//reports/filter_contractlist', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'invoicelist') {

            $this->renderPartial('//reports/filter_invoicelist', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'deliverynotelist') {

            $this->renderPartial('//reports/filter_deliverylist', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'projectdetailslist') {

            $this->renderPartial('//reports/filter_projectdetailslist', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'grossprofit') {

            $this->renderPartial('//reports/filter_grossprofit', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'gl_report') {

            $this->renderPartial('//reports/filter_gllist', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'gl_statement_report') {

            $this->renderPartial('//reports/filter_gl_statement_list', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'gl_summary') {

            $this->renderPartial('//reports/filter_gl_summary_list', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'ageing_report') {

            $this->renderPartial('//reports/filter_ageing_list', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'vat_report') {

            $this->renderPartial('//reports/filter_vat_report', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'vat_summary') {

            $this->renderPartial('//reports/filter_vat_summary', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'daybook_report') {

            $this->renderPartial('//reports/filter_daybook_list', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'trial_balance_report') {

            $this->renderPartial('//reports/filter_trial_balance', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'trial_balance_report_ex') {

            $this->renderPartial('//reports/filter_trial_balance_ex', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'profit_loss') {

            $this->renderPartial('//reports/filter_profit_loss', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'creditnotelist') {

            $this->renderPartial('//reports/filter_creditnotelist', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'directsaleslist') {

            $this->renderPartial('//reports/filter_directsaleslist', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'netsaleslist') {

            $this->renderPartial('//reports/filter_netsaleslist', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'purchaseorderlist') {

            $this->renderPartial('//reports/filter_purchaseorderlist', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'purchaseorderpendinglist') {

            $this->renderPartial('//reports/filter_purchaseorderpendinglist', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'materialreceiptslist') {

            $this->renderPartial('//reports/filter_materialreceiptslist', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'invoicereportlist') {

            $this->renderPartial('//reports/filter_purchaseinvoicelist', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'purchaseregisterlist') {

            $this->renderPartial('//reports/filter_purchaseregisterlist', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'purchasedebitnoteslist') {

            $this->renderPartial('//reports/filter_purchasedebitnoteslist', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'customersalereport') {

            $this->renderPartial('//reports/filter_customer_sales_report', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'customernosalereport') {

            $this->renderPartial('//reports/filter_customer_no_sales_report', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'item_to_order') {

            $this->renderPartial('//reports/filter_items_to_order', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'customeryearlybrandsalereport') {

            $this->renderPartial('//reports/filter_customer_brandsales_report', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'commissionincentive') {

            $this->renderPartial('//reports/filter_commissionincentive_list', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'invoicecommissionincentive') {

            $this->renderPartial('//reports/filter_invoicecommissionincentive', array('report_from' => $report_from), false, true);
        }
        if ($report_from == 'uninvoice_list') {

            $this->renderPartial('//reports/filter_uninvoice_list', array('report_from' => $report_from), false, true);
        }
    }

    public function actionPrintDeliveryReport() {

        $model = new DeliveryNote();

        $del_from_date = $_POST['del_from_date'];
        $del_to_date = $_POST['del_to_date'];
        // $type_of_contract = $_POST['type_of_contract'];
        $customer_id = $_POST['customer_id'];
        $sales_group_id = $_POST['sales_group_id'];
        $status = $_POST['status'];
        // $payment_terms = $_POST['payment_terms'];

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->render('//reports/print_delivery_list', array('model' => $model, 'del_from_date' => $del_from_date, 'del_to_date' => $del_to_date, 'sales_group_id' => $sales_group_id, 'customer_id' => $customer_id, 'status' => $status, 'title' => $title), false, true);
    }

    public function actionPrintDeliveryReportPDF() {

        $model = new DeliveryNote();

        $del_from_date = Yii::app()->request->getParam('del_from_date');
        $del_to_date = Yii::app()->request->getParam('del_to_date');
        $customer_id = Yii::app()->request->getParam('customer_id');
        $sales_group_id = $_GET["sales_group_id"]; //Yii::app()->request->getParam('sales_group_id');

        $status = Yii::app()->request->getParam('status');

//        $enquiry_id = Yii::app()->request->getParam('enquiry_id');

        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.deliverynote_list', array('model' => $model, 'del_from_date' => $del_from_date, 'del_to_date' => $del_to_date, 'sales_group_id' => $sales_group_id, 'status' => $status, 'customer_id' => $customer_id, 'title' => $title), true));

        $mPDF1->Output("DeliveryReport.pdf", 'I');
    }

    public function actionPrintInvoiceReport() {

        $model = new Invoice();

        $invoice_from_date = $_POST['invoice_from_date'];
        $invoice_to_date = $_POST['invoice_to_date'];
        // $type_of_contract = $_POST['type_of_contract'];
        $customer_id = $_POST['customer_id'];
        $sales_group = $_POST['sales_group'];
        $brand_id = $_POST['brand'];
        $product_id = $_POST['product_id'];

        $invoce_country = $_POST['invoce_country'];
        $invoce_location = $_POST['invoce_location'];

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->render('//reports/print_invoice_list', array('model' => $model, 'invoice_from_date' => $invoice_from_date, 'invoice_to_date' => $invoice_to_date, 'sales_group' => $sales_group,
            'customer_id' => $customer_id, 'product_id' => $product_id, 'brand_id' => $brand_id,
            'invoce_country' => $invoce_country, 'invoce_location' => $invoce_location, 'title' => $title), false, true);
    }

    public function actionPrintInvoiceReportPDF() {

        $model = new Invoice();

        $invoice_from_date = Yii::app()->request->getParam('invoice_from_date');
        $invoice_to_date = Yii::app()->request->getParam('invoice_to_date');
        $customer_id = Yii::app()->request->getParam('customer_id');
        $leadowner_id = Yii::app()->request->getParam('leadowner_id');
        $sales_group = Yii::app()->request->getParam('sales_group');
        //$payment_terms = Yii::app()->request->getParam('payment_terms'); 
        $invoce_country = Yii::app()->request->getParam('invoce_country');
        $invoce_location = Yii::app()->request->getParam('invoce_location');

//        $enquiry_id = Yii::app()->request->getParam('enquiry_id');

        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.invoice_list', array('model' => $model, 'sales_group' => $sales_group, 'invoice_from_date' => $invoice_from_date, 'invoice_to_date' => $invoice_to_date, 'sales_group' => $sales_group, 'customer_id' => $customer_id, 'leadowner_id' => $leadowner_id,
                    'invoce_country' => $invoce_country, 'invoce_location' => $invoce_location, 'title' => $title), true));

        $mPDF1->Output($htmlTemplate, 'I');
    }

    public function actionPrintInvoiceExcel() {

        $invoice_from_date = Yii::app()->request->getParam('invoice_from_date');
        $invoice_to_date = Yii::app()->request->getParam('invoice_to_date');
        $type_of_contract = Yii::app()->request->getParam('type_of_contract');
        $customer_id = Yii::app()->request->getParam('customer_id');
        $sales_group_id = Yii::app()->request->getParam('sales_group_id');
        $payment_terms = Yii::app()->request->getParam('payment_terms'); //print_r($payment_terms);die();

        $file = fopen("uploads/csvs/test.csv", "w");
        $criteria = new CDbCriteria;

        if (!empty($invoice_from_date)) {
            $invoice_from_date = str_replace('/', '-', $invoice_from_date);
            $invoice_from_date = date('Y-m-d', strtotime($invoice_from_date));
            $criteria->addCondition('t.invoice_date>="' . $invoice_from_date . '"', 'AND');
        }
        if (!empty($invoice_to_date)) {
            $invoice_to_date = str_replace('/', '-', $invoice_to_date);
            $invoice_to_date = date('Y-m-d', strtotime($invoice_to_date));
            $criteria->addCondition('t.invoice_date<="' . $invoice_to_date . '"', 'AND');
        }

        if (!empty($customer_id))
            $criteria->addCondition('t.customer_id="' . $customer_id . '"', 'AND');
        if (!empty($sales_group_id))
            $criteria->addCondition('t.sales_group_id="' . $sales_group_id . '"', 'AND');
        if ($payment_terms != '')
            $criteria->addCondition('t.payment_terms="' . $payment_terms . '"', 'AND');
        if (!empty($type_of_contract))
            $criteria->addCondition('t.type_of_contract="' . $type_of_contract . '"', 'AND');
//        print_r($criteria);
        $invoice = Invoice::model()->findAll($criteria); //print_r($invoice);die();
        $j = 0;

        $list[$j++] = 'No!Customer Name!Order Date!Currency!Net Amount!Grand Total!Sales Group!Payment Term!Type of Contract!Contact Name!Mobile!Email';

        foreach ($invoice as $i => $row) {
            if ($row->invoice_date != '0000-00-00') {
                $d1 = date("d/m/Y", strtotime($row->invoice_date));
            } else {
                $d1 = " ";
            }

            $list[$j++] = ($i + 1) . '!' . $row->customer->customer_name . '!' . $d1 . '!' . $row->currencyname->currency_code
                    . '!' . $row->net_amount . '!' . $row->grand_total . '!' . $row->salesgroup->group_name
                    . '!' . $row->paymentTerm->payment_term . '!' . $row->typedetail->service_group_name . '!' . $row->customercontact->person_name . '!' . $row->mobile . '!' . $row->email;
        }
        $j++;
        foreach ($list as $line) {
            fputcsv($file, explode('!', $line));
        }
        fclose($file);
        $filename = Yii::app()->getBaseUrl(true) . '/uploads/csvs/test.csv';
        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';
        header('Content-Type: application/csv');
        header("Content-disposition: attachment; filename=\"nittygritty_invoicelist.csv\"");
        readfile($filename);
        Yii::app()->end();
        return;
    }

    public function actionPrintPurchaseOrderReport() {

        $model = new PurchasingOrder();

        $order_from_date = $_POST['order_from_date'];
        $order_to_date = $_POST['order_to_date'];
        $vendor_id = $_POST['vendor_id'];
        $project_id = $_POST['project_id'];
        $completed = $_POST['completed'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->render('//reports/print_purchaseorder_list', array('model' => $model, 'order_from_date' => $order_from_date, 'order_to_date' => $order_to_date, 'project_id' => $project_id, 'vendor_id' => $vendor_id, 'completed' => $completed), false, true);
    }

    public function actionPrintOrderReport() {

        $model = new Order();

        $order_from_date = $_POST['order_from_date'];
        $delivery_from_date = $_POST['delivery_from_date'];
        $order_to_date = $_POST['order_to_date'];
        $delivery_to_date = $_POST['delivery_to_date'];
        $customer_id = $_POST['customer_id'];
        $sales_group = $_POST['sales_group'];
        $payment_terms = $_POST['payment_terms'];
        $type_of_contract = $_POST['type_of_contract'];
        $leadowner_id = $_POST['leadowner_id'];
        $leadowner_country = $_POST['ord_leadowner_country'];
        $brand = $_POST['brand'];
        $value_from = $_POST['value_from'];
        $value_to = $_POST['value_to'];
        $status = $_POST['status'];
        $probability = $_POST['probability'];

        $leadowner_country = $_POST['ord_leadowner_country'];
        $leadowner_location = $_POST['ord_leadowner_location'];
        $order_part_no_id = $_POST['order_part_no_id'];

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->render('//reports/print_order_list', array('model' => $model, 'leadowner_id' => $leadowner_id, 'order_from_date' => $order_from_date, 'delivery_from_date' => $delivery_from_date, 'order_to_date' => $order_to_date, 'delivery_to_date' => $delivery_to_date, 'sales_group' => $sales_group, 'payment_terms' => $payment_terms, 'type_of_contract' => $type_of_contract, 'customer_id' => $customer_id,
            'leadowner_country' => $leadowner_country, 'leadowner_location' => $leadowner_location, 'order_part_no_id' => $order_part_no_id,
            'brand' => $brand, 'value_from' => $value_from, 'value_to' => $value_to, 'status' => $status, 'probability' => $probability,
            'title' => $title), false, true);
    }

    public function actionPrintPurchaseOrderReportPDF() {

        $model = new Order();

        $order_from_date = Yii::app()->request->getParam('order_from_date');
        $order_to_date = Yii::app()->request->getParam('order_to_date');
        $vendor_id = Yii::app()->request->getParam('vendor_id');
        $project_id = Yii::app()->request->getParam('project_id');
        $completed = $_POST['completed'];

        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.purchaseorder_list', array('model' => $model, 'order_from_date' => $order_from_date, 'order_to_date' => $order_to_date, 'vendor_id' => $vendor_id, 'project_id' => $project_id, 'completed' => $completed), true));

        $mPDF1->Output($htmlTemplate, 'I');
    }

    public function actionPrintOrderReportPDF() {

        $model = new Order();

        $order_from_date = Yii::app()->request->getParam('order_from_date');
        $order_to_date = Yii::app()->request->getParam('order_to_date');
        $delivery_from_date = Yii::app()->request->getParam('delivery_from_date');
        $delivery_to_date = Yii::app()->request->getParam('delivery_to_date');
        $customer_id = Yii::app()->request->getParam('customer_id');
        $sales_group = Yii::app()->request->getParam('sales_group');
        $leadowner_id = Yii::app()->request->getParam('leadowner_id');
        $type_of_contract = Yii::app()->request->getParam('type_of_contract');

//        $enquiry_id = Yii::app()->request->getParam('enquiry_id');

        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.order_list', array('model' => $model, 'leadowner_id' => $leadowner_id, 'order_from_date' => $order_from_date, 'delivery_from_date' => $delivery_from_date, 'order_to_date' => $order_to_date, 'delivery_to_date' => $delivery_to_date, 'sales_group' => $sales_group, 'payment_terms' => $payment_terms, 'type_of_contract' => $type_of_contract, 'customer_id' => $customer_id, 'title' => $title), true));

        $mPDF1->Output("Orderlist.pdf", 'I');
    }

    public function actionPrintOrderExcel() {
        $order_from_date = Yii::app()->request->getParam('order_from_date');
        $order_to_date = Yii::app()->request->getParam('order_to_date');
        $delivery_from_date = Yii::app()->request->getParam('delivery_from_date');
        $delivery_to_date = Yii::app()->request->getParam('delivery_to_date');
        $customer_id = Yii::app()->request->getParam('customer_id');
        $sales_group = Yii::app()->request->getParam('sales_group');
        $payment_terms = Yii::app()->request->getParam('payment_terms');
        $type_of_contract = Yii::app()->request->getParam('type_of_contract');

        $file = fopen("uploads/csvs/test.csv", "w");
        $criteria = new CDbCriteria;

        if (!empty($order_from_date)) {
            $order_from_date = str_replace('/', '-', $order_from_date);
            $order_from_date = date('Y-m-d', strtotime($order_from_date));
            $criteria->addCondition('t.order_date>="' . $order_from_date . '"', 'AND');
        }
        if (!empty($order_to_date)) {
            $order_to_date = str_replace('/', '-', $order_to_date);
            $order_to_date = date('Y-m-d', strtotime($order_to_date));
            $criteria->addCondition('t.order_date<="' . $order_to_date . '"', 'AND');
        }




        $order = Order::model()->findAll($criteria);
        $j = 0;
        $list[$j++] = 'No!Order No!File No!Customer Name!Lead Owner!Order Date!Delivery Date!Sales Group!Currency!Grand Total!VAT!Grand Total(BC)';

        foreach ($order as $i => $row) {
            if ($row->order_date != '0000-00-00') {
                $d1 = date("d/m/Y", strtotime($row->order_date));
            } else {
                $d1 = " ";
            }
            if ($row->delivery_date != '0000-00-00') {
                $d2 = date("d/m/Y", strtotime($row->delivery_date));
            } else {
                $d2 = " ";
            }
            $model_currency = MasCurrency::model()->findByPk($row->currency);
            $total_bc = $row->grand_total * $model_currency->exchange_rate;
            $list[$j++] = ($i + 1) . '!' . $row->id . '!'
                    . $row->file_id . '!' . $row->customer->customer_name . '!' . $row->file->leadowner->first_name . " " . $row->file->leadowner->last_name . '!'
                    . $d1 . '!' . $d2 . '!'
                    . $row->salesgroup->group_name . '!' . $row->grand_total . '!' . $row->total_tax_amount . '!'
                    . $total_bc;
        }
        $j++;
        foreach ($list as $line) {
            fputcsv($file, explode('!', $line));
        }
        fclose($file);
        $filename = Yii::app()->getBaseUrl(true) . '/uploads/csvs/test.csv';
        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';
        header('Content-Type: application/csv');
        header("Content-disposition: attachment; filename=\"orderlist.csv\"");
        readfile($filename);
        Yii::app()->end();
        return;
    }

    public function actionPrintQuoteReport() {

        $model = new Quotes();
        $qtn_start_from_date = $_POST['start_from_date'];
        $qtn_start_to_date = $_POST['start_to_date'];
        $qtn_validity_from_date = $_POST['validity_from_date'];
        $qtn_validity_to_date = $_POST['validity_to_date'];
        $probability = $_POST['probability'];
        $exp_from_date = $_POST['exp_from_date'];
        $exp_to_date = $_POST['exp_to_date'];
        $customer_id = $_POST['customer_id'];
        $leadowner_id = $_POST['leadowner_id'];
        $sales_group = $_POST['sales_group'];

        $status = $_POST['status'];
        $qtn_country = $_POST['qtn_country'];
        $qtn_location = $_POST['qtn_location'];
        $qtn_part_no_id = $_POST['qtn_part_no_id'];
        $brand = $_POST['brand'];
        $value_from = $_POST['value_from'];
        $value_to = $_POST['value_to'];


        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->render('//reports/print_quote_list', array('model' => $model, 'probability' => $probability, 'qtn_start_from_date' => $qtn_start_from_date, 'qtn_start_to_date' => $qtn_start_to_date, 'exp_from_date' => $exp_from_date, 'exp_to_date' => $exp_to_date,
            'qtn_validity_from_date' => $qtn_validity_from_date, 'qtn_validity_to_date' => $qtn_validity_to_date, 'customer_id' => $customer_id, 'leadowner_id' => $leadowner_id, 'sales_group' => $sales_group, 'status' => $status,
            'qtn_country' => $qtn_country, 'qtn_location' => $qtn_location, 'qtn_part_no_id' => $qtn_part_no_id, 'brand' => $brand,
            'value_from' => $value_from, 'value_to' => $value_to, 'title' => $title), false, true);
    }

    public function actionPrintQuoteReport1() {

        $model = new Quotes();
        $description = $_POST['description'];
        $no_char = $_POST['no_char'];
        $start = $_POST['qtn_start_from_date'];
        $end = $_POST['qtn_start_to_date'];
        $customer_id = $_POST['customer_id'];
        $description1 = explode(',', $description);
        $no_char = explode(',', $no_char);
        $data1 = '';
        $des = '';
        $pre = '';
        foreach ($description1 as $i => $each) {
            $des_check = '';
            $length = $no_char[$i];
            $data = $_POST[$each];
            $des_check = $each;
            $des_check = str_replace("_", " ", $des_check);
            if (empty($data)) {
                if ($pre != '%') {
                    $data1.='%';
                }
                $pre = '%';
            } else {
                $data1.=$data;
                $pre = '';
                $len = strlen($data);
                if ($length > $len) {
                    $add = '';
                    $bal = $length - $len;
                    for ($j = 0; $j < $bal; $j++) {
                        $add.='X';
                    }
                    $data1.=$add;
                }
            }
        }
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->render('//reports/print_quote_list1', array('model' => $model, 'data' => $data1, 'start' => $start, 'end' => $end, 'customer_id' => $customer_id), false, true);
    }

    public function actionPrintQuoteReportPDF() {

        $model = new Quotes();

        $qtn_start_from_date = Yii::app()->request->getParam('qtn_start_from_date');
        $qtn_start_to_date = Yii::app()->request->getParam('qtn_start_to_date');
        $qtn_validity_from_date = Yii::app()->request->getParam('qtn_validity_from_date');
        $qtn_validity_to_date = Yii::app()->request->getParam('qtn_validity_to_date');
        $exp_from_date = Yii::app()->request->getParam('exp_from_date');
        $exp_to_date = Yii::app()->request->getParam('exp_to_date');
        $customer_id = Yii::app()->request->getParam('customer_id');
        $leadowner_id = Yii::app()->request->getParam('leadowner_id');
        $sales_group = Yii::app()->request->getParam('sales_group');
        $probability = Yii::app()->request->getParam('probability');
        //$type_of_contract = Yii::app()->request->getParam('type_of_contract');
        $status = Yii::app()->request->getParam('status');

//        $enquiry_id = Yii::app()->request->getParam('enquiry_id');

        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.quote_list', array('model' => $model, 'exp_from_date' => $exp_from_date, 'exp_to_date' => $exp_to_date, 'qtn_start_from_date' => $qtn_start_from_date, 'qtn_start_to_date' => $qtn_start_to_date, 'probability' => $probability, 'qtn_validity_from_date' => $qtn_validity_from_date, 'qtn_validity_to_date' => $qtn_validity_to_date, 'customer_id' => $customer_id, 'leadowner_id' => $leadowner_id, 'sales_group' => $sales_group, 'status' => $status, 'title' => $title), true));

        $mPDF1->Output("Quotelist.pdf", 'I');
    }

    public function actionPrintQuoteExcel() {
        $qtn_start_from_date = Yii::app()->request->getParam('qtn_start_from_date');
        $qtn_start_to_date = Yii::app()->request->getParam('qtn_start_to_date');
        $qtn_close_from_date = Yii::app()->request->getParam('qtn_close_from_date');
        $qtn_close_to_date = Yii::app()->request->getParam('qtn_close_to_date');
        $qtn_delivery_from_date = Yii::app()->request->getParam('qtn_delivery_from_date');
        $qtn_delivery_to_date = Yii::app()->request->getParam('qtn_delivery_to_date');
        $customer_id = Yii::app()->request->getParam('customer_id');
        $leadowner_id = Yii::app()->request->getParam('leadowner_id');
        $sales_group = Yii::app()->request->getParam('sales_group');
        $payment_terms = Yii::app()->request->getParam('payment_terms');
        $type_of_contract = Yii::app()->request->getParam('type_of_contract');
        $status = Yii::app()->request->getParam('status');

        $file = fopen("uploads/csvs/test.csv", "w");
        $criteria = new CDbCriteria;

        if (!empty($qtn_start_from_date)) {
            $qtn_start_from_date = str_replace('/', '-', $qtn_start_from_date);
            $qtn_start_from_date = date('Y-m-d', strtotime($qtn_start_from_date));
            $criteria->addCondition('t.qtn_start_date>="' . $qtn_start_from_date . '"', 'AND');
        }
        if (!empty($qtn_start_to_date)) {
            $qtn_start_to_date = str_replace('/', '-', $qtn_start_to_date);
            $qtn_start_to_date = date('Y-m-d', strtotime($qtn_start_to_date));
            $criteria->addCondition('t.qtn_start_date<="' . $qtn_start_to_date . '"', 'AND');
        }
        /*  if (!empty($qtn_close_from_date)) {
          $qtn_close_from_date = str_replace('/', '-', $qtn_close_from_date);
          $qtn_close_from_date = date('Y-m-d', strtotime($qtn_close_from_date));
          $criteria->addCondition('t.qtn_close_date>="' . $qtn_close_from_date . '"', 'AND');
          }
          if (!empty($qtn_close_to_date)) {
          $qtn_close_to_date = str_replace('/', '-', $qtn_close_to_date);
          $qtn_close_to_date = date('Y-m-d', strtotime($qtn_close_to_date));
          $criteria->addCondition('t.qtn_close_date<="' . $qtn_close_to_date . '"', 'AND');
          }
          if (!empty($qtn_delivery_from_date)) {
          $qtn_delivery_from_date = str_replace('/', '-', $qtn_delivery_from_date);
          $qtn_delivery_from_date = date('Y-m-d', strtotime($qtn_delivery_from_date));
          $criteria->addCondition('t.qtn_delivery_date>="' . $qtn_delivery_from_date . '"', 'AND');
          }
          if (!empty($qtn_delivery_to_date)) {
          $qtn_delivery_to_date = str_replace('/', '-', $qtn_delivery_to_date);
          $qtn_delivery_to_date = date('Y-m-d', strtotime($qtn_delivery_to_date));
          $criteria->addCondition('t.qtn_delivery_date<="' . $qtn_delivery_to_date . '"', 'AND');
          }
          if (!empty($customer_id))
          $criteria->addCondition('t.customer_id="' . $customer_id . '"', 'AND');
          if (!empty($sales_group))
          $criteria->addCondition('t.sales_group="' . $sales_group . '"', 'AND');
          if (!empty($leadowner_id))
          $criteria->addCondition('file.leadowner_id="' . $leadowner_id . '"', 'AND');
          if (!empty($status))
          $criteria->addCondition('t.status="' . $status . '"', 'AND');
         */


        $quote = Quotes::model()->with('file', 'customer', 'probability_details', 'customercontact', 'items.product')->findAll($criteria);
        $j = 0;

        $list[$j++] = 'No,File No,Company Name,Lead Owner,Quotation Date,Validity Date,Expected Order Date,Sales Group,Probability,Status,Currency,Grand Total(BC)';

        foreach ($quote as $i => $row) {
            if ($row->qtn_start_date != '0000-00-00') {
                $d1 = date("d/m/Y", strtotime($row->qtn_start_date));
            } else {
                $d1 = " ";
            }
            if ($row->qtn_close_date != '0000-00-00') {
                $d2 = date("d/m/Y", strtotime($row->qtn_close_date));
            } else {
                $d2 = " ";
            }
            if ($row->qtn_delivery_date != '0000-00-00') {
                $d3 = date("d/m/Y", strtotime($row->qtn_delivery_date));
            } else {
                $d3 = " ";
            }
            if ($row->qtn_validity != '0000-00-00') {
                $d4 = date("d/m/Y", strtotime($row->qtn_validity));
            } else {
                $d4 = " ";
            }
            if ($row->qtn_date != '0000-00-00') {
                $d5 = date("d/m/Y", strtotime($row->qtn_date));
            } else {
                $d5 = " ";
            }
            if ($row->expected_order_date != '0000-00-00') {
                $d6 = date("d/m/Y", strtotime($row->expected_order_date));
            } else {
                $d6 = " ";
            }
            if ($row->status == 'Y')
                $state = "Open";
            if ($row->status == 'C')
                $state = "Closed";
            if ($row->status == 'O')
                $state = "Others";
            if ($row->status == 'L')
                $state = "Lost";
            $model_currency = MasCurrency::model()->findByPk($row->currency);
            $total_bc = $row->grand_total * $model_currency->exchange_rate;
            $list[$j++] = ($i + 1) . ',' . $row->file_id . ',' . $row->customer->customer_name . ',' . $row->file->leadowner->first_name . " " . $row->file->leadowner->last_name
                    . ',' . $d5 . ',' . $d4 . ',' . $d6 . ',' . $row->salesgroup->group_name . ',' . $row->probability . ',' . $state . ',' . $row->currencyname->currency_code . ',' . $total_bc;
        }
        $j++;
        foreach ($list as $line) {
            fputcsv($file, explode(',', $line));
        }
        fclose($file);
        $filename = Yii::app()->getBaseUrl(true) . '/uploads/csvs/test.csv';
        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';
        header('Content-Type: application/csv');
        header("Content-disposition: attachment; filename=\"quotelist.csv\"");
        readfile($filename);
        Yii::app()->end();
        return;
    }

    public function actionPrintInventoryReport() {

        $model = new Store();
        $type = $_POST['type'];
        $part_number = $_POST['part_number'];
        $generic_name = $_POST['generic_name'];
        $tax_code = $_POST['tax_code'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->render('//reports/print_inventory_list', array('model' => $model, 'type' => $type, 'part_number' => $part_number, 'generic_name' => $generic_name, 'tax_code' => $tax_code, 'title' => $title), false, true);
    }

    public function actionPrintLeadReport() {

        $model = new Lead();
        $enq_from_date = $_POST['enq_from_date'];
        $enq_to_date = $_POST['enq_to_date'];
        $closing_from_date = $_POST['closing_from_date'];
        $closing_to_date = $_POST['closing_to_date'];
        $customer_id = $_POST['customer_id'];
        $status = $_POST['status'];
        $lead_owner_id = $_POST['leadowner_id'];
        $sales_group_id = $_POST['sales_group_id'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->render('//reports/print_lead_list', array('model' => $model, 'enq_from_date' => $enq_from_date, 'enq_to_date' => $enq_to_date, 'closing_from_date' => $closing_from_date, 'closing_to_date' => $closing_to_date, 'customer_id' => $customer_id, 'status' => $status, 'lead_owner_id' => $lead_owner_id, 'sales_group_id' => $sales_group_id, 'title' => $title), false, true);
    }

    public function actionPrintLeadReportPDF() {

        $model = new Lead();
        $enq_from_date = Yii::app()->request->getParam('enq_from_date');
        $enq_to_date = Yii::app()->request->getParam('enq_to_date');
        $closing_from_date = Yii::app()->request->getParam('closing_from_date');
        $closing_to_date = Yii::app()->request->getParam('closing_to_date');
        $customer_id = Yii::app()->request->getParam('customer_id');
        $status = Yii::app()->request->getParam('status');
        $lead_owner_id = Yii::app()->request->getParam('lead_owner_id');
        $sales_group_id = Yii::app()->request->getParam('sales_group_id');

//        $enquiry_id = Yii::app()->request->getParam('enquiry_id');

        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.lead_list', array('model' => $model, 'enq_from_date' => $enq_from_date, 'enq_to_date' => $enq_to_date, 'closing_from_date' => $closing_from_date, 'closing_to_date' => $closing_to_date, 'customer_id' => $customer_id, 'status' => $status, 'lead_owner_id' => $lead_owner_id, 'sales_group_id' => $sales_group_id, 'title' => $title), true));
        $mPDF1->Output('LeadList.pdf', 'I');
    }

    public function actionPrintInventoryReportPDF() {



        $model = new Store();
        $type = Yii::app()->request->getParam('type');

        $part_number = Yii::app()->request->getParam('part_number');
        $generic_name = Yii::app()->request->getParam('generic_name');
        $tax_code = Yii::app()->request->getParam('tax_code');

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $param = array('model' => $model, 'type' => $type, 'part_number' => $part_number, 'generic_name' => $generic_name, 'tax_code' => $tax_code, 'title' => $title);


        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.inventory_list', $param, true));
        $mPDF1->Output("InventoryReport.pdf", 'I');
    }

    public function actionPrintLeadExcel() {
        $enq_from_date = Yii::app()->request->getParam('enq_from_date');
        $enq_to_date = Yii::app()->request->getParam('enq_to_date');
        $closing_from_date = Yii::app()->request->getParam('closing_from_date');
        $closing_to_date = Yii::app()->request->getParam('closing_to_date');
        $customer_id = Yii::app()->request->getParam('customer_id');
        $status = Yii::app()->request->getParam('status');

        $file = fopen("uploads/csvs/test.csv", "w");
        $criteria = new CDbCriteria;

        if (!empty($enq_from_date)) {
            $enq_from_date = str_replace('/', '-', $enq_from_date);
            $enq_from_date = date('Y-m-d', strtotime($enq_from_date));
            $criteria->addCondition('t.enq_date>="' . $enq_from_date . '"', 'AND');
        }
        if (!empty($enq_to_date)) {
            $enq_to_date = str_replace('/', '-', $enq_to_date);
            $enq_to_date = date('Y-m-d', strtotime($enq_to_date));
            $criteria->addCondition('t.enq_date<="' . $enq_to_date . '"', 'AND');
        }
        if (!empty($closing_from_date)) {
            $closing_from_date = str_replace('/', '-', $closing_from_date);
            $closing_from_date = date('Y-m-d', strtotime($closing_from_date));
            $criteria->addCondition('t.closing_date>="' . $closing_from_date . '"', 'AND');
        }
        if (!empty($closing_to_date)) {
            $closing_to_date = str_replace('/', '-', $closing_to_date);
            $closing_to_date = date('Y-m-d', strtotime($closing_to_date));
            $criteria->addCondition('t.closing_date<="' . $closing_to_date . '"', 'AND');
        }
        if (!empty($customer_id))
            $criteria->addCondition('t.customer_id="' . $customer_id . '"', 'AND');
        if (!empty($status))
            $criteria->addCondition('t.status="' . $status . '"', 'AND');

        $lead = Lead::model()->findAll($criteria);
//          echo '<pre>'; print_r($criteria);
        $j = 0;

        $list[$j++] = 'No,Enquiry,Customer Name,Enquiry Date,Closing Date,Contact Name,Mobile,Email,Status';

        foreach ($lead as $i => $row) {
            if ($row->source_type_id == 1)
                $source = "Web";
            else if ($row->source_type_id == 2)
                $source = "Facebook";
            else if ($row->source_type_id == 3)
                $source = "Email";
            else if ($row->source_type_id == 4)
                $source = "Referral From Mouth";

            $list[$j++] = ($i + 1) . ',' . $row->title . ',' . $row->customer->customer_name . ',' . date_format(date_create($row->enq_date), 'd/m/Y') . ',' . date_format(date_create($row->closing_date), 'd/m/Y') . ',' . $row->file->leadowner->first_name . " " . $row->file->leadowner->last_name . ',' . $row->lead_reason . ',' . $row->salesgroup->group_name . ',' . $source . ',' . $row->lead_currency->currency_code . ',' . $row->amount . ',' . $row->probability->probability . ',' . $row->customercontact->person_name . ',' . $row->mobile1 . ',' . $row->email1;
        }
        $j++;
        foreach ($list as $line) {
            fputcsv($file, explode(',', $line));
        }
        fclose($file);
        $filename = Yii::app()->getBaseUrl(true) . '/uploads/csvs/test.csv';
        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';
        header('Content-Type: application/csv');
        header("Content-disposition: attachment; filename=\"nittygritty_leadlist.csv\"");
        readfile($filename);
        Yii::app()->end();
        return;
    }

    public function actionPrintCustomerReport() {

        $model = new Customer();

        $arr_customer_details['customer_name'] = $_POST['customer_name'];
        $arr_customer_details['country'] = $_POST['country'];
        $arr_customer_details['industry'] = $_POST['industry'];
        $arr_customer_details['create_from_date'] = $_POST['create_from_date'];
        $arr_customer_details['create_to_date'] = $_POST['create_to_date'];
        $arr_customer_details['update_from_date'] = $_POST['update_from_date'];
        $arr_customer_details['update_to_date'] = $_POST['update_to_date'];
        $arr_customer_details['customer_phoneno'] = $_POST['customer_phoneno'];
        $arr_customer_details['customer_email'] = $_POST['customer_email'];


        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->render('//reports/print_customer_list', array('model' => $model, 'customer_details' => $arr_customer_details, 'title' => $title, 'user' => $user), false, true);
    }

    public function actionPrintCustomerContactReport() {

        $model = new CustomerContact();

        $arr_customer_details['customer_name'] = $_POST['customer_name'];
        $arr_customer_details['country'] = $_POST['country'];
        $arr_customer_details['industry'] = $_POST['industry'];
        $arr_customer_details['create_from_date'] = $_POST['create_from_date'];
        $arr_customer_details['create_to_date'] = $_POST['create_to_date'];
        $arr_customer_details['update_from_date'] = $_POST['update_from_date'];
        $arr_customer_details['update_to_date'] = $_POST['update_to_date'];
        $arr_customer_details['customer_phoneno'] = $_POST['customer_phoneno'];
        $arr_customer_details['customer_email'] = $_POST['customer_email'];

//        $customer_country = $_POST['customer_country']; ,'customer_name'=>$customer_name,'customer_country'=>$customer_country      
        // print_r($arr_customer_details);
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->render('//reports/print_customercontact_list', array('model' => $model, 'customer_details' => $arr_customer_details, 'title' => $title), false, true);
    }

    public function actionPrintEnquiryReport() {

        $model = new PurchasingEnquiry();

        $enquiry_start_date = $_POST['enquiry_start_date'];

        $enquiry_end_date = $_POST['enquiry_end_date'];

        $enquiry_status = $_POST['enquiry_status'];

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->render('//reports/print_enquiry_list', array('model' => $model, 'enquiry_start_date' => $enquiry_start_date, 'enquiry_end_date' => $enquiry_end_date,
            'enquiry_status' => $enquiry_status, 'title' => $title), false, true);
    }

    public function actionPrintEnquiryReportPDF() {

        $model = new Enquiry();

        $enquiry_start_date = Yii::app()->request->getParam('enquiry_start_date');

        $enquiry_end_date = Yii::app()->request->getParam('enquiry_end_date');

        $enquiry_status = Yii::app()->request->getParam('enquiry_status');

        $enquiry_id = Yii::app()->request->getParam('enquiry_id');

        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mPDF1->WriteHTML($stylesheet, 1);

        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.enquiry_list', array('model' => $model, 'enquiry_id' => $enquiry_id, 'enquiry_start_date' => $enquiry_start_date, 'enquiry_end_date' => $enquiry_end_date, 'enquiry_status' => $enquiry_status, 'title' => $title), true));

        $mPDF1->Output($htmlTemplate, 'I');
    }

    public function actionPrintEnquiryExcel() {
        $start_date = Yii::app()->request->getParam('start_date');
        $end_date = Yii::app()->request->getParam('end_date');
        $status = Yii::app()->request->getParam('status');
        $file = fopen("uploads/csvs/test.csv", "w");
        $criteria = new CDbCriteria;

        if (!empty($start_date))
            $criteria->addCondition('t.enquiry_date>="' . $start_date . '"', 'AND');

        if (!empty($end_date))
            $criteria->addCondition('t.closing_date<="' . $end_date . '"', 'AND');

        $enquiry = Enquiry::model()->findAll($criteria);
        $j = 0;
        $list[$j++] = 'No,Enquiry,Customer Name,Contact Name,Mobile,Email,Enquiry Date,Closing Date';

        foreach ($enquiry as $i => $row) {
            $list[$j++] = ($i + 1) . ',' . $row->file_title . ',' . $row->customer->customer_name . ',' . $row->contact->person_name . ',' . $row->mobile_no . ',' . $row->email_id . ',' . date_format(date_create($row->enquiry_date), 'd/m/Y') . ',' . date_format(date_create($row->closing_date), 'd/m/Y');
        }
        $j++;
        foreach ($list as $line) {
            fputcsv($file, explode(',', $line));
        }
        fclose($file);
        $filename = Yii::app()->getBaseUrl(true) . '/uploads/csvs/test.csv';
        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';
        header('Content-Type: application/csv');
        header("Content-disposition: attachment; filename=\"enquiry.csv\"");
        readfile($filename);
        Yii::app()->end();
        return;
    }

    public function actionPrintexcelLeadList() {
        
        echo '**';
        
        /*
          $enq_from_date = Yii::app()->request->getParam('enq_from_date');
          $enq_to_date = Yii::app()->request->getParam('enq_to_date');
          $closing_from_date = Yii::app()->request->getParam('closing_from_date');
          $closing_to_date = Yii::app()->request->getParam('closing_to_date');
         
        $enq_from_date = Yii::app()->request->getParam('enq_from_date');
        $enq_to_date = Yii::app()->request->getParam('enq_to_date');
        $closing_from_date = Yii::app()->request->getParam('closing_from_date');
        $closing_to_date = Yii::app()->request->getParam('closing_to_date');
        $customer_id = Yii::app()->request->getParam('customer_id');
        $status = Yii::app()->request->getParam('status');
        $lead_owner_id = Yii::app()->request->getParam('lead_owner_id');
        $sales_group_id = Yii::app()->request->getParam('sales_group_id');

        $file = fopen("uploads/csvs/test.csv", "w");

        $condition = '1=1';
        ;
        if ($enq_from_date != '') {
            $enq_from_date = str_replace('/', '-', $enq_from_date);
            $enq_from_date = date('Y-m-d', strtotime($enq_from_date));
            $condition .= ' AND t.enq_date >="' . $enq_from_date . '"';
        }
        if ($enq_to_date != '') {
            $enq_to_date = str_replace('/', '-', $enq_to_date);
            $enq_to_date = date('Y-m-d', strtotime($enq_to_date));
            $condition .= ' AND t.enq_date <="' . $enq_to_date . '"';
        }
        if ($closing_from_date != '') {
            $closing_from_date = str_replace('/', '-', $closing_from_date);
            $closing_from_date = date('Y-m-d', strtotime($closing_from_date));
            $condition .= ' AND t.closing_date >="' . $closing_from_date . '"';
        }
        if ($closing_to_date != '') {
            $closing_to_date = str_replace('/', '-', $closing_to_date);
            $closing_to_date = date('Y-m-d', strtotime($closing_to_date));
            $condition .= ' AND t.closing_date <="' . $closing_to_date . '"';
        }
        if ($customer_id != '') {
            $condition .= ' AND t.customer_id ="' . $customer_id . '"';
        }
        if ($sales_group_id != '') {
            $condition .= ' AND t.sales_group_id ="' . $sales_group_id . '"';
        }

        if ($lead_owner_id != '') {
            $condition .= ' AND t.lead_owner_id ="' . $lead_owner_id . '"';
        }
        if ($status != '') {
            $condition .= ' AND t.status ="' . $status . '"';
        }
        $total = 0;
        //echo $condition;
        //die();
        $enquiry = Lead::model()->with('leadowner')->findAll(array('condition' => $condition));
        /*
          $criteria = new CDbCriteria;

          if (!empty($enq_from_date))
          $enq_from_date = str_replace('/', '-', $enq_from_date);
          $enq_from_date = date('Y-m-d', strtotime($enq_from_date));
          $criteria->addCondition('t.enq_date >="' . $enq_from_date . '"', 'AND');

          if (!empty($enq_to_date))
          $enq_to_date = str_replace('/', '-', $enq_to_date);
          $enq_to_date = date('Y-m-d', strtotime($enq_to_date));
          $criteria->addCondition('t.enq_date <="' . $enq_to_date . '"', 'AND');


          $enquiry = Lead::model()->with('leadowner')->findAll($criteria);
        /// * /
        $j = 0;
        $list[$j++] = 'No,Lead No,File No,Contact Name,Lead Owner,Enquiry Date,Closing Date,Sales Group,Currency,Value,Value(BC),';

        foreach ($enquiry as $i => $row) {
            $model_currency = MasCurrency::model()->findByPk($row->currency);
            $total_bc = $row->value * $model_currency->exchange_rate;
            $list[$j++] = ($i + 1) . ',' . $row->id . ',' . $row->file_id . ',' . $row->customer->customer_name . ',' . $row->leadowner->first_name . " " . $row->leadowner->last_name . ',' . date("d/m/Y", strtotime($row->enq_date)) . ',' . date("d/m/Y", strtotime($row->closing_date)) .
                    ',' . $row->salesgroup->group_name . ',' . $row->currencyname->currency_code . ',' . $row->value . ',' . $total_bc;
        }
        $j++;

        foreach ($list as $line) {
            fputcsv($file, explode(',', $line));
        }
        fclose($file);
        $filename = Yii::app()->getBaseUrl(true) . '/uploads/csvs/test.csv';
        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';
        header('Content-Type: application/csv');
        header("Content-disposition: attachment; filename=\"customer_enquiry.csv\"");
        readfile($filename);
        Yii::app()->end();
        return;
        */
    }

    public function actionPrintEnquiryExcelId() {

        $enquiry_id = Yii::app()->request->getParam('enquiry_id');
        $start_date = Yii::app()->request->getParam('start_date');
        $end_date = Yii::app()->request->getParam('end_date');
        $status = Yii::app()->request->getParam('status');
        $file = fopen("uploads/csvs/test.csv", "w");

        $criteria = new CDbCriteria;

        if (!empty($enquiry_id))
            $criteria->addCondition('t.id=' . $enquiry_id, 'AND');

        if (!empty($start_date))
            $criteria->addCondition('t.enquiry_date<=' . $start_date, 'AND');

        if (!empty($end_date))
            $criteria->addCondition('t.closing_date>=' . $end_date, 'AND');

        $enquiry = Enquiry::model()->findAll($criteria);
        $j = 0;
        $list[$j++] = 'No,Enquiry,Customer Name,Contact Name,Mobile,Email,Enquiry Date,Closing Date';

        foreach ($enquiry as $i => $row) {
            $list[$j++] = ($i + 1) . ',' . $row->file_title . ',' . $row->customer->customer_name . ',' . $row->contact->person_name . ',' . $row->mobile_no . ',' . $row->email_id . ',' . date_format(date_create($row->enquiry_date), 'd/m/Y') . ',' . date_format(date_create($row->closing_date), 'd/m/Y');
        }
        $j++;

        foreach ($list as $line) {
            fputcsv($file, explode(',', $line));
        }
        fclose($file);
        $filename = Yii::app()->getBaseUrl(true) . '/uploads/csvs/test.csv';
        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';
        header('Content-Type: application/csv');
        header("Content-disposition: attachment; filename=\"customer_enquiry.csv\"");
        readfile($filename);
        Yii::app()->end();
        return;
    }

    public function actionPrintCustomerContactReportPDF() {
        $model = new CustomerContact();


        $arr_customer_details['customer_name'] = $_GET['customer_details']['customer_name'];
        $arr_customer_details['country'] = $_GET['customer_details']['country'];
        $arr_customer_details['industry'] = $_GET['customer_details']['industry'];
        $arr_customer_details['create_from_date'] = $_GET['customer_details']['create_from_date'];
        $arr_customer_details['create_to_date'] = $_GET['customer_details']['create_to_date'];
        $arr_customer_details['update_from_date'] = $_GET['customer_details']['update_from_date'];
        $arr_customer_details['update_to_date'] = $_GET['customer_details']['update_to_date'];
        $arr_customer_details['customer_phoneno'] = $_GET['customer_details']['customer_phoneno'];
        $arr_customer_details['customer_email'] = $_GET['customer_details']['customer_email'];

        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.customercontact_list', array('model' => $model, 'customer_details' => $arr_customer_details, 'title' => $title), true));
        $mPDF1->Output($htmlTemplate, 'I');
    }

    public function actionPrintCustomerReportPDF() {
        $model = new Customer();
//        $customer_name = Yii::app()->request->getParam('customer_name');
//        $country = Yii::app()->request->getParam('country');
        //print_r($_GET['customer_details']);
        //die();

        $arr_customer_details['customer_name'] = $_GET['customer_details']['customer_name'];
        $arr_customer_details['country'] = $_GET['customer_details']['country'];
        $arr_customer_details['industry'] = $_GET['customer_details']['industry'];
        $arr_customer_details['create_from_date'] = $_GET['customer_details']['create_from_date'];
        $arr_customer_details['create_to_date'] = $_GET['customer_details']['create_to_date'];
        $arr_customer_details['update_from_date'] = $_GET['customer_details']['update_from_date'];
        $arr_customer_details['update_to_date'] = $_GET['customer_details']['update_to_date'];
        $arr_customer_details['customer_phoneno'] = $_GET['customer_details']['customer_phoneno'];
        $arr_customer_details['customer_email'] = $_GET['customer_details']['customer_email'];

        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.customer_list', array('model' => $model, 'customer_details' => $arr_customer_details, 'title' => $title), true));
        $mPDF1->Output($htmlTemplate, 'I');
    }

    public function actionPrintCustomerExcel() {
        $customer_name = Yii::app()->request->getParam('customer_name');
        $country = Yii::app()->request->getParam('country');
        $file = fopen("uploads/csvs/test.csv", "w");
        $criteria = new CDbCriteria;
        if (!empty($customer_name))
            $criteria->addCondition('t.customer_name like "%' . $customer_name . '%"', 'AND');

        if (!empty($country))
            $criteria->addCondition('t.customer_country ="' . $country . '"', 'AND');

        $customer = Customer::model()->with('country')->findAll($criteria);
        $j = 0;
        $list[$j++] = 'No/Customer Name/Credit Limit/Address/City/Postal Code/State/Country';

        foreach ($customer as $i => $row) {
            $list[$j++] = ($i + 1) . '/' . $row->customer_name . '/' . $row->customer_credit_limit . '/' . $row->customer_address . '/' . $row->customer_city . '/' . $row->customer_postal_code . '/' . $row->customer_state . '/' . $row->country->country_name;
        }

        $j++;

        foreach ($list as $line) {
            fputcsv($file, explode('/', $line));
        }

        fclose($file);

        $filename = Yii::app()->getBaseUrl(true) . '/uploads/csvs/test.csv';

        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';

        header('Content-Type: application/csv');

        header("Content-disposition: attachment; filename=\"customer.csv\"");

        readfile($filename);

        Yii::app()->end();

        return;
    }

    public function actionPrintRegistrationInvoiceRequest() {


        $model = new RegistrationInvoice();

        $invoice_no = $_POST['invoice_no'];
        $invoice_start_date = $_POST['invoice_start_date'];
        $invoice_end_date = $_POST['invoice_end_date'];
        $customer_id = $_POST['customer_id'];
        $payment_terms = $_POST['payment_terms'];

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->render('//reports/print_registration_invoice_list', array(
            'model' => $model,
            'invoice_no' => $invoice_no,
            'invoice_start_date' => $invoice_start_date,
            'invoice_end_date' => $invoice_end_date,
            'customer_id' => $customer_id,
            'payment_terms' => $payment_terms,
            'title' => $title), false, true);
    }

    public function actionPrinRegistrationInvoiceReportPDF() {

        $model = new RegistrationInvoice();

        $invoice_no = Yii::app()->request->getParam('invoice_no');
        $invoice_start_date = Yii::app()->request->getParam('invoice_start_date');
        $invoice_end_date = Yii::app()->request->getParam('invoice_end_date');
        $customer_id = Yii::app()->request->getParam('customer_id');
        $payment_terms = Yii::app()->request->getParam('payment_terms');


        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mPDF1->WriteHTML($stylesheet, 1);

        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.material_registration_invoice_list', array('model' => $model,
                    'invoice_no' => $invoice_no,
                    'invoice_start_date' => $invoice_start_date,
                    'invoice_end_date' => $invoice_end_date,
                    'customer_id' => $customer_id,
                    'payment_terms' => $payment_terms,
                    'title' => $title), true));

        $mPDF1->Output($htmlTemplate, 'I');
    }

    public function actionPrintMaterialRegistrationInvoiceExcel() {
        $customer_id = Yii::app()->request->getParam('customer_id');
        $invoice_start_date = Yii::app()->request->getParam('invoice_start_date');
        $invoice_end_date = Yii::app()->request->getParam('invoice_end_date');
        $invoice_no = Yii::app()->request->getParam('invoice_no');
        $payment_terms = Yii::app()->request->getParam('payment_terms');

        $file = fopen("uploads/csvs/test.csv", "w");

        $condition = '1=1';
        if ($customer_id != '') {
            $condition .= ' AND t.customer_id ="' . $customer_id . '"';
        }
        if ($invoice_start_date != '') {
            $invoice_start_date = str_replace('/', '-', $invoice_start_date);
            $invoice_start_date = date('Y-m-d', strtotime($invoice_start_date));
            $condition .= ' AND t.invoice_date >="' . $invoice_start_date . '"';
        }
        if ($invoice_end_date != '') {
            $invoice_end_date = str_replace('/', '-', $invoice_end_date);
            $invoice_end_date = date('Y-m-d', strtotime($invoice_end_date));
            $condition .= ' AND t.invoice_date <="' . $invoice_end_date . '"';
        }
        if ($invoice_no != '') {
            $condition .= ' AND t.file_id ="' . $invoice_no . '"';
        }
        if ($payment_terms != '') {
            $condition .= ' AND t.payment_terms ="' . $payment_terms . '"';
        }


        $model_registration_invoice = RegistrationInvoice::model()->findAll(array('condition' => $condition));

        $j = 0;
        $list[$j++] = 'No,File No,Customer Name,Invoice Date,Payment Term,Grand Total';

        foreach ($model_registration_invoice as $i => $row) {
            $list[$j++] = ($i + 1) . ',' . $row->file_id . ',' . $row->customers->customer_name . ',' . $row->invoice_date . ',' . $row->paymentname->payment_term . ',' . $row->grand_total;
        }
        $j++;
        foreach ($list as $line) {
            fputcsv($file, explode(',', $line));
        }
        fclose($file);
        $filename = Yii::app()->getBaseUrl(true) . '/uploads/csvs/test.csv';
        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';
        header('Content-Type: application/csv');
        header("Content-disposition: attachment; filename=\"material_Registration_Invoice.csv\"");
        readfile($filename);
        Yii::app()->end();
        return;
    }

    public function actionPrintGLReport() {
        $account_no = $_REQUEST['ledger_id'];
        $company_id = $_REQUEST['subledger_id'];
        $rp_from_date = $_REQUEST['from_date'];
        $rp_to_date = $_REQUEST['to_date'];
        $rp_from_date = str_replace('/', '-', $rp_from_date);
        $rp_from_date = date("Y-m-d", strtotime($rp_from_date));
        $rp_to_date = str_replace('/', '-', $rp_to_date);
        $rp_to_date = date("Y-m-d", strtotime($rp_to_date));
        $item_type = $_REQUEST['item_type'];
        $item_id = $_REQUEST['item_id'];
        ini_set("memory_limit", "-1");
//        ini_set('max_execution_time', 1000);


        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $mPDF1->SetWatermarkImage(Yii::app()->baseUrl . '/images/logo/200150_' . MasCompany::model()->findbyPK(Yii::app()->user->master_user_company_id)->company_logo);
        $mPDF1->showWatermarkImage = true;
        $mPDF1->watermarkImageAlpha = 0.09;
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_for_list.css');

        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial("application.views.front.pdf.generalledger", array('account_no' => $account_no, 'company_id' => $company_id, 'date_from' => $rp_from_date, 'date_to' => $rp_to_date, 'item_id' => $item_id, 'item_type' => $item_type), true));
        $mPDF1->Output('GL Report.pdf', 'I');
    }

    public function actionPrintGLStatementReport() {
        $date = str_replace('/', '-', $_REQUEST['statement_start_date']);
        $searchstartdate = date("Y-m-d", strtotime($date));
        $searchstartdate = '2015-01-01';
        $date1 = str_replace('/', '-', $_REQUEST['to_date']);
        $searchenddate = date("Y-m-d", strtotime($date1));
        $company_id = $_REQUEST['subledger_id'];
        $account_id = $_REQUEST['ledger_id'];
        if ($searchstartdate == null) {
            $searchstartdate = date('Y') . '-01-01';
        }
        if ($searchenddate == null) {
            $searchenddate = date('Y') . '-12-31';
        }
        if (!empty($company_id) && !empty($searchstartdate) && !empty($searchenddate) && !empty($account_id)) {
            $rp_to_date = $_POST['rp_to_date'];
            ini_set("memory_limit", "-1");
            $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
            $mPDF1->SetWatermarkImage(Yii::app()->baseUrl . '/images/logo/200150_' . MasCompany::model()->findbyPK(Yii::app()->user->master_user_company_id)->company_logo);
            $mPDF1->showWatermarkImage = true;
            $mPDF1->watermarkImageAlpha = 0.09;
            $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_for_single.css');
            $mPDF1->WriteHTML($stylesheet, 1);

            $mPDF1->WriteHTML($this->renderPartial("application.views.front.pdf.statement_of_account", array('subledger' => $company_id, 'date_to' => $searchenddate, 'date_from' => $searchstartdate, 'account' => $account_id), true));
            $mPDF1->Output('Statement.pdf', 'I');
        } else {
            echo "Please Select Account";
        }
    }

    public function actionPrintGLSummaryReport() {
        $account_no = $_REQUEST['ledger_id'];
        if ($account_no == 'value') {
            $account_no = "";
        }
        if ($account_no != '') {
            $rp_to_date = $_REQUEST['to_date'];
            $rp_to_date = str_replace('/', '-', $rp_to_date);
            $rp_to_date = date("Y-m-d", strtotime($rp_to_date));
            ini_set("memory_limit", -1);
            ini_set('max_execution_time', 1000);
            $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
            $mPDF1->SetWatermarkImage(Yii::app()->baseUrl . '/images/logo/200150_' . MasCompany::model()->findbyPK(Yii::app()->user->master_user_company_id)->company_logo);
            $mPDF1->showWatermarkImage = true;
            $mPDF1->watermarkImageAlpha = 0.09;
            $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_for_single.css');
            $mPDF1->WriteHTML($stylesheet, 1);

            $mPDF1->WriteHTML($this->renderPartial("application.views.front.pdf.generalledger_summary", array('account_no' => $account_no, 'date_to' => $rp_to_date), true));
            $mPDF1->Output('GL Summary.pdf', 'I');
        } else {
            echo "Please Select Account";
        }
    }

    public function actionPrintAgeingReport() {
        $date1 = str_replace('/', '-', $_REQUEST['to_date']);
        $searchenddate = date("Y-m-d", strtotime($date1));
        $company_id = (int) $_REQUEST['subledger_id'];
        $account_id = $_REQUEST['ledger_id'];
        if ($searchenddate == null) {
            $searchenddate = date('Y-m-d');
        }
        if (!empty($searchenddate) && !empty($account_id)) {
            if (!empty($company_id)) {
                $opening_bal = FinOpeningBalance::model()->find(array('condition' => 'account_id=' . $company_id . ' AND mainacc=' . $account_id));
                $trs = array();
                $tds = array();
                $total_amt = 0;
                $total_pend = 0;
                $total_columns = 11;
                $pend1 = 0;
                $pend2 = 0;
                $pend3 = 0;
                $pend4 = 0;
                $pend5 = 0;
                $pend6 = 0;
                $pend7 = 0;
                $tot_pend = 0;
                $trs[] = '<tr>
                            <th width="15%" class="bgblack">Ledger Name</th>
                            <th width="10%"> 0-30 Days</th>
                            <th width="10%"> 31-60 Days</th>
                            <th width="10%"> 61-90 Days</th>
                            <th width="10%"> 91-120 Days</th>
                            <th width="10%"> 121-150 Days</th>
                            <th width="10%"> 151-180 Days</th>
                            <th width="10%"> >180 Days</th>
                            <th width="10%">Total</th>
                        </tr>';

                $no_days_30 = date('Y-m-d', strtotime($searchenddate . ' -30 day'));
                $no_days_60 = date('Y-m-d', strtotime($searchenddate . ' -60 day'));
                $no_days_90 = date('Y-m-d', strtotime($searchenddate . ' -90 day'));
                $no_days_120 = date('Y-m-d', strtotime($searchenddate . ' -120 day'));
                $no_days_150 = date('Y-m-d', strtotime($searchenddate . ' -150 day'));
                $no_days_180 = date('Y-m-d', strtotime($searchenddate . ' -180 day'));
                Yii::app()->db->createCommand("TRUNCATE TABLE ageing")->execute();
                $SQL11 = "INSERT INTO ageing (SELECT A.id,A.subledger,A.date,A.voucher_no,A.debit,A.credit,(A.debit-sum(B.debit_allocate_amount)) as db,(A.credit-sum(B.credit_allocate_amount)) as cr FROM `crm_fin_general_ledger` A left join crm_fin_voucher_allocation B ON A.id=B.invoice_id where A.account_id=$account_id AND A.isAllocated='Y' AND (A.date between '2014-01-01' AND '$searchenddate') AND (B.allocate_date between '2014-01-01' AND '$searchenddate') group by B.invoice_id) UNION (SELECT A.id,A.subledger,A.date,A.voucher_no,A.debit,A.credit,(A.debit) as db,(A.credit) as cr FROM `crm_fin_general_ledger` A left join crm_fin_voucher_allocation B ON A.id=B.invoice_id where A.account_id=$account_id AND A.isAllocated='Y' AND (A.date between '2014-01-01' AND '$searchenddate') AND (B.allocate_date NOT between '2014-01-01' AND '$searchenddate') group by A.id) UNION (SELECT id,subledger,date,voucher_no,debit,credit,debit as db,credit as cr from crm_fin_general_ledger  where account_id=$account_id AND allocation_amount =0 AND isAllocated='Y' AND (date between '2014-01-01' AND '$searchenddate')) order by date ASC";
                Yii::app()->db->createCommand($SQL11)->execute();
                Yii::app()->db->createCommand("CREATE OR REPLACE VIEW ss AS select * from ageing group by invoice_id order by db DESC,cr DESC")->execute();
                $SQL1 = "select subledger,sum(db)-sum(cr) as amt from ss where date >= '$no_days_30' AND subledger like '$company_id'";
                $arr_sum_amount1 = Yii::app()->db->createCommand($SQL1)->queryAll();
                $SQL2 = "select subledger,sum(db)-sum(cr) as amt from ss where date >= '$no_days_60' AND date < '$no_days_30' AND subledger=$company_id";
                $arr_sum_amount2 = Yii::app()->db->createCommand($SQL2)->queryAll();
                $SQL3 = "select subledger,sum(db)-sum(cr) as amt from ss where date >= '$no_days_90' AND date < '$no_days_60' AND subledger=$company_id";
                $arr_sum_amount3 = Yii::app()->db->createCommand($SQL3)->queryAll();
                $SQL4 = "select subledger,sum(db)-sum(cr) as amt from ss where date >= '$no_days_120' AND date < '$no_days_90' AND subledger=$company_id";
                $arr_sum_amount4 = Yii::app()->db->createCommand($SQL4)->queryAll();
                $SQL5 = "select subledger,sum(db)-sum(cr) as amt from ss where date >= '$no_days_150' AND date < '$no_days_120' AND subledger=$company_id";
                $arr_sum_amount5 = Yii::app()->db->createCommand($SQL5)->queryAll();
                $SQL6 = "select subledger,sum(db)-sum(cr) as amt from ss where date >= '$no_days_180' AND date < '$no_days_150' AND subledger=$company_id";
                $arr_sum_amount6 = Yii::app()->db->createCommand($SQL6)->queryAll();
                $SQL7 = "select subledger,sum(db)-sum(cr) as amt from ss where date < '$no_days_180' AND subledger=$company_id";
                $arr_sum_amount7 = Yii::app()->db->createCommand($SQL7)->queryAll();
                $total_inv_amnt = 0;
                $total_pend_amnt = 0;
                $tot = 0;
                $due1 = 0;
                $due2 = 0;
                $due3 = 0;
                $due4 = 0;
                $due5 = 0;
                $due6 = 0;
                $due7 = 0;
                foreach ($arr_sum_amount1 as $eachInvoice1) {
                    $due1+=$eachInvoice1['amt'];
                }
                foreach ($arr_sum_amount2 as $eachInvoice2) {
                    $due2 = $eachInvoice2['amt'];
                }
                foreach ($arr_sum_amount3 as $eachInvoice3) {
                    $due3 = $eachInvoice3['amt'];
                }
                foreach ($arr_sum_amount4 as $eachInvoice4) {
                    $due4 = $eachInvoice4['amt'];
                }
                foreach ($arr_sum_amount5 as $eachInvoice5) {
                    $due5 = $eachInvoice5['amt'];
                }
                foreach ($arr_sum_amount6 as $eachInvoice6) {
                    $due6 = $eachInvoice6['amt'];
                }
                foreach ($arr_sum_amount7 as $eachInvoice7) {
                    if ($opening_bal->type == 1) {
                        $amt7 = $opening_bal->statement_op + $eachInvoice7['amt'];
                        $due7+=$opening_bal->statement_op + $eachInvoice7['amt'];
                    } else if ($opening_bal->type == 2) {
                        $amt7 = $eachInvoice7['amt'] - $opening_bal->statement_op;
                        $due7+=$eachInvoice7['amt'] - $opening_bal->statement_op;
                    } else {
                        $amt7 = $eachInvoice7['amt'];
                        $due7+=$eachInvoice7['amt'];
                    }
                }
                $pend1+=$due1;
                $pend2+=$due2;
                $pend3+=$due3;
                $pend4+=$due4;
                $pend5+=$due5;
                $pend6+=$due6;
                $pend7+=$due7;
                $pnd = $due1 + $due2 + $due3 + $due4 + $due5 + $due6 + $due7;
                if ($pnd != 0) {
                    $company = Subledger::model()->findByPk($company_id);
                    $tds = '<td class="cell-left"><b>' . $company->description . '</b></td>';
                    if ($due1 < 0) {
                        $due1 = Yii::app()->numberFormatter->formatCurrency(abs($due1), "") . ' Cr';
                    } else {
                        $due1 = Yii::app()->numberFormatter->formatCurrency($due1, "") . ' Dr';
                    }
                    if ($due2 < 0) {
                        $due2 = Yii::app()->numberFormatter->formatCurrency(abs($due2), "") . ' Cr';
                    } else {
                        $due2 = Yii::app()->numberFormatter->formatCurrency($due2, "") . ' Dr';
                    }
                    if ($due3 < 0) {
                        $due3 = Yii::app()->numberFormatter->formatCurrency(abs($due3), "") . ' Cr';
                    } else {
                        $due3 = Yii::app()->numberFormatter->formatCurrency($due3, "") . ' Dr';
                    }
                    if ($due4 < 0) {
                        $due4 = Yii::app()->numberFormatter->formatCurrency(abs($due4), "") . ' Cr';
                    } else {
                        $due4 = Yii::app()->numberFormatter->formatCurrency($due4, "") . ' Dr';
                    }
                    if ($due5 < 0) {
                        $due5 = Yii::app()->numberFormatter->formatCurrency(abs($due5), "") . ' Cr';
                    } else {
                        $due5 = Yii::app()->numberFormatter->formatCurrency($due5, "") . ' Dr';
                    }
                    if ($due6 < 0) {
                        $due6 = Yii::app()->numberFormatter->formatCurrency(abs($due6), "") . ' Cr';
                    } else {
                        $due6 = Yii::app()->numberFormatter->formatCurrency($due6, "") . ' Dr';
                    }
                    if ($due7 < 0) {
                        $due7 = Yii::app()->numberFormatter->formatCurrency(abs($due7), "") . ' Cr';
                    } else {
                        $due7 = Yii::app()->numberFormatter->formatCurrency($due7, "") . ' Dr';
                    }
                    if ($pnd < 0) {
                        $pnd = Yii::app()->numberFormatter->formatCurrency(abs($pnd), "") . ' Cr';
                    } else {
                        $pnd = Yii::app()->numberFormatter->formatCurrency($pnd, "") . ' Dr';
                    }
                    $tds.='<td class="cell-right">' . $due1 . '</td>';
                    $tds.='<td class="cell-right">' . $due2 . '</td>';
                    $tds.='<td class="cell-right">' . $due3 . '</td>';
                    $tds.='<td class="cell-right">' . $due4 . '</td>';
                    $tds.='<td class="cell-right">' . $due5 . '</td>';
                    $tds.='<td class="cell-right">' . $due6 . '</td>';
                    $tds.='<td class="cell-right">' . $due7 . '</td>';
                    $tds.='<td class="cell-right litegray">' . $pnd . '</td>';
                    $trs[] = '<tr>' . $tds . '</tr>';
                    $total_amt+=$total_inv_amnt;
                    $total_pend+=$total_pend_amnt;
                    $tot_pend+=$pnd;
                }

                $html_prepared = implode(' ', $trs);
                $html_prepared.='<tr><td><b>Grand Total</b></td><td class="cell-right"><b>' . $due1 . '</b></td><td class="cell-right"><b>' . $due2 . '</b></td><td class="cell-right"><b>' . $due3 . '</b></td><td class="cell-right"><b>' . $due4 . '</b></td><td class="cell-right"><b>' . $due5 . '</b></td><td class="cell-right"><b>' . $due6 . '</b></td><td class="cell-right"><b>' . $due7 . '</b></td><td class="cell-right"><b>' . $pnd . '</b></td></tr>';
                $page_type = "L";
                $this->report('', 'ageing-list', 'pdf_for_single', $html_prepared, 'LEDGER AGEING REPORT', $page_type);
            } else {
                $SQL = "(SELECT sub.id,sub.description as description,sub.id as account_no FROM `crm_fin_general_ledger` as ledger left join crm_subledger as sub on ledger.subledger=sub.id WHERE account_id=$account_id group by account_id,subledger order by sub.description) "
                        . " order by description";
//            echo $SQL;die;
                $company = Yii::app()->db->createCommand($SQL)->queryAll();


                $trs = array();
                $tds = array();
                $total_amt = 0;
                $total_pend = 0;
                $total_columns = 11;
                $pend1 = 0;
                $pend2 = 0;
                $pend3 = 0;
                $pend4 = 0;
                $pend5 = 0;
                $pend6 = 0;
                $pend7 = 0;
                $tot_pend = 0;
                $no_days_30 = date('Y-m-d', strtotime($searchenddate . ' -30 day'));
                $no_days_60 = date('Y-m-d', strtotime($no_days_30 . ' -30 day'));
                $no_days_90 = date('Y-m-d', strtotime($no_days_60 . ' -30 day'));
                $no_days_120 = date('Y-m-d', strtotime($no_days_90 . ' -30 day'));
                $no_days_150 = date('Y-m-d', strtotime($no_days_120 . ' -30 day'));
                $no_days_180 = date('Y-m-d', strtotime($no_days_150 . ' -30 day'));
                $trs[] = '<tr>
                            <th width="15%" class="bgblack" >Customer Name</th>
                            <th width="10%" class="cell-right bgblack"> 0-30 Days</th>
                            <th width="10%" class="cell-right bgblack"> 31-60 Days</th>
                            <th width="10%" class="cell-right bgblack"> 61-90 Days</th>
                            <th width="10%" class="cell-right bgblack"> 91-120 Days</th>
                            <th width="10%" class="cell-right bgblack"> >120 Days</th>
                            <th width="10%" class="cell-right bgblack">Total</th>
                        </tr>';

//$SQL10="DROP VIEW IF EXISTS q1, q2,q3,q4,q5,q6,q7"; 
//Yii::app()->db->createCommand($SQL10)->execute();
                Yii::app()->db->createCommand("TRUNCATE TABLE ageing")->execute();
//$SQL11="CREATE OR REPLACE VIEW q1 AS (SELECT A.subledger,A.date,A.voucher_no,A.debit,A.credit,(A.debit-sum(B.debit_allocate_amount)) as db,(A.credit-sum(B.credit_allocate_amount)) as cr FROM `crm_fin_general_ledger` A left join crm_fin_voucher_allocation B ON A.id=B.invoice_id where A.account_id=$account_id AND A.isAllocated='Y' AND (A.date between '2014-01-01' AND '$searchenddate') AND (B.allocate_date between '2014-01-01' AND '$searchenddate') group by B.invoice_id) UNION (SELECT A.subledger,A.date,A.voucher_no,A.debit,A.credit,(A.debit) as db,(A.credit) as cr FROM `crm_fin_general_ledger` A left join crm_fin_voucher_allocation B ON A.id=B.invoice_id where A.account_id=$account_id AND A.isAllocated='Y' AND (A.date between '2014-01-01' AND '$searchenddate') AND (B.allocate_date NOT between '2014-01-01' AND '$searchenddate') group by A.id) UNION (SELECT subledger,date,voucher_no,debit,credit,debit as db,credit as cr from crm_fin_general_ledger  where account_id=$account_id AND allocation_amount =0 AND isAllocated='Y' AND (date between '2014-01-01' AND '$searchenddate')) order by date ASC";
                $SQL11 = "INSERT INTO ageing (SELECT A.id,A.subledger,A.date,A.voucher_no,A.debit,A.credit,(A.debit-sum(B.debit_allocate_amount)) as db,(A.credit-sum(B.credit_allocate_amount)) as cr FROM `crm_fin_general_ledger` A left join crm_fin_voucher_allocation B ON A.id=B.invoice_id where A.account_id=$account_id AND A.isAllocated='Y' AND (A.date between '2014-01-01' AND '$searchenddate') AND (B.allocate_date between '2014-01-01' AND '$searchenddate') group by B.invoice_id) UNION (SELECT A.id,A.subledger,A.date,A.voucher_no,A.debit,A.credit,(A.debit) as db,(A.credit) as cr FROM `crm_fin_general_ledger` A left join crm_fin_voucher_allocation B ON A.id=B.invoice_id where A.account_id=$account_id AND A.isAllocated='Y' AND (A.date between '2014-01-01' AND '$searchenddate') AND (B.allocate_date NOT between '2014-01-01' AND '$searchenddate') group by A.id) UNION (SELECT id,subledger,date,voucher_no,debit,credit,debit as db,credit as cr from crm_fin_general_ledger  where account_id=$account_id AND allocation_amount =0 AND isAllocated='Y' AND (date between '2014-01-01' AND '$searchenddate')) order by date ASC";
//echo $SQL11;die;
                Yii::app()->db->createCommand($SQL11)->execute();
//$SQL100="select subledger,sum(db)-sum(cr) as amt from q1 group by subledger";
//$arr_sum_amount100  = Yii::app()->db->createCommand($SQL100)->queryAll();
//print_r($arr_sum_amount100);die;
                Yii::app()->db->createCommand("CREATE OR REPLACE VIEW ss AS select * from ageing group by invoice_id order by db DESC,cr DESC")->execute();
                $SQL1 = "select subledger,sum(db)-sum(cr) as amt from ss where date >= '$no_days_30' group by subledger";
                $arr_sum_amount1 = Yii::app()->db->createCommand($SQL1)->queryAll();
                $SQL2 = "select subledger,sum(db)-sum(cr) as amt from ss where date >= '$no_days_60' AND date < '$no_days_30' group by subledger";
                $arr_sum_amount2 = Yii::app()->db->createCommand($SQL2)->queryAll();
                $SQL3 = "select subledger,sum(db)-sum(cr) as amt from ss where date >= '$no_days_90' AND date < '$no_days_60' group by subledger";
                $arr_sum_amount3 = Yii::app()->db->createCommand($SQL3)->queryAll();
                $SQL4 = "select subledger,sum(db)-sum(cr) as amt from ss where date >= '$no_days_120' AND date < '$no_days_90' group by subledger";
                $arr_sum_amount4 = Yii::app()->db->createCommand($SQL4)->queryAll();
//$SQL5="select subledger,sum(db)-sum(cr) as amt from q1 where date >= '$no_days_150' AND date < '$no_days_120' group by subledger"; 
//$arr_sum_amount5  = Yii::app()->db->createCommand($SQL5)->queryAll();
//$SQL6="select subledger,sum(db)-sum(cr) as amt from q1 where date >= '$no_days_180' AND date < '$no_days_150' group by subledger"; 
//$arr_sum_amount6  = Yii::app()->db->createCommand($SQL6)->queryAll();
                $SQL7 = "select subledger,sum(db)-sum(cr) as amt from ss where date < '$no_days_120' group by subledger";
                $arr_sum_amount7 = Yii::app()->db->createCommand($SQL7)->queryAll();
                $tot = 0;
                $due1 = 0;
                $due2 = 0;
                $due3 = 0;
                $due4 = 0;
                $due5 = 0;
                $due6 = 0;
                $due7 = 0;

                $pnd = 0;
                foreach ($company as $rowCompany) {
                    $amt = 0;
                    $amt1 = 0;
                    $amt2 = 0;
                    $amt3 = 0;
                    $amt4 = 0;
                    $amt5 = 0;
                    $amt6 = 0;
                    $amt7 = 0;
                    $amt8 = 0;
                    if ($rowCompany['account_no'] != '') {
                        $opening_bal = FinOpeningBalance::model()->find(array('condition' => 'company_id=' . $rowCompany['account_no'] . ' AND mainacc=' . $account_id));
                    } else {
                        $opening_bal->type = 0;
                        $opening_bal->statement_op = 0;
                    }

                    $tds = '<td class="cell-left"><b>' . $rowCompany['company_name'] . '(' . $rowCompany['account_no'] . ')' . '</b></td>';
                    foreach ($arr_sum_amount1 as $eachInvoice1) {
                        $amt8 = $opening_bal->statement_op;
                        if ($rowCompany['id'] == $eachInvoice1['subledger']) {
                            $amt1 = $eachInvoice1['amt'];
                            $due1+=$eachInvoice1['amt'];
                            $amt8 = $opening_bal->statement_op;
                        }
                    }
                    if ($amt1 < 0) {
                        $tds.='<td class="cell-right">' . Yii::app()->numberFormatter->formatCurrency(abs($amt1), "") . ' Cr</td>';
                    } else {
                        $tds.='<td class="cell-right">' . Yii::app()->numberFormatter->formatCurrency($amt1, "") . ' Dr</td>';
                    }
                    foreach ($arr_sum_amount2 as $eachInvoice2) {
                        if ($rowCompany['id'] == $eachInvoice2['subledger']) {
                            $amt2 = $eachInvoice2['amt'];
                            $due2+=$eachInvoice2['amt'];
                            $amt8 = $opening_bal->statement_op;
                        }
                    }
                    if ($amt2 < 0) {
                        $tds.='<td class="cell-right">' . Yii::app()->numberFormatter->formatCurrency(abs($amt2), "") . ' Cr</td>';
                    } else {
                        $tds.='<td class="cell-right">' . Yii::app()->numberFormatter->formatCurrency($amt2, "") . ' Dr</td>';
                    }
                    foreach ($arr_sum_amount3 as $eachInvoice3) {
                        if ($rowCompany['id'] == $eachInvoice3['subledger']) {
                            $amt3 = $eachInvoice3['amt'];
                            $due3+=$eachInvoice3['amt'];
                            $amt8 = $opening_bal->statement_op;
                        }
                    }
                    if ($amt3 < 0) {
                        $tds.='<td class="cell-right">' . Yii::app()->numberFormatter->formatCurrency(abs($amt3), "") . ' Cr</td>';
                    } else {
                        $tds.='<td class="cell-right">' . Yii::app()->numberFormatter->formatCurrency($amt3, "") . ' Dr</td>';
                    }
                    foreach ($arr_sum_amount4 as $eachInvoice4) {
                        if ($rowCompany['id'] == $eachInvoice4['subledger']) {
                            $amt4 = $eachInvoice4['amt'];
                            $due4+=$eachInvoice4['amt'];
                            $amt8 = $opening_bal->statement_op;
                        }
                    }
                    if ($amt4 < 0) {
                        $tds.='<td class="cell-right">' . Yii::app()->numberFormatter->formatCurrency(abs($amt4), "") . ' Cr</td>';
                    } else {
                        $tds.='<td class="cell-right">' . Yii::app()->numberFormatter->formatCurrency($amt4, "") . ' Dr</td>';
                    }
                    foreach ($arr_sum_amount7 as $eachInvoice7) {

                        if ($rowCompany['id'] == $eachInvoice7['subledger']) {
                            $amt7 = $eachInvoice7['amt'];
                            $due7+=$eachInvoice7['amt'];
                            $amt8 = $opening_bal->statement_op;
                        }
                    }
                    if ($opening_bal->type == 1) {
                        $amt7 = $amt7 + $amt8;
                        $due7+=$amt8;
                    } else if ($opening_bal->type == 2) {

                        $amt7 = $amt7 - $amt8;
                        $due7 = $due7 - $amt8;
                    }
                    if ($amt7 < 0) {
                        $tds.='<td class="cell-right">' . Yii::app()->numberFormatter->formatCurrency(abs($amt7), "") . ' Cr</td>';
                    } else {
                        $tds.='<td class="cell-right">' . Yii::app()->numberFormatter->formatCurrency($amt7, "") . ' Dr</td>';
                    }
                    $amt = $amt1 + $amt2 + $amt3 + $amt4 + $amt5 + $amt6 + $amt7;
                    if ($amt < 0) {
                        $tds.='<td class="cell-right"><b>' . Yii::app()->numberFormatter->formatCurrency(abs($amt), "") . ' Cr</b></td>';
                    } else {
                        $tds.='<td class="cell-right"><b>' . Yii::app()->numberFormatter->formatCurrency($amt, "") . ' Dr</b></td>';
                    }
                    if ($amt != 0) {
                        $pnd+=$amt;
                        $trs[] = '<tr>' . $tds . '</tr>';
                    }
                }

                $pend1+=$due1;
                $pend2+=$due2;
                $pend3+=$due3;
                $pend4+=$due4;
//            $pend5+=$due5;
//            $pend6+=$due6;
                $pend7+=$due7;

                if ($pend1 < 0) {
                    $pend1 = Yii::app()->numberFormatter->formatCurrency(abs($pend1), "") . ' Cr';
                } else {
                    $pend1 = Yii::app()->numberFormatter->formatCurrency($pend1, "") . ' Dr';
                }
                if ($pend2 < 0) {
                    $pend2 = Yii::app()->numberFormatter->formatCurrency(abs($pend2), "") . ' Cr';
                } else {
                    $pend2 = Yii::app()->numberFormatter->formatCurrency($pend2, "") . ' Dr';
                }
                if ($pend3 < 0) {
                    $pend3 = Yii::app()->numberFormatter->formatCurrency(abs($pend3), "") . ' Cr';
                } else {
                    $pend3 = Yii::app()->numberFormatter->formatCurrency($pend3, "") . ' Dr';
                }
                if ($pend4 < 0) {
                    $pend4 = Yii::app()->numberFormatter->formatCurrency(abs($pend4), "") . ' Cr';
                } else {
                    $pend4 = Yii::app()->numberFormatter->formatCurrency($pend4, "") . ' Dr';
                }
                if ($pend7 < 0) {
                    $pend7 = Yii::app()->numberFormatter->formatCurrency(abs($pend7), "") . ' Cr';
                } else {
                    $pend7 = Yii::app()->numberFormatter->formatCurrency($pend7, "") . ' Dr';
                }
                if ($pnd < 0) {
                    $pnd = Yii::app()->numberFormatter->formatCurrency(abs($pnd), "") . ' Cr';
                } else {
                    $pnd = Yii::app()->numberFormatter->formatCurrency($pnd, "") . ' Dr';
                }
                $html_prepared = implode(' ', $trs);
                $html_prepared.='<tr><th class="bgblack"><b>Grand Total</b></th><th class="cell-right br-top"><b>' . $pend1 . '</b></th><th class="cell-right br-top bgblack"><b>' . $pend2 . '</b></th><th class="cell-right br-top bgblack"><b>' . $pend3 . '</b></th><th class="cell-right br-top bgblack"><b>' . $pend4 . '</b></th><th class="cell-right br-top bgblack"><b>' . $pend7 . '</b></th><th class="cell-right br-top bgblack"><b>' . $pnd . '</b></th></tr>';
                ini_set("memory_limit", "-1");
                $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
                // $mPDF1->SetWatermarkImage(Yii::app()->baseUrl . '/images/logo/200150_' . MasCompany::model()->findbyPK(Yii::app()->user->master_user_company_id)->company_logo);
                //$mPDF1->showWatermarkImage = true;
                // $mPDF1->watermarkImageAlpha = 0.09;
                $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_for_generalledger.css');
                $mPDF1->AddPage('L');
                $mPDF1->WriteHTML($stylesheet, 1);
                $mPDF1->WriteHTML($this->renderPartial("application.views.front.pdf.ageing", array('content' => $html_prepared, 'date_to' => $searchenddate, 'account_no' => $account_id), true));
                $mPDF1->Output('Ageing Report.pdf', 'I');

//        $this->report('', 'ledger-all', 'pdf_for_single', $html_prepared, 'Ageing Report');
//             $this->layout = 'pdf';
//    		$this->render('//pdf/ageing_report_html', array('date_to'=>$searchenddate,'account'=>$account_id,'content'=>$html_prepared), false, true);
            }
        } else {
            echo "Please Select Account";
        }
    }

    public function report($model, $htmlTemplate, $css, $html_prepared = null, $title = null) {
        ini_set("memory_limit", "128G");
        ini_set('max_execution_time', 1000);
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/' . $css . '.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        //print_r($this->renderPartial('application.views.front.pdf.reports.' . $htmlTemplate, array('model' => $model, 'product_items' => $html_prepared, 'title' => $title),true));
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.' . $htmlTemplate, array('model' => $model, 'product_items' => $html_prepared, 'title' => $title), true));
        $mPDF1->Output($htmlTemplate, 'I');
    }

    public function actionPrintDayBook() {
        $date_from = $_REQUEST['from_date'];
        $date_to = $_REQUEST['to_date'];
        $date_from = str_replace('/', '-', $date_from);
        $date_from = date("Y-m-d", strtotime($date_from));
        $date_to = str_replace('/', '-', $date_to);
        $date_to = date("Y-m-d", strtotime($date_to));
        ini_set("memory_limit", -1);
        ini_set('max_execution_time', 1000);
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $mPDF1->SetWatermarkImage(Yii::app()->baseUrl . '/images/logo/200150_' . MasCompany::model()->findbyPK(Yii::app()->user->master_user_company_id)->company_logo);
        $mPDF1->showWatermarkImage = true;
        $mPDF1->watermarkImageAlpha = 0.09;
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_for_single.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial("application.views.front.pdf.daybook_new", array('date_from' => $date_from, 'date_to' => $date_to), true));
        $mPDF1->Output('Day Book.pdf', 'I');
    }

    public function actionPrintVatSummary() {
        $date_from = $_REQUEST['from_date'];
        $date_to = $_REQUEST['to_date'];
        $date_from = str_replace('/', '-', $date_from);
        $date_from = date("Y-m-d", strtotime($date_from));
        $date_to = str_replace('/', '-', $date_to);
        $date_to = date("Y-m-d", strtotime($date_to));
        ini_set("memory_limit", -1);
        ini_set('max_execution_time', 1000);
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $mPDF1->SetWatermarkImage(Yii::app()->baseUrl . '/images/logo/200150_' . MasCompany::model()->findbyPK(Yii::app()->user->master_user_company_id)->company_logo);
        $mPDF1->showWatermarkImage = true;
        $mPDF1->watermarkImageAlpha = 0.09;
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_for_single.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial("application.views.front.pdf.vat_summary", array('date_from' => $date_from, 'date_to' => $date_to), true));
        $mPDF1->Output('VAT.pdf', 'I');
    }

    public function actionPrintVatFinalSummary() {
        $date_from = $_REQUEST['from_date'];
        $date_to = $_REQUEST['to_date'];
        $date_from = str_replace('/', '-', $date_from);
        $date_from = date("Y-m-d", strtotime($date_from));
        $date_to = str_replace('/', '-', $date_to);
        $date_to = date("Y-m-d", strtotime($date_to));
        ini_set("memory_limit", -1);
        ini_set('max_execution_time', 1000);
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $mPDF1->SetWatermarkImage(Yii::app()->baseUrl . '/images/logo/200150_' . MasCompany::model()->findbyPK(Yii::app()->user->master_user_company_id)->company_logo);
        $mPDF1->showWatermarkImage = true;
        $mPDF1->watermarkImageAlpha = 0.09;
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_for_single.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial("application.views.front.pdf.vat_final_summary", array('date_from' => $date_from, 'date_to' => $date_to), true));
        $mPDF1->Output('VATSUMMARY.pdf', 'I');
    }

    public function actionPrintTrialBalance() {
        $date_from = $_REQUEST['to_date'];
        $date_from = str_replace('/', '-', $date_from);
        $date_from = date("Y-m-d", strtotime($date_from));
        ini_set("memory_limit", "256M");
        //  ini_set('max_execution_time', 1000);
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $mPDF1->SetWatermarkImage(Yii::app()->baseUrl . '/images/logo/200150_' . MasCompany::model()->findbyPK(Yii::app()->user->master_user_company_id)->company_logo);
        $mPDF1->showWatermarkImage = true;
        $mPDF1->watermarkImageAlpha = 0.09;
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_for_single.css');
        $mPDF1->WriteHTML($stylesheet, 1);

        $mPDF1->WriteHTML($this->renderPartial("application.views.front.pdf.trial_bal", array('date_from' => $date_from), true));
        $mPDF1->Output('Trial Balance.pdf', 'I');
    }

    public function actionPrintTrialBalanceEx() {
        $date_from = $_REQUEST['to_date'];
        $date_from = str_replace('/', '-', $date_from);
        $date_from = date("Y-m-d", strtotime($date_from));
        ini_set("memory_limit", "256M");
        //  ini_set('max_execution_time', 1000);
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $mPDF1->SetWatermarkImage(Yii::app()->baseUrl . '/images/logo/200150_' . MasCompany::model()->findbyPK(Yii::app()->user->master_user_company_id)->company_logo);
        $mPDF1->showWatermarkImage = true;
        $mPDF1->watermarkImageAlpha = 0.09;
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_for_single.css');
        $mPDF1->WriteHTML($stylesheet, 1);

        $mPDF1->WriteHTML($this->renderPartial("application.views.front.pdf.trial_bal_ex", array('date_from' => $date_from), true));
        $mPDF1->Output('Trial Balance.pdf', 'I');
    }

    public function actionPrintProfitLoss() {
        $date_from = $_REQUEST['from_date'];
        $date_to = $_REQUEST['to_date'];
        $date_from = str_replace('/', '-', $date_from);
        $date_from = date("Y-m-d", strtotime($date_from));
        $date_to = str_replace('/', '-', $date_to);
        $date_to = date("Y-m-d", strtotime($date_to));
        ini_set("memory_limit", "256M");
        //  ini_set('max_execution_time', 1000);
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $mPDF1->SetWatermarkImage(Yii::app()->baseUrl . '/images/logo/200150_' . MasCompany::model()->findbyPK(Yii::app()->user->master_user_company_id)->company_logo);
        $mPDF1->showWatermarkImage = true;
        $mPDF1->watermarkImageAlpha = 0.09;
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_for_single.css');
        $mPDF1->WriteHTML($stylesheet, 1);

        $mPDF1->WriteHTML($this->renderPartial("application.views.front.pdf.profit_loss", array('date_from' => $date_from, 'date_to' => $date_to), true));
        $mPDF1->Output('profit&loss.pdf', 'I');
    }

    public function actionPrintMaterialReceiptsReport() {

        $model = new PurchasingMaterialreceipt();

        $order_from_date = $_POST['order_from_date'];
        $order_to_date = $_POST['order_to_date'];
        $vendor_id = $_POST['vendor_id'];
        $project_id = $_POST['project_id'];
        $qcchecked = $_POST['qcchecked'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->render('//reports/print_material_rece_list', array('model' => $model, 'order_from_date' => $order_from_date, 'order_to_date' => $order_to_date, 'project_id' => $project_id, 'vendor_id' => $vendor_id, 'qcchecked' => $qcchecked), false, true);
    }

    public function actionPrintInvoiceListReport() {

        $model = new PurchasingInvoice();

        $order_from_date = $_POST['order_from_date'];
        $order_to_date = $_POST['order_to_date'];
        $vendor_id = $_POST['vendor_id'];
        $project_id = $_POST['project_id'];

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->render('//reports/print_invoice_report_list', array('model' => $model, 'order_from_date' => $order_from_date, 'order_to_date' => $order_to_date, 'project_id' => $project_id, 'vendor_id' => $vendor_id), false, true);
    }

    public function actionPrintPurchaseRegisterReport() {

        $model = new PurchasingOrder();

        $order_from_date = $_POST['order_from_date'];
        $order_to_date = $_POST['order_to_date'];
        $po_id = $_POST['po_id'];
        $project_id = $_POST['project_id'];

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->render('//reports/print_purchase_reg_list', array('model' => $model, 'order_from_date' => $order_from_date, 'order_to_date' => $order_to_date, 'project_id' => $project_id, 'po_id' => $po_id), false, true);
    }

    public function actionPrintPurchaseDebitNotesReport() {

        $model = new Purchasingdebitnote();

        $order_from_date = $_POST['order_from_date'];
        $order_to_date = $_POST['order_to_date'];
        $vendor_id = $_POST['vendor_id'];
        $project_id = $_POST['project_id'];

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->render('//reports/print_purchasedebitnoteslist', array('model' => $model, 'order_from_date' => $order_from_date, 'order_to_date' => $order_to_date, 'project_id' => $project_id, 'vendor_id' => $vendor_id), false, true);
    }

    public function actionPrintPurchaseOrderPendingReportPDF() {

        $model = new PurchasingOrder();

        $order_from_date = Yii::app()->request->getParam('order_from_date');
        $order_to_date = Yii::app()->request->getParam('order_to_date');
        $vendor_id = Yii::app()->request->getParam('vendor_id');
        $project_id = Yii::app()->request->getParam('project_id');


        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.purchase_order_pending_list', array('model' => $model, 'order_from_date' => $order_from_date, 'order_to_date' => $order_to_date, 'vendor_id' => $vendor_id, 'project_id' => $project_id), true));

        $mPDF1->Output($htmlTemplate, 'I');
    }

    public function actionPrintMaterialReceiptsReportPDF() {

        $model = new PurchasingMaterialreceipt();

        $order_from_date = Yii::app()->request->getParam('order_from_date');
        $order_to_date = Yii::app()->request->getParam('order_to_date');
        $vendor_id = Yii::app()->request->getParam('vendor_id');
        $project_id = Yii::app()->request->getParam('project_id');
        $qcchecked = $_POST['qcchecked'];

        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.purchase_material_rec_list', array('model' => $model, 'order_from_date' => $order_from_date, 'order_to_date' => $order_to_date, 'vendor_id' => $vendor_id, 'project_id' => $project_id, 'qcchecked' => $qcchecked), true));

        $mPDF1->Output($htmlTemplate, 'I');
    }

    public function actionPrintInvoiceListReportPDF() {

        $model = new PurchasingInvoice();

        $order_from_date = Yii::app()->request->getParam('order_from_date');
        $order_to_date = Yii::app()->request->getParam('order_to_date');
        $vendor_id = Yii::app()->request->getParam('vendor_id');
        $project_id = Yii::app()->request->getParam('project_id');

        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.purchase_invoice_list', array('model' => $model, 'order_from_date' => $order_from_date, 'order_to_date' => $order_to_date, 'vendor_id' => $vendor_id, 'project_id' => $project_id), true));

        $mPDF1->Output($htmlTemplate, 'I');
    }

    public function actionPrintPurchaseRegisterReportPDF() {

        $model = new Order();

        $order_from_date = Yii::app()->request->getParam('order_from_date');
        $order_to_date = Yii::app()->request->getParam('order_to_date');
        $po_id = Yii::app()->request->getParam('po_id');
        $project_id = Yii::app()->request->getParam('project_id');


        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.purchase_register_list', array('model' => $model, 'order_from_date' => $order_from_date, 'order_to_date' => $order_to_date, 'po_id' => $po_id, 'project_id' => $project_id), true));

        $mPDF1->Output($htmlTemplate, 'I');
    }

    public function actionPrintPurchaseDebitNotesReportPDF() {

        $model = new Purchasingdebitnote();

        $order_from_date = Yii::app()->request->getParam('order_from_date');
        $order_to_date = Yii::app()->request->getParam('order_to_date');
        $vendor_id = Yii::app()->request->getParam('vendor_id');
        $project_id = Yii::app()->request->getParam('project_id');


        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.purchase_debitnote_list', array('model' => $model, 'order_from_date' => $order_from_date, 'order_to_date' => $order_to_date, 'vendor_id' => $vendor_id, 'project_id' => $project_id), true));

        $mPDF1->Output($htmlTemplate, 'I');
    }

    public function actionSearchPurchaseOrderNo() {
        $data_array = array();
        if (isset($_GET['term'])) {
            $condition = ' (t.po_id like "%' . $_GET['term'] . '%")';
            $model = PurchasingInvoice::model()->with('purchaseorder')->findAll(array('condition' => $condition, 'order' => 't.id DESC', 'group' => 't.po_id'));
            $i = 0;
            foreach ($model as $eachModel) {
                $data_array[$i]['value'] = $eachModel->po_id;
                $data_array[$i]['label'] = $eachModel->po_id;
                $i++;
            }
        }
        echo CJSON::encode($data_array);
        Yii::app()->end();
    }

    public function actionPendingPurchaseDetail() {

        $model = new PurchasingOrderStockItem();
        $order_id = Yii::app()->request->getParam('id');
        $this->render('single_order_details', array('model' => $model, 'id' => $order_id), false, true);
    }

    public function actionPrintInventoryReceiveReport() {
        $model = new InventoryIndirectReceivedItems();
        $type = $_POST['type'];
        $from_warehouse = $_POST['from_warehouse'];
        $to_warehouse = $_POST['to_warehouse'];
        $transfer_from_date = $_POST['transfer_from_date'];
        $transfer_to_date = $_POST['transfer_to_date'];
        $transfer_no = $_POST['transfer_no'];

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->render('//reports/print_inventoryreceive_list', array('model' => $model, 'type' => $type, 'from_warehouse' => $from_warehouse, 'to_warehouse' => $to_warehouse, 'transfer_from_date' => $transfer_from_date, 'transfer_to_date' => $transfer_to_date, 'transfer_no' => $transfer_no, 'title' => $title), false, true);
    }

    public function actionPrintDirectTransferReport() {
        $model = new InventoryDirectTransfer();
        $from_warehouse = $_POST['from_warehouse'];
        $to_warehouse = $_POST['to_warehouse'];
        $transfer_from_date = $_POST['transfer_from_date'];
        $transfer_to_date = $_POST['transfer_to_date'];
        $transfer_no = $_POST['transfer_no'];

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->render('//reports/print_directtransfer_list', array('model' => $model, 'from_warehouse' => $from_warehouse, 'to_warehouse' => $to_warehouse, 'transfer_from_date' => $transfer_from_date, 'transfer_to_date' => $transfer_to_date, 'transfer_no' => $transfer_no, 'title' => $title), false, true);
    }

    public function actionPrintDirectTransferReportPDF() {
        $model = new InventoryDirectTransfer();
        $from_warehouse = Yii::app()->request->getParam('from_warehouse');
        $to_warehouse = Yii::app()->request->getParam('to_warehouse');
        $transfer_from_date = Yii::app()->request->getParam('transfer_from_date');
        $transfer_to_date = Yii::app()->request->getParam('transfer_to_date');
        $transfer_no = Yii::app()->request->getParam('transfer_no');


        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.directtransfer_list', array('model' => $model, 'type' => $type, 'from_warehouse' => $from_warehouse, 'to_warehouse' => $to_warehouse, 'transfer_from_date' => $transfer_from_date, 'transfer_to_date' => $transfer_to_date, 'transfer_no' => $transfer_no), true));

        $mPDF1->Output("DirectTransferReport.pdf", 'I');
    }

    public function actionPrintDamagedReport() {
        $model = new InventoryIndirectReceivedItems();
        $from_warehouse = $_POST['from_warehouse'];
        $to_warehouse = $_POST['to_warehouse'];
        $transfer_from_date = $_POST['transfer_from_date'];
        $transfer_to_date = $_POST['transfer_to_date'];
        $transfer_no = $_POST['transfer_no'];

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->render('//reports/print_damaged_list', array('model' => $model, 'from_warehouse' => $from_warehouse, 'to_warehouse' => $to_warehouse, 'transfer_from_date' => $transfer_from_date, 'transfer_to_date' => $transfer_to_date, 'transfer_no' => $transfer_no, 'title' => $title), false, true);
    }

    public function actionPrintInTransistReport() {
        $model = new InventoryIndirectTransfer();
        $from_warehouse = Yii::app()->request->getParam('from_warehouse');
        $transfer_from_date = Yii::app()->request->getParam('transfer_from_date');
        $transfer_to_date = Yii::app()->request->getParam('transfer_to_date');
        $transfer_no = Yii::app()->request->getParam('transfer_no');

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->render('//reports/print_intransist_list', array('model' => $model, 'from_warehouse' => $from_warehouse, 'transfer_from_date' => $transfer_from_date, 'transfer_to_date' => $transfer_to_date, 'transfer_no' => $transfer_no, 'title' => $title), false, true);
    }

    public function actionPrintInTransistReportPDF() {
        $model = new InventoryIndirectTransfer();
        $from_warehouse = Yii::app()->request->getParam('from_warehouse');
        $transfer_from_date = Yii::app()->request->getParam('transfer_from_date');
        $transfer_to_date = Yii::app()->request->getParam('transfer_to_date');
        $transfer_no = Yii::app()->request->getParam('transfer_no');

        $arrayparam = array('model' => $model, 'from_warehouse' => $from_warehouse, 'transfer_from_date' => $transfer_from_date, 'transfer_to_date' => $transfer_to_date, 'transfer_no' => $transfer_no, 'title' => $title);

        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.intransist_list', $arrayparam, true));

        $mPDF1->Output("InTransistReport.pdf", 'I');
    }

    public function actionPrintInventorytransferReceiveReportPDF() {
        $model = new InventoryIndirectReceivedItems();
        $type = Yii::app()->request->getParam('type');
        $from_warehouse = Yii::app()->request->getParam('from_warehouse');
        $to_warehouse = Yii::app()->request->getParam('to_warehouse');
        $transfer_from_date = Yii::app()->request->getParam('transfer_from_date');
        $transfer_to_date = Yii::app()->request->getParam('transfer_to_date');
        $transfer_no = Yii::app()->request->getParam('transfer_no');

        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.inventoryreceive_list', array('model' => $model, 'type' => $type, 'from_warehouse' => $from_warehouse, 'to_warehouse' => $to_warehouse, 'transfer_from_date' => $transfer_from_date, 'transfer_to_date' => $transfer_to_date, 'transfer_no' => $transfer_no), true));

        $mPDF1->Output("Inventorytransfer.pdf", 'I');
    }

    public function actionPrintCreditNoteReport() {

        $model = new Creditnote();

        $from_date = $_POST['from_date'];
        $to_date = $_POST['to_date'];
        $customer_id = $_POST['customer_id'];
        $leadowner_id = $_POST['leadowner_id'];
        $inv_type = $_POST['inv_type'];

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->render('//reports/print_creditnote_list', array('model' => $model, 'leadowner_id' => $leadowner_id, 'from_date' => $from_date, 'to_date' => $to_date, 'customer_id' => $customer_id, 'title' => $title, 'inv_type' => $inv_type), false, true);
    }

    public function actionPrintDirectSalesReport() {

        $model = new DirectOrder();

        $from_date = $_POST['from_date'];
        $to_date = $_POST['to_date'];
        $customer_id = $_POST['customer_id'];
        $leadowner_id = $_POST['leadowner_id'];

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->render('//reports/print_directsales_list', array('model' => $model, 'leadowner_id' => $leadowner_id, 'from_date' => $from_date, 'to_date' => $to_date, 'customer_id' => $customer_id, 'title' => $title), false, true);
    }

    public function actionPrintDirectSalesReportPDF() {

        $model = new DirectOrder();

        $from_date = $_GET['from_date'];
        $to_date = $_GET['to_date'];
        $customer_id = $_GET['customer_id'];
        $leadowner_id = $_GET['leadowner_id'];


        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.Direct_Sales_Report', array('model' => $model, 'leadowner_id' => $leadowner_id, 'from_date' => $from_date, 'to_date' => $to_date, 'customer_id' => $customer_id, 'title' => $title), true));

        $mPDF1->Output("DirectSalesReport.pdf", 'I');

        //Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        //  $this->render('//reports/print_directsales_list', array('model' => $model, 'leadowner_id' => $leadowner_id,'from_date' => $from_date, 'to_date' => $to_date,  'customer_id' => $customer_id, 'title' => $title), false, true);
    }

//-----------------
    public function actionPrintCreditNoteReportPDF() {

        $model = new Creditnote();

        $from_date = Yii::app()->request->getParam('from_date');
        $to_date = Yii::app()->request->getParam('to_date');
        $customer_id = Yii::app()->request->getParam('customer_id');
        $leadowner_id = $_POST['leadowner_id'];
        $inv_type = Yii::app()->request->getParam('inv_type');

        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.creditnote_list', array('model' => $model, 'leadowner_id' => $leadowner_id, 'from_date' => $from_date, 'to_date' => $to_date, 'customer_id' => $customer_id, 'inv_type' => $inv_type, 'title' => $title), true));

        $mPDF1->Output("CreditnoteList.pdf", 'I');
    }

    public function actionPrintNetSalesReport() {

        $model = new Invoice();
        $from_date = $_POST['from_date'];
        $to_date = $_POST['to_date'];
        $customer_id = $_POST['customer_id'];
        $leadowner_id = $_POST['leadowner_id'];
        $inv_type = Yii::app()->request->getParam('inv_type');


        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->render('//reports/print_netsales_list', array('model' => $model, 'leadowner_id' => $leadowner_id, 'from_date' => $from_date, 'to_date' => $to_date, 'customer_id' => $customer_id, 'title' => $title, 'inv_type' => $inv_type), false, true);
    }

    public function actionPrintGrossProfitReport() {

        $model = new Invoice();
        $from_date = $_POST['from_date'];
        $to_date = $_POST['to_date'];
        $customer_id = $_POST['customer_id'];
        $leadowner_id = $_POST['leadowner_id'];
        $salesgroup = $_POST['salesgroup'];
        $inv_type = $_POST['inv_type'];

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->render('//reports/print_grossprofit_list', array('model' => $model, 'sales_group' => $salesgroup, 'leadowner_id' => $leadowner_id, 'from_date' => $from_date, 'to_date' => $to_date, 'customer_id' => $customer_id, 'title' => $title, 'inv_type' => $inv_type), false, true);
    }

    public function actionPrintGrossProfitReportPDF() {

        $model = new Invoice();
        $from_date = $_GET['from_date'];
        $to_date = $_GET['to_date'];
        $customer_id = $_GET['customer_id'];
        $leadowner_id = $_GET['leadowner_id'];
        $salesgroup = $_GET['salesgroup'];
        $inv_type = $_GET['inv_type'];

        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.printgrossprofit', array('model' => $model, 'sales_group' => $salesgroup, 'leadowner_id' => $leadowner_id, 'from_date' => $from_date, 'to_date' => $to_date, 'customer_id' => $customer_id, 'title' => $title, 'inv_type' => $inv_type), true));

        $mPDF1->Output("GrossProfitReport.pdf", 'I');
    }

    public function actionPrintNetSalesReportPDF() {

        $model = new Invoice();

        $from_date = Yii::app()->request->getParam('from_date');
        $to_date = Yii::app()->request->getParam('to_date');
        $customer_id = Yii::app()->request->getParam('customer_id');
        $leadowner_id = Yii::app()->request->getParam('leadowner_id');
        $inv_type = Yii::app()->request->getParam('inv_type');

        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.netsales_list', array('model' => $model, 'from_date' => $from_date, 'to_date' => $to_date, 'customer_id' => $customer_id, 'leadowner_id' => $leadowner_id, 'title' => $title, 'inv_type' => $inv_type), true));

        $mPDF1->Output("NetSales.pdf", 'I');
    }

    public function actionPrintCustomerSalesReport() {
        $arr_customer_details['customer_id'] = $_POST['customer_id'];
        $from_date = $_POST['sale_fromdate'];
        $to_date = $_POST['sale_todate'];
        //$arr_customer_details['sale_fromdate']              = $_POST['sale_fromdate'];
        //$arr_customer_details['sale_todate']              = $_POST['sale_todate'];
        //$arr_customer_details['includes_zero']              = $_POST['includes_zero'];

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->render('//reports/print_customer_sale_report', array('customer_details' => $arr_customer_details, 'from_date' => $from_date, 'to_date' => $to_date, 'title' => $title), false, true);
    }

    public function actionPrintCustomerBrandSalesReport() {
        $customer_id = $_POST['customer_id'];
        $brand = $_POST['brand'];

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->render('//reports/print_customer_brandsale_report', array('customer_id' => $customer_id, 'brand' => $brand, 'title' => $title), false, true);
    }

    public function actionPrintCustomerSalesReportPDF() {

        $arr_customer_details['customer_id'] = (int) Yii::app()->request->getParam('customer_id');
        $from_date = Yii::app()->request->getParam('from_date');
        $to_date = Yii::app()->request->getParam('to_date');

        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.pdf_customer_sale_report', array('customer_details' => $arr_customer_details, 'from_date' => $from_date, 'to_date' => $to_date, 'title' => $title), true));

        $mPDF1->Output($htmlTemplate, 'I');
    }

    public function actionPrintCustomerNoSalesReport() {
        $arr_customer_details['customer_id'] = $_POST['customer_id'];
        $from_date = $_POST['no_sale_fromdate'];
        $to_date = $_POST['no_sale_todate'];
        //$arr_customer_details['includes_zero']              = $_POST['includes_zero'];

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->render('//reports/print_customer_no_sale_report', array('customer_details' => $arr_customer_details, 'from_date' => $from_date, 'to_date' => $to_date, 'title' => $title), false, true);
    }

    public function actionPrintCustomerNoSalesReportPDF() {

        $arr_customer_details['customer_id'] = (int) Yii::app()->request->getParam('customer_id');
        ;
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.pdf_customer_sale_report', array('customer_details' => $arr_customer_details, 'title' => $title), true));

        $mPDF1->Output($htmlTemplate, 'I');
    }

    public function actionPrintListItemsOrdered() {

        $model = new Order();

        $brand_id = (int) $_POST['brand'];

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->render('//reports/print_list_items_ordered', array('model' => $model, 'brand_id' => $brand_id), false, true);
    }

    public function actionPrintUnInvoiceReport() {

        $vendor = $_POST['vendor'];
        $from_date = $_POST['from_date'];
        $to_date = $_POST['to_date'];

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->render('//reports/print_uninvoice_list', array('vendor' => $vendor, 'from_date' => $from_date, 'to_date' => $to_date), false, true);
    }

    /*    arul on 3-1-2018 */

    public function actionPrintPurchaseOrderExcel() {
        $order_from_date = Yii::app()->request->getParam('order_from_date');
        $order_to_date = Yii::app()->request->getParam('order_to_date');
        $project_id = Yii::app()->request->getParam('project_id');
        $vendor_id = Yii::app()->request->getParam('vendor_id');
        $completed = Yii::app()->request->getParam('po_status');

        $file = fopen("uploads/csvs/test.csv", "w");
        $criteria = new CDbCriteria;

        if (!empty($order_from_date)) {
            $order_from_date = str_replace('/', '-', $order_from_date);
            $order_from_date = date('Y-m-d', strtotime($order_from_date));
            $criteria->addCondition('t.order_date>="' . $order_from_date . '"', 'AND');
        }
        if (!empty($order_to_date)) {
            $order_to_date = str_replace('/', '-', $order_to_date);
            $order_to_date = date('Y-m-d', strtotime($order_to_date));
            $criteria->addCondition('t.order_date<="' . $order_to_date . '"', 'AND');
        }
        if (!empty($vendor_id)) {
            $criteria->addCondition('t.vendor_id="' . $vendor_id . '"', 'AND');
        }
        if (!empty($project_id)) {
            $criteria->addCondition('t.project_id="' . $project_id . '"', 'AND');
        }
        if (!empty($completed)) {
            $criteria->addCondition('t.completed="' . $completed . '"', 'AND');
        }

        $model_order = PurchasingOrder::model()->with('vendor_details', 'file')->findAll($criteria);

        $j = 0;
        $list[$j++] = 'No!PO No!File No!Title!Vendor!Order Date!Status!Grand Total!Grand Total(BC)';

        $tot = 0;
        foreach ($model_order as $i => $model) {

            $status = '';
            if ($model->file->current_process_status == 'P_O') {
                $status = 'Order';
            } else if ($model->file->current_process_status == 'M_R') {
                $status = 'MR';
            } else if ($model->file->current_process_status == 'Q_C') {
                $status = 'QC';
            } else if ($model->file->current_process_status == 'P_I') {
                $status = 'Invoice';
            } else {
                $status = '';
            }
            if ($model->completed == 'P') {
                $status = 'MR(P)';
            }
            if ($model->completed == 'C') {
                $status = 'SC';
            }

            if ($model->order_date != '0000-00-00') {
                $orderdate = date("d/m/Y", strtotime($model->order_date));
            } else {
                $orderdate = " ";
            }

            $grand_total = $model->currencyname->currency_code . " " . Yii::app()->numberFormatter->formatCurrency($model->stock_grand_total + $model->nonstock_grandtotal, "");

            $model_currency = MasCurrency::model()->findByPk($model->currencyname->id);
            $grand_total = $model->stock_grand_total + $model->nonstock_grandtotal;
            $total_bc = $grand_total * $model_currency->exchange_rate;
            $total += $total_bc;

            $tot+=$total_bc;

            $total_bc = Yii::app()->numberFormatter->formatCurrency($total_bc, " ");

            $list[$j++] = ($i + 1) . '!' . $model->id . '!' . $model->file_id . '!' . $model->title . '!' . $model->vendor_details->vendor_name . '!' . $orderdate . '!' . $status . '!' . $grand_total . '!' . $total_bc;
        }
        $tot = Yii::app()->numberFormatter->formatCurrency($tot, " ");
        $list[$j++] = " " . '!' . " " . '!' . " " . '!' . " " . '!' . " " . '!' . " " . '!' . " " . '!' . " Total " . '!' . $tot;
        $j++;
        foreach ($list as $line) {
            fputcsv($file, explode('!', $line));
        }
        fclose($file);
        $filename = Yii::app()->getBaseUrl(true) . '/uploads/csvs/test.csv';
        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';
        header('Content-Type: application/csv');
        header("Content-disposition: attachment; filename=\"purchaseOrderList.csv\"");
        readfile($filename);
        Yii::app()->end();
        return;
    }

    public function actionPrintPurchaseInvoiceExcel() {
        $order_from_date = Yii::app()->request->getParam('order_from_date');
        $order_to_date = Yii::app()->request->getParam('order_to_date');
        $project_id = Yii::app()->request->getParam('project_id');
        $vendor_id = Yii::app()->request->getParam('vendor_id');

        $file = fopen("uploads/csvs/test.csv", "w");
        $criteria = new CDbCriteria;

        if (!empty($order_from_date)) {
            $order_from_date = str_replace('/', '-', $order_from_date);
            $order_from_date = date('Y-m-d', strtotime($order_from_date));
            $criteria->addCondition('t.invoice_date>="' . $order_from_date . '"', 'AND');
        }
        if (!empty($order_to_date)) {
            $order_to_date = str_replace('/', '-', $order_to_date);
            $order_to_date = date('Y-m-d', strtotime($order_to_date));
            $criteria->addCondition('t.invoice_date<="' . $order_to_date . '"', 'AND');
        }
        if (!empty($vendor_id)) {
            $criteria->addCondition('t.vendor_id="' . $vendor_id . '"', 'AND');
        }
        if (!empty($project_id)) {
            $criteria->addCondition('t.project_id="' . $project_id . '"', 'AND');
        }

        $model_invoice = PurchasingInvoice::model()->with('vendor_details')->findAll($criteria);

        $j = 0;
        $list[$j++] = 'No!File No!PO No!Inv No!Vendor!Invoice Date!Value!Value(BC)';

        $tot = 0;
        foreach ($model_invoice as $i => $model) {



            if ($model->invoice_date != '0000-00-00') {
                $invoicedate = date("d/m/Y", strtotime($model->invoice_date));
            } else {
                $invoicedate = " ";
            }

            $grand_total = $model->currencyname->currency_code . " " . Yii::app()->numberFormatter->formatCurrency($model->grand_total, "");

            $model_currency = MasCurrency::model()->findByPk($model->currencyname->id);
            $grand_total = $model->grand_total;
            $total_bc = $grand_total * $model_currency->exchange_rate;
            $total += $total_bc;

            $tot+=$total_bc;

            $total_bc = Yii::app()->numberFormatter->formatCurrency($total_bc, " ");

            $list[$j++] = ($i + 1) . '!' . $model->file_id . '!' . $model->po_id . '!' . $model->id . '!' . $model->vendor_details->vendor_name . '!' . $invoicedate . '!' . $grand_total . '!' . $total_bc;
        }
        $tot = Yii::app()->numberFormatter->formatCurrency($tot, " ");
        $list[$j++] = " " . '!' . " " . '!' . " " . '!' . " " . '!' . " " . '!' . " " . '!' . " Total " . '!' . $tot;
        $j++;
        foreach ($list as $line) {
            fputcsv($file, explode('!', $line));
        }
        fclose($file);
        $filename = Yii::app()->getBaseUrl(true) . '/uploads/csvs/test.csv';
        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';
        header('Content-Type: application/csv');
        header("Content-disposition: attachment; filename=\"purchaseInvoiceList.csv\"");
        readfile($filename);
        Yii::app()->end();
        return;
    }

    public function actionPrintPurchaseMaterialReceiptsExcel() {
        $order_from_date = Yii::app()->request->getParam('order_from_date');
        $order_to_date = Yii::app()->request->getParam('order_to_date');
        $project_id = Yii::app()->request->getParam('project_id');
        $vendor_id = Yii::app()->request->getParam('vendor_id');
        $qcchecked = Yii::app()->request->getParam('qcchecked');

        $file = fopen("uploads/csvs/test.csv", "w");
        $criteria = new CDbCriteria;

        if (!empty($order_from_date)) {
            $order_from_date = str_replace('/', '-', $order_from_date);
            $order_from_date = date('Y-m-d', strtotime($order_from_date));
            $criteria->addCondition('purchaseorder.order_date>="' . $order_from_date . '"', 'AND');
        }
        if (!empty($order_to_date)) {
            $order_to_date = str_replace('/', '-', $order_to_date);
            $order_to_date = date('Y-m-d', strtotime($order_to_date));
            $criteria->addCondition('purchaseorder.order_date<="' . $order_to_date . '"', 'AND');
        }
        if (!empty($vendor_id)) {
            $criteria->addCondition('t.vendor_id="' . $vendor_id . '"', 'AND');
        }
        if (!empty($project_id)) {
            $criteria->addCondition('t.project_id="' . $project_id . '"', 'AND');
        }
        if (!empty($qcchecked)) {
            $criteria->addCondition('t.qcchecked="' . $qcchecked . '"');
        }

        $model_met_receipt = PurchasingMaterialreceipt::model()->with('vendor_details', 'purchaseorder')->findAll($criteria);

        $j = 0;
        $list[$j++] = 'No!File No!PO No!MRV. No!MRV Date!Vendor Name!QC';

        foreach ($model_met_receipt as $i => $model) {



            if ($model->mrv_receipt_date != '0000-00-00') {
                $mrv_date = date("d/m/Y", strtotime($model->mrv_receipt_date));
            } else {
                $mrv_date = " ";
            }

            if ($model->qcchecked == 'Y') {
                $qc_status = "Completed";
            } else {
                $qc_status = "Partial";
            }

            $list[$j++] = ($i + 1) . '!' . $model->file_id . '!' . $model->po_id . '!' . $model->id . '!' . $mrv_date . '!' . $model->vendor_details->vendor_name . '!' . $qc_status;
        }
        $j++;
        foreach ($list as $line) {
            fputcsv($file, explode('!', $line));
        }
        fclose($file);
        $filename = Yii::app()->getBaseUrl(true) . '/uploads/csvs/test.csv';
        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';
        header('Content-Type: application/csv');
        header("Content-disposition: attachment; filename=\"PurchaseMaterialReceiptsList.csv\"");
        readfile($filename);
        Yii::app()->end();
        return;
    }

    /*    arul on 3-1-2018 end */
    /*    arul on 4-1-2018 */

    public function actionPrintPurchaseDebiteNoteExcel() {
        $order_from_date = Yii::app()->request->getParam('order_from_date');
        $order_to_date = Yii::app()->request->getParam('order_to_date');
        $project_id = Yii::app()->request->getParam('project_id');
        $vendor_id = Yii::app()->request->getParam('vendor_id');

        $file = fopen("uploads/csvs/test.csv", "w");
        $criteria = new CDbCriteria;

        if (!empty($order_from_date)) {
            $order_from_date = str_replace('/', '-', $order_from_date);
            $order_from_date = date('Y-m-d', strtotime($order_from_date));
            $criteria->addCondition('purchaseorder.order_date>="' . $order_from_date . '"', 'AND');
        }
        if (!empty($order_to_date)) {
            $order_to_date = str_replace('/', '-', $order_to_date);
            $order_to_date = date('Y-m-d', strtotime($order_to_date));
            $criteria->addCondition('purchaseorder.order_date<="' . $order_to_date . '"', 'AND');
        }
        if (!empty($vendor_id)) {
            $criteria->addCondition('t.vendor_id="' . $vendor_id . '"', 'AND');
        }
        if (!empty($project_id)) {
            $criteria->addCondition('t.project_id="' . $project_id . '"', 'AND');
        }

        //$model_met_receipt = PurchasingMaterialreceipt::model()->with('vendor_details','purchaseorder')->findAll($criteria);
        $model_debitnote = Purchasingdebitnote::model()->with('vendor_details', 'purchaseinvoice.purchaseorder')->findAll($criteria);

        $j = 0;

        $grand_total = 0;
        $list[$j++] = 'No!File No!Inv.No!CRN.No.!Vendor!Reason!Dbt.Date!Value!Value(BC)';

        foreach ($model_debitnote as $i => $model) {



            if ($model->debited_date != '0000-00-00') {
                $debitnote_date = date("d/m/Y", strtotime($model->debited_date));
            } else {
                $debitnote_date = " ";
            }

            $tot = Yii::app()->numberFormatter->formatCurrency($model->debited_amount, "");

            $model_currency = MasCurrency::model()->findByPk($model->currency);
            $total_bc = $model->debited_amount * $model_currency->exchange_rate;
            $total += $total_bc;

            $grand_total+=$total_bc;

            $total_bc = Yii::app()->numberFormatter->formatCurrency($total_bc, " ");


            $list[$j++] = ($i + 1) . '!' . $model->file_id . '!' . $model->purchasing_invoice_id . '!' . $model->id . '!' . $model->vendor_details->vendor_name . '!' . $model->reason . '!' . $debitnote_date . '!' . $tot . '!' . $total_bc;
        }
        $grand_total = Yii::app()->numberFormatter->formatCurrency($grand_total, " ");
        $list[$j++] = " " . '!' . '!' . " " . '!' . " " . '!' . " " . '!' . " " . '!' . " " . '!' . " Total " . '!' . $grand_total;

        $j++;
        foreach ($list as $line) {
            fputcsv($file, explode('!', $line));
        }
        fclose($file);
        $filename = Yii::app()->getBaseUrl(true) . '/uploads/csvs/test.csv';
        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';
        header('Content-Type: application/csv');
        header("Content-disposition: attachment; filename=\"PurchaseDebiteNoteList.csv\"");
        readfile($filename);
        Yii::app()->end();
        return;
    }

    public function actionPrintPurchaseOrderedListItemsExcel() {

        $brand_id = Yii::app()->request->getParam('brand_id');

        $file = fopen("uploads/csvs/test.csv", "w");
        $criteria = new CDbCriteria;

        $condition = "file.current_process_status = 'Q' OR file.current_process_status = 'O' OR file.current_process_status = 'PD' OR file.current_process_status = 'PI'";
        ;
        $model_order_item = new OrderItem();
        if ($brand_id > 0) {
            $condition .= ' AND product.brand_class_id ="' . $brand_id . '"';
        }

        $model_order_item = $model_order_item->with('order', 'product', 'parent.file')->findAll(array('select' => 'SUM(quantity) AS quantity,SUM(received) AS received,product_id,product.part_number AS product_name,product.description AS descripion', 'condition' => $condition, 'group' => 't.product_id', 'order' => 'product_name ASC'));

        $j = 0;

        $grand_total = 0;
        $list[$j++] = 'No!Part no!Description!Tot.Ordered.!Tot.Delivered!Tot.Required!In Stock!Op.PurchaseOrder!To Be Purchased';

        foreach ($model_order_item as $i => $model) {



            $rem_qty = $model->quantity - $model->received;
            $model_store = new ProductLocation();
            $stk_qty = $model_store->find(array('select' => 'SUM(quantity) AS quantity', 'condition' => 'stock_id = ' . $model->product_id))->quantity;
            $po_qty = 0;
            $qty_purchased = $rem_qty - $stk_qty - $po_qty;


            if ($qty_purchased > 0) {

                $total_order = number_format((float) $model->quantity, 2, '.', '');
                $total_delivered = number_format((float) $model->received, 2, '.', '');
                $total_required = number_format((float) $rem_qty, 2, '.', '');
                $Stock = number_format((float) $stk_qty, 2, '.', '');
                $purchase_order = number_format((float) $po_qty, 2, '.', '');
                $to_be_purchased = number_format((float) $qty_purchased, 2, '.', '');

                $list[$j++] = ($i + 1) . '!' . $model->product->part_number . '!' . $model->product->description . '!' . $total_order . '!' . $total_delivered . '!' . $total_required . '!' . $Stock . '!' . $purchase_order . '!' . $to_be_purchased;
            }
        }
        $j++;
        foreach ($list as $line) {
            fputcsv($file, explode('!', $line));
        }
        fclose($file);
        $filename = Yii::app()->getBaseUrl(true) . '/uploads/csvs/test.csv';
        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';
        header('Content-Type: application/csv');
        header("Content-disposition: attachment; filename=\"Purchase_Listof_Items.csv\"");
        readfile($filename);
        Yii::app()->end();
        return;
    }

    public function actionPrintNetPurchaseExcel() {
        $from_date = Yii::app()->request->getParam('from_date');
        $to_date = Yii::app()->request->getParam('to_date');
        $inv_type = Yii::app()->request->getParam('inv_type');
        $vendor_id = Yii::app()->request->getParam('vendor_id');

        $file = fopen("uploads/csvs/test.csv", "w");
        $criteria = new CDbCriteria;

        $condition = '1=1';
        ;
        if ($from_date != '') {
            $from_date = str_replace('/', '-', $from_date);
            $from_date = date('Y-m-d', strtotime($from_date));
            $condition .= ' AND t.invoice_date >="' . $from_date . '"';
        }
        if ($to_date != '') {
            $to_date = str_replace('/', '-', $to_date);
            $to_date = date('Y-m-d', strtotime($to_date));
            $condition .= ' AND t.invoice_date <="' . $to_date . '"';
        }

        if ($vendor_id != '') {
            $condition .= ' AND t.vendor_id ="' . $vendor_id . '"';
        }
        if ($inv_type != '') {

            $condition .= ' AND t.invoice_type ="' . $inv_type . '"';
        }

        $model_invoice = PurchasingInvoice::model()->with('vendor_details')->findAll(array('condition' => $condition, 'order' => 't.id DESC'));

        $j = 0;

        $grand_total = 0;
        $list[$j++] = 'No!Inv.Date!Inv.No!File No.!Vendor!Inv.VAT!Inv.Amt!DN VAT!DN Amt!Net VAT!Net Amount';

        foreach ($model_invoice as $i => $model) {

            $model_debit = Purchasingdebitnote::model()->find(array('select' => 'IFNULL(SUM(debited_amount*exchange_rate),0)as debited_amount,IFNULL(SUM(total_tax_amount*exchange_rate),0)as total_tax_amount', 'condition' => 't.purchasing_invoice_id=' . $model->id));

            if ($model->invoice_date != '0000-00-00') {
                $invoice_date = date("d/m/Y", strtotime($model->invoice_date));
            } else {
                $invoice_date = " ";
            }

            $model_currency = MasCurrency::model()->findByPk($model->currency);
            $amount = $model->grand_total + $model->total_tax_amount;
            $debit = $model_debit->debited_amount + $model_debit->total_tax_amount;
            $total_bc = $amount * $model_currency->exchange_rate;
            $tax = $model->total_tax_amount * $model_currency->exchange_rate;
            $total_tax += $tax;
            $total_cn_tax += $model_debit->total_tax_amount;
            $total += $total_bc;
            $cn_total +=$debit;
            $net_amount = $total_bc - (int) ($model_debit->debited_amount);
            $invoice_vat = Yii::app()->numberFormatter->formatCurrency($tax, " ");

            $tot_tax = $total_tax - $total_cn_tax;
            $net_total = $total - $cn_total + ($tot_tax);

            $list[$j++] = ($i + 1) . '!' . $invoice_date . '!' . $model->id . '!' . $model->file_id . '!' . $model->vendor_details->vendor_name . '!' . $invoice_vat . '!' . Yii::app()->numberFormatter->formatCurrency($total_bc, " ") . '!' . Yii::app()->numberFormatter->formatCurrency($model_debit->total_tax_amount, " ") . '!' . Yii::app()->numberFormatter->formatCurrency($debit, " ") . '!' . Yii::app()->numberFormatter->formatCurrency($tax, " ") . '!' . Yii::app()->numberFormatter->formatCurrency($net_amount, " ");
        }
        //$list[$j++] = " " . '!' . '!' . " " . '!' . " " .  '!' . " " . '!' . Yii::app()->numberFormatter->formatCurrency($total_cn_tax, " "). '!' . Yii::app()->numberFormatter->formatCurrency($cn_total, " "). '!' . Yii::app()->numberFormatter->formatCurrency($tot_tax, " "). '!' . Yii::app()->numberFormatter->formatCurrency($net_total, " "). '!' . Yii::app()->numberFormatter->formatCurrency($total_tax, " "). '!' . Yii::app()->numberFormatter->formatCurrency($total, " ");
        $list[$j++] = " " . '!' . '!' . " " . '!' . " " . '!' . " " . '!' . Yii::app()->numberFormatter->formatCurrency($total, " ") . '!' . Yii::app()->numberFormatter->formatCurrency($total_tax, " ") . '!' . Yii::app()->numberFormatter->formatCurrency($total_cn_tax, " ") . '!' . Yii::app()->numberFormatter->formatCurrency($cn_total, " ") . '!' . Yii::app()->numberFormatter->formatCurrency($tot_tax, " ") . '!' . Yii::app()->numberFormatter->formatCurrency($net_total, " ");

        $j++;
        foreach ($list as $line) {
            fputcsv($file, explode('!', $line));
        }
        fclose($file);
        $filename = Yii::app()->getBaseUrl(true) . '/uploads/csvs/test.csv';
        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';
        header('Content-Type: application/csv');
        header("Content-disposition: attachment; filename=\"NetPurchaseList.csv\"");
        readfile($filename);
        Yii::app()->end();
        return;
    }

    public function actionPrintPurchaseRegisterExcel() {
        $order_from_date = Yii::app()->request->getParam('order_from_date');
        $order_to_date = Yii::app()->request->getParam('order_to_date');
        $po_id = Yii::app()->request->getParam('po_id');
        $project_id = Yii::app()->request->getParam('project_id');

        $file = fopen("uploads/csvs/test.csv", "w");
        $criteria = new CDbCriteria;

        if ($project_id > 0) {
            $arr_proj = MasProject::model()->findAll(array('condition' => 'isActive =  "Y" AND id=' . $project_id));
        } else {
            $arr_proj = MasProject::model()->findAll(array('condition' => 'isActive =  "Y"'));
        }
        $condition = '1=1';
        if ($order_from_date != '') {
            $order_from_date = str_replace('/', '-', $order_from_date);
            $order_from_date = date('Y-m-d', strtotime($order_from_date));
            $condition .= ' AND t.invoice_date >="' . $order_from_date . '"';
        }
        if ($order_to_date != '') {
            $order_to_date = str_replace('/', '-', $order_to_date);
            $order_to_date = date('Y-m-d', strtotime($order_to_date));
            $condition .= ' AND t.invoice_date <="' . $order_to_date . '"';
        }

        if ($po_id != '') {
            $condition .= ' AND t.po_id ="' . $po_id . '"';
        }
        $j = 0;

        if (!empty($arr_proj)) {
            foreach ($arr_proj as $i => $eachproject) {
                $listinvoice = PurchasingInvoice::model()->findAll(array('condition' => 'project_id="' . $eachproject->id . '" AND ' . $condition));
                $grand_total = 0;
                $list[$j++] = $eachproject->project_title . '!' . '!' . " " . '!' . " " . '!' . " " . '!';

                if (!empty($listinvoice)) {
                    foreach ($listinvoice as $each_invoice) {
                        $proj_inv_total = 0;

                        $list[$j++] = "File No : " . $each_invoice->file_id . '!' . '!' . " " . '!' . " " . '!' . " " . '!';
                        $list[$j++] = "Purchase Order No : " . $each_invoice->po_id . '!' . '!' . " " . '!' . " " . '!' . " " . '!';
                        $list[$j++] = "Purchase Invoice No : " . $each_invoice->id . '!' . '!' . " " . '!' . " " . '!' . " " . '!';
                        $list[$j++] = "Purchase Invoice Date : " . $each_invoice->invoice_date . '!' . '!' . " " . '!' . " " . '!' . " " . '!';
                        $list[$j++] = "Vendor : " . $each_invoice->vendor_details->vendor_name . '!' . '!' . " " . '!' . " " . '!' . " " . '!';


                        $arr_items = PurchasingInvoiceItem::model()->findAll(array('condition' => 'purchasing_invoice_id=' . $each_invoice->id));
                        $list[$j++] = 'Items!Description!Quantity!Rate.!Amount';
                        foreach ($arr_items as $each_item) {

                            $rate = $each_item->rate * $each_invoice->exchange_rate;
                            $amount = $rate * $each_item->quantity;
                            $proj_inv_total += $amount;
                            $grand_total+=$amount;

                            $list[$j++] = $each_item->product->part_number . '!' . $each_item->description . '!' . $each_item->quantity . '!' . $rate . '!' . $amount;
                        }
                        $list[$j++] = " " . '!' . '!' . " " . '!' . " " . " Total " . '!' . Yii::app()->numberFormatter->formatCurrency($proj_inv_total, "");
                        if ($grand_total > 0) {

                            $list[$j++] = " " . '!' . '!' . " " . '!' . " " . " Grand Total " . '!' . Yii::app()->numberFormatter->formatCurrency($grand_total, "");
                        }
                    }
                }
            }

            $grand_total = 0;
            $listinvoice = PurchasingInvoice::model()->findAll(array('condition' => $condition . ' AND project_id=0 '));
            if (!empty($listinvoice)) {

                $list[$j++] = "No Project Title" . '!' . '!' . " " . '!' . " " . '!' . " " . '!';

                foreach ($listinvoice as $each_invoice) {

                    $proj_inv_total = 0;
                    $list[$j++] = "File No : " . $each_invoice->file_id . '!' . '!' . " " . '!' . " " . '!' . " " . '!';
                    $list[$j++] = "Purchase Order No : " . $each_invoice->po_id . '!' . '!' . " " . '!' . " " . '!' . " " . '!';
                    $list[$j++] = "Purchase Invoice No : " . $each_invoice->id . '!' . '!' . " " . '!' . " " . '!' . " " . '!';
                    $list[$j++] = "Purchase Invoice Date : " . $each_invoice->invoice_date . '!' . '!' . " " . '!' . " " . '!' . " " . '!';
                    $list[$j++] = "Vendor : " . $each_invoice->vendor_details->vendor_name . '!' . '!' . " " . '!' . " " . '!' . " " . '!';

                    $arr_items = PurchasingInvoiceItem::model()->findAll(array('condition' => 'purchasing_invoice_id=' . $each_invoice->id));

                    $list[$j++] = 'Items!Description!Quantity!Rate.!Amount';

                    foreach ($arr_items as $each_item) {
                        $rate = $each_item->rate * $each_invoice->exchange_rate;
                        $amount = $rate * $each_item->quantity;
                        $proj_inv_total += $amount;
                        $grand_total+=$amount;

                        $list[$j++] = $each_item->product->part_number . '!' . $each_item->description . '!' . $each_item->quantity . '!' . $rate . '!' . $amount;
                    }
                    $list[$j++] = " " . '!' . '!' . " " . '!' . " " . " Total " . '!' . Yii::app()->numberFormatter->formatCurrency($proj_inv_total, "");
                    if ($grand_total > 0) {

                        $list[$j++] = " " . '!' . '!' . " " . '!' . " " . " Grand Total " . '!' . Yii::app()->numberFormatter->formatCurrency($grand_total, "");
                    }
                }
            }
        } else {

            $grand_total = 0;
            $listinvoice = PurchasingInvoice::model()->findAll(array('condition' => $condition . ' AND project_id=0 '));
            if (!empty($listinvoice)) {

                $list[$j++] = "No Project Title" . '!' . '!' . " " . '!' . " " . '!' . " " . '!';
                foreach ($listinvoice as $each_invoice) {
                    $proj_inv_total = 0;

                    $list[$j++] = "File No : " . $each_invoice->file_id . '!' . '!' . " " . '!' . " " . '!' . " " . '!';
                    $list[$j++] = "Purchase Order No : " . $each_invoice->po_id . '!' . '!' . " " . '!' . " " . '!' . " " . '!';
                    $list[$j++] = "Purchase Invoice No : " . $each_invoice->id . '!' . '!' . " " . '!' . " " . '!' . " " . '!';
                    $list[$j++] = "Purchase Invoice Date : " . $each_invoice->invoice_date . '!' . '!' . " " . '!' . " " . '!' . " " . '!';
                    $list[$j++] = "Vendor : " . $each_invoice->vendor_details->vendor_name . '!' . '!' . " " . '!' . " " . '!' . " " . '!';

                    $arr_items = PurchasingInvoiceItem::model()->findAll(array('condition' => 'purchasing_invoice_id=' . $each_invoice->id));

                    $list[$j++] = 'Items!Description!Quantity!Rate.!Amount';

                    foreach ($arr_items as $each_item) {
                        $rate = $each_item->rate * $each_invoice->exchange_rate;
                        $amount = $rate * $each_item->quantity;
                        $proj_inv_total += $amount;
                        $grand_total+=$amount;

                        $list[$j++] = $each_item->product->part_number . '!' . $each_item->description . '!' . $each_item->quantity . '!' . $rate . '!' . $amount;
                    }
                    $list[$j++] = " " . '!' . '!' . " " . '!' . " " . " Total " . '!' . Yii::app()->numberFormatter->formatCurrency($proj_inv_total, "");
                    if ($grand_total > 0) {

                        $list[$j++] = " " . '!' . '!' . " " . '!' . " " . " Grand Total " . '!' . Yii::app()->numberFormatter->formatCurrency($grand_total, "");
                    }
                }
            }
        }

        if (empty($list)) {
            $list[$j++] = " No Details " . '!' . '!' . " " . '!' . " " . " " . '!';
        }

        $j++;
        foreach ($list as $line) {
            fputcsv($file, explode('!', $line));
        }
        fclose($file);
        $filename = Yii::app()->getBaseUrl(true) . '/uploads/csvs/test.csv';
        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';
        header('Content-Type: application/csv');
        header("Content-disposition: attachment; filename=\"PurchaseRegisterList.csv\"");
        readfile($filename);
        Yii::app()->end();
        return;
    }

    public function actionPrintPurchaseOrderPendingReport() {

        $model = new PurchasingOrder();

        $order_from_date = Yii::app()->request->getParam('order_from_date');
        $order_to_date = Yii::app()->request->getParam('order_to_date');
        $vendor_id = Yii::app()->request->getParam('vendor_id');
        $project_id = Yii::app()->request->getParam('project_id');

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->render('//reports/print_purchasependingorder_list', array('model' => $model, 'order_from_date' => $order_from_date, 'order_to_date' => $order_to_date, 'project_id' => $project_id, 'vendor_id' => $vendor_id), false, true);
    }

    public function actionPrintPurchaseOrderPendingExcel() {
        $order_from_date = Yii::app()->request->getParam('order_from_date');
        $order_to_date = Yii::app()->request->getParam('order_to_date');
        $vendor_id = Yii::app()->request->getParam('vendor_id');
        $project_id = Yii::app()->request->getParam('project_id');

        $file = fopen("uploads/csvs/test.csv", "w");
        $condition = 't.completed != "Y"';
        ;
        if ($order_from_date != '') {
            $order_from_date = str_replace('/', '-', $order_from_date);
            $order_from_date = date('Y-m-d', strtotime($order_from_date));
            $condition .= ' AND t.order_date >="' . $order_from_date . '"';
        }
        if ($order_to_date != '') {
            $order_to_date = str_replace('/', '-', $order_to_date);
            $order_to_date = date('Y-m-d', strtotime($order_to_date));
            $condition .= ' AND t.order_date <="' . $order_to_date . '"';
        }

        if ($vendor_id != '') {
            $condition .= ' AND t.vendor_id ="' . $vendor_id . '"';
        }
        if ($project_id != '') {
            $condition .= ' AND t.project_id ="' . $project_id . '"';
        }

        $total = 0;
        $model_order = PurchasingOrder::model()->with('vendor_details', 'file')->findAll(array('condition' => $condition));

        $j = 0;

        $list[$j++] = 'No!PO No!File No!Vendor!Order Date!Req Date!Exp Del Date!Ordered(No.s)!Recieved(No.s)!Pending(No.s)!Details';

        foreach ($model_order as $i => $model) {

            if ($model->order_date != '0000-00-00') {
                $order_date = date("d/m/Y", strtotime($model->order_date));
            } else {
                $order_date = " ";
            }
            if ($model->required_date != '0000-00-00') {
                $required_date = date("d/m/Y", strtotime($model->required_date));
            } else {
                $required_date = " ";
            }
            if ($model->expected_delivery_date != '0000-00-00') {
                $expected_date = date("d/m/Y", strtotime($model->expected_delivery_date));
            } else {
                $expected_date = " ";
            }
            $need_quantity = $model->netStockQuantity + $model->netnonStockQuantity;
            $receivedQuantity = $model->file->receivedQuantity;
            $pendinQuantity = $need_quantity - $model->file->receivedQuantity;

            if ($model->netStockQuantity + $model->netnonStockQuantity > $model->file->receivedQuantity) {
                $list[$j++] = ($i + 1) . '!' . $model->id . '!' . $model->file_id . '!' . $model->vendor_details->vendor_name . '!' . $order_date . '!' . $required_date . '!' . $expected_date . '!' . number_format((float) $need_quantity, 2, '.', '') . '!' . number_format((float) $receivedQuantity, 2, '.', '') . '!' . number_format((float) $pendinQuantity, 2, '.', '');
            }
        }

        $j++;
        foreach ($list as $line) {
            fputcsv($file, explode('!', $line));
        }
        fclose($file);
        $filename = Yii::app()->getBaseUrl(true) . '/uploads/csvs/test.csv';
        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';
        header('Content-Type: application/csv');
        header("Content-disposition: attachment; filename=\"PurchasePendingOrderList.csv\"");
        readfile($filename);
        Yii::app()->end();
        return;
    }

    public function actionPrintInventoryListExcel() {
        $type = Yii::app()->request->getParam('type');
        $part_number = Yii::app()->request->getParam('part_number');
        $generic_name = Yii::app()->request->getParam('generic_name');
        $tax_code = Yii::app()->request->getParam('tax_code');
        $brand_id = Yii::app()->request->getParam('brand_id');

        $file = fopen("uploads/csvs/test.csv", "w");
        $condition = '1=1';
        ;
        if ($type != '') {
            $condition .= ' AND t.inventory_item_type ="' . $type . '"';
        }
        if ($part_number != '') {
            $condition .= ' AND t.part_number LIKE "%' . $part_number . '%"';
        }
        if ($generic_name != '') {
            $condition .= ' AND t.generic_name LIKE "%' . $generic_name . '%"';
        }
        if ($tax_code != '') {
            $condition .= ' AND t.tax_code LIKE "%' . $tax_code . '%"';
        }
        if ($brand_id != '') {
            $condition .= ' AND t.brand_class_id="' . $brand_id . '"';
        }

        $total = 0;
        $model_inventory = Store::model()->findAll(array('condition' => $condition, 'order' => 'description asc'));

        $j = 0;


        $list[$j++] = 'No!Part Number!Generic Name!Brand!Description!Item Type!Tax Code!Unit!Rate';

        foreach ($model_inventory as $i => $model) {

            $model_generic = MasGeneric::model()->find(array('condition' => 't.id="' . $model->generic_name . '"'));

            if ($model->inventory_item_type == 1) {
                $type = "Stock Item";
            } else if ($model->inventory_item_type == 2) {
                $type = "Service Item";
            }
            $taxcode = $model->tax->tax_code . ":" . $model->tax->percentage;

            $list[$j++] = ($i + 1) . '!' . $model->part_number . '!' . $model_generic->generic_name . '!' . $model->brand_detail->product_class . '!' . $model->description . '!' . $type . '!' . $taxcode . '!' . $model->unit->unit_name . '!' . Yii::app()->numberFormatter->formatCurrency($model->rate, "");
        }

        $j++;
        foreach ($list as $line) {
            fputcsv($file, explode('!', $line));
        }
        fclose($file);
        $filename = Yii::app()->getBaseUrl(true) . '/uploads/csvs/test.csv';
        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';
        header('Content-Type: application/csv');
        header("Content-disposition: attachment; filename=\"InventoryList.csv\"");
        readfile($filename);
        Yii::app()->end();
        return;
    }

    public function actionPrintInventoryMinStockExcel() {
        $brand_name = Yii::app()->request->getParam('brand_name');
        $generic_name = Yii::app()->request->getParam('generic_name');

        $file = fopen("uploads/csvs/test.csv", "w");
        $condition = '1=1';
        ;

        if ($generic_name != '') {
            $condition .= ' AND t.generic_name LIKE "%' . $generic_name . '%"';
        }
        if ($brand_name != '') {
            $condition .= ' AND t.brand_class_id LIKE "%' . $brand_name . '%"';
        }
        $model_inventory = Store::model()->findAll(array('condition' => $condition, 'order' => 'description asc'));

        $j = 0;

        $list[$j++] = 'No!Part Number!Description!Generic Name!Brand!Unit!Total Quantity!Re Order Level';

        foreach ($model_inventory as $i => $model) {


            $total_quantity = $model->total_quantity;
            $re_order_level = $model->re_order_level;
            if ($total_quantity != '0') {
                if ($total_quantity <= $re_order_level) {

                    $model_generic = MasGeneric::model()->find(array('condition' => 't.id="' . $model->generic_name . '"'));
                    $list[$j++] = ($i + 1) . '!' . $model->part_number . '!' . $model->description . '!' . $model->generic_name . '!' . $model->brand_detail->product_class . '!' . $model->unit->symbol . '!' . $model->total_quantity . '!' . $model->re_order_level;
                }
            }
        }

        $j++;
        foreach ($list as $line) {
            fputcsv($file, explode('!', $line));
        }
        fclose($file);
        $filename = Yii::app()->getBaseUrl(true) . '/uploads/csvs/test.csv';
        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';
        header('Content-Type: application/csv');
        header("Content-disposition: attachment; filename=\"InventoryMinimumStockList.csv\"");
        readfile($filename);
        Yii::app()->end();
        return;
    }

    /*    arul on 4-1-2018 end */

    /* adharsh 1-3-2018 start */

    public function actionPrintexcelinvreport() {
        $part_no = Yii::app()->request->getParam('part_no');
        //echo $del_from_date;
        //die();
        $type = Yii::app()->request->getParam('type');
        $tax_code = Yii::app()->request->getParam('tax_code');
        $inv_type = Yii::app()->request->getParam('inv_type');
        $generic_name = Yii::app()->request->getParam('generic_name');
        $brand_name = Yii::app()->request->getParam('brand_name');
        $file = fopen("uploads/csvs/test.csv", "w");


        $criteria = new CDbCriteria;
        $criteria->addCondition(' t.inventory_item_type="1"', 'AND');
        if (!empty($part_no))
            $criteria->addCondition('t.part_number LIKE "%' . $part_no . '%"', 'AND');

        if (!empty($tax_code))
            $criteria->addCondition('t.tax_code = "' . $tax_code . '"', 'AND');

        if ($inv_type > "0")
            $criteria->addCondition('t.inventory_item_type = "' . $inv_type . '"', 'AND');


        if (!empty($brand_name))
            $criteria->addCondition('t.brand_class_id="' . $brand_name . '"', 'AND');

        $model_stock = Store::model()->with('opening')->findAll($criteria);
        $j = 0;


        $list[$j++] = 'No/Part No/Generic Name/Brand/Description/Tax %/Total Qty/Unit/Rate/Total Value';
        $total_value = 0;
        $m = 1;
        foreach ($model_stock as $i => $model) {



            $cur_qty = 0;
            $total = 0;
            $mod_stock_till = new StockLedger();
            $condition1 = ' t.product_id ="' . $model->id . '"';
            if ($ware_house_id > 0) {
                $condition1.= ' AND t.	warehouse_id = "' . $ware_house_id . '"';
            }
            $mod_stock_till = $mod_stock_till->find(array('select' => 'SUM(in_qty)-SUM(out_qty) AS net_qty,SUM(in_qty) AS in_qty,SUM(out_qty) AS out_qty,cost_rate', 'condition' => $condition1, 'group' => 't.product_id', 'order' => 't.transaction_date DESC'));

            $cur_qty = (int) $mod_stock_till->net_qty + (int) $model->opening->opening_quantity;
            $zero_flag = 0;
            if ($type == 'N') {
                if ($cur_qty == 0) {
                    $zero_flag = 1;
                }
            } else {
                $zero_flag = 0;
            }

            if ($zero_flag == '0') {
                $model_generic = MasGeneric::model()->find(array('condition' => 't.id="' . $model->generic_name . '"'));
                $total = ((int) $cur_qty) * $model->rate;
                $total_value+=$total;

                $list[$j++] = $m++ . '/' . $model->part_number . '/' . $model_generic->generic_name . '/' . $model->brand_detail->product_class . '/' . $model->description . '/' . $model->tax->percentage . '/' . Yii::app()->numberFormatter->formatCurrency($cur_qty, " ") . '/' . $model->unit->symbol . '/' . Yii::app()->numberFormatter->formatCurrency($model->rate, " ")
                        . '/' . Yii::app()->numberFormatter->formatCurrency($total, " ");
            }
        }

        $j++;

        foreach ($list as $line) {
            fputcsv($file, explode('/', $line));
        }

        fclose($file);

        $filename = Yii::app()->getBaseUrl(true) . '/uploads/csvs/test.csv';

        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';

        header('Content-Type: application/csv');

        header("Content-disposition: attachment; filename=\"print_inv_report.csv\"");

        readfile($filename);

        Yii::app()->end();

        return;
    }

    public function actionPrintDeliveryListExcel() {
        $del_from_date = Yii::app()->request->getParam('del_from_date');
        //echo $del_from_date;
        //die();
        $del_to_date = Yii::app()->request->getParam('del_to_date');
        $customer_id = Yii::app()->request->getParam('customer_id');
        $status = Yii::app()->request->getParam('status');
        $file = fopen("uploads/csvs/test.csv", "w");
        $criteria = new CDbCriteria;
        if (!empty($del_from_date))
            $del_from_date = str_replace('/', '-', $del_from_date);
        $del_from_date = date('Y-m-d', strtotime($del_from_date));
        $criteria->addCondition('t.delivery_date >="' . $del_from_date . '"', 'AND');

        if (!empty($del_to_date))
            $del_to_date = str_replace('/', '-', $del_to_date);
        $del_to_date = date('Y-m-d', strtotime($del_to_date));
        $criteria->addCondition('t.delivery_date <="' . $del_to_date . '"', 'AND');

        if (!empty($customer_id))
            $criteria->addCondition('t.company_id ="' . $customer_id . '"', 'AND');

        if (!empty($status))
            $criteria->addCondition('t.delivery_status ="' . $status . '"', 'AND');

        $customer = DeliveryNote::model()->with('customer')->findAll($criteria);
        $j = 0;
        $list[$j++] = 'No/Delivery No/File No/Order No/Customer Name/Status';

        foreach ($customer as $i => $row) {


            $list[$j++] = ($i + 1) . '/' . $row->id . '/' . $row->file_id . '/' . $row->order_id . '/' . $row->customer->customer_name . '/' . $row->delivery_status;
        }

        $j++;

        foreach ($list as $line) {
            fputcsv($file, explode('/', $line));
        }

        fclose($file);

        $filename = Yii::app()->getBaseUrl(true) . '/uploads/csvs/test.csv';

        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';

        header('Content-Type: application/csv');

        header("Content-disposition: attachment; filename=\"Deliverylist.csv\"");

        readfile($filename);

        Yii::app()->end();

        return;
    }

    public function actionPrintexcelInvoiceList() {
        $invoice_from_date = Yii::app()->request->getParam('invoice_from_date');
        //echo $del_from_date;
        //die();
        $invoice_to_date = Yii::app()->request->getParam('invoice_to_date');
        $customer_id = Yii::app()->request->getParam('customer_id');
        $sales_group = Yii::app()->request->getParam('sales_group');
        $file = fopen("uploads/csvs/test.csv", "w");
        $criteria = new CDbCriteria;

        if (!empty($invoice_from_date))
            $invoice_from_date = str_replace('/', '-', $invoice_from_date);
        $invoice_from_date = date('Y-m-d', strtotime($invoice_from_date));
        $criteria->addCondition('t.invoice_date >="' . $invoice_from_date . '"', 'AND');

        if (!empty($invoice_to_date))
            $invoice_to_date = str_replace('/', '-', $invoice_to_date);
        $invoice_to_date = date('Y-m-d', strtotime($invoice_to_date));
        $criteria->addCondition('t.invoice_date <="' . $invoice_to_date . '"', 'AND');


        $total = 0;
        $total_tax = 0;
        $customer = Invoice::model()->with('customer', 'items.product', 'items')->findAll($criteria);
        $j = 0;
        $list[$j++] = 'No/Invoice No/File No/Order No/Customer Name/Date/Grand Total/VAT(BC)/Grand Total(BC)/';

        foreach ($customer as $i => $row) {
            if ($row->invoice_date != '0000-00-00') {
                $invoice_date = date("d-m-Y", strtotime($row->invoice_date));
            } else {
                $invoice_date = "";
            }
            $amount = $row->grand_total;
            $model_currency = MasCurrency::model()->findByPk($row->currency);
            $total_bc = $amount * $model_currency->exchange_rate;
            $tax = $row->total_tax_amount * $model_currency->exchange_rate;
            $total_tax += $tax;
            $total += $total_bc;

            $list[$j++] = ($i + 1) . '/' . $row->id . '/' . $row->file_id . '/' . $row->order_id . '/' . $row->customer->customer_name . '/' . $invoice_date . '/' . $amount . '/' . $tax . '/' . $total_bc;
        }

        $j++;

        foreach ($list as $line) {
            fputcsv($file, explode('/', $line));
        }

        fclose($file);

        $filename = Yii::app()->getBaseUrl(true) . '/uploads/csvs/test.csv';

        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';

        header('Content-Type: application/csv');

        header("Content-disposition: attachment; filename=\"invoice.csv\"");

        readfile($filename);

        Yii::app()->end();

        return;
    }

    public function actionPrintCreditnoteExcel() {
        $from_date = Yii::app()->request->getParam('from_date');
        //echo $del_from_date;
        //die();
        $to_date = Yii::app()->request->getParam('to_date');
        $customer_id = Yii::app()->request->getParam('customer_id');
        $inv_type = Yii::app()->request->getParam('inv_type');
        $file = fopen("uploads/csvs/test.csv", "w");
        $criteria = new CDbCriteria;
        if (!empty($from_date))
            $from_date = str_replace('/', '-', $from_date);
        $from_date = date('Y-m-d', strtotime($from_date));
        $criteria->addCondition(' t.credit_date >="' . $from_date . '"', 'AND');

        if (!empty($to_date))
            $to_date = str_replace('/', '-', $to_date);
        $to_date = date('Y-m-d', strtotime($to_date));
        $criteria->addCondition('t.credit_date <="' . $to_date . '"', 'AND');

        if (!empty($customer_id))
            $criteria->addCondition('t.company_id ="' . $customer_id . '"', 'AND');

        if (!empty($inv_type))
            $criteria->addCondition('invoice.invoice_type ="' . $inv_type . '"', 'AND');

        $customer = Creditnote::model()->with('customer', 'file', 'invoice')->findAll($criteria);
        $j = 0;







        $list[$j++] = 'No/CN Date/File No/Inv.No/CN No/Customer Name/Reason/Inv.Amount/VAT/Credit Amount/Grand Total(BC';

        foreach ($customer as $i => $row) {
            $model_currency = MasCurrency::model()->findByPk($row->currency);
            $total_bc = $row->credited_amount * $model_currency->exchange_rate;

            $list[$j++] = ($i + 1) . '/' . date("d-m-Y", strtotime($row->credit_date)) . '/' . $row->file_id . '/' . $row->invoice_id . '/' . $row->id . '/' . $row->customer->customer_name
                    . '/' . $row->reason . '/' . $row->invoice->grand_total . '/' . $row->total_tax_amount . '/' . $row->credited_amount . '/' . $total_bc;
        }

        $j++;

        foreach ($list as $line) {
            fputcsv($file, explode('/', $line));
        }

        fclose($file);

        $filename = Yii::app()->getBaseUrl(true) . '/uploads/csvs/test.csv';

        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';

        header('Content-Type: application/csv');

        header("Content-disposition: attachment; filename=\"creditnote_list.csv\"");

        readfile($filename);

        Yii::app()->end();

        return;
    }

    public function actionPrintDirectsale() {
        $from_date = Yii::app()->request->getParam('from_date');
        //echo $del_from_date;
        //die();
        $to_date = Yii::app()->request->getParam('to_date');
        $customer_id = Yii::app()->request->getParam('customer_id');

        $file = fopen("uploads/csvs/test.csv", "w");
        $criteria = new CDbCriteria;
        if (!empty($from_date))
            $from_date = str_replace('/', '-', $from_date);
        $from_date = date('Y-m-d', strtotime($from_date));
        $criteria->addCondition(' t.order_date >="' . $from_date . '"', 'AND');

        if (!empty($to_date))
            $to_date = str_replace('/', '-', $to_date);
        $to_date = date('Y-m-d', strtotime($to_date));
        $criteria->addCondition('t.order_date <="' . $to_date . '"', 'AND');

        if (!empty($customer_id))
            $criteria->addCondition('t.customer_id ="' . $customer_id . '"', 'AND');



        $customer = DirectOrder::model()->with('customer_details')->findAll($criteria);
        $j = 0;






        $list[$j++] = 'No/Date/Order No/Inv.No/Customer Name/Currency/Total/VAT/Grand Total(BC';

        foreach ($customer as $i => $row) {
            $model_invoice = new Invoice();
            $model_invoice = $model_invoice->find('order_id="' . $row->id . '"');
            $model_currency = MasCurrency::model()->findByPk($row->currency);
            $total_bc = $row->grand_total * $row->currency_details->exchange_rate;

            $list[$j++] = ($i + 1) . '/' . date("d-m-Y", strtotime($row->order_date)) . '/' . $row->id . '/' . $model_invoice->id . '/' . $row->customer_details->customer_name . '/' . $row->currency_details->currency_code
                    . '/' . $row->grand_total . '/' . $row->total_tax_amount . '/' . $total_bc;
        }

        $j++;

        foreach ($list as $line) {
            fputcsv($file, explode('/', $line));
        }

        fclose($file);

        $filename = Yii::app()->getBaseUrl(true) . '/uploads/csvs/test.csv';

        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';

        header('Content-Type: application/csv');

        header("Content-disposition: attachment; filename=\"directsale.csv\"");

        readfile($filename);

        Yii::app()->end();

        return;
    }

    public function actionPrintNetsaleList() {
        $from_date = Yii::app()->request->getParam('from_date');
        //echo $del_from_date;
        //die();
        $to_date = Yii::app()->request->getParam('to_date');
        $customer_id = Yii::app()->request->getParam('customer_id');
        $leadowner_id = Yii::app()->request->getParam('leadowner_id');
        $invoice_type = Yii::app()->request->getParam('invoice_type');
        $file = fopen("uploads/csvs/test.csv", "w");
        $criteria = new CDbCriteria;

        if (!empty($from_date))
            $from_date = str_replace('/', '-', $from_date);
        $from_date = date('Y-m-d', strtotime($from_date));
        $criteria->addCondition('t.invoice_date >="' . $from_date . '"', 'AND');

        if (!empty($to_date))
            $to_date = str_replace('/', '-', $to_date);
        $to_date = date('Y-m-d', strtotime($to_date));
        $criteria->addCondition(' t.invoice_date <="' . $to_date . '"', 'AND');

        if ($leadowner_id > 0)
            $criteria->addCondition(' t.lead_owner_id ="' . $leadowner_id . '"', 'AND');
        if ($customer_id > 0)
            $criteria->addCondition(' t.company_id ="' . $customer_id . '"', 'AND');


        $total = 0;
        $total_tax = 0;
        $customer = Invoice::model()->with('customer')->findAll($criteria);
        $j = 0;
        $list[$j++] = 'No/Invoice No/File No/Customer Name/Lead Owner/Inv.VAT/Inv.Amt/CN VAT/CN Amt/Net VAT/Net Amount/';

        foreach ($customer as $i => $row) {
            $model_credit = Creditnote::model()->find(array('select' => 'IFNULL(SUM(credited_amount*exchange_rate),0)as credited_amount,IFNULL(SUM(total_tax_amount*exchange_rate),0)as total_tax_amount', 'condition' => 't.invoice_id=' . $row->id));
            if ($row->invoice_date != '0000-00-00') {
                $invoice_date = date("d-m-Y", strtotime($row->invoice_date));
            } else {
                $invoice_date = "";
            }
            $model_currency = MasCurrency::model()->findByPk($row->currency);
            $amount = $row->grand_total + $row->total_tax_amount;
            $credit = $model_credit->credited_amount + $model_credit->total_tax_amount;
            $total_bc = $amount * $model_currency->exchange_rate;
            $tax = $row->total_tax_amount * $model_currency->exchange_rate;
            $total_tax += $tax;
            $total_cn_tax += $model_credit->total_tax_amount;
            $total += $total_bc;
            $cn_total +=$credit;
            $net_amount = $total_bc - (int) ($model_credit->credited_amount);
            $list[$j++] = ($i + 1) . '/' . $row->id . '/' . $row->file_id . '/' . $row->customer->customer_name . '/' . $row->file->leadowner->first_name . " " . $row->file->leadowner->last_name . '/'
                    . $tax . '/' . $total_bc . '/' . $model_credit->total_tax_amount . '/' . $credit . '/' . $tax . '/' . $net_amount;
        }

        $j++;

        foreach ($list as $line) {
            fputcsv($file, explode('/', $line));
        }

        fclose($file);

        $filename = Yii::app()->getBaseUrl(true) . '/uploads/csvs/test.csv';

        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';

        header('Content-Type: application/csv');

        header("Content-disposition: attachment; filename=\"netsales_list.csv\"");

        readfile($filename);

        Yii::app()->end();

        return;
    }

    public function actionPrintGrossprofitList() {
        $from_date = Yii::app()->request->getParam('from_date');
        //echo $del_from_date;
        //die();
        $to_date = Yii::app()->request->getParam('to_date');
        $customer_id = Yii::app()->request->getParam('customer_id');
        $leadowner_id = Yii::app()->request->getParam('leadowner_id');
        $sales_group = Yii::app()->request->getParam('sales_group');
        $actual_cost = Yii::app()->request->getParam('actual_cost');
        $file = fopen("uploads/csvs/test.csv", "w");
        $criteria = new CDbCriteria;

        if (!empty($from_date))
            $from_date = str_replace('/', '-', $from_date);
        $from_date = date('Y-m-d', strtotime($from_date));
        $criteria->addCondition('t.invoice_date >="' . $from_date . '"', 'AND');

        if (!empty($to_date))
            $to_date = str_replace('/', '-', $to_date);
        $to_date = date('Y-m-d', strtotime($to_date));
        $criteria->addCondition(' t.invoice_date <="' . $to_date . '"', 'AND');


        $total = 0;
        $total_tax = 0;
        $customer = Grossprofit::model()->findAll($criteria);
        $j = 0;
        $list[$j++] = 'No/Invoice No/Invoice Date/Customer Name/Currency/Invoice Value/Value(BC)/Cost/Profit/Profit (%)/';

        foreach ($customer as $i => $row) {
            $total_cost_rate = $row->total_cost_rate;
            $invoice_value_bc = $row->invoice_value_bc;
            $profit_value = ($invoice_value_bc - $total_cost_rate);
            $profit+= $profit_value;

            $profit_in_percentage = (($invoice_value_bc) > 0) ? round(($profit_value / $invoice_value_bc) * 100, 2) : 0;


            if ($row->invoice_date != '0000-00-00') {
                $invoice_date = date("d-m-Y", strtotime($row->invoice_date));
            } else {
                $invoice_date = "";
            }

            if (!empty($actual_cost)) {
                $cost = $actual_cost;
            } else {
                $cost = "0";
            }


            $list[$j++] = ($i + 1) . '/' . $row->invoice_no . '/' . $invoice_date . '/' . $row->customer_name . '/' . $row->currency_name . '/'
                    . $row->invoice_value . '/' . $row->invoice_value_bc . '/' . $cost . '/' . $profit_value . '/' . $profit_in_percentage;
        }

        $j++;

        foreach ($list as $line) {
            fputcsv($file, explode('/', $line));
        }

        fclose($file);

        $filename = Yii::app()->getBaseUrl(true) . '/uploads/csvs/test.csv';

        $path = Yii::app()->getBaseUrl(true) . '/uploads/csvs';

        header('Content-Type: application/csv');

        header("Content-disposition: attachment; filename=\"grossprofitlist.csv\"");

        readfile($filename);

        Yii::app()->end();

        return;
    }

    /* adharsh 1-3-2018 ends */
    /* jisha 8-1-17 starts */

    public function actionPrintInvoiceCommissionIncentiveReport() {

        $model = new Customer();

        $arr_details['customer_id'] = $_POST['customer_id'];
        $arr_details['leadowner_id'] = $_POST['leadowner_id'];
        $arr_details['from_date'] = $_POST['from_date'];
        $arr_details['to_date'] = $_POST['to_date'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->render('//reports/print_invcommisionincentive_list', array('model' => $model, 'arr_details' => $arr_details), false, true);
    }

    public function actionPrintCommissionIncentiveReport() {

        $model = new Customer();

        $arr_details['customer_id'] = $_POST['customer_id'];
        $arr_details['leadowner_id'] = $_POST['leadowner_id'];
        $arr_details['from_date'] = $_POST['from_date'];
        $arr_details['to_date'] = $_POST['to_date'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->render('//reports/print_commisionincentive_list', array('model' => $model, 'arr_details' => $arr_details), false, true);
    }

    /* jisha 8-1-17 ends */
}
