<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'department-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
        ));
?>

<div class="tab-content">

    <div class="tab-pane active">
        <ul class="clearfix form-ul material">
            <li class="col-sm-6">
                <input type="hidden" name="from" id="from" value="<?php echo $from; ?>">
                <?php echo $form->hiddenField($model, 'id'); ?>
                <?php echo $form->textField($model, 'department_name', array('data-label' => 'Department Name *', 'data-validation' => 'required')); ?>

                <?php echo $form->error($model, 'department_name'); ?>
            </li>
        </ul>
    </div>
</div>

<div class="modal-footer">
    <button type="button" class="btn btn-default" id="dept_close" data-dismiss="modal">Close</button>

<?php
$url = Yii::app()->createUrl('/Department/SaveDepartment');

echo CHtml::ajaxSubmitButton('Save', $url, array(
    'dataType' => 'json',
    'type' => 'post',
    'success' => 'function(data) {
        $("#loader").hide();
        if(data.status=="success"){  
            t8.success("Saved Successfully!");
            $("#dept_close").click();
            reloadTable("#tbl_department_details");
        } else { 
            $("#department-form .department-save-btn").prop("disabled", false);                      
            $("#department-form .department-save-btn").addClass("btn-theme").removeClass("btn_loding"); 
            $.each(data, function(key, val) {
                t8.error(""+val+""); 
            }); 
        } 
    }',
    'beforeSend' => 'function(){
        $("#loader").show();
        $("#department-form .department-save-btn").prop("disabled", true);                      
        $("#department-form .department-save-btn").addClass("btn_loding").removeClass("btn-theme"); 
        $(".toast8-error").hide(); 
    }'
        ), array('id' => 'mybtn' . rand(), 'class' => 'department-save-btn btn btn-theme'));
?>
</div>
    <?php $this->endWidget(); ?>