<?php
if ($action == 'view_country_detail') {
    ?>

    <div class="col-lg-12">
        <?php
        $model_country = MasCountry::model()->findByPk($country_id);
        ?>
        <p>
            <label>Emirates : </label>
            <b><?php echo $model_country['country_name']; ?></b>
        </p>
        <table class="table table-hover table-bordered personal-task">
            <thead>
                <tr>
                    <th>S.No</th>
                    <th>Month</th>
                    <th>Lead Count</th>
                </tr>
            </thead>
            <tbody>

                <?php
                if (!empty($graph_detail)) {
                    $i = 1;
                    $month_array = array("January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December");
                    $total = 0.00;
                    foreach ($graph_detail as $value) {
                        $month = $value['m'] - 1;
                        ?>
                        <tr onclick="getLeadCountryMonthDetails(<?php echo $value['m']; ?>,<?php echo $value['y']; ?>,<?php echo $country_id; ?>)">
                            <td><?php echo $i; ?></td>
                            <td><?php echo $month_array[$month] . " - " . $value['y']; ?></td>
                            <td class="text-right"><?php echo $value['TOTAL_COUNT']; ?></td>
                        </tr>
                        <?php
                        $total += $value['TOTAL_AMT'];
                        $i++;
                    }
                    ?>
                    <?php
                } else {
                    ?>
                    <tr>
                        <td colspan="4">No data found</td>
                    </tr>
                    <?php
                }
                ?>
            </tbody>
        </table>
    </div>

    <?php
} else if ($action == 'view_country_month_detail') {

    $month_arr = array("January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December");
    $month = $month - 1;
    ?>
    <div class="col-lg-12">
        <p>

            <b><?php echo $month_arr[$month] . " - " . $year; ?></b>
        </p>
        <table class="table table-hover table-bordered personal-task">
            <thead>
                <tr>
                    <th>S.No</th>
                    <th>ID</th>
                    <th>Customer Name</th>
                    <th>Enq Date</th>
                    <th>Closing Date</th>
                    <th>Amount</th>
                </tr>
            </thead>
            <tbody>

                <?php
                if (!empty($graph_detail)) {
                    $i = 1;
                    $total_amt = 0.00;
                    //$month_array = array("January","February","March","April","May","June","July","August","September","October","November","December");
                    foreach ($graph_detail as $value) {

                        $model_customer = Customer::model()->findByPk($value['customer_id']);
                        ?>
                        <tr>
                            <td><?php echo $i; ?></td>
                            <td><?php echo $value["id"]; ?></td>
                            <td><?php echo empty($model_customer->customer_name) ? $value["customer_name"] : $model_customer->customer_name; ?>

                            </td>
                            <td><?php echo date('d/m/Y', strtotime($value['enq_date'])); //echo $value['enq_date'];       ?></td>
                            <td><?php echo date('d/m/Y', strtotime($value['closing_date'])); //echo $value['closing_date'];       ?></td>
                            <td class="text-right"><?php echo $value['value']; ?></td>
                        </tr>
                        <?php
                        $total_amt += $value['value'];
                        $i++;
                    }
                    ?>
                    <tr>
                        <td class="text-right" colspan="5"><b>Total Amount</b></td>
                        <td class="text-right"><b><?php echo number_format((float) $total_amt, 2, '.', ''); ?></b></td>
                    </tr>
                    <?php
                } else {
                    ?>
                    <tr>
                        <td colspan="6">No data found</td>
                    </tr>
                    <?php
                }
                ?>
            </tbody>
        </table>
    </div>
    <?php
}
?>
