<?php

$colour = MasColourScheme::model()->findAll();
$cs = Yii::app()->getClientScript();
$baseUrl = Yii::app()->baseUrl;

$cs->registerScript("loadSettings", '
        $(document).ready(function() {

        var table_id ="#tbl_colour_details";
        var table = $(table_id).on("preXhr.dt", function (e, settings, data) {
        data.type = $("#type").val();
        return data;
    }).DataTable({
            scrollY         : "645px",
           // scrollX         : "true",
           // scrollCollapse  : true,
            pageLength      : 50,
			processing: true,
            ajax: {
                url: "' . Yii::app()->createUrl('colourscheme/GetList') . '",
                type: "POST",
                cache : false,
            },
             "columnDefs": [
                    {
                       "targets": [0,3],
                       "visible": false,
                    }
                 ],
             "rowCallback": function ( row, data ){
               
                     $("td", row).css("background-color", ""+data[3]+"");
              },
            serverSide:     true,
            fixedColumns:   true,
			processing: true,
//            fixedHeader: {
//                headerOffset: $("header.main").outerHeight()
//            }
        } );
        $(".dataTables_scrollFoot").hide();
    });', CClientScript::POS_HEAD);
    ?>
    <section class="panel" style="background-color:#F6F3EE;">
        <header class="panel-heading clearfix panel-theame">
            <i class="fa fa-crosshairs"></i> Colour Scheme
            <div class="pull-right">
              <div class="col-md-12">
                  <div class="col-md-12" width="100%">
            <?php  echo CHtml::dropdownList('type','',array('Q'=>'Quotation','O'=>'Order','L'=>'Lead'),array('class'=>'form-control', 'prompt'=>'--Type--','onChange' => 'reloadTable("#tbl_colour_details")'));  ?> 
                  </div>
              </div>
<!--            <div class="pull-right">
                <button class="btn btn-sm btn-theme" onclick="loadPopupModal('colourscheme/create','Add','lg')"><i class="fa fa-plus"></i> ADD</button>
            </div>-->
            
        </header>
        <div class="panel-body">
            <div class="custom-data-table">
                <table class="table table-hover table-bordered personal-task" id="tbl_colour_details" style="font-size:13px;">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Item</th>
                            <th>Field Name</th>
                            <th>Colour</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tfoot>
                        <tr>
                            <th>No</th>
                            <th>Item</th>
                            <th>Field Name</th>
                            <th>Colour</th>
                            <th>Actions</th>
                            
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </section>
