<section class="panel">
        <header class="panel-heading clearfix panel-theame">
            <i class="fa fa-calendar"></i> My Calendar
            <div class="pull-right">
        </div>
        </header>
        <div class="panel-body">
                <div id="calendar"></div>
        </div>
    </section>

     <?php
$cs = Yii::app()->getClientScript();
$baseUrl = Yii::app()->baseUrl;

$cs->registerScript("getCalendar", "$(document).ready(function(){
getCalendarEvents();

});", CClientScript::POS_READY);



$cs->registerScript("getCalendarEvents".rand(), "function getCalendarEvents(){
  var filter_id = $('#sel_event_type').val();
  $('#calendar').fullCalendar({
            header: {
                left: 'prev,next today',
                center: 'title',
                right: 'month,basicWeek,basicDay'
            },
            dayClick: function(date, allDay, jsEvent, view) { $(this).addClass('selected-date');},
            eventClick: function(calEvent, jsEvent, view) {           
            },
            header: { left: 'prev,next today', center: 'title', right: 'month,agendaWeek,agendaDay'},
            buttonText: {
                today: 'T',
                month: 'M',
                agendaWeek: 'W',
                agendaDay: 'D'
            },
            defaultView: 'month',
            eventMouseover: function(calEvent, jsEvent) {
                var tooltip = '<div class=\"tooltipevent\">' +calEvent.description + '</div>';
                $(\"body\").append(tooltip);
                $(this).mouseover(function(e) {
                    $(this).css('z-index', 10000);
                    $('.tooltipevent').fadeIn('500');
                    $('.tooltipevent').fadeTo('10', 1.9);
                }).mousemove(function(e) {
                    $('.tooltipevent').css('top', e.pageY + 10);
                    $('.tooltipevent').css('left', e.pageX - 60);
                });
            },
            eventMouseout: function(calEvent, jsEvent) {
                $(this).css('z-index', 8);
                $('.tooltipevent').remove();
            },
            eventAfterRender:function (event, element) { },
            editable: true,
            eventLimit: true,
            //timeFormat: '',
            eventRender: function (calEvent, jsEvent) {
                var tooltip = calEvent.description;
                var type=calEvent.type;
                $(jsEvent).attr('data-original-title', tooltip);
                $(jsEvent).tooltip({ container: 'body',html:true});
                // $(jsEvent).find('.fc-event-time').remove();
                return ['all', calEvent.type].indexOf($('#filter_selector').val()) != ''
            },
            
            loading: function( isLoading, view ) {
            if(isLoading) {// isLoading gives boolean value
                $('#loader').show();
            } else {
                 $('#loader').hide();
            }
        },
            
            
        events: {
                url : '" . Yii::app()->createUrl('calendar/getevent') . "',
            },            
        });
        
        
    }
", CClientScript::POS_READY);

?>

<style>.fc-time{
   display : none;
}</style>
