<?php
$invoice_update_jo_color = MasColourScheme::model()->find(array('condition'=>'text_code="IJO"'))->colour;
$invoice_jo_mismatch_color = MasColourScheme::model()->find(array('condition'=>'text_code="IJOC"'))->colour;
$cs = Yii::app()->getClientScript();
$cs->registerScript("cancelinvoice", "function cancelinvoice(invoice_id) {
    jConfirm('Confirm Cancellation of Invoice No- '+invoice_id+' ?', 'Confirmation Dialog', function(r) {
        if (r == true) {
                jQuery.ajax({
                    'dataType':'json',
                    'data' :{'id':invoice_id},
                    'type':'post',
                    'url': '" . Yii::app()->createUrl('logistics/invoice/cancelinvoice') . "',
                    'cache': false,
                    'success': function(data) {
                        if(data.status=='success'){
                            t8.success('Invoice Cancelled!');  
                            reloadTable('#tble_invoice'); 
                        }else{
                            $.each(data, function(key, val) { 
                                t8.error('Error In Cancellation'); 
                            }); 
                        }
                    }, 
                    'beforeSend':function(){
                        $('#loader').show();
                    },
                    'complete':function(){
                        $('#loader').hide();   
                    }
                });     
            }
        }); 
};", CClientScript::POS_HEAD);
?>
<script type="text/javascript">
    $(document).ready(function() {

    var table_id = "#tble_invoice";
    var table = $(table_id).on("preXhr.dt", function (e, settings, data) {
    data.invoice_type = $("#invoice_type").val();
    data.frm = $("#frm").val();
    return data;
    }).DataTable({
    scrollY         : "645px",
            pageLength      : 100,
            processing: true,
            columns: [
            {className: "sl col-max-1"},
            {className: "sl col-max-1"},
            {className: "sl col-max-1"},
            {className: "sl col-max-1"},
            {className: "sl col-max-1" },
            {className: "sl col-max-3" },
            {className: "sl col-max-1" },
            {className: "sl col-max-1" },
            {className: "sl col-max-1 text-right"},
            {className: "sl col-max-1 text-right"},
            {className: "sl col-max-1"},
            ],
            "columnDefs": [
            {
            "targets": [11,12, 13, 14, 15],
                    "visible": false,
            },
            ],
            ajax: {
            url: "<?php echo Yii::app()->createUrl('logistics/invoice/getinvoicelist'); ?>",
                    data: {"frm":<?php echo $frm; ?>},
                    type: "POST",
                    cache : false,
            },
            serverSide:     true,
            fixedColumns:   true,
            processing: true,
            fixedHeader: {
            headerOffset: $("header.main").outerHeight()
            },
            "fnCreatedRow"  : function(nRow, aData, iDataIndex){
            $(nRow).addClass("context-menu");
            },
            "fnRowCallback" : function(nRow, aData, iDisplayIndex, iDisplayIndexFull){
            if (aData[13] == "C"){
                $("td", nRow).css("background-color", "#ffcccb");
            }
            
             if (aData[16] > 0){
                $("td", nRow).css("background-color", "<?php echo $invoice_update_jo_color;?>");
            }  
            else if (aData[17] > 0){
                $("td", nRow).css("background-color", "<?php echo $invoice_jo_mismatch_color;?>");
            } 
            else if (aData[14] == "Y"){
                $("td", nRow).css("background-color", "#94EA9F");
            }
            $('#tble_invoice tbody').on('mouseover', 'tr', function () {
            $.contextMenu('destroy');
            });
            $('#tble_invoice tbody').on('click', 'tr', function () {
            var data = table.row(this).data();
            var invoice_posted = data[14];
            var invoice_cancel = data[15];
            var is_credit_note = data[11];
            var cnt_non_order_item = data[16];
            var invoice_status = data[13];
            var post_flag = data[17];
            
            $.contextMenu({
            selector: '.context-menu',
                    callback: function(key, options) {
                    var action_id = key;
                    var data = table.row(this).data();
                    var file_id = data[0];
                    var id = data[1];
                    var customer_id = data[12];
                    //var crm_user_id = data[14];
                    var customer_name = data[5];
                    var is_credit_note = data[11];
                    var invoice_posted = data[14];
                    var cnt_non_order_item = data[16];
                    var invoice_status = data[13];
                    var post_flag = data[17];
                    
                    if (action_id == "printpartnumber"){
                    window.open($('#liveSite').val() + "/index.php?r=logistics/invoice/PrintInvoiceReportPDF&id=" + id + "&frm=tax&barcode=N", "_blank")
                    }
                    else if (action_id == "activity"){
                        
                        loadPopupModal("activity/activity/history&frm=IN&customer_id="+customer_id+'&header_id='+id+'&file_id='+file_id,"Invoice" ,"xl");
                        //loadPopupModal("activity/create&file_id=" + file_id + "&customer_id=" + customer_id, "Edit Activity", "xl");
                    }else if (action_id == "view"){
                        loadPopupModal("logistics/invoice/CreateInvoice&id=" + id+"&type=view", "View Invoice - " + file_id + "/" + id + "/" + customer_name, "xl");
                    }else if (action_id == "cancel"){
                        cancelinvoice(id);
                    }else if (action_id == "edit"){
                        loadPopupModal("logistics/invoice/CreateInvoice&id=" + id, "Edit Invoice - " + file_id + "/" + id + "/" + customer_name, "xl");
                    }else if (action_id == "printbarcode"){
                    window.open($('#liveSite').val() + "/index.php?r=logistics/invoice/PrintInvoiceReportPDF&id=" + id + "&frm=tax&barcode=Y", "_blank")
                    }
                    else if (action_id == "updatecustomer"){
                        loadPopupModal("logistics/invoice/UpdateCustomer&id=" + id, "Edit Customer - " + id + "/" + customer_name, "xl");
                    }
//                    else if(action_id == "uploaddocument"){
//                        loadPopupModal("document/UploadERPDocument&frm=I&file_id=" + file_id, "Upload Document - " + file_id + "/" + id, "lg");
//                    }
                    else if(action_id == "post"){
                           jQuery.ajax({
                            'type': 'post',
                            'url': $('#liveSite').val() +"/index.php?r=finance/core/savemodulevouchers",
                            'data' : {'voucher_selection' : '7','type':'direct','status' : 'NEW','ids[]': id},
                            'success': function(data) { 
                            t8.success("Posted!");
                            reloadTable("#tble_invoice");
                            }
                        });
                    }
                    else if(action_id == "postsendemail"){
                        $('#loader').show();
                        
                           jQuery.ajax({
                            'type': 'post',
                            'url': $('#liveSite').val() +"/index.php?r=finance/core/savemodulevouchers",
                            'data' : {'voucher_selection' : '7','type':'direct','status' : 'NEW','ids[]': id,'frm':'postemail'},
                            'success': function(data) { 
                                
                                var content = jQuery.ajax({
                                    'type': 'post',
                                    'url': $('#liveSite').val() +"/index.php?r=logistics/invoice/sendpostedinvoice",
                                    'data' : {'id':id},
                                     'async': false
                                }).responseText;;
                                
                                if(content=='success'){
                                    $('#loader').hide();
                                    t8.success("Posted and Send Mail");
                                    reloadTable("#tble_invoice");
                                }
                                else{
                                    $('#loader').hide();
                                    t8.success("Posted! No email exist to send an email");
                                }
                            }
                        });
                    }
                    else if(action_id == "unpost"){
                           jQuery.ajax({
                            'type': 'post',
                            'url': $('#liveSite').val() +"/index.php?r=finance/core/savemodulevouchers",
                            'data' : {'voucher_selection' : '7','type':'direct','status' : 'EXISTING','ids[]': id},
                            'success': function(data) { 
                            t8.success("Unposted!");
                            reloadTable("#tble_invoice");
                            }
                        });
                    }
                    else if(action_id == "updatejoborder"){
                           loadPopupModal("logistics/invoice/updatejoborderitem&id=" + id, "Update Job Order - " + file_id + "/" + id + "/" + customer_name, "xl");
                    }
                    },
                    items: {
                        <?php if ((Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["invoice_edit"]))) { ?>
                            "edit": {name: "Edit", icon: "fa-edit", disabled: function(key, opt) {
                                    if (invoice_posted=='Y' || is_credit_note=='Y' || invoice_status=='C'){
                                        return !this.data('editDisabled');
                                    }
                                }
                            },
                        <?php } ?>
                          <?php if ((Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["invoice_edit"]))) { ?>
                            "updatecustomer": {name: "Update Customer", icon: "fa-refresh", disabled: function(key, opt) {
                                    if (invoice_posted=='Y' || is_credit_note=='Y' || invoice_status=='C'){
                                        return !this.data('updatecustomerDisabled');
                                    }
                                }
                            },
                        <?php } ?>
                  
                        <?php if ((Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["invoice_view"]))) { ?>
                            "view": {name: "View", icon: "fa-eye"},
                    <?php } ?>
                  

            
   <?php if ((Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["invoice_job_update"]))) { ?>
                            "updatejoborder": {name: "Update Job Order", icon: "fa-refresh", disabled: function(key, opt) {
                                    if (/*invoice_posted=='Y' || is_credit_note=='Y' || */cnt_non_order_item==0 || invoice_status=='C'){
                                        return !this.data('updatejoborderDisabled');
                                    }
                                }
                            },
                        <?php } ?>
                  
                       <?php if ((Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["activity_add"]))) { ?>
                        "activity": {name: "Activity", icon: "fa-certificate", disabled: function(key, opt) {
                                    if (invoice_status=='C'){
                                        return !this.data('activityDisabled');
                                    }
                                }},
                        <?php } ?>
                        <?php if ((Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["invoice_print"]))) { ?>
                                                        "printpartnumber": {name: "Print", icon: "fa-print"/*, disabled: function(key, opt) {
                                                        if (invoice_nature == 'A'){
                                                        return !this.data('printpartnumberDisabled');
                                                        }
                                                        }*/
                                                        },
                        <?php } ?>



            
   <?php if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["finance_voucher_import"])) { ?>
        "post": {name: "Post", icon: "fa-send", disabled: function(key, opt) {
                                    if (invoice_posted == 'Y' || cnt_non_order_item > 0 || post_flag==1  || invoice_status=='C'){
                                        return !this.data('postDisabled');
                                    }
                                }},
        <?php } ?>
        
         <?php if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["finance_voucher_import"])) { ?>
        "postsendemail": {name: "Post & Send Mail", icon: "fa-send", disabled: function(key, opt) {
                                    if (invoice_posted == 'Y' || cnt_non_order_item > 0 || post_flag==1 || invoice_status=='C'){
                                        return !this.data('postsendemailDisabled');
                                    }
                                }},
        <?php } ?>
            
   <?php if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["finance_voucher_import"])) { ?>
        "unpost": {name: "Unpost", icon: "fa-retweet", disabled: function(key, opt) {
                                    if (invoice_posted == 'N'  || invoice_status=='C'){
                                        return !this.data('unpostDisabled');
                                    }
                                }},
        <?php } ?>

                    }
            });
            });
            }
    });
    });</script>

<section class="panel"  style="background-color:#F6F3EE;">
    <input type="hidden" name="frm" id="frm" value="<?php echo $frm; ?>">
    <?php if ($frm == 1) { ?>
        <header class="panel-heading clearfix panel-theame-new">
        <?php } else { ?>
            <header class="panel-heading clearfix panel-theame">
            <?php } ?>
            <i class="fa fa-user"></i> Invoice
            <div class="pull-right">
                <div class="col-md-12">
                    <!--<div class="col-md-8" width="100%">-->
                        <?php //echo CHtml::dropdownlist('invoice_type', '', MasSalesGroup::getSalesGroup(), array('class' => 'form-control', 'onchange' => 'reloadTable("#tble_invoice");', 'prompt' => 'All')); ?>
                    <!--</div>-->
                    <?php
                    /*if ($frm != 1 && (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["invoice_add"]))) {
                        ?>
                        <div class="col-md-3">
                            <button class="btn btn-sm btn-theme" id="add_popup" onclick="loadPopupModal('logistics/invoice/createMultiInvoice', 'Add New Invoice', 'xl')"><i class="fa fa-plus"></i> ADD</button>
                        </div>
                    <?php }*/ ?>
                <?php if( Yii::app()->user->authorised_user == 1 || (int) Yii::app()->user->havePermissionOn["finance_voucher_import"] ) : ?>
                <button class="btn btn-sm btn-theme" title="Import Vouchers" onclick="loadPopupModal('finance/core/importvoucherssales','Post/Unpost','xl')"><i class="fa fa-download"></i> Post/Unpost</button>
            <?php endif; ?>
                </div>
            </div>
        </header>   
        <div class="panel-body">
            <div class="custom-data-table">
                <table class="table table-hover table-bordered personal-task" id="tble_invoice" style="font-size:13px;">
                    <thead>
                        <tr>
                            <th>File</th>
                            <th>Inv No</th>
                            <th>Order No</th>
                            <th>AWB#</th>
                            <th>Inv Date</th>
                            <th>Customer</th>
                            <th>Lead Owner</th>
                            <th>Curr</th>
                            <th>VAT</th>
                            <th>Value</th>
                            <th>Status</th>
                        </tr>
                    </thead>

                </table>
            </div>
            <div class="color-indicator">
                <span style="display: inline-block;width:30px;height:30px;background:#ffffff; box-shadow: 0px 2px 10px 2px #b7b5b5"></span><span class="verti"> Sales</span>
                <span style="display: inline-block;width:30px;height:30px;background:#D6FCDA; box-shadow: 0px 2px 10px 2px #b7b5b5"></span><span class="verti"> Hire</span>
                <span style="display: inline-block;width:30px;height:30px;background:#94EA9F; box-shadow: 0px 2px 10px 2px #b7b5b5"></span><span class="verti"> Direct Invoice</span>
                <span style="display: inline-block;width:30px;height:30px;background:#FFFACD; box-shadow: 0px 2px 10px 2px #b7b5b5"></span><span class="verti"> Advance</span>
                <span style="display: inline-block;width:30px;height:30px;background:#ffcccb; box-shadow: 0px 2px 10px 2px #b7b5b5"></span><span class="verti"> Cancelled</span>
                <span style="display: inline-block;width:30px;height:30px;background:<?php echo $invoice_update_jo_color;?>; box-shadow: 0px 2px 10px 2px #b7b5b5"></span><span class="verti"> To Update - Job Order</span>
                <span style="display: inline-block;width:30px;height:30px;background:<?php echo $invoice_jo_mismatch_color;?>; box-shadow: 0px 2px 10px 2px #b7b5b5"></span><span class="verti"> Item Count Mismatch</span>
            </div>
        </div>
</section>






