<div class="tab-content">
    <div class="tab-pane active" id="inventory">
        <section class="panel" style="background-color:#F6F3EE;">
            <header class="panel-heading clearfix panel-theame">
                <i class="fa fa-users"></i> Services
                <?php
                    ?>
                <div class="pull-right">
                <?php if ((Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["service_add"]))) { ?>
                    <button class="btn btn-sm btn-theme" onclick="loadPopupModal('logistics/inventory/createservice', 'New Service Item', 'lg')"><i class="fa fa-plus"></i> ADD</button>
                <?php } ?>
                </div>
                <input type="hidden" id="inventory_type" name="inventory_type" value="S">
                
            </header>   
            <div class="panel-body">
                <div class="custom-data-table">
                    <table class="table table-hover table-bordered personal-task datatable" id="tbl_service_inventory" style="font-size:13px;">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Part No</th>
                                <th>Description</th>
                                <th>Generic</th>
                                <th>Brand</th>
                                <th>Unit</th>
                                <th>Tax(%)</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </section>
    </div>
</div>
<script>
    $(document).ready(function () {
        //document ready

        var table_details_id = "#tbl_service_inventory";
        table_details = $(table_details_id).on("preXhr.dt", function (e, settings, data) {
        data.brand  = $("#brand").val();
        return data;

        }).DataTable({
            scrollY: "550px",
            "bAutoWidth": true,
            pageLength: 50,
            columns: [
                {className: ""},
                {className: ""},
                {className: ""}, 
                {className: ""},
                {className: ""},
                {className: ""},
                {className: ""},
                {className: ""},
            ],
            ajax: {
                url: "index.php?r=logistics/inventory/getservicelist",
                type: "POST",
                cache: false,
            },
            serverSide: true,
            fixedColumns: true,
            processing: true,
            order: [[1, "asc"]],
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {

                if (aData[2] == "Service") {
                    $("td", nRow).addClass("bg-success");
                }
                if (aData[11] == "N") {
                    $("td", nRow).addClass("bg-danger");
                }
            }
        });
        
        
        $(".dataTables_scrollFoot").hide();

    });
    function block(id, status){
        var r = confirm((status == "1") ? 'Are you sure to Block this Item?' : 'Are you sure to Unblock this Item?');
        if (r == true)
        {
            jQuery.ajax({
                'type'  : 'post',
                'datatype' :'json',
                'data'  : 'id=' + id + "&status=" + status,
                'url'  : $('#liveSite').val() + 'index.php?r=logistics/Inventory/EnableDisable',
                'cache': false,
                'success':function(data){
                    if (data.status == 'fail'){
                        t8.error('Please Try Later');
                    } else {
                        t8.info('Item Status Updated');
                        reloadTable("#tbl_service_inventory");
                    }
                }
            });
        }
    }
</script>