<div class="tab-content">
    <div class="tab-pane active" id="inventory">
        <section class="panel" style="background-color:#F6F3EE;">
            <header class="panel-heading clearfix panel-theame">
                <i class="fa fa-users"></i> Inventory
                <?php if ((Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["stock_add"]))) { ?>
                    <button class="btn btn-sm btn-theme" onclick="loadPopupModal('logistics/inventory/create', 'New Inventory', 'lg')"><i class="fa fa-plus"></i> ADD</button>
                    <button class="btn btn-sm btn-theme" onclick="loadPopupModal('logistics/uploadstock/uploadinventory', 'Upload Inventory', 'xl')"><i class="fa fa-upload"></i> UPLOAD</button>
                <?php  } ?>
                <div class="pull-right" style="display:inline-flex">
                <!--&NonBreakingSpace;-->
                <?php echo CHtml::dropdownlist('customer_id','',Customer::getCustomers(), array('class'=>'form-control','data-label'=>'Customer','prompt' => 'All Customers')); ?>
               
                <?php //echo CHtml::dropdownlist('ware_house_id','',MasInventoryWarehouse::getWarehouses(), array('class'=>'form-control','data-label'=>'Warehouse','prompt' => 'All Warehouse')); ?>
                <?php //echo CHtml::dropdownlist('rack_id','',MasInvRack::getRacks(), array('class'=>'form-control','data-label'=>'Rack','prompt' => 'All Rack')); ?>
                <?php //echo CHtml::dropdownlist('bin_id','',MasInvBin::getBins(), array('class'=>'form-control','data-label'=>'Bin','prompt' => 'All Bin')); ?>
                &NonBreakingSpace;
                <button class="btn btn-sm btn-theme" onclick="reloadTable('#tbl_inventory');"><i class="fa fa-retweet"></i></button>&nbsp;
                <?php if ((Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["stock_add"]))) { ?>
                <button class="btn btn-sm btn-theme" onclick="LoadInventoryExcel();"><i class="fa fa-file-excel-o"></i> Export to Excel</button>
                <?php  } ?>
                <input type="hidden" id="inventory_type" name="inventory_type" value="I">
                </div>
            </header>   
            <div class="panel-body">
                <div class="custom-data-table">
                    <table class="table table-hover table-bordered personal-task datatable" id="tbl_inventory" style="font-size:13px;">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Customer Name</th>
                                <th>Part No</th>
                                <th>Description</th>
                                <!--th>Type</th>
                                <th>Brand</th-->
                                <th>Number of Pcs</th>
                                <th>Unit</th>
                                <th>Length (cm )</th>
                                <th>Width (cm )</th>
                                <th>Height (cm )</th>
                                <th>CBM</th>
                                <!--th>Warehouse</th>
                                <th>Rack</th>
                                <th>Bin</th-->
                                <th>Actions</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </section>
    </div>
</div>
<script>
    $(document).ready(function () {
        //document ready

        var table_details_id = "#tbl_inventory";
        table_details = $(table_details_id).on("preXhr.dt", function (e, settings, data) {

        data.customer_id    = $("#customer_id").val();
        data.ware_house_id  = $("#ware_house_id").val();
        data.rack_id        = $("#rack_id").val();
        data.bin_id         = $("#bin_id").val();
        data.inv_type       ="I";
        return data;

}).DataTable({
            scrollY: "550px",
            "bAutoWidth": true,
            pageLength: 100,
            columns: [
                {className: ""},
                {className: ""},
                {className: ""}, 
                {className: ""},
                {className: "text-right"},               
                {className: "text-center"}, 
                {className: "text-right" },
                {className: "text-right" },
                {className: "text-center" },
                {className: "text-center" },
                {className: ""},
                /*{className: ""},
                {className: ""},
                {className: ""},*/
            ],
            ajax: {
                url: "index.php?r=logistics/inventory/getlist",
                type: "POST",
                cache: false,
            },
            serverSide: true,
            fixedColumns: true,
            processing: true,
            order: [[1, "asc"]],
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {

            }
        });
        
        
        $(".dataTables_scrollFoot").hide();

    });
    function block(id, status){
        var r = confirm((status == "1") ? 'Are you sure to Block this Item?' : 'Are you sure to Unblock this Item?');
        if (r == true)
        {
            jQuery.ajax({
                'type'  : 'post',
                'datatype' :'json',
                'data'  : 'id=' + id + "&status=" + status,
                'url'  : $('#liveSite').val() + 'index.php?r=logistics/Inventory/EnableDisable',
                'cache': false,
                'success':function(data){
                    if (data.status == 'fail'){
                        t8.error('Please Try Later');
                    } else {
                        t8.info('Item Status Updated');
                        reloadTable("#tbl_inventory");
                    }
                }
            });
        }
    }
</script>

<?php 
$cs = Yii::app()->getClientScript();
$cs->registerScript("LoadInventoryExcel", "function LoadInventoryExcel(){
        var customer_id    = $('#customer_id').val();
        var ware_house_id  = $('#ware_house_id').val();
        var rack_id        = $('#rack_id').val();
        var bin_id         = $('#bin_id').val();
     window.open($('#liveSite').val()+'index.php?r=logistics/excel/PrintInventoryItemCustomerReportExcel&customer_id='+customer_id+'&ware_house_id='+ware_house_id+'&rack_id='+rack_id+'&bin_id='+bin_id, '_blank');

}", CClientScript::POS_HEAD);

$cs->registerScript("GetStockTransactionList", "function GetStockTransactionList(customer_id,product_id){
    window.open($('#liveSite').val()+'index.php?r=logistics/inventory/PrintCustomerProductStockTransactionExcel&customer_id='+customer_id+'&product_id='+product_id, '_blank');
     //window.open($('#liveSite').val()+'index.php?r=excel/PrintCustomerProductStockTransactionExcel&customer_id='+customer_id+'&product_id='+product_id, '_blank');

}", CClientScript::POS_HEAD);

?>