<?php

/**
 * This is the model class for table "{{sales_price_group_name}}".
 *
 * The followings are the available columns in table '{{sales_price_group_name}}':
 * @property integer $id
 * @property string $pricing_group_name
 * @property string $lowest_pricing_group
 */
class SalesPriceGroupName extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{sales_price_group_name}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('pricing_group_name, lowest_pricing_group', 'required'),
			array('pricing_group_name', 'length', 'max'=>255),
			array('lowest_pricing_group', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, pricing_group_name, lowest_pricing_group', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'pricing_group_name' => 'Pricing Group Name',
			'lowest_pricing_group' => 'Lowest Pricing Group',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('pricing_group_name',$this->pricing_group_name,true);
		$criteria->compare('lowest_pricing_group',$this->lowest_pricing_group,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return SalesPriceGroupName the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
	
	public static function getSalesPricingGroupName() {
		$model = self::model()->findAll();
		return CHtml::listData($model, 'id', 'pricing_group_name');
	}

	public static function getSalesPricingGroupNameWithoutLowestPrice() {
		$condition = 'lowest_pricing_group="N"';
		$model = self::model()->findAll(array('condition'=>$condition));
		return CHtml::listData($model, 'id', 'pricing_group_name');
	}
	public function getDefaulSalesPricingGroupDetails() {
		$condition = 'default_pricing_group="Y"';
		return self::model()->find(array('condition' => $condition));
	}
	
	public function getSalesPricingGroupDetailsById($id) {
		return self::model()->findByPk($id);
	}
}
