<?php

/**
 * This is the model class for table "{{purchasing_invoice}}".
 *
 * The followings are the available columns in table '{{purchasing_invoice}}':
 * @property integer $id
 * @property integer $file_id
 * @property integer $po_id
 * @property integer $vend_id
 * @property string $vend_name
 * @property string $dly_no
 * @property string $dly_date
 * @property string $shipped_by
 * @property string $awb_no
 * @property integer $mrv_no
 * @property integer $tracking_no
 * @property string $others
 * @property string $storekeeper_notes
 * @property string $qc_check
 * @property integer $qc_notes
 * @property integer $qc_check_date
 * @property integer $mtl_receipt_date
 * @property integer $invoice_date
 */
class PurchasingInvoice extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public $title;
    public $received_amt;
    public $qc_checked_employee_name;
    public $currency_name;
    public $invoice_table_id;
    public $value;
    public $country;
    public $searchstartdate;
    public $searchenddate;
    public $project;
    public $project_name;
    public $purchase_invoice_no;


    public function tableName() {
        return '{{purchasinginvoice}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('vendor_id, invoice_date,payment_date,invoice_no,currency', 'required'),
            array('file_id, po_id,crm_user_id, vendor_id, tracking_no, qc_checked_employee,currency', 'numerical', 'integerOnly' => true),
            array('invoice_no, vendor_name, dly_no, shipped_by, awb_no, others ,materialreceived, qc_checked_employee_name, invoice_no, qc_check_notes,payment_terms,purchase_invoice_type', 'length', 'max' => 255),
            array('qc_check,paid', 'length', 'max' => 1),
            array('exchange_rate,grand_total,tax_type,total_tax_amount', 'numerical'),
            array('notes,terms_and_conditions,remarks,payment_terms,invoice_no', 'length', 'max' => 5000),
             array(
                  'invoice_date',
                  'compare',
                  'compareAttribute'=>'dly_date',
                  'operator'=>'>=', 
                  'allowEmpty'=>false , 
                  'message'=>'{attribute} must be greater than "{compareValue}".'
                ),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, file_id, po_id, vendor_id,grand_total,vendor_name, dly_no, dly_date, shipped_by, awb_no, mrv_no, tracking_no, others, storekeeper_notes, qc_check, qc_notes, qc_check_date, mtl_receipt_date, invoice_date', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'file' => array(self::BELONGS_TO, 'MasterFile', 'file_id'),
            'invoicetype' => array(self::BELONGS_TO, 'MasInvoiceType', 'invoice_type'),
            'vendor' => array(self::BELONGS_TO, 'Company', 'vendor_id'),
            'vendor_details' => array(self::BELONGS_TO, 'Vendor', 'vendor_id'),
            'purchaseorder' => array(self::BELONGS_TO, 'PurchasingOrder', 'po_id'),
            'items' => array(self::HAS_MANY, 'PurchasingInvoiceItem', 'purchasing_invoice_id'),
            'adItems' => array(self::HAS_MANY, 'PurchasingInvoiceAddition', 'purchasing_invoice_id'),
            'dedItems' => array(self::HAS_MANY, 'PurchasingInvoiceDeduction', 'purchasing_invoice_id'),
            'netAmount' => array(self::STAT, 'PurchasingInvoiceItem', 'purchasing_invoice_id', 'join' => ' INNER JOIN {{purchasinginvoice}} I ON I.id = t.purchasing_invoice_id', 'select' => 'ROUND((SUM(t.net_amount)*I.exchange_rate), 2)'),
            'netPurchase' => array(self::STAT, 'PurchasingInvoiceItem', 'purchasing_invoice_id', 'join' => ' INNER JOIN {{purchasinginvoice}} I ON I.id = t.purchasing_invoice_id', 'select' => 'ROUND((SUM(t.net_amount+t.tax_amount)*I.exchange_rate), 2)'),
            'netQuantity' => array(self::STAT, 'PurchasingInvoiceItem', 'purchasing_invoice_id', 'select' => 'SUM(quantity)'),
            'currencyname' => array(self::BELONGS_TO, 'MasCurrency', 'currency'),
            'shippedby' => array(self::BELONGS_TO, 'MasShipping', 'shipped_by'),
            'paymentTerm' => array(self::BELONGS_TO, 'MasPaymentTerm', 'payment_terms'),
            'receivedAmount' => array(self::STAT, 'PaidInvoices', 'invoice_id', 'select' => 'SUM(received_amt)'),
            'paidInvoice' => array(self::HAS_MANY, 'PaidInvoices', 'invoice_id'),
            'returned' => array(self::HAS_ONE, 'Purchasingcredit', 'purchasing_invoice_id'),
            'returnedAmount' => array(self::STAT, 'Purchasingcredit', 'purchasing_invoice_id', 'select' => 'SUM(credited_amount)'),
            'adTotal' => array(self::STAT, 'PurchasingInvoiceAddition', 'purchasing_invoice_id', 'join' => ' INNER JOIN {{purchasinginvoice}} I ON I.id = t.purchasing_invoice_id', 'select' => 'ROUND((SUM(t.calculated_value) * I.exchange_rate), 2)'),
            'dedTotal' => array(self::STAT, 'PurchasingInvoiceDeduction', 'purchasing_invoice_id', 'join' => ' INNER JOIN {{purchasinginvoice}} I ON I.id = t.purchasing_invoice_id', 'select' => 'ROUND((SUM(t.calculated_value) * I.exchange_rate), 2)'),
            'netTotal' => array(self::STAT, 'PurchasingInvoiceItem', 'purchasing_invoice_id', 'select' => 'SUM(amount)'),
            'project_details' => array(self::BELONGS_TO, 'MasProject', 'project_id'),
            'crmUser' => array(self::BELONGS_TO, 'User', 'crm_user_id'),
            'netVat' => array(self::STAT, 'PurchasingInvoiceItem', 'purchasing_invoice_id', 'join' => ' INNER JOIN {{purchasinginvoice}} I ON I.id = t.purchasing_invoice_id', 'select' => 'ROUND(SUM(tax_amount*I.exchange_rate), 2)'),
            'total_landing_cost' => array(self::STAT, 'PurchasingInvoiceLandedCost', 'purchasing_invoice_id', 'join' => ' INNER JOIN {{purchasinginvoice}} I ON I.id = t.purchasing_invoice_id', 'select' => 'ROUND((SUM(t.particular_value*t.exchange_rate)), 2)'),
            'landingItems' => array(self::HAS_MANY, 'PurchasingInvoiceLandedCost', 'purchasing_invoice_id'),
            'landingCostTotal' => array(self::STAT, 'PurchasingInvoice', 'purchase_invoice_id','select' => 'ROUND(SUM(t.grand_total*t.exchange_rate), 2)'),
            'rateTot' => array(self::STAT, 'PurchasingInvoiceItem', 'purchasing_invoice_id', 'join' => ' INNER JOIN {{purchasinginvoice}} I ON I.id = t.purchasing_invoice_id', 'select' => 'ROUND(SUM(rate*I.exchange_rate), 2)'),
            'netVatOrg' => array(self::STAT, 'PurchasingInvoiceItem', 'purchasing_invoice_id', 'join' => ' INNER JOIN {{purchasinginvoice}} I ON I.id = t.purchasing_invoice_id', 'select' => 'ROUND((SUM(tax_amount)), 2)'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'file_id' => 'File',
            'po_id' => 'Po',
            'vendor_id' => 'Shipper',
            'vendor_name' => 'Shipper Name',
            'dly_no' => 'Dly No',
            'dly_date' => 'Dly Date',
            'shipped_by' => 'Shipped By',
            'awb_no' => 'AWB No',
            'tracking_no' => 'Tracking No',
            'others' => 'Others',
            'storekeeper_notes' => 'Storekeeper Notes',
            'qc_check' => 'QC',
            'qc_notes' => 'QC Notes',
            'qc_check_date' => 'QC Date',
            'mtl_receipt_date' => 'Mtl Receipt Date',
            'invoice_date' => 'Invoice Date',
            'qc_checked_employee'=>'QC By'
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
     public function report() {
        $criteria = new CDbCriteria;
        $criteria->with = array('file','vendor','purchaseorder');
        if (!empty($this->vendor_id))
            $condition[] = 't.vendor_id="' . $this->vendor_id . '"';
        if (!empty($this->project))
            $condition[] = 'purchaseorder.project="' . $this->project . '"';
        if (!empty($this->country))
            $condition[] = 'vendor.billing_country="' . $this->country . '"';
        if (!empty($this->value))
            $condition[] = 't.grand_total<="' . $this->value . '"';
        if (is_array($condition))
            $criteria->condition = implode(' AND ', $condition);
        if (!empty($this->searchstartdate) && !empty($this->searchenddate)) {
            $criteria->addBetweenCondition('invoice_date', $this->searchstartdate, $this->searchenddate);
        }
       /* $criteria->addCondition('       file.own_company_id=' . Yii::app()->user->master_user_company_id . ' AND 
                                        file.own_branch_id=' . Yii::app()->user->master_user_branch_id, 'AND');*/
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.invoice_date DESC,t.id DESC,t.file_id DESC,t.vendor_id DESC',
            ),
            'pagination' => false
        ));
    }
    public function search($searchterm = null) {
        $criteria = new CDbCriteria;
        $searchterm = empty($searchterm) ? trim(Yii::app()->request->getParam('purchase_inv_search')) : $searchterm;
        $criteria->with = array('file', 'file.company');
       /* $criteria->addCondition('       file.own_company_id=' . Yii::app()->user->master_user_company_id . ' AND 
                                        file.own_branch_id=' . Yii::app()->user->master_user_branch_id, 'AND');*/
        //((int) Yii::app()->session['company_id'] > 0 && !isset($_GET['month'])) ? $criteria->addCondition('t.company_id=' . Yii::app()->session['company_id'], 'AND') : '';
        if (!empty($searchterm)) {
            $criteria->addCondition('   t.id like "%' . $searchterm . '%" OR 
                                        t.vendor_id like "%' . $searchterm . '%" OR 
                                        t.po_id like "%' . $searchterm . '%" OR 
                                        t.file_id like "%' . $searchterm . '%" OR 
                                        company.company_name like "%' . $searchterm . '%" OR 
                                        file.file_title like "%' . $searchterm . '%"', 'AND');
        }
        if (isset($_GET['month']))
            $criteria->addCondition("YEAR(invoice_date)='" . date('Y') . "' AND MONTH(invoice_date) ='" . $_GET['month'] . "'", 'AND');
       /* else
            $criteria->addCondition('file.current_process_status="P_I" OR file.current_process_status="P_PI"', 'AND');*/

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.id DESC, t.file_id DESC ,t.invoice_date DESC',
            ),
           'pagination' => (Yii::app()->controller->id != "export") ? array('pageSize' => 15) : false,
       ));
    }
    
    public function seacrhInvoice() {
        $criteria = new CDbCriteria;
        $criteria->with = "file";
        $comp_id = isset($_GET['comp_id']) ? $_GET['comp_id'] : ((int) Yii::app()->session['company_id'] > 0 ? Yii::app()->session['company_id'] : 0);
        $criteria->condition = "file.company_id=" . $comp_id;
        $criteria->order = "paid DESC";
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    public function generatereport() {
        $criteria = new CDbCriteria;
        $criteria->condition = "isActive   =   'Y'";
        if (isset($_POST['rp_from_date']) && isset($_POST['rp_to_date'])) {
            $criteria->condition .= ' AND invoice_date BETWEEN "' . $_POST['rp_from_date'] . '" AND "' . $_POST['rp_to_date'] . '"';
            if (isset($_POST['vendor_id']))
                $criteria->condition .= ' AND vendor_id in ( ' . $_POST['vendor_id'] . ')';
        }
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.id DESC, t.file_id DESC ,t.invoice_date DESC',
            ),
            'pagination' => array('pageSize' => 500)
        ));
    }


    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return PurchasingInvoice the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }
    
    public function getFullcurrency(){
        return $this->currencyname->currency_code;
    }

     public function getTotals($ids) {
        $ids = implode(",", $ids);
        $connection = Yii::app()->db;
        if (!empty($ids)) {
            $command = $connection->createCommand("SELECT SUM(grand_total*exchange_rate) FROM `crm_purchasinginvoice` where id in ($ids)");
            return $command->queryScalar();
        }
        else
            return "";
    }
 public function getTots($ids) {
        $ids = implode(",", $ids);
        $connection = Yii::app()->db;
        if (!empty($ids)) {
            $command = $connection->createCommand("SELECT SUM(grand_total) FROM `crm_purchasinginvoice` where id in ($ids)");
            return $command->queryScalar();
        }
        else
            return "";
    }

    public function getGrandtotalvalue(){
        return ( round( ($this->grand_total * $this->exchange_rate), 2) );
    }

    public function update_landed_cost()
    {
        set_time_limit(0);
        if ($this->id > 0) {
            $purchaseInvoiceHead = PurchasingInvoice::model()->findBypk((int) $this->id);
            //Purchase Invoice
            if ( $purchaseInvoiceHead->id > 0 ) {
                //Each Item
                foreach ($purchaseInvoiceHead->items as $each) {
                    //Additional Cost
                    $total_additional_cost = (float) $purchaseInvoiceHead->total_landing_cost;
                    //Total Footer value
                    $total_footer_value = (float) $purchaseInvoiceHead->adTotal + (float) $purchaseInvoiceHead->dedTotal;
                    //Grand Total
                    $grandTotal = (float) $purchaseInvoiceHead->grand_total * (float) $purchaseInvoiceHead->exchange_rate;
                    $grandTotal_with_landed_cost = $grandTotal + $total_additional_cost;
                    $grandTotal_without_footer_value = $grandTotal - $total_footer_value;

                    $previousQuantity = (float) $each->previous_quantity;
                    $perviousRate = (float) $each->previous_cost_rate;
                    //Netvalue @that transaction
                    $previousNetvalue = $previousQuantity * $perviousRate;

                    $purchasedRate = (float) $each->rate; //D3
                    //Footer value additionals
                    $additional_cost = ( $grandTotal_without_footer_value > 0 ) ? $purchasedRate * ( $total_footer_value / $grandTotal_without_footer_value ) : 0;
                    $additional_cost = round($additional_cost, 6);
                    //Actual Purchase cost - after adding footer value
                    $purchasedRate += $additional_cost;
                    //Current Netvalue after footer addition 
                    $current_net_value = $purchasedRate * (float) $each->quantity;
                    //Current Netvalue with landed cost
                    $totalQuantity = $previousQuantity + (float) $each->quantity;
                    $current_net_value +=  ( $current_net_value * $total_additional_cost ) / $grandTotal;
                    $current_net_value = round($current_net_value, 6);
                    //New cost rate
                    $new_cost_rate = ( $totalQuantity > 0 ) ? ( $previousNetvalue + $current_net_value ) / $totalQuantity : 0;
                    $new_cost_rate = round($new_cost_rate, 6);
                    //Updating the new cost
                    Store::model()->updateBypk($each->product_id, array('rate' => $new_cost_rate));
                    //Updating Stock Ledger
                    StockLedger::model()->updateAll(
                        array('cost_price' => $new_cost_rate),
                        'product_id=' . $each->product_id . ' AND transaction_date >="' . $each->purchasinginvoice->invoice_date . '"'
                    );
                    //Invoice Item table
                    $updateQuery = 'UPDATE {{invoice_item}} II LEFT JOIN {{invoice}} I ON I.id=II.invoice_id SET II.cost_rate="' . $new_cost_rate . '" WHERE I.invoice_date >= "' . $each->purchasinginvoice->invoice_date . '"';
                    Yii::app()->db->createCommand($updateQuery)->execute();

                    //All the purchases after that
                    $count_of_purchases = PurchasingInvoiceItem::model()->with('purchasinginvoice')->count(array('condition' => 't.product_id = ' . $each->product_id . ' AND purchasinginvoice.id > "' . $each->purchasing_invoice_id . '" AND purchasinginvoice.invoice_date >= "' . $each->purchasinginvoice->invoice_date . '"'));
                    //Nested Loops
                    if ($count_of_purchases > 0) {
                        $purchaseInvoice = $purchaseInvoiceHead;
                        $all_purchases = PurchasingInvoiceItem::model()->with('purchasinginvoice')->findAll(array('condition' => 't.product_id = ' . $each->product_id . ' AND purchasinginvoice.id > "' . $each->purchasing_invoice_id . '" AND purchasinginvoice.invoice_date >= "' . $each->purchasinginvoice->invoice_date . '"', 'order' => 'purchasinginvoice.invoice_date ASC'));
                        foreach ($all_purchases as $x => $each_purchase) {
                            //Updating the previuos cost rate
                            $each_purchase->previous_cost_rate = $new_cost_rate;
                            $each_purchase->update();
                            
                            //previous Model
                            $previous_purchase_invoice = $purchaseInvoice;
                            $purchaseInvoice = PurchasingInvoice::model()->findBypk((int) $each_purchase->purchasing_invoice_id);
                            //Additional Cost
                            $total_additional_cost = (float) $purchaseInvoice->total_landing_cost;
                            //Total Footer value
                            $total_footer_value = (float) $purchaseInvoice->adTotal + (float) $purchaseInvoice->dedTotal;
                            //Grand Total
                            $grandTotal = (float) $purchaseInvoice->grand_total * (float) $purchaseInvoice->exchange_rate;
                            $grandTotal_with_landed_cost = $grandTotal + $total_additional_cost;
                            $grandTotal_without_footer_value = $grandTotal - $total_footer_value;

                            $previousQuantity = (float) $each_purchase->previous_quantity;
                            $perviousRate = (float) $each_purchase->previous_cost_rate;
                            //Netvalue @that transaction
                            $previousNetvalue = $previousQuantity * $perviousRate;

                            $purchasedRate = (float) $each_purchase->rate; //D3
                            $additional_cost = ($grandTotal_without_footer_value > 0) ? $purchasedRate * ($total_footer_value / $grandTotal_without_footer_value) : 0;
                            //Actual Purchase cost - after adding footer value
                            $purchasedRate += $additional_cost;
                            //Current Netvalue after footer addition 
                            $current_net_value = $purchasedRate * (float) $each_purchase->quantity;
                            //Current Netvalue with landed cost
                            $totalQuantity = $previousQuantity + (float) $each_purchase->quantity;
                            $current_net_value +=  ( $current_net_value * $total_additional_cost ) / $grandTotal;
                            //New cost rate
                            $new_cost_rate = ( $totalQuantity > 0 ) ? ( $previousNetvalue + $current_net_value ) / $totalQuantity : 0;
                            $new_cost_rate = round($new_cost_rate, 6);
                            //Updating the new cost
                            Store::model()->updateBypk($each_purchase->product_id, array('rate' => $new_cost_rate));
                            //Updating Stock Ledger
                            StockLedger::model()->updateAll(
                                array('cost_price' => $new_cost_rate),
                                'product_id=' . $each_purchase->product_id . ' AND transaction_date >="' . $each_purchase->purchasinginvoice->invoice_date . '"'
                            );
                            //Invoice Item table
                            $updateQuery = 'UPDATE {{invoice_item}} II LEFT JOIN {{invoice}} I ON I.id=II.invoice_id SET II.cost_rate="' . $new_cost_rate . '" WHERE I.invoice_date >= "' . $each_purchase->purchasinginvoice->invoice_date . '"';
                            Yii::app()->db->createCommand($updateQuery)->execute();
                        }
                    }
                }
            }
        }
    }
        public static function getPurchasedInvoices()
	{
		$condition = 'isActive =  "Y"';
		$model = self::model()->findAll(array('condition' => $condition,'order'=>'id,invoice_no'));
		return CHtml::listData($model, 'id', 'fullInv');
    }
    public function getFullInv() {
        return $this->id." : ".$this->invoice_no;
    }
}


