<?php

/**
 * This is the model class for table "{{purchasing_enquiry_item_details}}".
 *
 * The followings are the available columns in table '{{purchasing_enquiry_item_details}}':
 * @property integer $id
 * @property integer $enquiry_id
 * @property integer $product_id
 * @property string $description
 * @property integer $unit
 * @property double $rate
 * @property double $amount
 */
class PurchasingEnquiryItem extends CActiveRecord {

    public $product_name;

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{purchasing_enquiry_item}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('product_name, description, quantity', 'required'),
            array('id, purchasing_enquiry_id, product_id', 'numerical', 'integerOnly' => true),
            array('quantity', 'numerical'),
            array('description, unit', 'length', 'max' => 25000),
            array('quantity', 'length', 'max'=>10),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, purchasing_enquiry_id, product_id, description, unit', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'product' => array(self::BELONGS_TO, 'Store', 'product_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'purchasing_enquiry_id' => 'Enquiry',
            'product_id' => 'Product',
            'description' => 'Description',
            'unit' => 'Unit',
            'rate' => 'Rate',
            'amount' => 'Amount',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('purchasing_enquiry_id', $this->purchasing_enquiry_id);
        $criteria->compare('product_id', $this->product_id);
        $criteria->compare('description', $this->description, true);
        $criteria->compare('unit', $this->unit);
        $criteria->compare('quantity', $this->quantity);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.id',
            ),
            'pagination' => (Yii::app()->controller->id != "export") ? array('pageSize' => 5) : false,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return PurchasingEnquiryItem the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

}
