<?php
class Packaging extends CActiveRecord {
    public $customer_name;
    public function tableName() {
        return '{{packaging}}';
    }
    public function rules() {
        return array(
            array('transaction_date,transaction_id,transaction_type', 'required'),
            array('transaction_id', 'numerical', 'integerOnly' => true),
            array('active', 'length', 'max' => 1),
            array('id,  transaction_date, active, reference', 'safe', 'on' => 'search'),
        );
    }

    public function relations() {
        return array(
            'transaction' => array(self::BELONGS_TO, 'GoodsReceipt', 'transaction_id'),
            'goodsissue' => array(self::BELONGS_TO, 'GoodsIssue', 'transaction_id'),
            'customer_det' => array(self::BELONGS_TO, 'Customer', 'customer_id'),
            
        );
    }

    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'transaction_date' => 'Transaction Date',
        );
    }
    
    public function search($searchterm = null) {
        $criteria = new CDbCriteria;
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.transaction_date DESC,t.receipt_no DESC',
            ),
            'pagination' => array('pageSize' => 20),
        ));
    }
    
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

}
