<?php

/**
 * This is the model class for table "{{mas_payment_term}}".
 *
 * The followings are the available columns in table '{{mas_payment_term}}':
 * @property integer $id
 * @property string $payment_code
 * @property string $payment_terms
 * @property integer $no_of_days
 * @property string $isActive
 */
class MasPaymentTerm extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{mas_payment_term}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('payment_code, payment_terms, no_of_days', 'required'),
            array('payment_code', 'unique'),
            array('payment_code', 'filter', 'filter'=>'trim'),
            array('no_of_days', 'numerical', 'integerOnly' => true),
          //  array('payment_code', 'length', 'max' => 255),
            array('isActive,isBasePaymentTerm', 'length', 'max' => 1),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, payment_code, payment_terms, no_of_days, isActive,created_by,updated_by,created_datetime,updated_datetime', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'payment_code' => 'Payment Code',
            'payment_terms' => 'Payment Terms',
            'no_of_days' => 'No of Days',
            'isActive' => 'Is Active',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        $criteria = new CDbCriteria;
        $searchterm = trim(Yii::app()->request->getParam('paymentterm'));
        //$criteria->addCondition('isActive =  "Y" AND company_id=' . Yii::app()->user->master_user_company_id, 'AND');		$criteria->addCondition('isActive =  "Y"', 'AND');
        if (!empty($searchterm))
            $criteria->addCondition('payment_code like "%' . $searchterm . '%"', 'AND');
        return new CActiveDataProvider($this, array(
            'pagination' => array(
                'pageSize' => 5,
            ),
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.payment_code ASC',
            ),
        ));
    }

    public function getpaymentTermWithCode() {
        return $this->payment_code . ":" . $this->payment_terms;
    }
    
    public function getpaymentTerm() {
        return $this->payment_terms;
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return MasPaymentTerm the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public static function getPaymentTerms() {
        //$condition = 'isActive =  "Y" AND company_id=' . Yii::app()->user->master_user_company_id;        
        $condition = 'isActive =  "Y"';
        $model = self::model()->findAll(array('condition' => $condition,'order'=>'isBasePaymentTerm,payment_terms ASC'));
        return CHtml::listData($model, 'id', 'payment_terms');
    }

}
