<?php

/**
 * This is the model class for table "{{mas_inv_bin}}".
 *
 * The followings are the available columns in table '{{mas_inv_bin}}':
 * @property integer $id
 * @property string $name
 * @property integer $rack_id
 * @property string $isActive
 * @property string $is_base_bin
 * @property integer $created_by
 * @property integer $updated_by
 * @property string $created_datetime
 * @property string $updated_datetime
 */
class MasInvBin extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{mas_inv_bin}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('name, rack_id', 'required'),
			array('rack_id, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('name,maximum_weight,maximum_volume', 'length', 'max'=>255),
			array('isActive, is_base_bin', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, name, rack_id, isActive, is_base_bin, created_by, updated_by, created_datetime, updated_datetime', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'rack' => array(self::BELONGS_TO, 'MasInvRack', 'rack_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'name' => 'Name',
			'rack_id' => 'Rack',
			'isActive' => 'Is Active',
			'is_base_bin' => 'Is Base Bin',
			'created_by' => 'Created By',
			'updated_by' => 'Updated By',
			'created_datetime' => 'Created Datetime',
			'updated_datetime' => 'Updated Datetime',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('name',$this->name,true);
		$criteria->compare('rack_id',$this->rack_id);
		$criteria->compare('isActive',$this->isActive,true);
		$criteria->compare('is_base_bin',$this->is_base_bin,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('created_datetime',$this->created_datetime,true);
		$criteria->compare('updated_datetime',$this->updated_datetime,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return MasInvBin the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
    }

    public static function getBins() {
        $condition = 'isActive="Y"';
        $model = self::model()->findAll(array('condition' => $condition));
        $returnArray =  CHtml::listData($model, 'id', 'name');
        return $returnArray;
    }
    
    public static function getBins_rackwise( $id = 0 ) {
        $returnArray = array();
        if( (int) $id > 0 ){
            $condition = 'isActive =  "Y" AND rack_id='.$id;
            $model = self::model()->findAll(array('condition' => $condition));
            $returnArray =  CHtml::listData($model, 'id', 'name');
        }
        return $returnArray;
    }
    public static function getDefaultBinId() {
        $condition = 'isActive =  "Y" AND is_base_bin="Y"';
    	$model = self::model()->find(array('condition' => $condition,'order'=>'name ASC'));
        return $model->id;
    }
    
    public function getBinName($id){
        $model = self::model()->findByPk($id);
        return $model->name;
    }
    
}
