<?php

/**
 * This is the model class for table "erp_master_generic".
 *
 * The followings are the available columns in table 'erp_master_generic':
 * @property integer $id
 * @property string $generic_name
 * @property string $is_default
 * @property integer $created_by
 * @property string $created_time
 * @property integer $updated_by
 * @property string $updated_time
 * @property string $active
 * @property integer $outlet
 */
class MasGeneric extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{mas_generic}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('generic_name', 'required'),
			array('created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('generic_name', 'length', 'max'=>50),
			array('is_default, active', 'length', 'max'=>1),
			array('created_time, updated_time', 'safe'),
			array('generic_name', 'unique'),
			array('id, generic_name, is_default, created_by, created_time, updated_by, updated_time, active', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'generic_name' => 'Generic Name',
			'is_default' => 'Is Default',
			'created_by' => 'Created By',
			'created_time' => 'Created Time',
			'updated_by' => 'Updated By',
			'updated_time' => 'Updated Time',
			'active' => 'N : No, Y: Yes',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('generic_name',$this->generic_name,true);
		$criteria->compare('is_default',$this->is_default,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_time',$this->created_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_time',$this->updated_time,true);
		$criteria->compare('active',$this->active,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	
	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return MasterGeneric the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
	public static function getAllGeneric(){
	    return CHtml::listData(self::model()->findAll( array( 'condition' => 'active="Y"', 'order' => 'is_default ASC, generic_name ASC' ) ), 'id', 'generic_name');
	}
}
