<?php

/**
 * This is the model class for table "{{mas_assets}}".
 *
 * The followings are the available columns in table '{{mas_assets}}':
 * @property integer $id
 * @property string $isActive
 *
 * The followings are the available model relations:

 */
class MasDocument extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{hr_mas_document}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('document_name,renewal_remainder,document_type,master_type', 'required'),
            array('document_name','length', 'max' => 255),
            array('renewal_remainder', 'numerical', 'integerOnly' => true),
            array('isActive', 'length', 'max' => 1),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('document_name,renewal_remainder, isActive', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'document_name'=>'Document Name',
            'renewal_remainder'=>'Remainder Days',
            'isActive' => 'Is Active',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        $criteria = new CDbCriteria;
       $sterm = trim(Yii::app()->request->getParam('search'));
     
        if($sterm)
        {
        $criteria->addCondition('document_name like "%' . $sterm . '%"', 'AND');
        }
        
        return new CActiveDataProvider($this, array(
            'pagination' => array(
                'pageSize' => 12,
            ),
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.document_name ASC',
            ),
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return MasBank the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }
  
    public static function getDocuments() {
        $condition = 'isActive =  "Y"';
        $model = self::model()->findAll(array('condition' => $condition,'order'=>'document_name asc'));
        return CHtml::listData($model, 'id', 'document_name');
    }
	
	   public static function getCompanyDocuments() {
        $condition = 'isActive =  "Y" and master_type = 2';
        $model = self::model()->findAll(array('condition' => $condition,'order'=>'document_name asc'));
        return CHtml::listData($model, 'id', 'document_name');
    }
	
    public static function getEmployeeDocuments() {
        $condition = 'isActive =  "Y" and master_type = 1';
        $model = self::model()->findAll(array('condition' => $condition,'order'=>'document_name asc'));
        return CHtml::listData($model, 'id', 'document_name');
    }
    
    public static function getDocumentsWithdate() {
        $condition = 'isActive =  "Y" and document_type="1"';
        $model = self::model()->findAll(array('condition' => $condition,'order'=>'document_name asc'));
        return CHtml::listData($model, 'id', 'document_name');
    }
    public static function getEmployeeDocument($employee_id=0,$document_id=0) {
        $condition = 'isActive =  "Y" and master_type = 1';
        $employee_document=array();
        $model_employee_documents = EmployeeDocuments::model()->findAll(array('select'=>'document_id','condition' => 'document_id!="'.$document_id.'" and employee_id="'.$employee_id.'"'));
        foreach ($model_employee_documents as $key_1 => $value_1) {
            $employee_document[$key_1]=$value_1->document_id;
        }
        $model = self::model()->findAll(array('condition' => $condition,'order'=>'document_name asc'));
        $document=array();
        foreach ($model as $key => $value) {
            if (!in_array($value->id,$employee_document)) {
                $document[$key]['id']=$value->id;
                $document[$key]['document_name']=$value->document_name;
            }
        }
        return CHtml::listData($document, 'id', 'document_name');
    }
}
