<?php
class FormMaster extends CActiveRecord
{
	public function tableName()
	{
		return '{{form_master}}';
	}

	public function rules()
	{
		return array(
			array('code, next_number', 'required'),
			array('next_number', 'numerical', 'integerOnly'=>true),
			array('code', 'length', 'max'=>20),
			array('title, prefix', 'length', 'max'=>50),
			array('id, code, title, next_number, prefix', 'safe', 'on'=>'search'),
		);
	}
        
	public function relations()
	{
		return array(
		);
	}

	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'code' => 'Code',
			'title' => 'Table Name',
			'next_number' => 'Next Number',
			'prefix' => 'Prefix',
		);
	}

	public function search()
	{
		$criteria=new CDbCriteria;
		$criteria->compare('id',$this->id);
		$criteria->compare('code',$this->code,true);
		$criteria->compare('title',$this->title,true);
		$criteria->compare('next_number',$this->next_number);
		$criteria->compare('prefix',$this->prefix,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
	public static function model($className=__CLASS__)
	{
	return parent::model($className);
	}
}
