<?php

/**
 * This is the model class for table "{{flat_notes}}".
 *
 * The followings are the available columns in table '{{flat_notes}}':
 * @property integer $id
 * @property string $reminder_date
 * @property string $notes
 * @property integer $note_status
 * @property integer $flat_id
 * @property integer $created_by
 * @property string $created_user
 * @property string $building_name
 * @property string $building_class_name
 * @property string $landlord_name
 * @property string $tenant_name
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class FileNotes extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	
	
	
	public function tableName()
	{
		return '{{file_note}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('notes','required'),
			array('id, crm_user_id, customer_vendor_id', 'numerical', 'integerOnly'=>true),
			array('notes','length', 'max'=>255),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, crm_user_id, customer_vendor_id, customer_vendor_type, file_id,contact_id, file_note_from,notes,isActive,created_by,updated_by,created_datetime,updated_datetime', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
				'file' => array(self::BELONGS_TO, 'File', 'file_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'crm_user_id' => 'crm_user_id',
			'customer_vendor_type' => 'customer_vendor_type',
			'file_id' => 'file_id',
			'contact_id' => 'contact_id',
			'created_by' => 'Created By',
			'file_note_from' => 'file_note_from',
			'notes' => 'notes',
                        'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
      
        }
	

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return FlatNotes the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
