<?php

/**
 * This is the model class for table "{{customer_docs}}".
 *
 * The followings are the available columns in table '{{customer_docs}}':
 * @property integer $id
 * @property integer $customer_id
 * @property string $document_no
 * @property integer $document_type
 * @property string $document
 * @property string $from_date
 * @property string $to_date
 */
class CustomerDocs extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{customer_docs}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('customer_id, document_no, document_type, document', 'required'),
			array('customer_id, document_type', 'numerical', 'integerOnly'=>true),
			array('document_no, document', 'length', 'max'=>255),
			array('document_type', 'documentRequired'),
                        //// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, customer_id, document_no, document_type, document, from_date, to_date', 'safe', 'on'=>'search'),
		);
	}
        public function documentRequired($attribute,$params)
        {			
            if($this->document_type =="1")
            {   
//                if($this->from_date == '')
//                $this->addError('from_date', 'From Date cannot be blank');
                if($this->to_date == '')
                $this->addError('to_date', 'To Date cannot be blank');
            }        
                
        }
	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'cus_details' => array(self::BELONGS_TO, 'Customer','customer_id'),
                    'doctype' => array(self::BELONGS_TO, 'MasDocumentType','document_type'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'customer_id' => 'Customer',
			'document_no' => 'Document No',
			'document_type' => '1-statement of accounts,2-trade license',
			'document' => 'Document',
			'from_date' => 'From Date',
			'to_date' => 'To Date',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('customer_id',$this->customer_id);
		$criteria->compare('document_no',$this->document_no,true);
		$criteria->compare('document_type',$this->document_type);
		$criteria->compare('document',$this->document,true);
		$criteria->compare('from_date',$this->from_date,true);
		$criteria->compare('to_date',$this->to_date,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return CustomerDocs the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
        public function getType() {
            switch ($this->document_type) {
                case '1':
                    return 'Trade License';
                    break;
                case '2':
                    return 'Others';
                    break;
                
            }
        }
}
