<?php

/**
 * This is the model class for table "{{creditnote_item}}".
 *
 * The followings are the available columns in table '{{creditnote_item}}':
 * @property integer $id
 * @property integer $creditnote_id
 * @property integer $product_id
 * @property string $description
 * @property string $quantity
 * @property string $rate
 * @property string $returned_rate
 * @property string $net_amount
 * @property integer $invoice_item_id
 * @property string $tax_vat_amount
 * @property string $tax_vat_percentage
 * @property integer $unit_id
 * @property integer $created_by
 * @property integer $updated_by
 * @property string $created_datetime
 * @property string $updated_datetime
 */
class CreditnoteItem extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{creditnote_item}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			//array('creditnote_id, product_id, description, quantity, rate, returned_rate, net_amount, invoice_item_id, tax_vat_amount, tax_vat_percentage, unit_id, created_by, updated_by, created_datetime, updated_datetime', 'required'),
			array('creditnote_id, product_id, invoice_item_id, unit_id', 'numerical', 'integerOnly'=>true),
			array('quantity, rate, returned_rate, net_amount, tax_vat_amount, tax_vat_percentage', 'length', 'max'=>15),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, creditnote_id, product_id, description, quantity, rate, returned_rate, net_amount, invoice_item_id, tax_vat_amount, tax_vat_percentage, unit_id', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		 return array(
            'product' => array(self::BELONGS_TO, 'Inventory', 'product_id'),
            'parent' => array(self::BELONGS_TO, 'Creditnote', 'creditnote_id'),
            'inv_item' => array(self::BELONGS_TO,'InvoiceItem','invoice_item_id'),
            'units' => array(self::BELONGS_TO, 'MasUnit', 'unit_id'),
        );
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'creditnote_id' => 'Creditnote',
			'product_id' => 'Product',
			'description' => 'Description',
			'quantity' => 'Quantity',
			'rate' => 'Rate',
			'returned_rate' => 'Returned Quantity',
			'net_amount' => 'Net Amount',
			'invoice_item_id' => 'Invoice Item',
			'tax_vat_amount' => 'Tax Vat Amount',
			'tax_vat_percentage' => 'Tax Vat Percentage',
			'unit_id' => 'Unit',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('creditnote_id',$this->creditnote_id);
		$criteria->compare('product_id',$this->product_id);
		$criteria->compare('description',$this->description,true);
		$criteria->compare('quantity',$this->quantity,true);
		$criteria->compare('rate',$this->rate,true);
		$criteria->compare('returned_rate',$this->returned_rate,true);
		$criteria->compare('net_amount',$this->net_amount,true);
		$criteria->compare('invoice_item_id',$this->invoice_item_id);
		$criteria->compare('tax_vat_amount',$this->tax_vat_amount,true);
		$criteria->compare('tax_vat_percentage',$this->tax_vat_percentage,true);
		$criteria->compare('unit_id',$this->unit_id);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return CreditnoteItem the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
