<?php 
class MastertransporttypeController extends Controller {

   public function accessRules() {
        return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                    'actions' => array('login', 'error', 'logout'),
                    'users' => array('*'),
                    ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                    'actions' => array('Index','Create','DeleteTransportType','SaveTransportType','GetList'),
                    'expression' => '$user->isMember()',
                    ),
                array('deny', // deny all users
                    'users' => array('*'),
                    ),
                );
         }
    
        public function filters()
        {
        return array(
            'accessControl', // perform access control for CRUD operations
            );
        }
        
        public function actionIndex() {
        $this->render('index');
         }
         
        public function actionGetList()
         {
 
                $model=new MasTransportType();
                $draw    = $_POST['draw'];
                $offset = $_POST['start'];
                $limit  = $_POST['length'];
                $columns = array(
                // datatable column index  => database column name
                   0 =>'transport_type',
                  
                   );
                $filterColumn = $columns[$_POST['order'][0]['column']];
                $filterOrder  = $_POST['order'][0]['dir'];
                $orderBy   = $filterColumn." ".$filterOrder;
                $condition = 't.isActive="Y"';
                if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
                {
                  $searchString = $_POST['search']['value'];
                  $condition ="  (transport_type LIKE '%".$searchString."%')";
                }
                $count = $model->count(array('condition'=>$condition));
                $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>$orderBy));
                $recordsTotal = $count;
                $recordsFiltered = $count;
                $data['draw'] = $draw;
                $data['recordsTotal'] = $recordsTotal;
                $data['recordsFiltered'] = $recordsFiltered;
                $rowData=array();
                $m=1;
                
                foreach ($model as $row)
                {
                    $div = '';
                       
                    
                    if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["mas_inv_TransportType_edit"])){
                        $div .= '<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'transporttype/create&id='.$row['id'].'\',\'Edit TransportType\',\'lg\')"><i class="fa fa-pencil"></i></button>';
                    }
                    if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["mas_inv_TransportType_delete"])){
                    //    $div .=  '<a href ="#" class="btn btn-danger btn-xs" onclick="deleteTransportType('.$row['id'].')"><i class="fa fa-trash-o "></i></a>';
                    }
                        $rowData[]=array($m,$row['transport_type'],'<div class="btn-wrap text-center">'.$div.'</div>',
                          array('id' => $row['id'],'code'=>$row['transport_type'], 'status' => $row->isActive));
   
                
                    $m++;
                    
                }

                $data['data'] = $rowData;
                echo json_encode($data);
    }
    public function actionCreate()
    {
        $model=new MasTransportType(); 
        $id=(int) Yii::app()->request->getParam('id');
        if($id>0){
            $model=$model->findByPk($id);
        }
         Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);

        $this->renderPartial('create', array('model' => $model,'from' => $from), false, true);
    }
    public function actionSaveTransportType()
        {
            $model = new MasTransportType();
            if (isset($_POST['MasTransportType']))
            {   $model->created_by = Yii::app()->user->id;
                $model->created_date_time =date('Y-m-d h:i:s');
    		
    		if ((int) @$_POST['MasTransportType']['id'] > 0)
                {   $model->updated_by = Yii::app()->user->id;
                    $model->updated_date_time =date('Y-m-d h:i:s');
                    $id= (int) @$_POST['MasTransportType']['id'];
                    $model=$model->findByPk($id); 
                    $audit_type = 'UPDATED';
                    $edit_flag=1;
                }else{
                    $audit_type = 'CREATED';
                }
                $model->attributes=$_POST['MasTransportType'];
                $model->transport_type=$_POST['MasTransportType']['transport_type'];
                if($model->save())
                {
                   
                        // inserting to audit log
                        AuditLog::saveAuditLogs(
                            'TransportType_MASTER',
                            Yii::app()->user->id,
                            $audit_type
                        );
                        // end audit log
                        $jsonData['status'] = 'success';
                        $jsonData['frm'] = $_POST['TransportType_form'];
                        $jsonData['from'] = $_POST['from'];
                        $jsonData['id'] = $model->id;
	                echo CJSON::encode($jsonData);
                       // $this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('index'));
                }
                else
                {
                        $error = CActiveForm::validate($model, '', false);
                        if ($error != '[]')
		               echo $error;
                }
               // $this->render('bank_form', array('model' => $model), false, true);

            }
        }
        public function actionDeleteMasTransportType()
    {
		$id = $_POST['id'];
                $model_s = Store::model()->findAll(array('condition'=>'TransportType_id='.$id.' '));
                if(empty($model_s)){
                    $model=new MasTransportType();
                    $del = $model->findByPk($id); // audit log changes
                    $model->deleteByPk($id);
                    // inserting to audit log
                    AuditLog::saveAuditLogs(
                        'TransportType_MASTER',
                        Yii::app()->user->id,
                        'DELETED',
                        " with symbol: - {$del->symbol}  "
                    );
                    // end audit log
                    echo "success";  
                }else{
                    echo "fail";  
                }
               
    }
}

?>