<?php

class MasjoborderstatusController extends Controller
{
 public function accessRules() {
        return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                    'actions' => array('login', 'error', 'logout'),
                    'users' => array('*'),
                    ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                    'actions' => array('Index','Create','DeleteJobOrderStatus','SaveJobOrderStatus','GetList'),
                    'expression' => '$user->isMember()',
                    ),
                array('deny', // deny all users
                    'users' => array('*'),
                    ),
                );
         }
    
        public function filters()
        {
        return array(
            'accessControl', // perform access control for CRUD operations
            );
        }
        
        public function actionIndex() {
        $this->render('index');
         }
         
        public function actionGetList()
         {
 
                $model=new MasJobOrderStatus();
                $draw    = $_POST['draw'];
                $offset = $_POST['start'];
                $limit  = $_POST['length'];
                $columns = array(
                // datatable column index  => database column name
                   0 =>'job_status',
                   1 =>'vendor.vendor_name',
                   );
                $filterColumn = $columns[$_POST['order'][0]['column']];
                $filterOrder  = $_POST['order'][0]['dir'];
                $orderBy   = $filterColumn." ".$filterOrder;
                $condition = 't.isActive="Y"';
                if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
                {
                  $searchString = $_POST['search']['value'];
                  $condition ="  (job_status LIKE '%".$searchString."%')";
                }
                $count = $model->count(array('condition'=>$condition));
                $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>'job_status'));
                $recordsTotal = $count;
                $recordsFiltered = $count;
                $data['draw'] = $draw;
                $data['recordsTotal'] = $recordsTotal;
                $data['recordsFiltered'] = $recordsFiltered;
                $rowData=array();
                $m=1;
                
                foreach ($model as $row)
                {
                    $div = '';
                       
                    
                    if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["mas_job_order_status_edit"])){
                        $div .= '<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'masjoborderstatus/create&id='.$row['id'].'\',\'Edit JobOrder Status\',\'lg\')"><i class="fa fa-pencil"></i></button>';
                    }
                    if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["mas_job_order_status_delete"])){
                    //    $div .=  '<a href ="#" class="btn btn-danger btn-xs" onclick="deleteJobOrderStatus('.$row['id'].')"><i class="fa fa-trash-o "></i></a>';
                    }
                        $rowData[]=array($m,$row['vendor']['vendor_name'],$row['job_status'],
                          array('id' => $row['id'],'code'=>$row['job_status'], 'status' => $row->isActive));
   
                
                    $m++;
                    
                }

                $data['data'] = $rowData;
                echo json_encode($data);
    }
    public function actionCreate()
    {
        $model=new MasJobOrderStatus(); 
        $id=(int) Yii::app()->request->getParam('id');
        if($id>0){
            $model=$model->findByPk($id);
        }
         Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);

        $this->renderPartial('create', array('model' => $model,'from' => $from), false, true);
    }
    public function actionSaveJobOrderStatus()
        {
            $model = new MasJobOrderStatus();
            if (isset($_POST['MasJobOrderStatus']))
            {   
    		
    		if ((int) @$_POST['MasJobOrderStatus']['id'] > 0)
                {   
                    $id= (int) @$_POST['MasJobOrderStatus']['id'];
                    $model=$model->findByPk($id); 
                    $audit_type = 'UPDATED';
                    $edit_flag=1;
                }else{
                    $audit_type = 'CREATED';
                }
                $model->attributes=$_POST['MasJobOrderStatus'];
                $model->job_status=trim($_POST['MasJobOrderStatus']['job_status']);
                if($model->save())
                {
                   
                        // inserting to audit log
                        AuditLog::saveAuditLogs(
                            'JobOrderStatus_MASTER',
                            Yii::app()->user->id,
                            $audit_type
                        );
                        // end audit log
                        $jsonData['status'] = 'success';
                        $jsonData['frm'] = $_POST['JobOrderStatus_form'];
                        $jsonData['from'] = $_POST['from'];
                        $jsonData['id'] = $model->id;
	                echo CJSON::encode($jsonData);
                       // $this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('index'));
                }
                else
                {
                        $error = CActiveForm::validate($model, '', false);
                        if ($error != '[]')
		               echo $error;
                }
               // $this->render('bank_form', array('model' => $model), false, true);

            }
        }
}