<?php

class GoodsissueController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'Create', 'GetList', 'SaveIssue', 'Delete', 'GetProducts', 'DeleteIssueItem', 'DeleteIssue', 'Append',
                    'AddStock', 'GetRow', 'GetFactor', 'Getunitdrop', 'PrintIssuePDF', 'Upload', 'UploadDocuments', 'SaveUploadIssue', 'UpdateGoodsissueUpload',
                    'SaveUploadedDetailsToIssue','PrintIssuePackagingPDF','PrintDeliveryNotePDF','UploadIssue'),
                'expression' => '$user->isMember()',
            ), /*             * copied by jisha from bouleward on 8-11-17* */
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex() {
        $this->render('index');
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    /*     * copied by jisha from bouleward on 8-11-17* */

    public function actionGetList() {
        $model = new GoodsIssue();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'transaction_no',
            1 => 'transaction_date',
            2 => 'customer_id',
            3 => 'reference_no',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.active="Y" AND t.state="COMPLETED"';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition.=" and (t.id LIKE '%" . $searchString . "%' OR issue_no LIKE '%" . $searchString . "%' OR transaction_date LIKE '%" . $searchString . "%')";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => 'id desc'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $date_d = date("d/m/Y", strtotime($row->transaction_date));
            $rowData[] = array($row['id'], $date_d, $row->customer->customer_name, $row['reference']);
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    /*     * copied by jisha from bouleward on 8-11-17* */

    public function actionCreate() {
        $model = new GoodsIssue();
        $model_item = array(new GoodsIssueItems());
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
            $model_item = GoodsIssueItems::model()->findAll(array('condition' => 'transaction_id = ' . $model->id . ''));
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('issue_form', array('model' => $model, 'model_item' => $model_item), false, false);
    }

    public function actionSaveIssue() {
        $model = new GoodsIssue();

        if (isset($_POST['GoodsIssue'])) {
            $scenario = '';
            if ((int) @$_POST['GoodsIssue']['id'] > 0) {
                $id = (int) @$_POST['GoodsIssue']['id'];
                $model = $model->findByPk($id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_time = date('Y-m-d h:i:s');
                $scenario = 'update';
                $audit_type = 'UPDATED';
            } else {
                $model->created_by = Yii::app()->user->id;
                $model->created_time = date('Y-m-d h:i:s');
                $scenario = 'add';
                $audit_type = 'CREATED';
                $scene = 'new';
            }
            $modelformmaster = FormMaster::model()->findByPk(4);
            $model->attributes = $_POST['GoodsIssue'];
            if ($_POST['GoodsIssue']['transaction_date'] != '00/00/0000') {
                $model->transaction_date = str_replace('/', '-', $_POST['GoodsIssue']['transaction_date']);
                $model->transaction_date = date("Y-m-d", strtotime($model->transaction_date));
            }
            if ($scene == 'new') {
                $model->issue_no = $modelformmaster->next_number;
            }
            $model->state = 'CHECK_IN';
            $valid = $model->validate();
            $date = date("Y-m-d H:i:s");
            if (is_array($_POST['GoodsIssueItems'])) {
                foreach ($_POST['GoodsIssueItems'] as $k => $rowItem) {
                    $model_item[$k] = new GoodsIssueItems;
                    if ($rowItem['id'] > 0) {
                        $model_item[$k] = GoodsIssueItems::model()->findByPk($rowItem['id']);
                    }
                    $model_item[$k]->product_id = $rowItem['product_id'];
                    $model_item[$k]->description = $rowItem['description'];
                    $model_item[$k]->quantity = $rowItem['quantity'];
                    $model_item[$k]->unit = $rowItem['unit'];
                    $model_item[$k]->rate = $rowItem['rate'];
                    $model_item[$k]->length = $rowItem['length'];
                    $model_item[$k]->breadth = $rowItem['breadth'];
                    $model_item[$k]->height = $rowItem['height'];
                    $model_item[$k]->cbm = $rowItem['cbm'];
                    $model_item[$k]->bill_of_exit = $rowItem['bill_of_exit'];
                    $valid = $model_item[$k]->validate() && $valid;
                }
            }
            if ($valid) {
                $model->save(false);
                if ($scene == 'new') {
                    $next_no = $model->issue_no + 1;
                    FormMaster::model()->updateByPk($modelformmaster->id, array('next_number' => $next_no));
                }
                Checkin::model()->deleteAll(array('condition' => 'transaction_type="GI" AND transaction_id=' . $model->id));
                CheckinItems::model()->deleteAll(array('condition' => 'transaction_type="GI" AND transaction_id=' . $model->id));
                GoodsIssueItems::model()->deleteAll(array('condition' => 'header_id=' . $model->id));
                $Checkin = new Checkin;
                $Checkin->transaction_type = 'GI';
                $Checkin->transaction_date = $model->transaction_date;
                $Checkin->transaction_id = $model->id;
                $Checkin->created_by = $model->created_by;
                $Checkin->created_time = $model->created_time;
                $Checkin->save(false);
                // inserting to audit log
                AuditLog::saveAuditLogs(
                        'ISSUE', Yii::app()->user->id, $audit_type, " with Checkin No: - {$Checkin->id}  "
                );
                // end audit log 

                foreach ($model_item as $eachitem) {
                    $eachitem->header_id = $model->id;
                    $eachitem->save(false);

                    $CheckinItems = new CheckinItems;
                    $CheckinItems->transaction_type = 'GI';
                    $CheckinItems->checkin_id = $Checkin->id;
                    $CheckinItems->transaction_id = $model->id;
                    $CheckinItems->transaction_item_id = $eachitem->id;
                    $CheckinItems->product_id = $eachitem->product_id;
                    $CheckinItems->description = $eachitem->description;
                    $CheckinItems->quantity = $eachitem->quantity;
                    $CheckinItems->unit = $eachitem->unit;
                    $unit = MasUnit::model()->findByPk($CheckinItems->unit);
                    $CheckinItems->default_product_unit = $unit->base_unit_id;
                    $CheckinItems->unit_exchange_rate = $unit->unit_exchange_rate;
                    $CheckinItems->length = $eachitem->length;
                    $CheckinItems->breadth = $eachitem->breadth;
                    $CheckinItems->height = $eachitem->height;
                    $CheckinItems->cbm = $eachitem->cbm;
                    $CheckinItems->rate = $eachitem->rate;
                    $CheckinItems->bill_of_entry_exit = $eachitem->bill_of_exit;
                    $CheckinItems->save(false);
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                if ($model_item[0]->product_id > 0)
                    $error2 = json_decode(CActiveForm::validateTabular($model_item, '', false), true);
                else
                    $error2[] = "Please add atleast one line item";
                $error = CJSON::encode(array_merge_recursive($error1, $error2));
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    public function actionGetProducts() {
        $from = $_GET['frm'];
        $searchTerm = $_GET['term'];
        $customer_id = $_GET['customer_id'];
        $condition = 'active = "Y" AND ( type ="I") AND (part_number LIKE "%' . $searchTerm . '%" OR description LIKE "%' . $searchTerm . '%")';
        if((int)$customer_id>0){
            $condition .=' AND customer_id='.(int)$customer_id; 
        }
        $model = new Inventory();
        $model = $model->findAll(array('condition' => $condition, 'limit' => 200));
        $i = 0;
        foreach ($model as $eachModel) {
            $in_qty=(int) Yii::app()->db->createCommand('select sum(quantity*exchange_rate) AS qty from {{stock_ledger}} where transaction_type="IN"');
            $out_qty=(int) Yii::app()->db->createCommand('select sum(quantity*exchange_rate) AS qty from {{stock_ledger}} where transaction_type="OUT"');
            $qty=$in_qty-$out_qty;
            $data[$i]['value'] = $eachModel->id;
            $data[$i]['label'] = $eachModel->part_number.' : '. $eachModel->description;
            $data[$i]['part_number'] = $eachModel->part_number;
            $data[$i]['description'] = $eachModel->description;
            $data[$i]['unit_id'] = $eachModel->unit;
            $data[$i]['unit_name'] = $eachModel->units->unit_name;
            $data[$i]['free_qty'] = (float) $qty;
            $data[$i]['rate'] = $eachModel->rate;
            $data[$i]['length'] = $eachModel->length;
            $data[$i]['width'] = $eachModel->width;
            $data[$i]['height'] = $eachModel->height;
            $data[$i]['volume'] = $eachModel->volume;
            $i++;
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }
    /*     * copied by jisha from bouleward on 8-11-17* */

    public function actionDeleteIssue() {
        $id = $_POST['id'];
        $model = new GoodsIssue();
        $model->deleteByPk($id);
        echo "success";
    }

    /*     * copied by jisha from bouleward on 8-11-17* */

    public function actionDeleteIssueItem() {

        $id = $_POST['id'];

        $model = new GoodsIssueItem();

        $model->deleteByPk($id);

        $jsonData['status'] = 'success';

        $jsonData['id'] = $id;

        echo CJSON::encode($jsonData);
    }

    /* jo */

    public function actionGetunitdrop() {
        $row = $_POST['row_field'];
        $unit_id = $_POST['unit'];
        $arr_units = MasUnit::getSimilarUnits($unit_id);
        $drop = array();
        $modelOrder = new GoodsIssueItems;
        $modelOrder->unit = $unit_id;
        $drop['drop'] = CHtml::activedropdownlist($modelOrder, "[" . $row . "]unit", $arr_units, array('class' => 'unit go', 'onchange' => 'getFactor(this.id,this.value)'));
        echo CJSON::encode($drop);
    }

    public function actionGetFactor() {
        $factor = 1;
        if ((int) $_POST['value'] > 0) {
            $factor = UnitOfMeasurement::getFactor($_POST['value']);
        }
        echo $factor;
    }

    public function actionPrintIssuePDF() {

        //$model = new PurchasingRequisition();
        $id = Yii::app()->request->getParam('id');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.logistics.views.pdf.issues_print', array('id' => $id, 'title' => $title), true));
        $mPDF1->Output("Issues.pdf", 'I');
    }
    public function actionPrintIssuePackagingPDF() {

        $id = Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = GoodsIssue::model()->findByPk($id);
        }
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.logistics.views.pdf.issues_packaging_print', array('model' => $model, 'id' => $id, 'title' => $title), true));
        $mPDF1->Output("IssuesPackaging.pdf", 'I');
    }
    /* end */

    public function actionUploadIssue() {
        $model = new GoodsIssue();
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('issue_upload_form', array('model' => $model), false, false);
    }

    public function actionSaveUploadIssue() {
        $model = new GoodsIssue();
        $other = array();
        if (isset($_POST['GoodsIssue'])) {
            $scenario = '';
            $model->created_by = Yii::app()->user->id;
            $model->created_time = date('Y-m-d h:i:s');
            $scenario = 'add';
            $audit_type = 'CREATED';
            $scene = 'new';

            $modelformmaster = FormMaster::model()->findByPk(3);
            $model->attributes = $_POST['GoodsIssue'];
            if ($_POST['GoodsIssue']['transaction_date'] != '') {
                $model->transaction_date = str_replace('/', '-', $_POST['GoodsIssue']['transaction_date']);
                $model->transaction_date = date("Y-m-d", strtotime($model->transaction_date));
            }

            $model->state = 'CHECK_IN';
            $valid = $model->validate();
            $date = date("Y-m-d H:i:s");
            $warehouse = $_POST['warehouse'];
            if ($warehouse == '') {
                $valid = false;
                $other[] = 'Warehouse cannot be blank';
            }
            $issue_date = $model->transaction_date;
            $customer_id = $model->customer_id;
            $reference = $model->reference;
            $customer_name = $_POST['GoodsIssue']['customer_name'];
            $notes = $model->notes;
            $warehouse_name = MasInventoryWarehouse::model()->findByPk($warehouse)->warehouse_name;
            $file = $_POST['Icon']['file'];
            $default_exchange_unit_id = MasUnit::model()->find(array('condition' => 'is_default="Y"'))->id;
            $unit_name = MasUnit::model()->findByPk($default_exchange_unit_id)->unit_name;
            if (($handle = fopen("uploads/documents/" . $file, "r")) !== FALSE) {
                $n = 1;
                while (($row = fgetcsv($handle)) !== FALSE) {
                    if ($n > 1) {
                        $row0 = $row[0]; //product
                        $inventory = Inventory::model()->findByPartno($row0)->part_number;
                        $product_id = Inventory::model()->findByPartno($row0)->id;
                        $row1 = $row[1]; //qty
                        $row2 = $row[2]; //boe
                        $ware_house_cnd ='';
                        $SQL_IN = "select SUM(quantity*unit_exchange_rate) from erp_stock_ledger where product_id=" . (int)$product_id . " AND customer_vendor_id=" . (int)$customer_id . " AND transaction_type='IN' AND transaction_date<='$issue_date'".$ware_house_cnd;
                        $stocks_in = Yii::app()->db->createCommand($SQL_IN)->queryScalar();
                        $SQL_OUT = "select SUM(quantity*unit_exchange_rate) from erp_stock_ledger where product_id=" . (int)$product_id . " AND customer_vendor_id=" . (int)$customer_id . " AND transaction_type='OUT' AND transaction_date<='$issue_date'".$ware_house_cnd;
                        $stocks_out = Yii::app()->db->createCommand($SQL_OUT)->queryScalar();
                        $stock = $stocks_in - $stocks_out;
                        $qty = $row[1];
                        if ($qty > $stock) {
                            $other[] = $inventory . ' available quantity : ' . $stock . $unit_name;
                            $valid = false;
                        }
                    }
                    $n++;
                }
                fclose($handle);
            }
            if ($valid) {
                Yii::app()->db->createCommand("truncate temp_goods_issue_uploads")->execute();

                if (($handle = fopen("uploads/documents/" . $file, "r")) !== FALSE) {

                    $n = 1;
                    while (($row = fgetcsv($handle)) !== FALSE) {
                        if ($n > 1) {
                            $row0 = $row[0]; //product
                            $inventory = Inventory::model()->findByPartno($row0)->part_number;
                            $product_id = Inventory::model()->findByPartno($row0)->id;
                            $row1 = $row[1]; //qty
                            $row2 = $row[2]; //boe 
                            $rowl = $row[3];
                            $rowb = $row[4];
                            $rowh = $row[5];
                            $SQL = "INSERT INTO temp_goods_issue_uploads (goods_issue_date,reference,customer_id,customer_name,notes,product_id,products,quantity,unit_id,unit,unit_exchange_id,unit_exchange_rate,bill_of_exit,warehouse,warehouse_name,length,breadth,height) 
                                VALUES('$issue_date','$reference','$customer_id','$customer_name','$notes','$product_id','$inventory','$row1','$default_exchange_unit_id','$unit_name','$default_exchange_unit_id','1','$row2','$warehouse','$warehouse_name','$rowl','$rowb','$rowh')";
                            Yii::app()->db->createCommand($SQL)->execute();
                        }
                        $n++;
                    }
                    fclose($handle);
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                $error = CJSON::encode(array_merge_recursive($error1, $other));
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actionUpdateGoodsissueUpload() {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('issue_update_status_form', array(), false, false);
    }

    public function actionSaveUploadedDetailsToIssue() {
        $model = new GoodsIssue();
        $other = array();
        $temp = Yii::app()->db->createCommand("select * from temp_goods_issue_uploads")->queryAll();
        $model->created_by = Yii::app()->user->id;
        $model->created_time = date('Y-m-d h:i:s');
        $scenario = 'add';
        $audit_type = 'CREATED';
        $scene = 'new';
        $customer_id = $temp[0]['customer_id'];

        $model->transaction_date = $temp[0]['goods_issue_date'];
        $model->reference = $temp[0]['reference'];
        $model->customer_id = $customer_id;
        $model->state = 'CHECK_IN';
        $model->notes = $temp[0]['notes'];
        $warehouse = $temp[0]['warehouse'];
        $modelformmaster = FormMaster::model()->findByPk(4);
        $model->issue_no = $modelformmaster->next_number;
        $valid = $model->validate();

        foreach ($temp as $k => $rowItem) {
            $model_item[$k] = new GoodsIssueItems;
            $model_item[$k]->product_id = $rowItem['product_id'];
            $model_item[$k]->description = Inventory::model()->findByPk($rowItem['product_id'])->description;
            $SQL_IN = "select SUM(quantity*unit_exchange_rate) from erp_stock_ledger where product_id=" . $rowItem['product_id'] . " AND customer_vendor_id=" . $customer_id . " AND transaction_type='IN' AND transaction_date<='".$temp[0]["goods_issue_date"]."'".$ware_house_cnd;
            $stocks_in = Yii::app()->db->createCommand($SQL_IN)->queryScalar();
            $SQL_OUT = "select SUM(quantity*unit_exchange_rate) from erp_stock_ledger where product_id=" . $rowItem['product_id'] . " AND customer_vendor_id=" . $customer_id . " AND transaction_type='OUT' AND transaction_date<='".$temp[0]['goods_issue_date']." '".$ware_house_cnd;
            $stocks_out = Yii::app()->db->createCommand($SQL_OUT)->queryScalar();
            $stock = $stocks_in - $stocks_out;
            $qty = $rowItem['quantity'];               
            if ($qty > $stock) {
                $unit_name = MasUnit::model()->find(array('condition' => 'is_default="Y"'))->unit_name;
                $other[] = Inventory::model()->findByPk($rowItem['product_id'])->part_number.'('.$qty.')' . ' available quantity : ' . $stock .' '.$unit_name;
                $valid = false;
            }
            $model_item[$k]->quantity = (int) $rowItem['quantity'];
            $model_item[$k]->unit = $rowItem['unit_id'];
            $model_item[$k]->rate = (int) $rowItem['rate'];
            $model_item[$k]->bill_of_exit = $rowItem['bill_of_exit'];
            $model_item[$k]->length = $rowItem['length'];
            $model_item[$k]->breadth = $rowItem['breadth'];
            $model_item[$k]->height = $rowItem['height'];
            $model_item[$k]->cbm = $rowItem['length']*$rowItem['breadth']*$rowItem['height']/1000000;
            $valid = $model_item[$k]->validate() && $valid;
        }
        if ($valid) {
            $model->save();
            if ($scene == 'new') {
                $next_no = $model->issue_no + 1;
                FormMaster::model()->updateByPk($modelformmaster->id, array('next_number' => $next_no));
            }
            Checkin::model()->deleteAll(array('condition' => 'transaction_type="GI" AND transaction_id=' . $model->id));
            CheckinItems::model()->deleteAll(array('condition' => 'transaction_type="GI" AND transaction_id=' . $model->id));
            GoodsIssueItems::model()->deleteAll(array('condition' => 'header_id=' . $model->id));
            $Checkin = new Checkin;
            $Checkin->transaction_type = 'GI';
            $Checkin->transaction_date = $model->transaction_date;
            $Checkin->transaction_id = $model->id;
            $Checkin->created_by = $model->created_by;
            $Checkin->created_time = $model->created_time;
            $Checkin->customer_id = $customer_id;
            $Checkin->save();
            $Checkin->refresh();
            // inserting to audit log
            AuditLog::saveAuditLogs(
                    'ISSUE', Yii::app()->user->id, $audit_type, " with Checkin No: - {$Checkin->id}  "
            );
            // end audit log 

            foreach ($model_item as $eachitem) {
                $eachitem->header_id = $model->id;
                $eachitem->save(false);

                $CheckinItems = new CheckinItems;
                $CheckinItems->transaction_type = 'GI';
                $CheckinItems->checkin_id = $Checkin->id;
                $CheckinItems->transaction_id = $model->id;
                $CheckinItems->transaction_item_id = $eachitem->id;
                $CheckinItems->product_id = $eachitem->product_id;
                $CheckinItems->description = $eachitem->description;
                $CheckinItems->quantity = $eachitem->quantity;
                $CheckinItems->unit = $eachitem->unit;
                $unit = MasUnit::model()->findByPk($CheckinItems->unit);
                $CheckinItems->default_product_unit = $unit->base_unit_id;
                $CheckinItems->unit_exchange_rate = $unit->unit_exchange_rate;
                $CheckinItems->rate = $eachitem->rate;
                $CheckinItems->bill_of_entry_exit = $eachitem->bill_of_exit;
                $CheckinItems->length = $eachitem->length;
                $CheckinItems->breadth = $eachitem->breadth;
                $CheckinItems->height = $eachitem->height;
                $CheckinItems->save(false);
            }
            //goods issue end
            //checkin started
            $checkin_id = $Checkin->id;
            $checkin_model = $Checkin;
            $CheckinItems = CheckinItems::model()->findAll(array('condition' => 'checkin_id=' . $checkin_id, 'order' => 'id ASC'));
            Yii::app()->db->createCommand('delete from temp_packaging_items where transaction_id=' . $model->id . ' AND transaction_type="GI"')->execute();
            $SQL = 'INSERT INTO temp_packaging_items (transaction_type,checkin_id,checkin_item_id,transaction_id,transaction_item_id,product_id,description,quantity,unit,default_product_unit,unit_exchange_rate,rate,bill_of_entry_exit,length,breadth,height) 
            SELECT transaction_type,checkin_id,id,transaction_id,transaction_item_id,product_id,description,quantity,unit,default_product_unit,unit_exchange_rate,rate,bill_of_entry_exit,length,breadth,height FROM erp_checkin_items WHERE transaction_id=' . $model->id . ' AND transaction_type="GI"';
            Yii::app()->db->createCommand($SQL)->execute();
            $packaging_model = new Packaging();
            $packaging_model->transaction_type = 'GI';
            $packaging_model->transaction_id = $model->id;
            $packaging_model->created_by = Yii::app()->user->id;
            $packaging_model->created_time = date('Y-m-d h:i:s');
            $packaging_model->transaction_date = $model->transaction_date;
            $packaging_model->customer_id = $customer_id;
            $i = 0;
            $arr_used_bins = array();
            foreach ($CheckinItems as $k => $rowItem) {
                $checkin_id = $rowItem['checkin_id'];
                $checkin_item_id = $rowItem['id'];                
                $packages = Yii::app()->db->createCommand('select * from temp_packaging_items where checkin_item_id=' . $checkin_item_id)->queryAll();
                if (!empty($packages)) {
                    foreach ($packages as $eachPackage) {
                        $eachproduct_qty =$eachPackage['quantity'];
                    
                        $stockledgeritems = StockLedger::model()->findAll(array('condition'=>'transaction_type="IN" AND customer_vendor_id='.$customer_id.' AND quantity>0 AND product_id='.$eachPackage['product_id']));
                        foreach ($stockledgeritems as $j=>$stockledgermodel)
                        {
                            $out_qty=Yii::app()->db->createCommand("select SUM(quantity*unit_exchange_rate) from erp_stock_ledger where transaction_type='OUT' AND in_stockledger_id=".$stockledgermodel->id)->queryScalar();
                            $available_quantity=($stockledgermodel->quantity*$stockledgermodel->unit_exchange_rate)-$out_qty;
                            if($available_quantity >0 && $eachproduct_qty>0){
                                if($eachproduct_qty<=$available_quantity){
                                    $need_qty = $eachproduct_qty;
                                }else{
                                    $need_qty = $available_quantity;                                    
                                }
                                $eachproduct_qty=$eachproduct_qty-$need_qty;
                                $model_pitem[$i] = new PackagingItems;
                                $model_pitem[$i]->transaction_type = $eachPackage['transaction_type'];
                                $model_pitem[$i]->checkin_id = $eachPackage['checkin_id'];
                                $model_pitem[$i]->checkin_item_id = $eachPackage['checkin_item_id'];
                                $model_pitem[$i]->transaction_id = $model->id;
                                $model_pitem[$i]->transaction_item_id = $eachPackage['transaction_item_id'];
                                $model_pitem[$i]->product_id = $eachPackage['product_id'];
                                $model_pitem[$i]->description = $eachPackage['description'];
                                $model_pitem[$i]->quantity = $need_qty;
                                $model_pitem[$i]->unit = $stockledgermodel['default_product_unit'];
                                $model_pitem[$i]->default_product_unit = $stockledgermodel['default_product_unit'];
                                $model_pitem[$i]->unit_exchange_rate = $stockledgermodel['unit_exchange_rate'];
                                $model_pitem[$i]->rate = $stockledgermodel['rate'];
                                $model_pitem[$i]->bill_of_entry_exit = $eachPackage['bill_of_entry_exit'];
                                $model_pitem[$i]->package_id = $packaging_model->id;
                                $model_pitem[$i]->weight = $stockledgermodel['weight'];
                                $model_pitem[$i]->volume = $stockledgermodel['volume'];
                                $model_pitem[$i]->warehouse_id = $stockledgermodel['warehouse_id'];
                                $model_pitem[$i]->length = $eachPackage['length'];
                                $model_pitem[$i]->breadth = $eachPackage['breadth'];
                                $model_pitem[$i]->height = $eachPackage['height'];
                                $model_pitem[$i]->rack_id = $stockledgermodel['rack_id'];
                                $model_pitem[$i]->bin_id = $stockledgermodel['bin_id'];
                                $model_pitem[$i]->in_stockledger_id= $stockledgermodel['id'];
                                $i++;
                                
                            }
                        }
                    }
                }
            }
            Yii::app()->db->createCommand('delete from temp_packaging_items where transaction_type="GI" AND transaction_id=' . $model->id)->execute();
            $packaging_model->save(false);
            $packaging_model->refresh();
            $issue=GoodsIssue::model()->findByPk($packaging_model->transaction_id);
            $issue->state='COMPLETED';
            $issue->save(false);
            // inserting to audit log
                AuditLog::saveAuditLogs(
                    'ISSUE',
                    Yii::app()->user->id,
                    $audit_type,
                    " with Packaging No: - {$packaging_model->id}  "
                );
            // end audit log 
            foreach ($model_pitem as $eachitem){
                $eachitem->package_id = $packaging_model->id;
                $eachitem->save(false); 
                
                //StockLedger Start
                $StockledgerIn = StockLedger::model()->findByPk($eachitem['in_stockledger_id']);
                $StockLedger = new StockLedger;
                $StockLedger->transaction_date = $model->transaction_date;
                $StockLedger->transaction_type = 'OUT';
                $StockLedger->type = 'GI';
                $StockLedger->customer_vendor_id = $packaging_model->customer_id;
                $StockLedger->file_id = 0;
                $StockLedger->header_id = $model->id;
                $StockLedger->item_id = $eachitem->transaction_item_id;
                $StockLedger->product_id = $eachitem->product_id;
                $inventory = Inventory::model()->findByPk($eachitem->product_id);
                $StockLedger->brand_id = $inventory->brand;
                $StockLedger->rate = $eachitem->rate;
                $StockLedger->currency = 1;
                $StockLedger->exchange_rate = 1;
                $StockLedger->quantity = $eachitem['quantity'];
                $StockLedger->unit = $eachitem['unit'];
                $StockLedger->default_product_unit = $eachitem['default_product_unit'];
                $StockLedger->unit_exchange_rate = $eachitem['unit_exchange_rate'];
                $StockLedger->warehouse_id = $StockledgerIn->warehouse_id;
                $StockLedger->rack_id = $StockledgerIn->rack_id;
                $StockLedger->bin_id = $StockledgerIn->bin_id;
                $StockLedger->batch_no = $StockledgerIn->batch_no;
                $StockLedger->serial_no = $StockledgerIn->serial_no;
                $StockLedger->manufacturing_date = $StockledgerIn->manufacturing_date;
                $StockLedger->expiry_date = $StockledgerIn->expiry_date;
                $StockLedger->bill_of_entry_exit = $eachitem->bill_of_entry_exit;
                $StockLedger->hs_code = $inventory->hs_code;
                $StockLedger->in_stockledger_id = $StockledgerIn->id;
                $StockLedger->length =$StockledgerIn->length;
                $StockLedger->breadth =$StockledgerIn->breadth;
                $StockLedger->height =$StockledgerIn->height;
                
                $StockLedger->created_by = Yii::app()->user->id;
                $StockLedger->created_time = date('Y-m-d h:i:s');
                $StockLedger->stock_updated= 'Y';
                $StockLedger->save(false);
                $stockledgerOut = Yii::app()->db->createCommand("select SUM(quantity*unit_exchange_rate) AS qty from erp_stock_ledger where in_stockledger_id=" . $StockledgerIn->id)->queryScalar();
                $bal = ($StockledgerIn->quantity * $StockledgerIn->unit_exchange_rate) - $stockledgerOut;
                if ($bal < 0.1) {
                    if ($StockledgerIn->bin_id > 0) {
                        $bin = MasInvBin::model()->findByPk($StockledgerIn->bin_id);
                        $bin->is_free = "Y";
                        $bin->save(false);
                    }
                }
                $raks = MasInvBin::model()->findAll(array('condition' => 'is_free="N" AND rack_id=' . $StockledgerIn->rack_id));
                if ((int) $StockledgerIn->rack->total_bins == count($raks)) {
                    if ($StockledgerIn->rack_id > 0) {
                        $rak = MasInvRack::model()->findByPk($StockledgerIn->rack_id);
                        $rak->is_free = "N";
                        $rak->save(false);
                    }
                } else {
                    if ($StockledgerIn->rack_id > 0) {
                        $rak = MasInvRack::model()->findByPk($StockledgerIn->rack_id);
                        $rak->is_free = "Y";
                        $rak->save(false);
                    }
                }
                //StockLedger End
                  
            }
            Yii::app()->db->createCommand('delete from temp_goods_issue_uploads')->execute();
           
            $jsonData['status'] = 'success';
            echo CJSON::encode($jsonData);
        } else {
            $error1 = json_decode(CActiveForm::validate($model, '', false), true);
             if ($model_item[0]->product_id > 0)
                $error2 = json_decode(CActiveForm::validateTabular($model_item, '', false), true);
            else
                $error2[] = "Please add atleast one line item";
            $error = CJSON::encode(array_merge_recursive($error1, $error2,$other));
            if ($error != '[]')
                echo $error;
        }
    }
    
    
    public function actionPrintDeliveryNotePDF() {

        //$model = new PurchasingRequisition();
        $id = Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = GoodsIssue::model()->findByPk($id);
        }
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.logistics.views.pdf.issues_delivery_note_print', array('model' => $model, 'id' => $id, 'title' => $title), true));
        $mPDF1->Output("Deliverynote_".$id.".pdf", 'I');
    }

}
