<?php

class EnquiryController extends Controller
{
	public $layout = 'layout';
	public function accessRules() {
		return array(
				array('allow', // allow all users to perform 'index' and 'view' actions
						'actions' => array('login', 'error', 'logout', 'Forgotpassword', 'Recover', 'companyFieldDetails'),
						'users' => array('*'),
				),
				array('allow', // allow authenticated user to perform 'create' and 'update' actions
						'actions' => array('Index','Create','GetProducts','GetAllProducts','SaveEnquiry','GetEnquiryList','DeleteEnquiryItem',
                                                    'DeleteNonStockEnquiryItem','PrintEnquiryReportPDF','AddPrice','SavePrice','Analyse','AddPurchaseOrder','ShowMore','GetProductPreviousCostPrice'),
						'expression' => '$user->isMember()',
				),
				array('deny', // deny all users
						'users' => array('*'),
				),
		);
	}
	
	public function filters() {
		return array('accessControl'); // perform access control for CRUD operations
	}
	
	
	public function actionIndex()
	{
		$this->render('index');
        }
        public function actionGetEnquiryList() {

        $model = new PurchasingEnquiry();


        $draw = $_POST['draw'];

        $offset = $_POST['start'];

        $limit = $_POST['length'];

        $columns = array(

            // datatable column index  => database column name

            0 => 't.id',

            1 => 't.title',
            2 => 't.enquiry_date',

            3 => 't.required_date',
            4 =>'t.vendor_id',
            5 => 'convert_status',

        );

        $filterColumn = $columns[$_POST['order'][0]['column']];

        $filterOrder = $_POST['order'][0]['dir'];

        $orderBy = $filterColumn . " " . $filterOrder;

        
        $condition = "1=1";
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {

            $searchString = $_POST['search']['value'];

            $condition .= " AND ( t.id LIKE '%" .$searchString. "%' OR t.title LIKE '%" . $searchString . "%'  OR t.required_date LIKE '%" . $searchString . "%'  OR t.enquiry_date LIKE '%" . $searchString . "%')";

        }else{
            $condition .= " AND convert_status='Y'";
        }

        $count = $model->count(array('condition' => $condition));

        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset,'order'=>'id DESC'));

        $recordsTotal = $count;

        $recordsFiltered = $count;

        $data['draw'] = $draw;

        $data['recordsTotal'] = $recordsTotal;

        $data['recordsFiltered'] = $recordsFiltered;

        $rowData = array();

        $i = 1;
     
        
        
       
        foreach ($model as $row) {
            $req_date=date("d/m/Y", strtotime($row->enquiry_date));
            $required_date=date("d/m/Y", strtotime($row->required_date));
            $vendor_name =array();
            $vendorname="";
            $vendor_id=explode(',',$row['vendor_id']);
            foreach ($vendor_id as $value) {                            
                $vendor_name[]=Vendor::model()->findbyPk($value)->vendor_name;
            }
            if(!empty($vendor_name)){
                $vendorname=  implode(',', $vendor_name);
            }
            //$drop=   CHtml::dropDownList('vendor_id_'.$row['id'],'',Vendor::getVendorsEnquiry($row->id),array('class' =>'form-control','style' =>'width:200px; height:18px; padding:4px'));
           
            //$enqExits = PurchasingAnalysis::model()->findAll(array('condition' => 'enq_id = '.$row['id'].' '));
            $enqExits="";
            $Analyse = '';
            if(!empty($enqExits)){
                if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["enquiry_analysis"])){
                    $Analyse = ' <button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'enquiry/analyse&id=' . $row['id'] . '\',\'Analysis - ' . $row['id'] . '\',\'xl\')" title="Analyse Price"><i class="fa fa-pie-chart"></i></button>';
                }  
            }
            if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["enquiry_pdf"])){
                $print_btn=' <a class="btn btn-primary btn-xs" onclick="printenquiry('.$row['id'].');" title="Print Enquiry"><i class="fa fa-file-pdf-o" aria-hidden="true"></i></a>';
            }
            if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["enquiry_price"])){
                    $AddVendorItem = ' <button class="btn btn-primary btn-xs" onclick="addprice('.$row['id'].');" title="Add Vendor Specific Prices"><i class="fa fa-plus"></i></button> ';
            }
            $rowData[] = array($row['id'],$req_date, $required_date,$vendorname,$row['convert_status']); 
        }

        $data['data'] = $rowData;

        echo json_encode($data);

    }
        public function actionCreate()
        {  
             
            $model           = new PurchasingEnquiry(); 
           
            $modelEnquiryStockItem = array(new PurchasingEnquiryStockItem);
            $modelEnquiryNonStockItem = array(new PurchasingEnquiryNonStockItem);
             
            $id              = (int) Yii::app()->request->getParam('id');
            $req_id          = (int) Yii::app()->request->getParam('req_id');      
            $movement_analysis_id          = (int) Yii::app()->request->getParam('analysis_id');      
            $temp_id =  Yii::app()->request->getParam('temp_id');   
            if($id > 0){
                $model=$model->findByPk($id);
                $modelEnquiryStockItem = PurchasingEnquiryStockItem::model()->findAll(array('condition'=>'purchasing_enquiry_id="'.$id.'"')); 
                if(empty($modelEnquiryStockItem)){
                    $modelEnquiryStockItem = array(new PurchasingEnquiryStockItem);
                }
            
                $modelEnquiryNonStockItem = PurchasingEnquiryNonStockItem::model()->findAll(array('condition'=>'purchasing_enquiry_id="'.$id.'"')); 
                if(empty($modelEnquiryNonStockItem)){
                    $modelEnquiryNonStockItem = array(new PurchasingEnquiryNonStockItem);
                }
            }
            if($req_id > 0)
            {
                
                $modelRequisition=PurchasingRequisition::model()->findByPk($req_id);
                $model->title=$modelRequisition->file_title;
                $model->requisition_id=$req_id;
                $model->remarks=$modelRequisition->remarks;
               
                foreach ($modelRequisition->stockitems as $i => $eachItem) {
                    $modelEnquiryStockItem[$i] = new PurchasingEnquiryStockItem;
                    $modelEnquiryStockItem[$i]->stock_item_id = $eachItem->stock_item_id;
                    $modelEnquiryStockItem[$i]->stock_item_name = $eachItem->stock_item_name;
                    $modelEnquiryStockItem[$i]->stock_item_description = $eachItem->stock_item_description;
                    $modelEnquiryStockItem[$i]->stock_item_unit = $eachItem->stock_item_unit;
                    $modelEnquiryStockItem[$i]->stock_item_quantity = $eachItem->stock_item_quantity;
                }
                 foreach ($modelRequisition->nonstockitems as $i => $eachItem1) {
                    $modelEnquiryNonStockItem[$i] = new PurchasingEnquiryNonStockItem;
                    $modelEnquiryNonStockItem[$i]->non_stock_item_name = $eachItem1->non_stock_item_name;
                    $modelEnquiryNonStockItem[$i]->non_stock_item_description = $eachItem1->non_stock_item_description;
                    $modelEnquiryNonStockItem[$i]->non_stock_item_unit = $eachItem1->non_stock_item_unit;
                    $modelEnquiryNonStockItem[$i]->non_stock_item_quantity = $eachItem1->non_stock_item_quantity;
                }          
            }else if($temp_id > 0){
                 $modeltemp = PurchasingEnquirytemp::model()->findByPk($temp_id);
                 $tempItems = PurchasingEnquiryStockItemtemp::model()->findAll(array('condition' => 'purchasing_enquiry_id='.$temp_id));
                 $tempnonItems = PurchasingEnquiryNonStockItemtemp::model()->findAll(array('condition' => 'purchasing_enquiry_id='.$temp_id));
                 $model->attributes = $modeltemp->attributes;
                 foreach ($tempItems as $i => $eachItem) {
                    $modelEnquiryStockItem[$i] = new PurchasingEnquiryStockItem;
                    $modelEnquiryStockItem[$i]->stock_item_id = $eachItem->stock_item_id;
                    $modelEnquiryStockItem[$i]->stock_item_name = $eachItem->stock_item_name;
                    $modelEnquiryStockItem[$i]->stock_item_description = $eachItem->stock_item_description;
                    $modelEnquiryStockItem[$i]->stock_item_unit = $eachItem->stock_item_unit;
                    $modelEnquiryStockItem[$i]->stock_item_quantity = $eachItem->stock_item_quantity;
                }
                foreach ($tempnonItems as $i => $eachItem1) {
                    $modelEnquiryNonStockItem[$i] = new PurchasingEnquiryNonStockItem;
                    $modelEnquiryNonStockItem[$i]->non_stock_item_name = $eachItem1->non_stock_item_name;
                    $modelEnquiryNonStockItem[$i]->non_stock_item_description = $eachItem1->non_stock_item_description;
                    $modelEnquiryNonStockItem[$i]->non_stock_item_unit = $eachItem1->non_stock_item_unit;
                    $modelEnquiryNonStockItem[$i]->non_stock_item_quantity = $eachItem1->non_stock_item_quantity;
                }    
            }
            //code added by mereena on 10/02/2021 
            else if($movement_analysis_id > 0)
            {
                
                $modelMovementAnalysis          =   PurchaseMovementAnalysis::model()->findByPk($movement_analysis_id);
                $model->movement_analysis_id    =   $movement_analysis_id;
               $k=0;
                foreach ($modelMovementAnalysis->items as $i => $eachItem) {
                    if((int) $eachItem->proposal_qty > 0){
                        $modelEnquiryStockItem[$k]                              = new PurchasingEnquiryStockItem;
                        $modelEnquiryStockItem[$k]->stock_item_id               = $eachItem->product_id;
                        $modelEnquiryStockItem[$k]->stock_item_name             = $eachItem->part_number;
                        $modelEnquiryStockItem[$k]->stock_item_description      = $eachItem->description;
                        $modelEnquiryStockItem[$k]->stock_item_unit             = $eachItem->unitdetails->symbol;
                        $modelEnquiryStockItem[$k]->stock_item_quantity         = $eachItem->proposal_qty;
                        $k++;
                    }
                }
            }
            //end  
            if($model->enquiry_date!=''){
                $model->enquiry_date = date('d/m/y',strtotime($model->enquiry_date));
            }else{
                $model->enquiry_date = date('d/m/Y');
            }
            if($model->required_date !=''){
                $model->required_date = date('d/m/y',strtotime($model->required_date));
            }else{
                $model->required_date  = date('d/m/Y', strtotime('+1 Week'));
            }    
                Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false , 'jquery-2.1.4.min.js' => false);
		$this->render('create',array('model'=>$model,
                                            'modelEnquiryStockItem'=>$modelEnquiryStockItem,
                                            'modelEnquiryNonStockItem'=>$modelEnquiryNonStockItem,'req_id' => $req_id,
                                            'movement_analysis_id'=>$movement_analysis_id
                                            ));
        }
        
    public function actionSaveEnquiry() 
    {
         
        $model       = new PurchasingEnquiry();
        $m = '';
        //$modelEnquiryItem = array( new PurchasingEnquiryStockItem );
        //$modelNonStock       = array (new PurchasingEnquiryNonStockItem);
        /*         * ********** START Code for Save ************** */
        if (isset($_POST['PurchasingEnquiry'])) 
        {
            $scenario='';
            if ((int) @$_POST['PurchasingEnquiry']['id'] > 0) {
                $model->id = (int) $_POST['PurchasingEnquiry']['id'];
                $model = $model->findByPK($model->id);
                $model->scenario = 'update';
                $scenario='update';
                $audit_type = 'UPDATED';
            } else {
                $model->crm_user_id = Yii::app()->user->id;
                $model->created_by = Yii::app()->user->id;
                $model->created_datetime = date('Y-m-d h:i:s');
                $model->scenario = 'add';
                $scenario='add';
                $audit_type = 'CREATED';
            }
            $model->updated_by = Yii::app()->user->id;
            $model->updated_datetime = date('Y-m-d h:i:s');
            $model->attributes = $_POST['PurchasingEnquiry'];
            $model->requisition_id = $_POST['PurchasingEnquiry']['requisition_id'];   
            $model->movement_analysis_id = (int) $_POST['PurchasingEnquiry']['movement_analysis_id'];   
            if(is_array($_POST['PurchasingEnquiry']['vendor_id']))
            $arrvendors= implode(",",array_filter($_POST['PurchasingEnquiry']['vendor_id'])); 
            $model->vendor_id=$arrvendors;
            if ($_POST['PurchasingEnquiry']['enquiry_date'] != '' && $_POST['PurchasingEnquiry']['enquiry_date'] != '0000-00-00') {
                   $model->enquiry_date = str_replace('/', '-', $_POST['PurchasingEnquiry']['enquiry_date']);
                   $model->enquiry_date = date("Y-m-d h:i", strtotime($model->enquiry_date));
            }
            if ($_POST['PurchasingEnquiry']['required_date'] != '' && $_POST['PurchasingEnquiry']['required_date'] != '0000-00-00') {
                   $model->required_date = str_replace('/', '-',$_POST['PurchasingEnquiry']['required_date']);
                   $model->required_date = date("Y-m-d h:i", strtotime($model->required_date));
            }
            $model->convert_status = $_POST['PurchasingEnquiry']['convert_status'];
            //$model->start_text = $_POST['PurchasingEnquiry']['start_text'];
            $model->remarks = $_POST['PurchasingEnquiry']['remarks'];
            $valid = $model->validate();                
            if (!empty($_POST['PurchasingEnquiryStockItem'])) {
                foreach ($_POST['PurchasingEnquiryStockItem'] as $j => $rowItem) {
                    if($rowItem['stock_item_id'] > 0){
                        //if(empty($rowItem['id']))
                        //{
                            $modelEnquiryItem[$j] = new PurchasingEnquiryStockItem();
                            $modelEnquiryItem[$j]->created_by = Yii::app()->user->id;
                            $modelEnquiryItem[$j]->created_datetime = date('Y-m-d h:i:s');
                        //}else{
                           // $modelEnquiryItem[$j] = PurchasingEnquiryStockItem::model()->findByPk($rowItem['id']);
                            
                       // }                                
                        $modelEnquiryItem[$j]->updated_by = Yii::app()->user->id;
                        $modelEnquiryItem[$j]->updated_datetime = date('Y-m-d h:i:s');
                        $modelEnquiryItem[$j]->purchasing_enquiry_id = '0';
                        $modelEnquiryItem[$j]->stock_item_id = $rowItem['stock_item_id'];
                        $modelEnquiryItem[$j]->stock_item_quantity = $rowItem['stock_item_quantity'];
                        $modelEnquiryItem[$j]->stock_item_name = $rowItem['stock_item_name'];
                        $modelEnquiryItem[$j]->stock_item_description = $rowItem['stock_item_description'];
                        $modelEnquiryItem[$j]->stock_item_unit = $rowItem['stock_item_unit']; 
                        $valid = $modelEnquiryItem[$j]->validate() && $valid;
                    }
                   
                }
            }   
            if (!empty($_POST['PurchasingEnquiryNonStockItem'])) 
            {   
                foreach ($_POST['PurchasingEnquiryNonStockItem'] as $k => $rowItem) {
                    if($rowItem['non_stock_item_name'] !=''){
                        //if(empty($rowItem['id']))
                        //{
                            $modelNonStock[$k] = new PurchasingEnquiryNonStockItem();
                            $modelNonStock[$k]->created_by = Yii::app()->user->id;
                            $modelNonStock[$k]->created_datetime = date('Y-m-d h:i:s'); 
                        //}else{
                            //$modelNonStock[$k] = PurchasingEnquiryNonStockItem::model()->findByPk($rowItem['id']);
                            
                        //}
                        $modelNonStock[$k]->updated_by = Yii::app()->user->id;
                        $modelNonStock[$k]->updated_datetime = date('Y-m-d h:i:s');
                        $modelNonStock[$k]->purchasing_enquiry_id = '0';
                        $modelNonStock[$k]->non_stock_item_quantity = $rowItem['non_stock_item_quantity'];
                        $modelNonStock[$k]->non_stock_item_name = $rowItem['non_stock_item_name'];
                        $modelNonStock[$k]->non_stock_item_description = $rowItem['non_stock_item_description'];
                        $modelNonStock[$k]->non_stock_item_unit = $rowItem['non_stock_item_unit']; 
                        //$modelNonStock->save(false);
                        $valid = $modelNonStock[$k]->validate() && $valid;
                    }
                }
            } 
            
            if ($valid){      
                $model->save();
                // inserting to audit log
                AuditLog::saveAuditLogs(
                    'PURCHASE_ENQUIRY',
                    Yii::app()->user->id,
                    $audit_type,
                    " with ID: - {$model->id}  "
                );
                // end audit log
                if (!empty($modelEnquiryItem)) {
                    PurchasingEnquiryStockItem::model()->deleteAll('purchasing_enquiry_id=:refer_id', array(':refer_id' => $model->id));
                    foreach ($modelEnquiryItem as $eachItem) {
                        $eachItem->purchasing_enquiry_id = $model->id;
                        $eachItem->save(false);
                    }
                    
                    if((int) $_POST['PurchasingEnquiry']['movement_analysis_id'] > 0){
                        PurchaseMovementAnalysis::model()->updateByPk($_POST['PurchasingEnquiry']['movement_analysis_id'], array('is_converted'=>'Y')); 
                    }
                }
                if (!empty($modelNonStock)) {
                    PurchasingEnquiryNonStockItem::model()->deleteAll('purchasing_enquiry_id=:refer_id', array(':refer_id' => $model->id));
                    foreach ($modelNonStock as $row) {
                        $row->purchasing_enquiry_id = $model->id;
                        $row->save(false);
                    }
                }
                
                $jsonData['crm_user_id'] = Yii::app()->user->id;
                $jsonData['id'] = $model->id;
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);

            } else 
            {
                $error1 = array();$error2 =array();$error3 =array();
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                if ($modelEnquiryItem[0]->stock_item_id != '')
                    $error2 = json_decode(CActiveForm::validateTabular($modelEnquiryItem, '', false), true);
                else
                    $error2[] = "Please add atleast one stock item";
                if ($modelNonStock[0]->non_stock_item_name!='')
                    $error3 = json_decode(CActiveForm::validateTabular($modelNonStock, '', false), true);
                $error = CJSON::encode(array_merge_recursive($error3, $error2,$error1));
                if ($error != '[]')
                    echo $error;
            }
        }        
    }
        
    public function actionGetProducts() {
        $from = $_GET['frm'];
        $searchTerm = $_GET['term'];
        $condition = 't.isActive = "Y" AND (part_number LIKE "%' . $searchTerm . '%" OR description LIKE "%' . $searchTerm . '%")';
        $model = new Inventory();
        $model = $model->with('taxDetails')->findAll(array('condition' => $condition));
        $i = 0;
        foreach ($model as $eachModel) {
            $data[$i]['value'] = $eachModel->id;
            $data[$i]['label'] = $eachModel->part_number.' : '. $eachModel->description;
            $data[$i]['part_number'] = $eachModel->part_number;
            $data[$i]['description'] = $eachModel->description;
            $data[$i]['unit_id'] = $eachModel->units->id;
            $data[$i]['unit_name'] = $eachModel->units->unit_name;
            $data[$i]['tax_code'] = $eachModel->taxDetails;
            $i++;
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }
    public function actionGetAllProducts() {
        $from = $_GET['frm'];
        $searchTerm = $_GET['term'];
        $condition = 't.isActive = "Y" AND ( inventory_item_type =1 OR inventory_item_type=3 OR inventory_item_type=2) AND (part_number LIKE "%' . $searchTerm . '%" OR description LIKE "%' . $searchTerm . '%")';
        $model = new Store();
        $model = $model->with('tax')->findAll(array('condition' => $condition));
        $i = 0;
        foreach ($model as $eachModel) {
            $data[$i]['value'] = $eachModel->id;
            $data[$i]['label'] = $eachModel->part_number.' : '. $eachModel->description;
            $data[$i]['part_number'] = $eachModel->part_number;
            $data[$i]['description'] = $eachModel->description;
            $data[$i]['unit_id'] = $eachModel->unit->id;
            $data[$i]['unit_name'] = $eachModel->unit->symbol;
            $data[$i]['tax_code'] = $eachModel->tax;
            $i++;
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }
    public function actionDeleteEnquiryItem() {

        $id = $_POST['id'];

        $model = new PurchasingEnquiryStockItem();

        $model->deleteByPk($id);

        $jsonData['status'] = 'success';

        $jsonData['id'] = $id;

        echo CJSON::encode($jsonData);

    }
        
    public function actionDeleteNonStockEnquiryItem(){
        $id = $_POST['id'];

        $model = new PurchasingEnquiryNonStockItem();

        $model->deleteByPk($id);

        $jsonData['status'] = 'success';

        $jsonData['id'] = $id;

        echo CJSON::encode($jsonData);
    } 
        
    public function actionPrintEnquiryReportPDF() {

        $id = Yii::app()->request->getParam('id');
        $vendor_id = Yii::app()->request->getParam('vendor_id');
        if($id>0)
        {
           $model = PurchasingEnquiry::model()->findByPk($id);
        }
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.enquiry_list_individual', array('model' => $model, 'id' => $id, 'title' => $title,'vendor_id'=>$vendor_id),true));
        $mPDF1->Output($htmlTemplate, 'I');
    }  
    
    public function actionAddPrice()
        {  
       
           
            $id =  Yii::app()->request->getParam('id');
            $vendor_id =  Yii::app()->request->getParam('vendor_id');
            $vendor_name = Vendor::model()->findByPk($vendor_id)->vendor_name;
            $modelPricedAdded = PurchasingAnalysis::model()->findAll(array('condition'=>'enq_id='.$id.' AND vendor_id = '.$vendor_id.' ')); 
            if(!empty($modelPricedAdded)){
                foreach ($modelPricedAdded as $i => $eachItem){
                        $modelItems[$i] = PurchasingAnalysis::model()->findByPk($eachItem->id);
                        $modelItems[$i]->stock_item_name = $eachItem->product->part_number;
                        $modelItems[$i]->unit_name = $eachItem->product->unit->symbol;
                        
                    }
            }
            if($id > 0 && empty($modelPricedAdded)){
                $model=PurchasingEnquiry::model()->findByPk($id);
                $modelEnquiryStockItem = PurchasingEnquiryStockItem::model()->findAll(array('condition'=>'purchasing_enquiry_id="'.$id.'"')); 
                if(is_array($modelEnquiryStockItem)){
                    foreach ($modelEnquiryStockItem as $i => $eachItem){
                        $modelItems[$i] = new PurchasingAnalysis;
                        $modelItems[$i]->enq_id = $id;
                        $modelItems[$i]->vendor_id = $vendor_id;
                        $modelItems[$i]->stock_item_id = $eachItem->stock_item_id;
                        $modelItems[$i]->stock_item_name = $eachItem->product->part_number;
                        $modelItems[$i]->unit_name = $eachItem->product->unit->symbol;
                        $modelItems[$i]->stock_item_quantity = $eachItem->stock_item_quantity;
                        $modelItems[$i]->description = $eachItem->stock_item_description; 
                    }
                }
                
            }
           
                Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false , 'jquery-2.1.4.min.js' => false);
		$this->render('price_form',array('model'=>$model,'modelItems'=>$modelItems,'vendor_name' =>$vendor_name));
        }
        
        
          public function actionSavePrice(){
            
             if (is_array($_POST['PurchasingAnalysis'])) {
                 
                    $valid =true;
                    foreach ($_POST['PurchasingAnalysis'] as $i => $item) {

                            $modelItems[$i] = new PurchasingAnalysis;
                            if($item['id'] > 0){
                                 $modelItems[$i]  = PurchasingAnalysis::model()->findByPk($item['id']);
                            }
                            $modelItems[$i]->attributes = $item;
                            $valid = $modelItems[$i]->validate() && $valid;
                    }
                    if($valid){
                        
                             foreach ($modelItems as $eachModel) {
                                    $eachModel->created_by = Yii::app()->user->id;
                                    $eachModel->created_datetime = date('Y-m-d h:i:s'); 
                                    $eachModel->save();
                             }
                             $jsonData['status'] = 'success';
                             echo CJSON::encode($jsonData);
                        
                    }else{
                         $error = CActiveForm::validateTabular($modelItems, '', false);
                         if ($error != '[]')
                                echo $error;
                    }

                }
           
        }
        
         public function actionAnalyse()
        {  
       
           
            $id =  Yii::app()->request->getParam('id');
            
                Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false , 'jquery-2.1.4.min.js' => false);
		$this->render('analyse_form',array('id' => $id));
        }
        
        public function actionAddPurchaseOrder(){
            $enq_id = $_POST['id'];
            $product_ids = $_POST['product'];
            $vendor_id = $_POST['vendor_id'];
            $products = explode(',', $product_ids);
            if($enq_id > 0)
            {
                $modelEnquiry=PurchasingEnquiry::model()->findByPk($enq_id);
                $model = new PurchasingOrdertemp;
                $model->title = $modelEnquiry->title;
                $model->enquiry_id = $enq_id;
//                $file = new MasterFile;
//                $file->crm_user_id = Yii::app()->user->id;
//                $file->customer_id = $vendor_id;
//                $file->file_title = $modelEnquiry->title;
//                $file->start_from = 'P_E';
//                $file->current_process_status = 'P_O';
//                $file->save(false);
//                $model->file_id = $file->id;
                $model->crm_user_id = Yii::app()->user->id;
                $model->vendor_id = $vendor_id;
                $model->currency = 23; 
                $model->exchange_rate = 1; //UAE Dhirham
                $model->created_by = Yii::app()->user->id;
                $model->created_datetime = date('Y-m-d h:i:s');
                $total = 0;
                foreach ($products as $i => $eachItem) {
                    if($eachItem > 0){
                        $modelOrderStockItem[$i] = new PurchasingOrderStockItemtemp;
                        $con = 'enq_id="'.$enq_id.'" AND  stock_item_id  = '.$eachItem.' AND vendor_id = '.$vendor_id.' ';
                        $Analyse = PurchasingAnalysis::model()->find(array('condition'=>$con));
                        $modelOrderStockItem[$i]->stock_item_id = $eachItem;
                        $modelOrderStockItem[$i]->stock_item_name = $Analyse->product->part_number;
                        $modelOrderStockItem[$i]->stock_item_description = $Analyse->product->description;
                        $modelOrderStockItem[$i]->stock_item_unit = $Analyse->product->unit->symbol;
                        $modelOrderStockItem[$i]->stock_item_quantity = $Analyse->stock_available;
                        $modelOrderStockItem[$i]->stock_item_rate =  $Analyse->stock_rate;
                        $modelOrderStockItem[$i]->stock_item_amount = $Analyse->stock_rate * $Analyse->stock_available;
                        $total += $Analyse->stock_rate * $Analyse->stock_available;
                    }

                }                 
            }
                $date = date('Y-m-d');
                $model->expected_delivery_date = $date;
                $model->stock_grand_total = $total;
                $model->required_date =  date('Y-m-d', strtotime('+1 Week'));
                $model->order_date = $date;
                $model->save(false);
                foreach ($modelOrderStockItem as $each){
                        $each->purchasing_order_id = $model->id;
                        $each->save(false);
                }
                 $jsonData['status'] = 'success';
                 $jsonData['id'] = $model->id;
                 $jsonData['vendor_id'] = $vendor_id;
                 echo CJSON::encode($jsonData);
           
        }
        
        public function actionShowMore()
        {  
            $id =  Yii::app()->request->getParam('id');
            $model = PurchasingEnquiry::model()->findByPk($id);
            Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false , 'jquery-2.1.4.min.js' => false);
            $this->render('enquiry_more_option',array('id' => $id,'model'=>$model));
        }
        public function actionGetProductPreviousCostPrice(){
            $product_id =  Yii::app()->request->getParam('product_id');
            $previous_cost_price=StockLedger::model()->getPreviousCostPrice($product_id);
            $jsonData['previous_cost_price'] = $previous_cost_price;
            echo CJSON::encode($jsonData);
        }
        
        
        
        
}