<?php

class CreditnoteController extends Controller {

    public $layout = 'layout';

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout', 'Forgotpassword', 'Recover', 'companyFieldDetails'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'GetCreditNoteList', 'Create', 'DeleteNotes', 'GetNotesList', 'UploadDocuments',
                    'GetDocumentList', 'DeleteDocument', 'GetDeliveryList', 'createInvoice', 'SetFile', 'GetFileDetails',
                    'GetFiles', 'Getfileno', 'FetchDeliveryNotes', 'SaveMultipleDeliveryInvoice', 'CreateReceipt', 'SaveReceipt', 'EditReceipt',
                    'GetDescription', 'SaveCreditNote', 'PrintFile', 'AddQuantityDetails', 'GetFactor', 'GetCheckingList', 'ReturnItems', 'PostCreditNote','CancelCreditNote',
                    'GetinvoiceDetails','GetsalesreturnDetails'
                ),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array('accessControl'); // perform access control for CRUD operations
    }

    public function actionIndex() {
        $frm = (int) Yii::app()->request->getParam('frm');
        $this->render('index',array('frm'=>$frm));
    }

    public function actionGetFileDetails($file_id, $needed_model) {

        $masterFile = MasterFile::model()->with($needed_model)->findByPK($file_id);
        $jsonData['file'] = $masterFile;
        $jsonData[$needed_model] = $masterFile->{$needed_model};
        $jsonData['salesgroup'] = MasSalesGroup::model()->findByPK($jsonData[$needed_model]->sales_group);
        $jsonData['currency'] = MasCurrency::model()->findByPK($jsonData[$needed_model]->currency);
        $jsonData['paymenttermdetails'] = MasPaymentTerm::model()->findByPK($jsonData[$needed_model]->payment_terms);
        $jsonData['payemntterm'] = $jsonData['paymenttermdetails']->payment_code . ':' . $jsonData['paymenttermdetails']->payment_terms;
        return $jsonData;
    }

    public function actionGetFiles($status = array(), $options = array()) {
        $data_array = array();
        if (isset($_GET['term'])) {
            $condition = 'isActive="Y" AND current_process_status in ("' . implode('","', $status) . '") AND (	file_title like "%' . $_GET['term'] . '%" or id like "%' . $_GET['term'] . '%")';
            if (!empty($options)) {
                foreach ($options as $column => $column_val) {
                    $condition .= ' AND ' . $column . '="' . $column_val . '"';
                }
            }
            $model = MasterFile::model()->findAll(array('condition' => $condition, 'order' => 'id DESC'));
            $i = 0;
            foreach ($model as $eachModel) {
                $data_array[$i]['value'] = $eachModel->id;
                $data_array[$i]['label'] = $eachModel->id . ':' . $eachModel->file_title;
                $i++;
            }
        }
        echo CJSON::encode($data_array);
        Yii::app()->end();
    }

    public function actionCreate() {
        $model = new Creditnote();

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('create', array('model' => $model));
    }

    public function actioncreateInvoice() {
        $model = new Invoice();
        $id = (int) Yii::app()->request->getParam('id');
        $delivery_id = (int) Yii::app()->request->getParam('delivery_id');
        $file_id = (int) Yii::app()->request->getParam('file_id');

        $modelItems = array(new InvoiceItem);
        if ($id > 0) {
            $model = $model->findByPk($id);
            $modelOrderItems = InvoiceItem::model()->findAll(array('condition' => 'invoice_id="' . $id . '"'));
            if (empty($modelOrderItems)) {
                $modelOrderItems = array(new InvoiceItem);
            }
        }
        if ($delivery_id > 0) {
            $modelorder = DeliveryNote::model()->findByPK($delivery_id);
            $model->file_id = $modelorder->file_id;
            $model->company_id = $modelorder->company_id;
            $model->order_id = $modelorder->order_id;
            $model->delivery_ids = $modelorder->id;
            $model->billing_address = $modelorder->billing_address;
            $model->shipping_address = $modelorder->shipping_address;
            $model->contact_id = $modelorder->contact_id;
            $model->sales_group = $modelorder->order->sales_group;
            $model->notes = $modelorder->notes;
            $model->terms_and_conditions = $modelorder->terms_and_conditions;
            $model->lpo = $modelorder->lpo;
            $model->others = $modelorder->others;
            $model->currency = $modelorder->order->currency;
            $model->exchange_rate = $modelorder->order->exchange_rate;
            $model->payment_terms = $modelorder->order->payment_terms;
            $model->remarks = $modelorder->remarks;
            $model->terms_and_conditions = $modelorder->terms_and_conditions;
            $modelItems = DeliveryNoteItem::model()->findAll(array('condition' => 'delivery_note_id=' . $modelorder->id));
            foreach ($modelItems as $i => $eachItem) {
                if ($eachItem->picked_qty > 0) {
                    $orderItems = OrderItem::model()->find(array('condition' => 'order_id=' . $modelorder->order_id . ' AND product_id=' . $eachItem->product_id));
                    $modelInvoiceItems[$i] = new InvoiceItem;
                    $modelInvoiceItems[$i]->product_id = $eachItem->product_id;
                    $modelInvoiceItems[$i]->description = $eachItem->description;
                    $modelInvoiceItems[$i]->quantity = $eachItem->picked_qty;
                    $modelInvoiceItems[$i]->rate = $orderItems->rate;
                    $modelInvoiceItems[$i]->tax_vat_percentage = $eachItem->tax_vat_percentage;
                    $modelInvoiceItems[$i]->tax_vat_amount = $eachItem->tax_vat_amount;
                    $modelInvoiceItems[$i]->amount = $eachItem->picked_qty * $orderItems->rate;
                    $modelInvoiceItems[$i]->addition_percentage = $orderItems->addition_percentage;
                    $modelInvoiceItems[$i]->addition_amount = $orderItems->addition_amount;
                    $modelInvoiceItems[$i]->deduction_percentage = $orderItems->deduction_percentage;
                    $modelInvoiceItems[$i]->deduction_amount = $orderItems->deduction_amount;
                    $modelInvoiceItems[$i]->net_amount = ($eachItem->picked_qty * $orderItems->rate) + $orderItems->addition_amount - $orderItems->deduction_amount;
                }
            }
            $modelAdd = OrderAddition::model()->findAll(array('condition' => 'order_id=' . $modelorder->id));
            if (empty($modelAdd)) {
                $modelAdd = array(new OrderAddition);
            }
            $modelDed = OrderDeduction::model()->findAll(array('condition' => 'order_id=' . $modelorder->id));
            if (empty($modelDed)) {
                $modelDed = array(new OrderDeduction);
            }
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('create', array('model' => $model, 'file_id' => $model->file_id,
            'modelInvoiceItems' => $modelInvoiceItems, 'modelAdd' => $modelAdd, 'modelDed' => $modelDed
        ));
    }

    public function actionSaveCreditNote() {
        $modelCreditNote = new Creditnote;

        if (isset($_POST['Creditnote'])) {

            $modelCreditNote->scenario = 'add';
            $modelCreditNote->scenario = 'update';
            $modelCreditNote->attributes = $_POST['Creditnote'];
            $modelInvoice = Invoice::model()->findByPk($modelCreditNote->invoice_id);
            $modelCreditNote->file_id = $modelInvoice->file_id;
            $modelCreditNote->job_order_id = $modelInvoice->order_id;
            $modelCreditNote->tax_type = $modelInvoice->tax_type;
            $modelCreditNote->customer_id = $modelInvoice->customer_id;
            $modelCreditNote->contact_id = $modelInvoice->contact_id;
            $modelCreditNote->created_date_time = date('Y-m-d h:i:s');
            $modelCreditNote->created_by = Yii::app()->user->id;
            $modelCreditNote->credited_date = date('Y-m-d', strtotime( str_replace('/', '-', $_POST['Creditnote']['credited_date']) ));
            $modelCreditNote->lead_owner_id = $modelInvoice->lead_owner_id;
            //$modelCreditNote->terms_and_conditions =  $_POST['terms_conditions'];
            $other_errors = array();
            $grand_total = 0;
            $valid1 = true;
            $valid = true;
            $f=0;
            
            foreach ($_POST['CreditnoteItem'] as $i => $item) {
                if ($item['product_id']>0 && $item['returned_rate']>0) {
                    $modelItem[$f] = new CreditnoteItem;
                    $modelItem[$f]->attributes          = $_POST['CreditnoteItem'][$i];
                    $modelItem[$f]->description         = $item['description'];
                    $modelItem[$f]->tax_vat_percentage  = $_POST['CreditnoteItem'][$i]['tax_vat_percentage'];
                    $modelItem[$f]->tax_vat_amount      = $_POST['CreditnoteItem'][$i]['tax_vat_amount'];
                    $modelItem[$f]->unit_id             = $_POST['CreditnoteItem'][$i]['unit_id'];
                    $valid = $modelItem[$f]->validate() && $valid;
                    $f++;
                }
            }


          

            $valid = $valid && is_array($modelItem);
            if ($modelCreditNote->validate() && $valid) { // after validation saving the whole data 

                    $modelCreditNote->save(false);
    
                     // inserting to audit log
                     AuditLog::saveAuditLogs(
                        'CREDIT_NOTE',
                        Yii::app()->user->id,
                        'CREATED',
                        " Checking No: - {$modelCreditNote->id}   "
                    );
                    // end audit log 
                    
                    $modelCreditNote->refresh();
                    $total_tax_amount = 0;
                    foreach ($modelItem as $eachItem) {
                        $eachItem->creditnote_id = $modelCreditNote->id;
                        $eachItem->save(false);
                        $grand_total += $eachItem->net_amount;
                        $total_tax_amount += $eachItem->tax_vat_amount;
                    }
                    

                $grand_total += $total_tax_amount;

                $modelCreditNote->updateByPk($modelCreditNote->id, array('credited_amount' => $grand_total, 'total_tax_amount' => $total_tax_amount));
                
                Invoice::model()->updateByPk($modelCreditNote->invoice_id, array('is_credit_note' => 'Y'));
                
                $jsonData['file'] = $modelCreditNote->file;
                $jsonData['model'] = $modelCreditNote;
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } 
            else {
                $error3 = array();
                $error1 = json_decode(CActiveForm::validate($modelCreditNote, '', false), true);

                if (!empty($modelItem[0]->product_id))
                    $error2 = json_decode(CActiveForm::validateTabular($modelItem, '', false), true);
                else
                    $error2[] = "Please add atleast one line item";

                if (!empty($model_stock_item))
                    $error3 = json_decode(CActiveForm::validate($model_stock_item, '', false), true);

                $error = CJSON::encode(array_merge_recursive($error1, $error2, $error3));

                if ($error != '[]')
                    echo $error;
            }
            
        }
            Yii::app()->end();
    }

    public function actionGetCreditNoteList() {
        $model = new Creditnote();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $frm  = $_POST['frm'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.file_id',
            1 => 't.invoice_id',
            2 => 't.id',
            3 => 't.customer_id',
            4 => 't.credited_date',
            5 => 't.currency',
            6 => 't.id',
            7 => 't.total_tax_amount',
            8 => 't.id',
            9 => 't.id'
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        // if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["credit_view_all"])){
        //     $condition = 't.isActive="Y" ';
        // }else{
        //     $condition = 't.isActive="Y" AND t.crm_user_id= "'.Yii::app()->user->id.'" ';
        // }

        //$condition = 't.isActive="Y"';
        $condition = '1=1';
        if(((int) Yii::app()->user->havePermissionOn["credit_note_view_all"]) == 0){
            $condition.= ' AND t.lead_owner_id= "'.Yii::app()->user->id.'"';
        }
        
       

        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " AND (customer.customer_name LIKE '%" . $searchString . "%' OR t.file_id LIKE '%" . $searchString . "%' OR  t.id LIKE '%" . $searchString . "%' OR  t.invoice_id LIKE '%" . $searchString . "%'  OR invoice.invoice_no LIKE '%" . $searchString . "%' OR t.reference LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('customer', 'file', 'invoice')->count(array('condition' => $condition));
        $model = $model->with('customer', 'file', 'invoice')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => 't.id DESC'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();

        foreach ($model as $row) {
            $status = '';
            $div = '';
            $modelInvoice_type = $row['invoice']['invoice_type'];
            //$modelInvoice_no = $row['invoice']['invoice_no'];
            $modelInvoice_no = $row['invoice']['id'];
            /* if((int) $modelInvoice_type > 0){
              $modelInvoiceType = new MasInvoiceType();
              $arr_invoice_type_details = $modelInvoiceType->findByPk((int) $modelInvoice_type);
              $inv_code      = $arr_invoice_type_details->inv_code;
              $modelInvoice_no=$inv_code.'-'.$modelInvoice_no;
              } */
                if ((Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["credit_pdf"])) && $row->invoice->invoicetype->tax == 'Y') {
                    $div .= '<a class="btn btn-primary btn-xs" title="Print" target="_blank" href="index.php?r=creditnote/printfile&file=' . $row['file_id'] . '&id=' . $row['id'] . '&customer=' . $row['customer_id'] . '&frm=tax"><i class="fa fa-file-pdf-o" aria-hidden="true"></i></a>';
                } else if (Yii::app()->user->authorised_user == 1 || ( (int) Yii::app()->user->havePermissionOn["credit_pdf"] && $row->invoice->invoicetype->tax == 'N') || ( (int) Yii::app()->user->havePermissionOn["credit_pdf"])) {
                    $div .= '<a class="btn btn-primary btn-xs" title="Print" target="_blank" href="index.php?r=creditnote/printfile&file=' . $row['file_id'] . '&id=' . $row['id'] . '&customer=' . $row['customer_id'] . '&frm=taxnil"><i class="fa fa-file-pdf-o" aria-hidden="true"></i></a>';
                }
           
            $net_returned_amount = (($row['credited_amount'] + $row['total_tax_amount']) * $row['exchange_rate']);
//            $status=$row['file']['status'];
            if($row['posted']=='Y')
            {
            $status.='Posted';    
            $color='green';
            }
            else {
            $status.='Unposted';      
            $color='red';
            }
            $status='<span title="'.$status.'" style="background-color:'.$color.'; color:#fff;">'.$status.'</span>';
            $rowData[] = array($row['file_id'], $row['id'], $modelInvoice_no, $row->customer->customer_name, date("d/m/Y", strtotime($row['credited_date'])), $row['currencyname']['currency_code'], Yii::app()->numberFormatter->formatCurrency($row['invoice']['grand_total'], ""), Yii::app()->numberFormatter->formatCurrency($row['total_tax_amount'], ""), Yii::app()->numberFormatter->formatCurrency($row['credited_amount'], ""),$status, '<div class="btn-wrap text-center">' . $div . '</div>',$row->created_by,$row->posted,$row->isActive);
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionDeleteNotes() {
        $id = $_POST['id'];
        $model = new FileNotes();
        $model->deleteByPk($id);
        echo "success";
    }

    public function actionGetNotesList() {
        $id = $_POST['id'];
        $model = new FileNotes();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 'notes',
            2 => 'created_datetime',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        if ($id == '') {
            $id = 0;
        }
        $condition = 't.file_id="' . $id . '"';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " and (notes LIKE '%" . $searchString . "%')";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $rowData[] = array($m, $row->notes, date('d/m/Y', STRTOTIME($row->created_datetime)), '<div class="btn-wrap">
                            <a href ="#" class="btn btn-danger btn-xs" onclick="deleteNotes(' . $row['id'] . ')"><i class="fa fa-trash-o "></i></a></div>');
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionGetDocumentList() {
        $model = new Document();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.file_id',
            1 => 't.document_name',
            2 => 't.created_by',
            3 => 't.created_datetime',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.isActive="Y" and t.file_id = "' . $_POST['file_id'] . '" and uploaded_from = "O"';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " and (document_name LIKE '%" . $searchString . "%')";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $button_string = "";
            $model2 = User::model()->find(array('condition' => 't.id = "' . $row['created_by'] . '"'));
            if (isset(Yii::app()->user->havePermissionOn['credit_document']) || Yii::app()->user->authorised_user == 1) {
                $button_string .= ' <a href ="#" class="btn btn-danger btn-xs" onclick="deleteDocument(' . $row['id'] . ')"><i class="fa fa-trash-o "></i></a> &nbsp;';
            }
            //$button_string .= '<a href ="'. Yii::app()->createUrl('lead/downloaddocument&id='.$row['id']).'" class=" btn btn-primary btn-xs"><i class="fa fa-download"></i></a>';
            $rowData[] = array($m, $row['document_name'], $model2->username, date("d/m/Y", strtotime($row['created_datetime'])), '<div class="btn-wrap text-center">' . $button_string . '</div>');
//                    $model2 = User::model()->find(array('condition'=>'t.id = "'.$row['created_by'].'"'));
//                    $rowData[]=array($m,$row['document_name'],$model2->username,date("d/m/Y",strtotime($row['created_datetime'])),
//                            '<div class="btn-wrap text-center">'
//                             .'<a href ="#" class="btn btn-danger btn-xs" onclick="deleteDocument(' . $row['id'] . ')"><i class="fa fa-trash-o "></i></a></div>');
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionDeleteDocument() {
        $id = $_POST['id'];
        $modelDocument = new Document();
        $modelDocument->deleteByPk($id);
        echo "success";
    }

    public function actionGetfileno() {
        $searchTerm = $_GET['term'];
        $condition = 't.file_id LIKE "%' . $searchTerm . '%" OR t.id LIKE "%' . $searchTerm . '%"';
        $model = new Invoice();
        $model = $model->with('file', 'customer', 'contact')->findAll(array('condition' => $condition));
        $i = 0;
        foreach ($model as $eachModel) {
            $data[$i]['value'] = $eachModel->id;
            $data[$i]['label'] = $eachModel->file_id . ' : ' . $eachModel->id; //$eachModel->invoicetype->inv_code.'-'.
            $data[$i]['currency'] = $eachModel->currency0->currency;
            $data[$i]['currency_id'] = $eachModel->currency0->id;
            $data[$i]['exchangerate'] = $eachModel->currency0->exchange_rate;
            $data[$i]['customer_id'] = $eachModel->customer_id;
            $data[$i]['customer_name'] = $eachModel->customer->customer_name;
            $i++;
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }

    public function actionGetDescription() {
        $modelInvoice_id = (int) Yii::app()->request->getParam('id');
        $model = Invoice::model()->findByPk($modelInvoice_id);
        $data['customer_name'] = $model->customer->customer_name;
        $data['customer_id'] = $model->customer_id;
        $invitems = InvoiceItem::model()->findAll(array('condition' => 'invoice_id=' . $modelInvoice_id));
        $colspan=9;
        $tbl = '<table class="table table-hover table-bordered personal-task" id="credit_item_table">        
            <tr>            
            <th>No</th>     
            <th>Product</th>            
            <th>Description</th>            
            <th>Qty(Picked)</th>   
            <th>Unit</th>              
            <th>Actual.Rate</th>                      
            <th>Returned Amount</th>                        
            <th>Balance Amount</th>              
            <th>Credit Amount</th> 
            <th>Amount</th>          
            <th>Tax(%)</th>                     
           </tr>';
          
        $data_exist=0;
        $i=0;
        foreach ($invitems as $row => $eachRow) {
            $factor = 1;
            $model = new CreditnoteItem;
            $arr_inventory = Inventory::model()->findByPk($eachRow->product_id);
            $model->unit_id = $eachRow->unit_id;
           
            /* if($arr_inventory->type=="S"){
                $total_qty = $eachRow->quantity * $eachRow->invoiceunit->factor;
            }
            else{
                $total_qty = $eachRow->quantity;
            }*/
            $total_qty = $eachRow->quantity;
            $total_rate = $eachRow->rate;
            //$return_qty = CreditnoteItem::model()->find(array('select' => '(SUM(t.returned_quantity)) AS returned_quantity', 'condition' => 't.invoice_item_id="' . $eachRow->id . '" AND t.product_id="' . $eachRow->product_id . '" AND t.returned_quantity !="0"', 'group' => 't.product_id'))->returned_quantity;
            $return_rate = CreditnoteItem::model()->find(array('select' => '(SUM(t.returned_rate)) AS returned_rate', 'condition' => 't.invoice_item_id="' . $eachRow->id . '" AND t.product_id="' . $eachRow->product_id . '" AND t.returned_rate !="0"', 'group' => 't.product_id'))->returned_rate;
            if ($return_rate < 1) {
                $return_rate = 0;
            }
            $total_return = $return_rate;
            $total_remaining = $total_rate - $total_return;
            if ($total_remaining < 1) {
                $total_remaining = 0;
            }
            if ($total_remaining>0) {
                $data_exist=1;
            }
            
            if($total_remaining>0){
                
                
            $tbl .= '<tr>';
            $tbl .= '<td>' . ($i + 1) . '</td>';
            $tbl .= '<td><input type="hidden" id="credits_note_productname_' . $i . '" value="' . $arr_inventory->part_number . '">' . $arr_inventory->part_number
                    . CHtml::activeHiddenField($model, "[$i]product_id", array('value' => $eachRow->product_id)) .
                    CHtml::activeHiddenField($model, "[$i]description", array('value' => $eachRow->description)) .
                    CHtml::activeHiddenField($model, "[$i]invoice_item_id", array('value' => $eachRow->id))
                    . CHtml::activeHiddenField($model, "[$i]rate", array('value' => ($eachRow->net_amount / $eachRow->quantity)))
                    . CHtml::activeHiddenField($model, "[$i]id", array('value' => $eachRow->id))
                    . CHtml::activeHiddenField($model, "[$i]unit_id", array('value' => $eachRow->unit_id))
                    . CHtml::hiddenField("InvoiceItem[$i]_total_return", $total_return)
                    . CHtml::hiddenField("InvoiceItem[$i]_total_quantity", $total_qty)
                    . CHtml::hiddenField("InvoiceItem[$i]_total_remaining", $total_remaining) 
                    . '</td>';
            $tbl .= '<td>' . $eachRow->description . '</td>';
            $tbl .= '<td>' . $eachRow->quantity . '</td> ';
            $tbl .= '<td>' . CHtml::activedropdownlist($model, "[" . $i . "]unit_id", MasUnit::getSimilarUnits($eachRow->unit_id), array('class' => 'unit go')) . '</td> ';
            $tbl .= '<td>' . CHtml::activeTextField($model, "[$i]net_rate", array('class' => 'rate go text-right to_be_calculated', 'readonly' => 'true', 'value' => number_format((round($eachRow->net_amount / $eachRow->quantity, 2)),"2"))) . '</td>';
            $tbl .= '<td class="cell-right">' . CHtml::activeHiddenField($model, "[$i]quantity", array('value' => $eachRow->quantity))
                    . CHtml::TextField("CreditnoteItem[$i][previous_rate]",$return_rate, array('class' => 'rate qty go cell-center text-right', 'readonly' => 'true')) . '</td>';
             $tbl .= '<td class="cell-right">' .  CHtml::TextField("CreditnoteItem[$i][balance_rate]",number_format($total_remaining,"2"), array('class' => 'rate qty go cell-center text-right', 'readonly' => 'true')) . '</td>';
             $tbl .= '<td class="cell-right">' . CHtml::activeTextField($model, "[$i]returned_rate", array('class' => 'rate qty go cell-center text-right', 'onkeypress' => 'removequantity($("#material_receipt_stocktable"),this,this.id);return isNumberKey1(event,' . $eachRow->quantity . ',this.value);', 'onkeyup' => 'calculateValues11($("#credit_item_table"));')) . '</td>';        
            
           
            $tbl .=  '<td class="cell-right">' . CHtml::activeTextField($model, "[$i]net_amount", array('class' => 'rate go text-right to_be_calculated', 'readonly' => 'true')) . '</td>'
                    . '<td>' . CHtml::activeTextField($model, "[$i]tax_vat_percentage", array('class' => 'rate go text-right to_be_calculated', 'readonly' => 'true', 'value' => $eachRow->tax_vat_percentage))
                    . CHtml::activeHiddenField($model, "[$i]tax_vat_amount", array('value' => $eachRow->tax_vat_amount))
                    . '</td>'
                    . '</tr>';
                    
                    $i++;
            }
        }
        if($data_exist==0){
            $tbl .=  '<tr><td colspan="'.$colspan.'" class="text-center text-bold">No Item Exist</td></tr>';
        }
        $tbl .= '</table>';
        $data['tbl'] = $tbl;
        echo CJSON::encode($data);
        Yii::app()->end();
    }

    public function actionPrintFile() {


        $id = Yii::app()->request->getParam('id');
        $file_id = Yii::app()->request->getParam('file');
        $customer_id = Yii::app()->request->getParam('customer');
        $frm = Yii::app()->request->getParam('frm');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        if ($frm == 'tax') {
            $mPDF1->WriteHTML($this->renderPartial('application.modules.logistics.views.pdf.creditnote_individual_tax', array('id' => $id, 'file_id' => $file_id, 'customer_id' => $customer_id), true));
        } else {
            $mPDF1->WriteHTML($this->renderPartial('application.modules.logistics.views.pdf.creditnote_individual', array('id' => $id, 'file_id' => $file_id, 'customer_id' => $customer_id), true));
        }
        $mPDF1->Output($htmlTemplate, 'I');
    }

    public function actionAddQuantityDetails() {

        $product_name = filter_var($_POST['product_name'], FILTER_SANITIZE_STRING);
        $product_id = filter_var($_POST['product_id'], FILTER_VALIDATE_INT);
        $quantity = filter_var($_POST['quantity'], FILTER_VALIDATE_INT);
        $totalquantity = filter_var($_POST['totalquantity'], FILTER_VALIDATE_INT);
        $order_id = filter_var($_POST['order_id'], FILTER_VALIDATE_INT);
        $newId = filter_var($_POST['newId'], FILTER_VALIDATE_INT);
        $item_row_id = filter_var($_POST['item_row_id'], FILTER_VALIDATE_INT);
        $model_material_stock = new MaterialReceiptStockDetails();
        $model_product = Inventory::model()->findbyPK($product_id);
        $batch_mandty = 0;
        $serial_mandty = 0;
        $color_mandatory = "";
        $color_mandatory_1 = "";
        if ($model_product->have_expiry_date == "Y") {
            $batch_mandty = 1;
            $color_mandatory = "bg-danger";
        }
        if ($model_product->have_serial_no == "Y") {
            $serial_mandty = 1;
            $color_mandatory_1 = "bg-danger";
        }

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        if ($model_product->have_serial_no == "Y") {
            $this->render('material_receipt_stock_serial', array('model_material_stock' => $model_material_stock, 'product_name' => $product_name, 'product_id' => $product_id, 'quantity' => $quantity, 'newId' => $newId, 'batch_mandty' => $batch_mandty, 'serial_mandty' => $serial_mandty, 'color_mandatory' => $color_mandatory, 'color_mandatory_1' => $color_mandatory_1, 'order_id' => $order_id, 'totalquantity' => $totalquantity, 'item_row_id' => $item_row_id));
        } else {
            $this->render('material_receipt_stock', array('model_material_stock' => $model_material_stock, 'product_name' => $product_name, 'product_id' => $product_id, 'quantity' => $quantity, 'newId' => $newId, 'batch_mandty' => $batch_mandty, 'serial_mandty' => $serial_mandty, 'color_mandatory' => $color_mandatory, 'color_mandatory_1' => $color_mandatory_1, 'order_id' => $order_id, 'totalquantity' => $totalquantity, 'item_row_id' => $item_row_id));
        }
    }

    public function actionGetFactor() {
        $factor = 1;
        if ((int) $_POST['value'] > 0) {
            $factor = UnitOfMeasurement::getFactor($_POST['value']);
        }
        echo $factor;
    }

    public function actionGetCheckingList() {
        $model = new Creditnote();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.file_id',
            1 => 't.invoice_id',
            2 => 't.id',
            3 => 't.customer_id',
            4 => 't.credited_date',
            5 => 't.currency',
            6 => 't.id',
            7 => 't.total_tax_amount',
            8 => 't.id',
            9 => 't.id'
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;

        $condition = 't.isActive="Y"';
        if (!isset(Yii::app()->user->havePermissionOn["credit_view_all"]) && Yii::app()->user->authorised_user != 1) {
            $condition .= ' AND (t.crm_user_id= "' . Yii::app()->user->id . '" OR file.lead_owner_id="' . Yii::app()->user->id . '")';
        }


        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " AND (customer.customer_name LIKE '%" . $searchString . "%' OR t.file_id LIKE '%" . $searchString . "%' OR  t.id LIKE '%" . $searchString . "%' OR  credit_note_no LIKE '%" . $searchString . "%' OR t.invoice_id LIKE '%" . $searchString . "%'  OR invoice.invoice_no LIKE '%" . $searchString . "%' OR t.reference LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('customer', 'file', 'invoice')->count(array('condition' => $condition));
        $model = $model->with('customer', 'file', 'invoice')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();

        foreach ($model as $row) {
            $status = '';
            $div = '';
            $modelInvoice_type = $row['invoice']['invoice_type'];
            $modelInvoice_no = $row['invoice']['invoice_no'];
            if ((int) $modelInvoice_type > 0) {
                $modelInvoiceType = new MasInvoiceType();
                $arr_invoice_type_details = $modelInvoiceType->findByPk((int) $modelInvoice_type);
                $inv_code = $arr_invoice_type_details->inv_code;
                $modelInvoice_no = $inv_code . '-' . $modelInvoice_no;
            }

            $net_returned_amount = (($row['credited_amount'] + $row['total_tax_amount']) * $row['exchange_rate']);


            $rowData[] = array($row['id'], $row['file_id'], $modelInvoice_no, $row->customer->customer_name, $row['currencyname']['currency_code'], Yii::app()->numberFormatter->formatCurrency($row['total_tax_amount'], ""), Yii::app()->numberFormatter->formatCurrency($row['credited_amount'], ""));
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionReturnItems() {
        $id = (int) Yii::app()->request->getParam('id');
        $model = new Creditnote();

        if ($id > 0) {
            $model = $model->findByPk($id);

            $k = 0;
            $modelItems = CreditnoteItem::model()->findAll(array('condition' => 'creditnote_id=' . $id . ' AND quantity>0'));
            if (!empty($modelItems)) {
                foreach ($modelItems as $eachItem) {
                    $modelItems[$k] = new ProductLocationDetails;
                    $modelItems[$k]->product_id = $eachItem->product_id;
                    $modelItems[$k]->quantity = $eachItem->quantity;
                    $modelItems[$k]->header_id = $eachItem->creditnote_id;
                    $modelItems[$k]->header_item_id = $eachItem->id;
                    $modelItems[$k]->transaction_type = "CREDIT_NOTE";
                    $k++;
                }
            }
        }

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('return_item_form', array('model' => $model, 'items' => $modelItems, 'id' => $id));
    }

    public function actionPostCreditNote() {
        $modelCreditNote = new Creditnote();
        $receivedQuantity = array();
        $valid = true;

        if (is_array($_POST['ProductLocationDetails'])) {
            foreach ($_POST['ProductLocationDetails'] as $i => $item) {

                if ($item['product_id'] > 0 AND $item['quantity'] > 0) {
                    $modelProLocDetails[$i] = new ProductLocationDetails;
                    $modelProLocDetails[$i]->attributes = $_POST['ProductLocationDetails'][$i];
                    $modelProLocDetails[$i]->header_id = $item['header_id'];
                    $modelProLocDetails[$i]->header_item_id = $item['header_item_id'];
                    $modelProLocDetails[$i]->product_id = $item['product_id'];
                    $modelProLocDetails[$i]->bill_of_entry = $item['bill_of_entry'];
                    $modelProLocDetails[$i]->warehouse_id = $item['warehouse_id'];
                    $modelProLocDetails[$i]->rack_id = $item['rack_id'];
                    $modelProLocDetails[$i]->bin_id = $item['bin_id'];
                    $modelProLocDetails[$i]->batch_no = $item['batch_no'];
                    $modelProLocDetails[$i]->serial_no = $item['serial_no'];
                    $modelProLocDetails[$i]->quantity = $item['quantity'];
                    $modelProLocDetails[$i]->transaction_type = $item['transaction_type'];
                    $modelProLocDetails[$i]->created_by = Yii::app()->user->id;
                    $modelProLocDetails[$i]->created_date = date('Y-m-d h:i:s');

                    if ($item['manufacturing_date'] != '00/00/0000' AND $item['manufacturing_date'] != '01/01/1970' AND $item['manufacturing_date'] != '') {
                        $mf_date = str_replace('/', '-', $item['manufacturing_date']);
                        $modelProLocDetails[$i]->manufacturing_date = date("Y-m-d", strtotime($mf_date));
                    } else {
                        $modelProLocDetails[$i]->manufacturing_date = "0000-00-00";
                    }
                    if ($item['expiry_date'] != '00/00/0000' AND $item['expiry_date'] != '01/01/1970' AND $item['expiry_date'] != '') {
                        $expiry_date = str_replace('/', '-', $item['expiry_date']);
                        $modelProLocDetails[$i]->expiry_date = date("Y-m-d", strtotime($expiry_date));
                    } else {
                        $modelProLocDetails[$i]->expiry_date = "0000-00-00";
                    }
                    $valid = $modelProLocDetails[$i]->validate() && $valid;
                }
            }



            if ($valid) {

                $credit_note_id = $_POST['credit_note_id'];
                if ($credit_note_id > 0) {
                    $modelCreditNote = $modelCreditNote->findByPk($credit_note_id);
                    $modelCreditNote->save(false);
                }
                if (!empty($modelProLocDetails)) {
                    foreach ($modelProLocDetails as $eachItem) {
                        if (empty($eachItem->batch_no)) {
                            $eachItem->batch_no = $modelCreditNote->id;
                        }
                        $eachItem->isActive = "Y";
                        $eachItem->save(false);

                        $stockLedger = new StockLedger;
                        $stockLedger->header_id = $eachItem['header_id'];
                        $stockLedger->header_item_id = $eachItem['header_item_id'];
                        $stockLedger->transaction_date = date('Y-m-d');
                        $stockLedger->transaction_type = $eachItem['transaction_type'];
                        $stockLedger->product_id = $eachItem['product_id'];
                        $stockLedger->quantity = $eachItem['quantity'];
                        $stockLedger->product_location_id = $eachItem->id;

                        $modelInventory = Inventory::model()->findBypk($eachItem['product_id']);
                        $stockLedger->unit_id = $modelInventory['unit_id'];
                        $stockLedger->warehouse_id = $eachItem['warehouse_id'];
                        $stockLedger->rack_id = $eachItem['rack_id'];
                        $stockLedger->bin_id = $eachItem['bin_id'];
                        $stockLedger->created_by = Yii::app()->user->id;
                        $stockLedger->created_date = date('Y-m-d h:i:s');
                        $stockLedger->cost_price = $modelInventory->rate;
                        $stockLedger->save(false);
                    }
                }
                echo CJSON::encode(array('status' => 'success'));
            } else {

                $error2 = array();
                $error4 = array();
                $error1 = array();
                if (!empty($modelProLocDetails))
                    $error2 = json_decode(CActiveForm::validateTabular($modelProLocDetails, '', false), true);
                $error = CJSON::encode(array_merge_recursive($error1, $error2));
                if ($error != '[]' || $error != '')
                    echo $error;
            }
        }
    }
    public function actionGetinvoiceDetails() {
         $customer_id = $_POST['customer_id'];
        $model = Invoice::model()->findAll(array('condition' =>'customer_id="'.$customer_id.'" AND invoice_status="Y"'));       
        $i = 0;
        $data=array();
        foreach ($model as $eachModel) {
            $data[$i]['id'] = $eachModel->id;
            $data[$i]['file_id'] = $eachModel->file_id . ' : ' . $eachModel->id; 
            $i++;
        }
        $modelInvoice_details=CHtml::listData($data, 'id', 'file_id');
        $drop_down=CHtml::dropDownList('tax_invoice_id', '',$modelInvoice_details,  array('class' => 'tooltipster', 'title' => 'Invoice No','data-label'=>'Invoice No <span style="color:red">*</span>','data-search'=>true,'empty'=>'Select','onchange' => 'gethiringreturndetails(this.value);'));   
        echo CJSON::encode( array('details'=>$drop_down));
    }

    public function actionGetsalesreturnDetails() {
        $modelInvoice_id = $_POST['invoice_id'];
        $model = Invoice::model()->findByPk($modelInvoice_id);
        //Default Currency
        $default_currency='N';
        if($model->currency0->id==Yii::app()->user->company_base_currency){
            $default_currency='Y';
        }
        echo CJSON::encode( array(
            'currency'=>$model->currency0->currency_code,
            'currency_id'=>$model->currency0->id,
            'exchangerate'=>$model->currency0->exchange_rate,
            'customer_id'=>$model->customer_id,
            'customer_name'=>$model->customer->customer_name,
            'default_currency'=>$default_currency,
            'invoice_date'=>date('d/m/Y',strtotime($model->invoice_date)),
        ));
    }
    
    public function actionCancelCreditNote(){
         $id = (int) Yii::app()->request->getParam('id');
         if($id > 0){
            Creditnote::model()->updateByPk($id, array('isActive' => 'N','total_tax_amount'=>'0.00','credited_amount'=>'0.00')); 
            CreditnoteItem::model()->updateAll(array('rate' => '0.00','returned_rate' => '0.00', 'net_amount' => '0.00', 'tax_vat_amount' => '0.00','tax_vat_percentage'=>'0.00'), 'creditnote_id ='.$id);
            echo 'success';
         }
         else{
             echo 'fail';
         }
    }

}
