<!DOCTYPE html>
<html>
<head>
    <title><?php echo date('dmYhis'); ?></title>
</head>
<body>
    <div class="">
        <div class="col-6">
                <div class="input-block">
                    <b><?php echo 'Subledger Report'; ?></b>
                </div>
                <br>
                <table class="table" style="width:100%">
                <tr>
                    <td class="bc-tl">From </td>
                    <td>
                        <?php echo date('d/m/Y', strtotime($from_date)); ?>
                    </td>
                </tr>
                <tr>
                    <td>To</td>
                    <td>
                        <?php echo date('d/m/Y', strtotime($to_date)); ?>
                    </td>
                </tr>
                <tr>
                    <td>Subledger</td>
                    <td>
                        <?php echo FinanceSubledger::model()->findBypk( (int) $subledger )->description;?>
                    </td>
                </tr>
            </table>
        </div>
        <div class="col-5 offset-1" style="color:#101010;">
            <div class="text-right">
                <img src="<?php echo 'images/logo/'.Yii::app()->user->pdf_company_logo; ?>" class="logo">
            </div>
        </div>
    </div>
    <div class="col-md-12">
    <?php 
        $query = 'SELECT ledger_id
                  FROM crm_finance_voucher_items
                  WHERE subledger_id='.(int) $subledger.' GROUP BY ledger_id';
        $legders = ( $subledger > 0 ) ? Yii::app()->db->createCommand($query)->queryAll() : array();
        
        if( !empty( $legders ) ) {
                foreach( $legders as $each ) :
                    $ledgerModel = FinanceLegder::model()->findBypk($each['ledger_id']);
        ?>
                 <br>
                <table class="table table-fixed table-bordered table-primary">
                    <thead>
                        <tr><td colspan="6" class="text-center"><b><?php echo $ledgerModel->description;  ?></b></td></tr>
                        <tr>
                            <th>Date</th>
                            <th>Voucher No</th>
                            <th>Narration</th> 
                            <th class="text-right">Dr</th> 
                            <th class="text-right">Cr</th> 
                            <th class="text-right">Balance</th>  
                        </tr>
                    </thead>
                    <?php 
                        $condition = 'parent.is_posted = "Y" AND parent.voucher_date BETWEEN "'.$from_date.'" AND "'.$to_date.'"';
                        $condition_for_opening = 'H.is_posted = "Y" AND H.voucher_date < "'.$from_date.'"';
                        
                        $condition .= ' AND t.ledger_id='.$ledgerModel->id;
                        $condition_for_opening .= ' AND I.ledger_id='.$ledgerModel->id;
                        
                        $condition .= ' AND t.subledger_id='.$subledger;
                        $condition_for_opening .= ' AND I.subledger_id='.$subledger;
                        
                        $openingBalance = Yii::app()->db->createCommand('SELECT SUM(I.amount*H.exchange_rate) AS amount FROM crm_finance_voucher_items I LEFT JOIN crm_finance_voucher_head H ON I.header_id = H.id WHERE '.$condition_for_opening.' ')->queryScalar();
                        $items = FinanceVoucherItems::model()->with('parent')->findAll( array( 'condition' => $condition, 'order' => 'parent.voucher_date ASC' ) );
                
                        $previousBalance = $openingBalance;
                        $closingBalance = $openingBalance;
                        $symbol = ( $previousBalance > 0 ) ? 'Dr' : 'Cr';
                    ?>
                    <tbody>    
                        <tr>
                            <td colspan="5" class="text-right"><b>Opening Balance</b></td>
                            <td class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency(abs($previousBalance)," ").' '.$symbol;?></td>
                        </tr>
                    <?php 
                    
                        $total_debit = 0;
                        $total_credit = 0;
                        foreach ( $items as $each ){
                            
                            $debit = ( $each->amount > 0 ) ? $each->amount*$each->parent->exchange_rate : '';
                            $credit = ( $each->amount < 0 ) ? abs($each->amount*$each->parent->exchange_rate) : '';
                            $running = $debit - $credit + $previousBalance;
                            $previousBalance = $running;
                            $symbol = ( $running > 0 ) ? 'Dr' : 'Cr';
                            $closingBalance +=  ( $debit - $credit );

                            $total_debit += $debit;
                            $total_credit += $credit;
                            
                    ?>
                        <tr>      
                            <td><?php echo date("d/m/Y",strtotime($each->parent->voucher_date)); ?></td>
                            <td><?php echo $each->parent->fullvoucher; ?></td>
                            <td><?php echo $each->narration; ?></td>
                            <td class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency($debit," "); ?></td>
                            <td class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency(abs($credit)," "); ?></td>
                            <td class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency(abs($running)," ")." ".$symbol; ?></td>
                        </tr>
                    <?php } 
                            $symbol = ( $closingBalance > 0 ) ? 'Dr' : 'Cr';
                    ?>
                        <tr>
                            <td colspan="3" class="text-right"><b>Total</b></td>
                            <td class="text-right"><b><?php echo Yii::app()->numberFormatter->formatCurrency(abs($total_debit)," "); ?></b></td>
                            <td class="text-right"><b><?php echo Yii::app()->numberFormatter->formatCurrency(abs($total_credit)," "); ?></b></td>
                            <td class="text-right"></td>
                        </tr>
                        <tr>
                            <td colspan="5" class="text-right"><b>Closing Balance</b></td>
                            <td class="text-right"><b><?php echo Yii::app()->numberFormatter->formatCurrency(abs($closingBalance)," ").' '.$symbol;?></b></td>
                        </tr>
                    </tbody>
                </table>
            <?php endforeach; ?>
        <?php }else{ 
            
                echo '<table id="tbl_reorder_level_table" class="table table-fixed table-bordered table-primary">
                        <thead>
                            <tr>
                                <th>Date</th>
                                <th>Voucher No</th>
                                <th>Narration</th> 
                                <th class="text-right">Dr</th> 
                                <th class="text-right">Cr</th> 
                                <th class="text-right">Balance</th>  
                            </tr>
                        </thead>
                        <tbody>
                            <tr><td colspan="6" class="text-center">No Data</td></tr>
                        </tbody>
                    </table>';
        }
            ?>
    </div>
    
    <htmlpagefooter name="myfooter">
    <div style="text-align:center;width:100%;font-size:10px"><?= Yii::app()->user->footer_autogenerated; ?>
        <?php
                  date_default_timezone_set("Asia/Dubai");
                 echo date('d/m/Y')." ".date("h:i:sa"); ?>
    </div>

    
        <div style="border-top: 1px dotted #000000; font-size: 12px; text-align: center; padding-top: 10px; background-color: #d7faeb;">
             <div style="text-align:center;width:100%">
                <b><?= Yii::app()->user->footer_line_1 ?></b><br>
                <?= Yii::app()->user->footer_line_2 ?>
            </div>
            <div style="text-align:center;width:100%">Page {PAGENO} of {nb} </div>
        </div>
    </htmlpagefooter>
</body>

</html>

