<script src="js/jquery.aCollapTable.js"></script>

<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("loadPage", "function loadPage(){
            
                $('#loader').show();
                jQuery.ajax({
                    'type': 'post',
                    'url': '" . Yii::app()->createUrl('finance/reports/cus_pl_html') . "',
                    'data' : { 'ledger_id' : $('#ledger_id').val(), 'subledger_id' : $('#subledger_id').val(), 'from' : $('#fn_report_from').val(), 'to' : $('#fn_report_to').val() },
                    'success': function(data) {
                        $('#data_div').show();
                        $('.main-li-data').html(data);
                        $('#loader').hide();
                    }
                });
        }", CClientScript::POS_HEAD);

        $cs->registerScript("getSublegders", "function getSublegders(field_id)
        {
           account_id = $('#ledger_id').val();
           $('#subledger_id').val(0);
           if( account_id > 0 ){
                var url = '" . Yii::app()->createUrl('finance/vouchers/subledgerlist') . "&ledger='+account_id;
                $('#'+field_id).autocomplete({
                    minLength   : 1,
                    source      : function (request, response) { autoCompleteSource(request, response, url) },
                    focus       : function( event, ui ) {},
                    select          : function( event, ui ) {
                        event.preventDefault();
                        $('#subledger_name').val(ui.item.label);
                        $('#subledger_id').val(ui.item.value);
                    }
                })
            }else{
                t8.error('Choose customer! Ledger First!');
                $('#subledger_name').val('');
                return false;
            }
        }", CClientScript::POS_HEAD); 
        $cs->registerScript("load_details", "function load_details(from_date, to_date, subledger_id){
            $('#loader').show();
            jQuery.ajax({
                'type': 'post',
                'url': '" . Yii::app()->createUrl('finance/reports/pl_cus_detailed') . "',
                'data' : { 'subledger_id' : subledger_id, 'to' : to_date, 'from' : from_date },
                'success': function(data) {
                    $('#gl_report_li').hide();
                    $('#gl_report_tab').empty();
                    $('#pl_cus_li').removeClass('active');
                    $('#pl_cus_tab').removeClass('active');
                    $('#pl_cus_detailed_li').show();
                    $('#pl_cus_detailed_li').addClass('active');
                    $('#pl_cus_detailed_tab').addClass('active');
                    $('#pl_cus_detailed_tab').html(data);
                    $('#loader').hide();
                }
            });
        }", CClientScript::POS_HEAD);

?>

<style>
table {
  font-family: arial, sans-serif !important;
  border-collapse: collapse !important;
  width: 100% !important;
}

td, th {
  border: 1px solid #dddddd !important;
  text-align: left !important;
  padding: 8px !important;
}

table th{
	padding-top: 12px;
    padding-bottom: 12px;
    text-align: left;
    background-color: #1f67b2;
    color: white;
}

tr:nth-child(even) {
  background-color: #f2f2f2 !important;
}
</style>
<div class="row">
    <div class="col-sm-12">
        <section class="panel">
            <header class="panel-heading clearfix">
                <ul class="clearfix form-ul material">
                    <li class="col-sm-2">
                        <?php echo CHtml::textField('fn_report_from', date('01/m/Y'), array('class' => 'datepicker tooltipster', 'data-label' => 'From')); ?>
                    </li>
                    <li class="col-sm-2">
                        <?php echo CHtml::textField('fn_report_to', date('t/m/Y'), array('class' => 'datepicker tooltipster', 'data-label' => 'To')); ?>
                    </li>
                    <li class="col-sm-3">
                        <?php echo CHtml::hiddenField("ledger_id", (int) FinanceLegder::model()->find( array( 'condition' => 'classification="RECEIVABLE"' ) )->id); ?>
                        <?php echo CHtml::hiddenField("subledger_id"); ?>
                        <?php echo CHtml::textField("subledger_name", '', array('data-label' => 'Customer', 'class' => 'tooltipster', 'onKeyup' => 'js:getSublegders(this.id);')); ?>
                    </li>
                    <div class="btn-wrap text-center">
                        <a type="button" class="btn btn-sm btn-theme" onclick="loadPage();">HTML</a>
                        <a type="button" class="btn btn-sm btn-theme" onclick="window.open($('#liveSite').val()+'index.php?r=finance/reports/cus_pl_pdf&from_date='+$('#fn_report_from').val()+'&to_date='+$('#fn_report_to').val()+'&ledger='+$('#ledger_id').val()+'&subledger='+$('#subledger_id').val(), '_blank'); ">PDF</a>
                        <a type="button" class="btn btn-sm btn-theme" onclick="window.open($('#liveSite').val()+'index.php?r=finance/reports/cus_pl_excel&from_date='+$('#fn_report_from').val()+'&to_date='+$('#fn_report_to').val()+'&ledger='+$('#ledger_id').val()+'&subledger='+$('#subledger_id').val(), '_blank');">XLS</a>
                    </div>
                </ul>
            </header>
            <div class="panel-body" id="data_div" style="display:none;" >
                <ul class="nav nav-tabs company-nav-tabs nav-tab-theme">
                    <li id="pl_cus_li" class="main-li active"><a href="#pl_cus_tab" data-toggle="tab">Customer Summary</a></li>
                    <li id="pl_cus_detailed_li" style="display:none;"><a href="#pl_cus_detailed_tab" data-toggle="tab" >Details <i onclick="$('#pl_cus_li').addClass('active');$('#pl_cus_tab').addClass('active');$('#pl_cus_detailed_li').hide();$('#pl_cus_detailed_tab').empty();" class="fa fa-remove"></i></a></li>
                </ul>
                <div class="tab-content">
                    <div class="tab-pane main-li-data active" id="pl_cus_tab">
                    </div>
                    <div class="tab-pane" id="pl_cus_detailed_tab">
                    </div>
            </div>
        </section>
    </div>
</div>
