
<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("loadledger", 
                '$(document).ready(function() {
                    var table_id ="#fin_ledgers";
                    var table = $(table_id).on("preXhr.dt", function (e, settings, data) {
                        data.parent_account = $("#parent_account").val();
                        return data;
                    }).DataTable({
                    scrollY         : "750px",
                    pageLength      : 100,
                    ajax: {
                        url: "' . Yii::app()->createUrl('finance/core/getledgers') . '",
                        type: "POST",
                        cache : false,
                    },
                    serverSide:     true,
                    fixedColumns:   true,
                    processing: true,
                });
                $(".dataTables_scrollFoot").hide();
            });', CClientScript::POS_HEAD);
            $cs->registerScript("deleteAccount",  "function deleteAccount(id){
                var r = confirm('Are you sure to delete this?');
                    if(r==true)
                    {
                        jQuery.ajax({
                          'type'  : 'post',
                          'data'  : 'id=' + id,
                          'url'  : $('#liveSite').val()+'index.php?r=finance/core/deleteledger',
                          'cache': false,
                          'success':function(data){
                            if(data=='fail'){
                                alert('Error while Delete', 'Alert');
                            }else {
                                reloadTable('#fin_ledgers');
                                t8.success('Deleted!');
                            }
                           }
                        });
                    }
            };", CClientScript::POS_HEAD);

  ?>
    <section class="panel" style="background-color:#F6F3EE;">
        <header class="panel-heading clearfix panel-theame">
            <i class="fa fa-file"></i> Ledgers
            <div class="pull-right" style="display:flex;">
            <?php  echo CHtml::dropdownList('parent_account','',FinanceLegder::getParents(),array('class'=>'form-control', 'onChange' => 'reloadTable("#fin_ledgers")', 'prompt' => '-select-'));  ?> 
                <?php if( Yii::app()->user->authorised_user == 1 ) : ?>
                    <button class="btn btn-sm btn-theme" title="System accounts mapping" onclick="loadPopupModal('finance/core/systemmapping','Mappings','lg')"><i class="fa fa-cogs"></i></button>
                    <button class="btn btn-sm btn-theme" title="Footer mapping" onclick="loadPopupModal('finance/core/footermapping','Footer Mappings','lg')"><i class="fa fa-truck"></i></button>
                <?php endif; ?>   
                <button class="btn btn-sm btn-theme" onclick="loadPopupModal('finance/core/createledger','New Ledger','lg')"><i class="fa fa-plus"></i></button>
            </div>
        </header>
        <div class="panel-body">
            <div class="custom-data-table">
                <table class="table table-hover table-bordered personal-task" id="fin_ledgers" style="font-size:13px;">
                    <thead>
                        <tr>
                            <th>Account</th>
                            <th>Description</th>
                            <th>Parent</th>
                            <th>Group</th>
                            <th>Subledger</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tfoot>
                        <tr>
                            <th>Account</th>
                            <th>Description</th>
                            <th>Parent</th>
                            <th>Group</th>
                            <th>Subledger</th>
                            <th>Actions</th>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </section>
