<?php

/**
 * This is the model class for table "{{finance_subledger_type}}".
 *
 * The followings are the available columns in table '{{finance_subledger_type}}':
 * @property integer $id
 * @property string $description
 * @property string $staring_series
 * @property string $last_account_no
 * @property string $system_generated
 * @property string $table_model
 * @property string $value_field
 * @property string $update_field
 */
class FinanceSubledgerType extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
                     public $emirates_id;
                     public $industry;
	public function tableName()
	{
		return '{{finance_subledger_type}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('description, last_account_no', 'required'),
			array('description, table_model, value_field, update_field', 'length', 'max'=>255),
			array('staring_series, last_account_no', 'length', 'max'=>20),
			array('system_generated', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, description, staring_series, last_account_no, system_generated, table_model, value_field, update_field', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'description' => 'Description',
			'staring_series' => 'Staring Series',
			'last_account_no' => 'Last Account No',
			'system_generated' => 'System Generated',
			'table_model' => 'Table Model',
			'value_field' => 'Value Field',
			'update_field' => 'Update Field',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('description',$this->description,true);
		$criteria->compare('staring_series',$this->staring_series,true);
		$criteria->compare('last_account_no',$this->last_account_no,true);
		$criteria->compare('system_generated',$this->system_generated,true);
		$criteria->compare('table_model',$this->table_model,true);
		$criteria->compare('value_field',$this->value_field,true);
		$criteria->compare('update_field',$this->update_field,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return FinanceSubledgerType the static model class
	 */
	
	 public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	public static function getSublegdertypes( $boolean ){
		$condition = ( $boolean ) ? '1=1' : 'system_generated="Y"';
		return CHtml::listData(self::model()->findAll( array( 'condition' => $condition, 'order' => 'description' ) ), 'id', 'description');
	}
	
    public static function getAlltypes()
	{
            $model = self::model()->findAll();
            return CHtml::listData($model, 'id', 'description');
	}
	
    public static function getSystemGeneratedNoSubLedgerType()
	{
            $model = self::model()->findAll(array('condition' => 'system_generated="N"', 'order' => 'description'));
            return CHtml::listData($model, 'id', 'description');
	}

	public static function nextAccount($subledger_type, $savetype){
		$nextAccount = 0;
		if( (int) $subledger_type > 0 ){
			$model = self::model()->findBypk( $subledger_type );
			$nextAccount = ( $model->last_account_no > 0 ) ? $model->last_account_no+1 : $model->staring_series;
			if( $savetype ){
				$model->last_account_no = $nextAccount;
				$model->save(false);
			}
		}
		return $nextAccount;
	}
}
