<?php

/**
 * This is the model class for table "{{finance_footer_mapping}}".
 *
 * The followings are the available columns in table '{{finance_footer_mapping}}':
 * @property integer $id
 * @property integer $footer_id
 * @property integer $account_id
 */
class FinanceFooterMapping extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{finance_footer_mapping}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('footer_id, account_id', 'required'),
			array('footer_id, account_id, subledger_id', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, footer_id, account_id, subledger_id', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'footer' => array(self::BELONGS_TO, 'MasFooterItems', 'footer_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'footer_id' => 'Footer',
			'account_id' => 'Account',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('footer_id',$this->footer_id);
		$criteria->compare('account_id',$this->account_id);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return FinanceFooterMapping the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	public function getFooteraccount( $footer_id ){
		$model = self::model()->find( array( 'condition' => 'footer_id='.(int) $footer_id ));
		return ( $model->id > 0 ) ? array( 'name' => $model->footer->item_name, 'account' => $model->account_id, 'subledger' => $model->subledger_id ) : array( 'name' => 'Unbalanced', 'account' => FinanceSystemAccountsMapping::getSystemdefault('unbalanced_amount_ac') ); 
	}
}
