<?php

class HrController extends Controller
{

    public function accessRules()
    {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Generatesalaryvoucher', 'Deletesalaryvoucher', 'Getsubledgerdrop', 'Generatewps', 'Deletewps','PostSalary','DeleteSalary'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function addVoucherhead($arr_items)
    {
        $model = new FinanceVoucherHead;
        $model->voucher_type = $arr_items['voucher_type'];
        $model->voucher_no = $arr_items['voucher_no'];
        $model->voucher_date = $arr_items['voucher_date'];
        $model->due_date = (isset($arr_items['due_date'])) ? $arr_items['due_date'] : $model->voucher_date;
        $model->total_voucher_amount =  $arr_items['total_voucher_amount'];
        // $model->currency = (isset($arr_items['currency'])) ? $arr_items['currency'] : 'AED';
        // $model->exchange_rate = (isset($arr_items['exchange_rate']) && $arr_items['exchange_rate'] > 0) ? $arr_items['exchange_rate'] : 1;
        $model->header_table_id = $arr_items['header_table_id'];
        $model->reference_no = $arr_items['reference_no'];
        $model->is_posted = (isset($arr_items['is_posted'])) ? $arr_items['is_posted'] : 'Y';
        $model->created_by = Yii::app()->user->id;
        $model->created_datetime = date('Y-m-d h:i:s');
        $model->cheque_cleared=(isset($arr_items['cheque_cleared'])) ? $arr_items['cheque_cleared'] : 'Y';
        $model->cheque_date=(isset($arr_items['cheque_cleared'])) ? $arr_items['cheque_date'] : '0000-00-00';
        $model->cheque_no=$arr_items['cheque_no'];
        return ($model->save(false)) ? $model->id : 0; //exception
    }

    public function addVoucheritems($headerId, $arr_items)
    {
        $model = new FinanceVoucherItems;
        $model->header_id = $headerId;
        $model->ledger_id = $arr_items['ledger_id'];
        $model->brand_id = (int) $arr_items['brand_id'];
        $model->employee_id = (int) $arr_items['employee_id'];
        $model->subledger_id = $arr_items['subledger_id'];
        $model->brand_id=$arr_items['brand_id'];
        $model->narration = $arr_items['narration'];
        $model->amount = $arr_items['amount'];
        $model->currency_code = (isset($arr_items['currency'])) ? $arr_items['currency'] : 'AED';
        $model->currency_id = (isset($arr_items['currency_id'])) ? $arr_items['currency_id'] : 1;
        $model->exchange_rate = (isset($arr_items['exchange_rate']) && $arr_items['exchange_rate'] > 0) ? $arr_items['exchange_rate'] : 1;
        $model->opening_cheque_cleared=(isset($arr_items['opening_cheque_cleared'])) ? $arr_items['opening_cheque_cleared'] : 'Y';
        
        $model->save(false);
    }

    public function actionGeneratesalaryvoucher()
    {
        $id = $_POST['id'];
        $response = array('status' => 'failed', 'msg' => 'Unknown data');
        $voucherHead = array();

        function savableDate($date)
        {
            $last_closed_year = FinanceAuditClose::lastClosed();
            $voucherDate_array = explode('-', $date);
            $voucherYear = $voucherDate_array[0];
            return ($voucherYear <= $last_closed_year) ? false : true;
        }

        // function generateLeave($header_id, $data){
        //     $total = 0;
        //     foreach( $data as $each ) :
        //         $itemsArray = array();
        //         $itemsArray['ledger_id'] = $each['ledger_id'];
        //         $itemsArray['subledger_id'] = $each['subledger_id'];
        //         $itemsArray['narration'] = $each['narration'];
        //         $itemsArray['amount'] = $each['amount'];
        //         $this->addVoucheritems($header_id, $itemsArray);
        //     endforeach;
        // }

        if ($id > 0):
            $mainModel = SalaryProcessing::model()->findBypk($id);
            if ((int) $mainModel->voucher_id == 0) {
                if (savableDate($mainModel->payroll_enddate)) {
                    if (!empty($mainModel->items)) {

                        $voucherHead['voucher_type'] = 12;
                        $voucherHead['voucher_no'] = FinanceVoucherType::getVoucherno(12, true);
                        $voucherHead['voucher_date'] = $mainModel->payroll_enddate;
                        $voucherHead['header_table_id'] = $mainModel->id;
                        $voucherHead['reference_no'] = 'System generated voucher';
                        $voucherHead['is_posted'] = 'Y';
                        $voucherHead['created_by'] = Yii::app()->user->id;
                        $voucherHead['created_datetime'] = date('Y-m-d h:i:s');

                        $lastSavedid = $this->addVoucherhead($voucherHead);
                        $totalValue = 0;
                        $totalLeaveSettlement = 0;
                        $leaveVoucher = array();
                        $totalLeavesalary = 0;

                        foreach ($mainModel->items as $i => $each) {
                            $itemsArray = array();
                            $itemsArray['ledger_id'] = FinanceSystemAccountsMapping::getSystemdefault('employee_salary');
                            $itemsArray['subledger_id'] = $each->generateSubledger();
                            $itemsArray['narration'] = 'Salary for month ' . $mainModel->payroll_month . ' ' . date('Y');
                            $itemsArray['amount'] = -1 * ($each->employee_salary_amount+$each->overtime_amount+$each->other_addition-$each->other_deduction- $each->leave_amount - $each->salary_advance_amount-$each->before_joining_salary-$each->work_loss_deduction+$each->annual_leave_addition-$each->annual_leave_deduction);
                            $itemsArray['employee_id'] = $each->generateSubledger();
                            if ($itemsArray['amount'] < 0):
                                $this->addVoucheritems($lastSavedid, $itemsArray);
                                $totalValue += abs($itemsArray['amount']);

                                //Loan Deduction
                                if ($each->loan_amount > 0):
                                    $itemsArray = array();
                                    $itemsArray['ledger_id'] = FinanceSystemAccountsMapping::getSystemdefault('employee_salary');
                                    $itemsArray['subledger_id'] = $each->generateSubledger();
                                    $itemsArray['narration'] = 'Loan deduction for month ' . $mainModel->payroll_month . ' ' . date('Y');
                                    $itemsArray['amount'] = $each->loan_amount;
                                    $itemsArray['employee_id'] = $each->generateSubledger();
                                    $this->addVoucheritems($lastSavedid, $itemsArray);

                                    $itemsArray = array();
                                    $itemsArray['ledger_id'] = FinanceSystemAccountsMapping::getSystemdefault('employee_loan');
                                    $itemsArray['subledger_id'] = $each->generateSubledger();
                                    $itemsArray['narration'] = 'Loan collected for month ' . $mainModel->payroll_month . ' ' . date('Y');
                                    $itemsArray['amount'] = -1 * $each->loan_amount;
                                    $itemsArray['employee_id'] = $each->generateSubledger();
                                    $this->addVoucheritems($lastSavedid, $itemsArray);
                                endif;

                                //Pension Payable
                                if ($each->pension_amount > 0):
                                    $itemsArray = array();
                                    $itemsArray['ledger_id'] = FinanceSystemAccountsMapping::getSystemdefault('employee_salary');
                                    $itemsArray['subledger_id'] = $each->generateSubledger();
                                    $itemsArray['narration'] = 'Pension deduction for month ' . $mainModel->payroll_month . ' ' . date('Y');
                                    $itemsArray['amount'] = $each->pension_amount_employee;
                                    $itemsArray['employee_id'] = $each->generateSubledger();
                                    $this->addVoucheritems($lastSavedid, $itemsArray);

                                    $itemsArray = array();
                                    $itemsArray['ledger_id'] = FinanceSystemAccountsMapping::getSystemdefault('employee_pension');
                                    $itemsArray['subledger_id'] = $each->generateSubledger();
                                    $itemsArray['narration'] = 'Pension share for month ' . $mainModel->payroll_month . ' ' . date('Y');
                                    $itemsArray['amount'] = -1 * $each->pension_amount;
                                    $itemsArray['employee_id'] = $each->generateSubledger();
                                    $this->addVoucheritems($lastSavedid, $itemsArray);

                                    $totalValue += abs($each->pension_amount_company);
                                endif;

                                //Leave settlement
                                if ($each->leave_settlement > 0):
                                    $itemsArray = array();
                                    $itemsArray['ledger_id'] = FinanceSystemAccountsMapping::getSystemdefault('employee_salary');
                                    $itemsArray['subledger_id'] = $each->generateSubledger();
                                    $itemsArray['narration'] = 'Leave Settlement for month ' . $mainModel->payroll_month . ' ' . date('Y');
                                    $itemsArray['amount'] = -1 * $each->leave_settlement;
                                    $itemsArray['employee_id'] = $each->generateSubledger();
                                    $this->addVoucheritems($lastSavedid, $itemsArray);
                                    $totalLeaveSettlement += $each->leave_settlement;
                                endif;

                                //Leave salary Provision
                                 if( $each->annual_leave_deduction > 0 ) :
                                    $itemsArray = array();
                                    $itemsArray['ledger_id'] = FinanceSystemAccountsMapping::getSystemdefault('employee_salary');
                                    $itemsArray['subledger_id'] = $each->generateSubledger();
                                    $itemsArray['narration'] = 'Leave salary for month ' . $mainModel->payroll_month . ' ' . date('Y');
                                    $itemsArray['amount'] = $each->annual_leave_deduction;
                                    $itemsArray['employee_id'] = $each->generateSubledger();
                                    $this->addVoucheritems($lastSavedid, $itemsArray);
                                    
                                    $itemsArray = array();
                                    $itemsArray['ledger_id'] = FinanceSystemAccountsMapping::getSystemdefault('employee_leave_expense');
                                    $itemsArray['subledger_id'] = $each->generateSubledger();
                                    $itemsArray['narration'] = 'Leave salary for month ' . $mainModel->payroll_month . ' ' . date('Y');
                                    $itemsArray['amount'] = -1*$each->annual_leave_deduction;
                                    $itemsArray['employee_id'] = $each->generateSubledger();
                                    $this->addVoucheritems($lastSavedid, $itemsArray);
                                    
                                 endif;

                            endif;
                        }

                        if ($totalValue > 0):
                            //Total Salary
                            $itemsArray = array();
                            $itemsArray['ledger_id'] = FinanceSystemAccountsMapping::getSystemdefault('salary_provison');
                            $itemsArray['subledger_id'] = 0;
                            $itemsArray['narration'] = 'Salary for month ' . $mainModel->payroll_month;
                            $itemsArray['amount'] = (float) $totalValue;
                            $itemsArray['employee_id'] = $each->generateSubledger();
                            $this->addVoucheritems($lastSavedid, $itemsArray);
                        endif;

                        //Leave settlement
                        if ($totalLeaveSettlement > 0):
                            $itemsArray = array();
                            $itemsArray['ledger_id'] = FinanceSystemAccountsMapping::getSystemdefault('employee_leave_salary_prov');
                            $itemsArray['subledger_id'] = 0;
                            $itemsArray['narration'] = 'Leave Settlement for month ' . $mainModel->payroll_month;
                            $itemsArray['amount'] = $totalLeaveSettlement;
                            $itemsArray['employee_id'] = $each->generateSubledger();
                            $this->addVoucheritems($lastSavedid, $itemsArray);
                        endif;

                        //AALV Voucher
                        // if( $totalLeavesalary > 0 ) :
                        //     generateLeave($lastSavedid, $leaveVoucher);
                        // endif;

                        FinanceVoucherHead::model()->updateBypk($lastSavedid, array('total_voucher_amount' => $totalValue));

                        $mainModel->posted = 'Y';
                        $mainModel->voucher_id = $lastSavedid;
                        $mainModel->posted_date = date('Y-m-d');
                        $mainModel->update();

                        $response['status'] = 'success';
                        $response['msg'] = 'Success';

                    } else {
                        $response['msg'] = 'No data!';
                    }
                } else {
                    $response['msg'] = 'Year is closed!';
                }
            } else {
                $response['msg'] = 'Voucher is already posted!';
            }
        endif;
        echo json_encode($response);
    }

    public function actionDeletesalaryvoucher()
    {
        $id = $_POST['id'];
        $response = array('status' => 'failed', 'msg' => 'Unknown data');

        function isPostable($date)
        {
            $last_closed_year = FinanceAuditClose::lastClosed();
            $voucherDate_array = explode('-', $date);
            $voucherYear = $voucherDate_array[0];
            return ($voucherYear <= $last_closed_year) ? false : true;
        }

        if ($id > 0) {
            $mainModel = SalaryProcessing::model()->findBypk($id);
            if ($mainModel->voucher_id > 0) {
                $model = FinanceVoucherHead::model()->findBypk($mainModel->voucher_id);
                if (isPostable($model->voucher_date)) {
                    FinanceVoucherHead::model()->deleteBypk($mainModel->voucher_id);
                    FinanceVoucherItems::model()->deleteAll('header_id=:refer_id', array(':refer_id' => $mainModel->voucher_id));

                    $mainModel->posted = 'N';
                    $mainModel->voucher_id = 0;
                    $mainModel->posted_date = '0000-00-00';
                    $mainModel->update();

                    $response['status'] = 'success';
                    $response['msg'] = 'Success';
                } else {
                    $response['msg'] = 'Cannot unpost voucher, Audited!';
                }

            } else {
                $response['msg'] = 'Already unposted!';
            }

        }

        echo json_encode($response);
    }

    // public function actionGeneratewps()
    // {

    //     $sif_head = (int) $_POST['id'];
    //     $response = array('status' => 'failed', 'msg' => 'Unknown data');

    //     if ($sif_head > 0) {
    //         $model = MonthlySalarySif::model()->findBypk($sif_head);
    //         $totalAmount = 0;
    //         if ($model->posted == 'N') {
    //             foreach ($model->items as $each) {
    //                 $voucherHead = array();
    //             $voucherHead['voucher_type'] = 6; //WPS
    //             $voucherHead['voucher_no'] = FinanceVoucherType::getVoucherno(6, true);
    //             $voucherHead['voucher_date'] = $model->date;
    //             $voucherHead['header_table_id'] = $model->id;
    //             $voucherHead['reference_no'] = 'System generated voucher';
    //             $voucherHead['is_posted'] = 'Y';
    //             $voucherHead['total_voucher_amount'] = $each->total;
    //             $voucherHead['created_by'] = Yii::app()->user->id;
    //             $voucherHead['created_datetime'] = date('Y-m-d h:i:s');

    //             $lastSavedid = $this->addVoucherhead($voucherHead);
    //                 $totalAmount = $each->total;
    //                 $HrEmployeeBrandSalaryPercent=EmployeeBrandSalaryPercent::model()->findAll(array('condition'=>'employee_id='.$each->employee_id,'order'=>'brand_id'));
    //                 if(empty($HrEmployeeBrandSalaryPercent))
    //                 {
    //                 $itemsArray = array();
    //                 $itemsArray['ledger_id'] = FinanceSystemAccountsMapping::getSystemdefault('employee_salary');
    //                 $itemsArray['subledger_id'] = $each->generateSubledger();
    //                 $itemsArray['narration'] = 'Salary for month ' . $model->salary_month . ' ' . date('Y');
    //                 $itemsArray['amount'] = $each->total;
    //                 $this->addVoucheritems($lastSavedid, $itemsArray);
    //                 $totalAmount = $each->total;
    //                 }
    //                 else {
    //                     foreach($HrEmployeeBrandSalaryPercent as $eachBrand)
    //                     {
    //                     $itemsArray = array();
    //                     $itemsArray['ledger_id'] = FinanceSystemAccountsMapping::getSystemdefault('employee_salary');
    //                     $itemsArray['subledger_id'] = $each->generateSubledger();
    //                     $itemsArray['narration'] = 'Salary for month ' . $model->salary_month . ' ' . date('Y');
    //                     $totalSalary=$each->total;
                        
    //                     $salary=($totalSalary*$eachBrand->salary_percent)/100;
                        
    //                     $itemsArray['brand_id'] = $eachBrand->brand_id;
    //                     $itemsArray['amount'] = $salary;
    //                     $this->addVoucheritems($lastSavedid, $itemsArray);
    //                     // $totalAmount += $salary; 
    //                     }   
    //                 }
    //             $itemsArray = array();
    //             $itemsArray['ledger_id'] = $model->legder_id;
    //             $itemsArray['subledger_id'] = $model->sublegder_id;
    //             $itemsArray['narration'] = 'Salary for month ' . $model->salary_month . ' ' . date('Y');
    //             $itemsArray['amount'] = -1 * $totalAmount;
    //             $this->addVoucheritems($lastSavedid, $itemsArray);
    //             }

                

    //             $model->posted = 'Y';
    //             $model->posted_on = date('Y-m-d');
    //             $model->voucher_id = $lastSavedid;
    //             $model->update();

    //             $response['status'] = 'success';
    //             $response['msg'] = 'Success';
    //         } else {
    //             $response['msg'] = 'Already Posted!';
    //         }
    //     } else {
    //         $response['msg'] = 'Invalid!';
    //     }
    //     echo json_encode($response);
    // }

    // public function actionDeletewps()
    // {
    //     $sif_head = (int) $_POST['id'];
    //     $response = array('status' => 'failed', 'msg' => 'Unknown data');

    //     function isPostable($date)
    //     {
    //         $last_closed_year = FinanceAuditClose::lastClosed();
    //         $voucherDate_array = explode('-', $date);
    //         $voucherYear = $voucherDate_array[0];
    //         return ($voucherYear <= $last_closed_year) ? false : true;
    //     }

    //     if ($sif_head > 0) {
    //         $mainModel = MonthlySalarySif::model()->findBypk($sif_head);
    //         if ($mainModel->posted == 'Y' && $mainModel->voucher_id > 0) {
    //             $model = FinanceVoucherHead::model()->findBypk($mainModel->voucher_id);
    //             if (isPostable($model->voucher_date)) {
    //                 FinanceVoucherHead::model()->deleteBypk($mainModel->voucher_id);
    //                 FinanceVoucherItems::model()->deleteAll('header_id=:refer_id', array(':refer_id' => $mainModel->voucher_id));

    //                 $mainModel->posted = 'N';
    //                 $mainModel->posted_on = '0000-00-00';
    //                 $mainModel->voucher_id = 0;
    //                 $mainModel->update();

    //                 $response['status'] = 'success';
    //                 $response['msg'] = 'Success';
    //             } else {
    //                 $response['msg'] = 'Already unposted!';
    //             }

    //         } else {
    //             $response['msg'] = 'Already Unposted!';
    //         }
    //     } else {
    //         $response['msg'] = 'Invalid!';
    //     }
    //     echo json_encode($response);
    // }

    public function actionGeneratewps()
    {

        $sif_head = (int) $_POST['id'];
        $response = array('status' => 'failed', 'msg' => 'Unknown data');

        if ($sif_head > 0) {
            $model = MonthlySalarySif::model()->findBypk($sif_head);
            $totalAmount = 0;
            if ($model->posted == 'N') {
                $voucherHead = array();
                $voucherHead['voucher_type'] = 6; //WPS
                $voucherHead['voucher_no'] = FinanceVoucherType::getVoucherno(6, true);
                $voucherHead['voucher_date'] = $model->sif_date;
                $voucherHead['header_table_id'] = $model->id;
                $voucherHead['reference_no'] = 'System generated voucher';
                $voucherHead['is_posted'] = 'Y';
                $voucherHead['total_voucher_amount'] = $model->total_amount;
                $voucherHead['cheque_no'] = $model->cheque_no;
                $voucherHead['cheque_date'] = $model->cheque_date;
                $voucherHead['created_by'] = Yii::app()->user->id;
                $voucherHead['created_datetime'] = date('Y-m-d h:i:s');
                $type=$model->salary_payment_mode;
                if($type==2)
                {
                $voucherHead['cheque_cleared']='N';
                }
                $lastSavedid = $this->addVoucherhead($voucherHead);
                switch($type)
                {
                case 1:
                $account=FinanceSystemAccountsMapping::getSystemdefault('cash_account');
                $subledger_account=FinanceSystemAccountsMapping::getSystemdefault_subledger('cash_account');
                break;
                case 2:
//                $account=FinanceSystemAccountsMapping::getSystemdefault('pdc_i');
                $account=FinanceSystemAccountsMapping::getSystemdefault('employee_wps');
                $subledger_account=FinanceSystemAccountsMapping::getSystemdefault_subledger('employee_wps');
                break; 
                case 3:
                $account=FinanceSystemAccountsMapping::getSystemdefault('employee_wps');
                $subledger_account=FinanceSystemAccountsMapping::getSystemdefault_subledger('employee_wps');
                break;  
                case 4:
                $account=FinanceSystemAccountsMapping::getSystemdefault('employee_wps');
                $subledger_account=FinanceSystemAccountsMapping::getSystemdefault_subledger('employee_wps');
                break;    
                }
                if($type!=2 && $type!=4)
                {
                if($type==3)
                {
                $subledger_account=$model->wpscompany_detail->fin_bank_subledger_id;
                }
                $itemsArray = array();
                $itemsArray['ledger_id'] = $account;
                $itemsArray['subledger_id'] = $subledger_account;
                $itemsArray['narration'] = 'Salary for month ' . $model->salary_month . ' ' . date('Y');
                $itemsArray['amount'] = -1*$model->total_amount;
                $this->addVoucheritems($lastSavedid, $itemsArray);
                }
                foreach ($model->items as $each) {
                    $totalAmount = $each->total;
                    $itemsArray = array();
                    $itemsArray['ledger_id'] = FinanceSystemAccountsMapping::getSystemdefault('employee_salary');
                    $itemsArray['subledger_id'] = $each->generateSubledger();
                    $itemsArray['narration'] = 'Salary for month ' . $model->salary_month . ' ' . date('Y');
                    $itemsArray['amount'] = $each->total;
                    $itemsArray['employee_id'] = $each->generateSubledger();
                    $this->addVoucheritems($lastSavedid, $itemsArray);
                    $totalAmount = $each->total;
                if($type==2)
                {
                $itemsArray = array();
                $itemsArray['ledger_id'] = $account;
                $itemsArray['subledger_id'] = $subledger_account;
                $itemsArray['narration'] = 'Salary for month ' . $model->salary_month . ' ' . date('Y');
                $itemsArray['amount'] = -1*$each->total;
                $itemsArray['opening_cheque_cleared'] ='N';
                $this->addVoucheritems($lastSavedid, $itemsArray);
                }
                if($type==4)
                {
                $itemsArray = array();
                $itemsArray['ledger_id'] = $account;
                $itemsArray['subledger_id'] = $subledger_account;
                $itemsArray['narration'] = 'Salary for month ' . $model->salary_month . ' ' . date('Y');
                $itemsArray['amount'] = -1*$each->total;
                $itemsArray['opening_cheque_cleared'] ='N';
                $this->addVoucheritems($lastSavedid, $itemsArray);
                }
                }

                

                $model->posted = 'Y';
                $model->posted_on = date('Y-m-d');
                $model->voucher_id = $lastSavedid;
                $model->update();

                $response['status'] = 'success';
                $response['msg'] = 'Success';
            } else {
                $response['msg'] = 'Already Posted!';
            }
        } else {
            $response['msg'] = 'Invalid!';
        }
        echo json_encode($response);
    }

    public function actionDeletewps()
    {
        $sif_head = (int) $_POST['id'];
        $response = array('status' => 'failed', 'msg' => 'Unknown data');

        function isPostable($date)
        {
            $last_closed_year = FinanceAuditClose::lastClosed();
            $voucherDate_array = explode('-', $date);
            $voucherYear = $voucherDate_array[0];
            return ($voucherYear <= $last_closed_year) ? false : true;
        }

        if ($sif_head > 0) {
            $mainModel = MonthlySalarySif::model()->findBypk($sif_head);
            if ($mainModel->posted == 'Y' && $mainModel->voucher_id > 0) {
                
                $model = FinanceVoucherHead::model()->findAll(array('condition'=>'id="'.$mainModel->voucher_id.'" AND voucher_type=6'));
                foreach($model as $eachModel)
                {
                if (isPostable($eachModel->voucher_date)) {
                    FinanceVoucherHead::model()->deleteBypk($eachModel->id);
                    FinanceVoucherItems::model()->deleteAll('header_id=:refer_id', array(':refer_id' => $eachModel->id)); 
                }
            }
                    $mainModel->posted = 'N';
                    $mainModel->posted_on = '0000-00-00';
                    $mainModel->voucher_id = 0;
                    $mainModel->update();

                    $response['status'] = 'success';
                    $response['msg'] = 'Success';
            } else {
                $response['msg'] = 'Already Unposted!';
            }
        } else {
            $response['msg'] = 'Invalid!';
        }
        echo json_encode($response);
    }

    public function actionPostSalary() {
        $id = Yii::app()->request->getParam('salary_slip_id');
        $response = array('status' => 'failed', 'msg' => 'Unknown data');

        if ($id > 0) {
            $model = SalaryProcessing::model()->findbyPK($id);
            $model_salary_slip = SalarySlip::model()->findAll(array('condition' => 'salary_processing_id="'.$model->id.'"'));
        
            $totalAmount = 0;
            if ($model->posted == 'N') {
                foreach ($model_salary_slip as $each) {
                    $voucherHead = array();
                $voucherHead['voucher_type'] = 12; //SALARY POSTING
                $voucherHead['voucher_no'] = FinanceVoucherType::getVoucherno(12, true);
                $voucherHead['voucher_date'] = $model->payroll_enddate;
                $voucherHead['header_table_id'] = $model->id;
                $voucherHead['reference_no'] = 'System generated voucher';
                $voucherHead['is_posted'] = 'Y';
                $voucherHead['total_voucher_amount'] = $each->total_salary_amount;
                $voucherHead['created_by'] = Yii::app()->user->id;
                $voucherHead['created_datetime'] = date('Y-m-d h:i:s');

                    $lastSavedid = $this->addVoucherhead($voucherHead);
                    $totalAmount = $each->total_salary_amount;
                    $HrEmployeeBrandSalaryPercent=EmployeeBrandSalaryPercent::model()->findAll(array('condition'=>'employee_id='.$each->employee_id,'order'=>'brand_id'));
                    if(empty($HrEmployeeBrandSalaryPercent))
                    {
                    if($each->annual_leave_deduction>0)
                    {
                    //Annual Leave Salary
                    $itemsArray = array();
                    if($each->employeedetail->post_salary=='Y')
                    {
                    $itemsArray['ledger_id'] = FinanceSystemAccountsMapping::getSystemdefault('employee_annual_leave_salary');
                    }
                    else {
                    $itemsArray['ledger_id'] = FinanceSystemAccountsMapping::getSystemdefault('employee_advance_salary');    
                    }
                    $itemsArray['subledger_id'] = $each->generateSubledger();
                    $itemsArray['narration'] = 'Salary for month ' . $model->payroll_month . ' ' . date('Y');
                    $itemsArray['amount'] = $each->total_salary_amount-$each->annual_leave_deduction;
                    $this->addVoucheritems($lastSavedid, $itemsArray);
                    // Normal Salary
                    $itemsArray = array();
                    if($each->employeedetail->post_salary=='Y')
                    {
                    $itemsArray['ledger_id'] = FinanceSystemAccountsMapping::getSystemdefault('employee_salary_wages');
                    }
                    else {
                    $itemsArray['ledger_id'] = FinanceSystemAccountsMapping::getSystemdefault('employee_advance_salary');    
                    }
                    $itemsArray['subledger_id'] = $each->generateSubledger();
                    $itemsArray['narration'] = 'Salary for month ' . $model->payroll_month . ' ' . date('Y');
                    $itemsArray['amount'] = $each->annual_leave_deduction;
                    $this->addVoucheritems($lastSavedid, $itemsArray);

                    $totalAmount = $each->total_salary_amount;
                    }
                    else
                    {
                    $itemsArray = array();
                    if($each->employeedetail->post_salary=='Y')
                    {
                    $itemsArray['ledger_id'] = FinanceSystemAccountsMapping::getSystemdefault('employee_salary_wages');
                    }
                    else {
                    $itemsArray['ledger_id'] = FinanceSystemAccountsMapping::getSystemdefault('employee_advance_salary');    
                    }
                    $itemsArray['subledger_id'] = $each->generateSubledger();
                    $itemsArray['narration'] = 'Salary for month ' . $model->payroll_month . ' ' . date('Y');
                    $itemsArray['amount'] = $each->total_salary_amount;
                    $this->addVoucheritems($lastSavedid, $itemsArray);
                    $totalAmount = $each->total_salary_amount;
                    }
                    }
                    else {
                        foreach($HrEmployeeBrandSalaryPercent as $eachBrand)
                        {
                        $itemsArray = array();
                        if($each->annual_leave_deduction>0)
                        {
                        $itemsArray = array();
                        //Annual Leave
                        $totalSalary=$each->total_salary_amount-$each->annual_leave_deduction;    
                        //Annual Leave Salary
                        if($each->employeedetail->post_salary=='Y')
                        {
                        $itemsArray['ledger_id'] = FinanceSystemAccountsMapping::getSystemdefault('employee_annual_leave_salary');
                        }
                        else 
                        {
                        $itemsArray['ledger_id'] = FinanceSystemAccountsMapping::getSystemdefault('employee_advance_salary');    
                        }
                        $itemsArray['subledger_id'] = $each->generateSubledger();
                        $itemsArray['narration'] = 'Salary for month ' . $model->payroll_month . ' ' . date('Y');
                        
                        
                        $salary=($totalSalary*$eachBrand->salary_percent)/100;
                        
                        $itemsArray['brand_id'] = $eachBrand->brand_id;
                        $itemsArray['amount'] = $salary;
                        $this->addVoucheritems($lastSavedid, $itemsArray);
                        // Normal Salary
                        $itemsArray = array();
                        $totalSalary=$each->annual_leave_deduction; 
                        if($each->employeedetail->post_salary=='Y')
                        {
                        $itemsArray['ledger_id'] = FinanceSystemAccountsMapping::getSystemdefault('employee_salary_wages');
                        }
                        else 
                        {
                        $itemsArray['ledger_id'] = FinanceSystemAccountsMapping::getSystemdefault('employee_advance_salary');    
                        }
                        $itemsArray['subledger_id'] = $each->generateSubledger();
                        $itemsArray['narration'] = 'Salary for month ' . $model->payroll_month . ' ' . date('Y');
                        
                        
                        $salary=($totalSalary*$eachBrand->salary_percent)/100;
                        
                        $itemsArray['brand_id'] = $eachBrand->brand_id;
                        $itemsArray['amount'] = $salary;
                        $this->addVoucheritems($lastSavedid, $itemsArray);

                        }
                        else {
                        if($each->employeedetail->post_salary=='Y')
                        {
                        $itemsArray['ledger_id'] = FinanceSystemAccountsMapping::getSystemdefault('employee_salary_wages');
                        }
                        else 
                        {
                        $itemsArray['ledger_id'] = FinanceSystemAccountsMapping::getSystemdefault('employee_advance_salary');    
                        }
                        $itemsArray['subledger_id'] = $each->generateSubledger();
                        $itemsArray['narration'] = 'Salary for month ' . $model->payroll_month . ' ' . date('Y');
                        $totalSalary=$each->total_salary_amount;
                        
                        $salary=($totalSalary*$eachBrand->salary_percent)/100;
                        
                        $itemsArray['brand_id'] = $eachBrand->brand_id;
                        $itemsArray['amount'] = $salary;
                        $this->addVoucheritems($lastSavedid, $itemsArray);
                        } 
                        }   
                    }
                $totalAmount = $each->total_salary_amount;
                $itemsArray = array();
                $itemsArray['ledger_id'] = FinanceSystemAccountsMapping::getSystemdefault('employee_salary');
                $itemsArray['subledger_id'] = $each->generateSubledger();
                $itemsArray['narration'] = 'Salary for month ' . $model->payroll_month . ' ' . date('Y');
                $itemsArray['amount'] = -1 * $totalAmount;
                $this->addVoucheritems($lastSavedid, $itemsArray);
                }
                $model->posted = 'Y';
                $model->posted_date = date('Y-m-d');
                $model->voucher_id = $lastSavedid;
                $model->save();

                $response['status'] = 'success';
                $response['msg'] = 'Success';
            } else {
                $response['msg'] = 'Already Posted!';
            }
        } else {
            $response['msg'] = 'Invalid!';
        }
        echo json_encode($response);  
    }
    public function actionDeleteSalary()
    {
        $salary_head = (int) $_POST['salary_slip_id'];
        $response = array('status' => 'failed', 'msg' => 'Unknown data');

        function isPostable($date)
        {
            $last_closed_year = FinanceAuditClose::lastClosed();
            $voucherDate_array = explode('-', $date);
            $voucherYear = $voucherDate_array[0];
            return ($voucherYear <= $last_closed_year) ? false : true;
        }

        if ($salary_head > 0) {
            $mainModel = SalaryProcessing::model()->findBypk($salary_head);
            if ($mainModel->posted == 'Y') {
                $model = FinanceVoucherHead::model()->findAll(array('condition'=>'voucher_date="'.$mainModel->payroll_enddate.'" AND voucher_type=12'));
                foreach($model as $eachModel)
                {
                if (isPostable($eachModel->voucher_date)) {
                    FinanceVoucherHead::model()->deleteBypk($eachModel->id);
                    FinanceVoucherItems::model()->deleteAll('header_id=:refer_id', array(':refer_id' => $eachModel->id));
                    $response['status'] = 'success';
                    $response['msg'] = 'Success';
                }
            }
            if($response['status']=='success')
            {
            $mainModel->posted = 'N';
            $mainModel->posted_date = '0000-00-00';
            $mainModel->voucher_id = 0;
            $mainModel->update();
            }
            } else {
                $response['msg'] = 'Already Unposted!';
            }
        } else {
            $response['msg'] = 'Invalid!';
        }
        echo json_encode($response);
    }
}
