<?php

/**
 * This is the model class for table "{{fuel_sub_charges}}".
 *
 * The followings are the available columns in table '{{fuel_sub_charges}}':
 * @property integer $id
 * @property string $from_date
 * @property string $to_date
 * @property double $fuel_sur_charge
 * @property string $isActive
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class FuelSubCharges extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{fuel_sub_charges}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('agent_id,from_date, to_date, fuel_sur_charge, created_by, created_date_time', 'required'),
			array('from_date', 'validatefromDate'),
			array('created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('fuel_sur_charge', 'numerical'),
			array('isActive', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, from_date, to_date, fuel_sur_charge, isActive, created_by, created_date_time, updated_by, updated_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
            'agent' => array(self::BELONGS_TO, 'Vendor','agent_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'from_date' => 'From Date',
			'to_date' => 'To Date',
			'fuel_sur_charge' => 'Fuel Sur Charge',
			'isActive' => 'Is Active',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
			'agent_id' => 'Agent',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('from_date',$this->from_date,true);
		$criteria->compare('to_date',$this->to_date,true);
		$criteria->compare('fuel_sur_charge',$this->fuel_sur_charge);
		$criteria->compare('isActive',$this->isActive,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return FuelSubCharges the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
	
	public function validatefromDate($attribute) {
       
        if ($this->from_date!='0000-00-00' && $this->from_date!='' && $this->to_date!='0000-00-00' && $this->to_date!='') {
            if(strtotime($this->from_date)<=strtotime($this->to_date)){
                $condition='((from_date<="' . $this->from_date . '" AND to_date>="' . $this->to_date . '") OR  (from_date BETWEEN  "' . $this->from_date . '" AND  "' . $this->to_date . '"
                                OR to_date BETWEEN  "' . $this->from_date . '" AND  "' . $this->to_date . '"))';
                if($this->id!=''){
                    $condition.=' AND id!="'.$this->id.'"';
                }
                $condition.=' AND agent_id="'.$this->agent_id.'" ';
                $model_fuel_sur_charge = self::model()->find(array('condition' =>$condition));
                if(!empty($model_fuel_sur_charge)){
                    $this->addError($attribute, 'Already exist from '.date("d/m/Y",strtotime($model_fuel_sur_charge->from_date)).' - '.date("d/m/Y",strtotime($model_fuel_sur_charge->to_date)));
                    return false;
                }else{
                    return true;
                }
            }else{
                $this->addError($attribute, 'Start Date must be less that End Date');
                return false;
            }
        } else {
            $this->addError($attribute, 'Please Enter Date in Given Format');
            return false;
        }
        
	}


}
