<?php

class UsergroupController extends Controller {

    public function accessRules() {

        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'GetUsergroupList', 'hrcreate', 'SaveHRUserGroup',
                    'Create', 'GetUserGroupLis', 'DeleteUserGroup', 'SaveUserGroup', 'Create_new'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {

        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionIndex() {

        $models = MasUserGroup::model()->findAll();

        $this->render('index', array('model' => $model), false, true);
    }

    public function actionCreate() {

        $model = new MasUserGroup();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('usergroup_form', array('model' => $model, 'id' => $id), false, true);
    }

    public function actionCreate_new() {

        $model = new MasUserGroup();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('usergroup_form_new', array('model' => $model, 'id' => $id), false, true);
    }

    public function actionGetUserGroupList() {

        $model = new MasUserGroup();

        $draw = $_POST['draw'];

        $offset = $_POST['start'];

        $limit = $_POST['length'];

        $columns = array(
            // datatable column index  => database column name

            0 => 'group_name',
        );

        $filterColumn = $columns[$_POST['order'][0]['column']];

        $filterOrder = $_POST['order'][0]['dir'];

        $orderBy = $filterColumn . " " . $filterOrder;

        $condition = 't.isActive="Y"';

        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {

            $searchString = $_POST['search']['value'];

            $condition.=" AND (group_name LIKE '%" . $searchString . "%')";
        }

        $count = $model->count(array('condition' => $condition));

        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));

        $recordsTotal = $count;

        $recordsFiltered = $count;

        $data['draw'] = $draw;

        $data['recordsTotal'] = $recordsTotal;

        $data['recordsFiltered'] = $recordsFiltered;

        $rowData = array();
        $m = 1;

        foreach ($model as $row) {
            $div = '';
            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["admin_usergroup_edit"])) {
                // $div .= '<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'usergroup/create&id='.$row['id'].'\',\'Edit User Group\',\'lg\')"><i class="fa fa-pencil"></i></button> ';
            }
            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["admin_usergroup_delete"])) {
                // $div .= '<a href ="#" class="btn btn-danger btn-xs" onclick="deleteUserGroup('.$row['id'].')"><i class="fa fa-trash-o "></i></a>';
            }
            $rowData[] = array($row['group_name'],
                '<div class="btn-wrap text-center">' . $div . '</div>',
                array('id' => $row['id'], 'code' => $row['group_name']));

            $m++;
        }


//      foreach ($model as $row)
//
//      {
//
//
//
//          $rowData[]=array($row['group_name'],'<div class="btn-wrap text-center"><button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'usergroup/create&id='.$row['id'].'\',\'Edit User Group\',\'lg\')"><i class="fa fa-pencil"></i></button> '
//             .'<a href ="#" class="btn btn-danger btn-xs" onclick="deleteUserGroup('.$row['id'].')"><i class="fa fa-trash-o "></i></a></div>');
//                    $m++;
//
//      }

        $data['data'] = $rowData;

        echo json_encode($data);
    }

    public function actionDeleteUserGroup() {
        $id = $_POST['id'];
        $model = new MasUserGroup();
        $del = $model->findByPk($id);
        $model->deleteByPk($id);
        // inserting to audit log
        AuditLog::saveAuditLogs(
            'USER_GROUPS',
            Yii::app()->user->id,
            'DELETED',
            " with groupname: - {$del->group_name}  ",
            "",
            ""
        );
        echo "success";
    }

    public function actionSaveUserGroup() {
        $model = new MasUserGroup();
        /*         * ********** START Code for Save ************** */
        if (isset($_POST['MasUserGroup'])) {
            $model->created_by = Yii::app()->user->id;
            $model->created_datetime = date('Y-m-d h:i:s');
            if ((int) @$_POST['MasUserGroup']['id'] > 0) {
                $model->updated_by = Yii::app()->user->id;
                $model->updated_datetime = date('Y-m-d h:i:s');
                $model->id = (int) $_POST['MasUserGroup']['id'];
                $model = $model->findByPK($model->id);
                $audit_type = 'UPDATED';
            }else{
                $audit_type = 'CREATED';
                $model->hr_permissions ='{}';
            }
            $model->attributes = $_POST['MasUserGroup'];
            $model->qtn_approval_val_limit = $_POST['MasUserGroup']['qtn_approval_val_limit'];
            $model->order_approval_val_limit = $_POST['MasUserGroup']['order_approval_val_limit'];
            $model->purchase_order_approval_val_limit = $_POST['MasUserGroup']['purchase_order_approval_val_limit'];
            $model->min_profit_percentage = $_POST['MasUserGroup']['min_profit_percentage'];
            $allPermissions = array();
            foreach ($_POST['MasUserGroup']['permissions'] as $eachPermissionArray) {
                if (is_array($eachPermissionArray)) {
                    foreach ($eachPermissionArray as $eachPermission) {
                        $allPermissions[$eachPermission] = 1;
                    }
                }
            }
            $model->permissions = json_encode($allPermissions);
            if ($model->save()) {
                // inserting to audit log
                AuditLog::saveAuditLogs(
                    'USER_GROUPS',
                    Yii::app()->user->id,
                    $audit_type,
                    " with groupname: - {$model->group_name}  ",
                    "",
                    ""
                );
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actionhrcreate() {

        $model = new MasUserGroup();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('hr_usergroup_form', array('model' => $model, 'id' => $id), false, true);
    }

    public function actionSaveHRUserGroup() {
        $model = new MasUserGroup();
        /*         * ********** START Code for Save ************** */
        if (isset($_POST['MasUserGroup'])) {
            $model->created_by = Yii::app()->user->id;
            $model->created_datetime = date('Y-m-d h:i:s');
            if ((int) @$_POST['MasUserGroup']['id'] > 0) {
                $model->updated_by = Yii::app()->user->id;
                $model->updated_datetime = date('Y-m-d h:i:s');
                $model->id = (int) $_POST['MasUserGroup']['id'];
                $model = $model->findByPK($model->id);
            }

            $allPermissions = array();
            foreach ($_POST['MasUserGroup']['permissions'] as $eachPermissionArray) {
                if (is_array($eachPermissionArray)) {
                    foreach ($eachPermissionArray as $eachPermission) {
                        $allPermissions[$eachPermission] = 1;
                    }
                }
            }
            $model->hr_permissions = json_encode($allPermissions);
            if ($model->save()) {
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }

}
