<?php

class RackController extends Controller
{
        public function accessRules() {
            return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                  'actions' => array('login', 'error', 'logout'),
                  'users' => array('*'),
                  ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                  'actions' => array('Index','Create','GetList','SaveRack','DeleteRack','DirectAdd', 'Disable'),
                  'expression' => '$user->isMember()',
                  ),
                array('deny', // deny all users
                  'users' => array('*'),
                  ),
                );
        }
	public function actionIndex()
	{
		$this->render('index');
	}

	
	
	public function filters()
        {
            return array(
                'accessControl', // perform access control for CRUD operations
                );
        }
        public function actionGetList()
        {
                $model=new MasInvRack();
                $draw    = $_POST['draw'];
                $offset = $_POST['start'];
                $limit  = $_POST['length'];
                $columns = array(
                // datatable column index  => database column name
                   0 =>'name',
                   
                   );
                $filterColumn = $columns[$_POST['order'][0]['column']];
                $filterOrder  = $_POST['order'][0]['dir'];
                $orderBy   = $filterColumn." ".$filterOrder;
                $condition = 't.isActive="Y"';
                if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
                {
                  $searchString = $_POST['search']['value'];
                  $condition ="  (name LIKE '%".$searchString."%')";
                }
                $count = $model->count(array('condition'=>$condition));
                $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>$orderBy));
                $recordsTotal = $count;
                $recordsFiltered = $count;
                $data['draw'] = $draw;
                $data['recordsTotal'] = $recordsTotal;
                $data['recordsFiltered'] = $recordsFiltered;
                $rowData=array();
                $m = 1;
                
                foreach ($model as $row)
                {
                    $div = '';
                    if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["mas_inv_rack_edit"])){
                       // $div .= '<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'rack/create&id='.$row['id'].'\',\'Edit Rack\',\'lg\')"><i class="fa fa-pencil"></i></button>';
                    }
                    if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["mas_inv_rack_delete"])){
                        //$div .=  '<a href ="#" class="btn btn-danger btn-xs" onclick="deleteRack('.$row['id'].')"><i class="fa fa-trash-o "></i></a>';
                    }
                       $rowData[]=array($m,
                           $row['name'],
                           '<div class="btn-wrap text-center">'.$div.'</div>',
                           $row['is_base_rack'],
                array('id' => $row['id'],'code'=>$row['name'], 'status' => $row->isActive));
                    $m++;
                    
                }
                $data['data'] = $rowData;
                echo json_encode($data);
        }
         public function actionCreate()
        {
            $model=new MasInvRack();
            $id = (int) Yii::app()->request->getParam('id');
            if($id>0){
                $model=$model->findByPk($id);
            }
                Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->render('rack_form', array('model' => $model), false, false);
        }
  
  
        public function actionSaveRack()
        {
            $model = new MasInvRack();
            if (isset($_POST['MasInvRack']))
            {
    		$model->created_by = Yii::app()->user->id;
                $model->created_datetime =date('Y-m-d h:i:s');
    		if ((int) @$_POST['MasInvRack']['id'] > 0)
                {   $model->updated_by = Yii::app()->user->id;
                    $model->updated_datetime =date('Y-m-d h:i:s');
                    $id= (int) @$_POST['MasInvRack']['id'];
                    $model=$model->findByPk($id); 
                    $audit_type = 'UPDATED';
                    $edit_flag=1;
                }else{
                    $audit_type = 'CREATED';
                }
                if($_POST['MasInvRack']['is_base_rack'] == "Y"){
                	MasInvRack::model()->updateAll(array( 'is_base_rack' => 'N' ), 'is_base_rack = "Y"' );
                }
                $model->attributes=$_POST['MasInvRack'];
                if ($model->save())
                {
                        // inserting to audit log
                        AuditLog::saveAuditLogs(
                            'RACK_MASTER',
                            Yii::app()->user->id,
                            $audit_type,
                            " with name: - {$model->name}  "
                        );
                        // end audit log
                        $jsonData['status'] = 'success';
                        $jsonData['frm'] = $_POST['rack_form'];
                        $jsonData['id'] = $model->id;
	                echo CJSON::encode($jsonData);
                }
                else
                {
                        $error = CActiveForm::validate($model, '', false);
                        if ($error != '[]')
		               echo $error;
                }
          
            }
        }
        public function actionDeleteRack(){
		$id = $_POST['id'];
                $model=new MasInvRack();
                $rack = $model->findByPk($id); // audit log changes
                $model->deleteByPk($id);
                // inserting to audit log
                AuditLog::saveAuditLogs(
                    'RACK_MASTER',
                    Yii::app()->user->id,
                    'DELETED',
                    " with name: - {$rack->name}  "
                );
                // end audit log
                echo "success";
    }
    
     public function actionDirectAdd(){
           $from = $_POST['from'];
           $name = $_POST['name'];
           if($name != ''){
               $modelRack = new MasInvRack;
               $modelRack->name = $name;
               if($modelRack->save()){
                    $data  = MasInvRack::getRacks();
                    if($from == 'inventory'){
                        $model = new ProductLocation;
                        $field_name = 'rack';
                    }
                    $model->$field_name = $modelRack->id;
                    $drop=CHtml::activedropDownList($model,$field_name, $data,  array('class' => 'tooltipster','data-label'=>'Rack'));  
                    $status=array("status" =>"success","drop" => $drop);    
                    echo CJSON::encode($status);
            
               }else{
                   $error = CActiveForm::validate($modelRack, '', false);
                        if ($error != '[]')
		               echo $error;
               }
           }
           
         }
        public function actionDisable() {
        $id = Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');
        $model = new MasInvRack();
        $model = $model->findByPk($id);
        $model->isActive = ($status == "Y" ) ? "N" : "Y";
        $model->save();
        echo json_encode(array("status" => "success"));
    }
}