<?php

class QuotationpricelistController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'Create', 'GetList', 'Save', 'Disable'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex() {
        $this->render('index');
    }

    // Uncomment the following methods and override them if needed

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

     public function actionGetList() {
        $model = new QuotationPriceList();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'agent',
            1 => 'weight',
            2 => 'price',
            3 => 'price_type',
            4 => 'comment',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = '1=1 AND t.isActive="Y"';
        if ($_POST['agent']!='') {
            $condition .= " AND agent ='{$_POST['agent']}' ";
        }
        if ($_POST['country_id'] != '') { 
            $condition .= ' AND country_id=' . $_POST['country_id'];
        }
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition  .= " AND (agent LIKE '%" . $searchString . "%' OR country_ref.country_name LIKE '%" . $searchString . "%'  OR weight LIKE '%" . $searchString . "%' OR price LIKE '%" . $searchString . "%' OR price_type LIKE '%" . $searchString . "%' OR comment LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('country_ref')->count(array('condition' => $condition));
        $model = $model->with('country_ref')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        // $count = $model->count(array('condition' => $condition));
        // $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $div = '';
            $rowData[] = array($m,
                $row['agent'],
                $row->country_ref->country_name,
                $row['weight'],
                $row['price'],
                '<div class="btn-wrap text-center">' . $div . '</div>',
                array('id' => $row['id'],'code'=> 'Edit Quotation Price List ', 'status' => $row->isActive));

            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreate() {
        $model = new QuotationPriceList();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('quotation_form', array('model' => $model), false, false);
    }

    public function actionSave() {
        $model = new QuotationPriceList();
        if (isset($_POST['QuotationPriceList'])) {
            $model->created_by = Yii::app()->user->id;
            $model->created_date_time = date('Y-m-d h:i:s');
            if ((int) @$_POST['QuotationPriceList']['id'] > 0) {
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d h:i:s');
                $id = (int) @$_POST['QuotationPriceList']['id'];
                $model = $model->findByPk($id);
                $audit_type = 'UPDATED'; 
            }else{
                $audit_type = 'CREATED';
            }
            $model->attributes = $_POST['QuotationPriceList'];
            if ($model->save()) {
                $jsonData['status'] = 'success';
                $jsonData['frm'] = $_POST['country_form'];
                $jsonData['id'] = $model->id;
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }

  
    public function actionDisable() {
        $id = Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');
        $model = new QuotationPriceList();
        $model = $model->findByPk($id);
        $model->isActive = ($status == "Y" ) ? "N" : "Y";
        $model->save();
        echo json_encode(array("status" => "success"));
    }

}
