<?php

class PaymenttermsController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'Create', 'GetPaymentTermList', 'SavePaymentTerm', 'DisablePaymentterm', 'DirectAdd'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    /**
     * This is the default 'index' action that is invoked
     * when an action is not explicitly requested by users.
     */
    public function actionIndex() {

        $this->render('index');
    }

    public function actionCreate() {
        $model = new MasPaymentTerm();
        $from = Yii::app()->request->getParam('from');
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('create', array('model' => $model, 'from' => $from), false, true);
    }

    public function actionGetPaymentTermList() {

        $model = new MasPaymentTerm();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 'payment_terms',
            2 => 'no_of_days',
            3 => 'isBasePaymentTerm',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.isActive="Y"';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $condition = "1=1 ";
            $searchString = $_POST['search']['value'];
            $condition.=" and (payment_code LIKE '%" . $searchString . "%' OR payment_terms LIKE '%" . $searchString . "%')";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
//                  foreach ($model as $row)
//                {
//                    $rowData[]=array($m,$row['payment_code'],$row['payment_terms'],$row['no_of_days'],$row['isBasePaymentTerm'],
//              '<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'paymentterms/create&id='.$row['id'].'\',\'Edit Payment Term\')"><i class="fa fa-pencil"></i></button> '
//             .'<a href ="#" onclick="deletePaymentterm('.$row['id'].')"><button class="btn btn-danger btn-xs"><i class="fa fa-trash-o "></i></button></a>');
//               $m++;
//                }
        foreach ($model as $row) {

            $div = '';
            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["paymentterm_edit"])) {
                $div .= '<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'paymentterms/create&id=' . $row['id'] . '\',\'Edit Payment Term\')"><i class="fa fa-pencil"></i></button> ';
            }
            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["paymentterm_delete"])) {
                //$div .=  ' <a href ="#" onclick="deletePaymentterm('.$row['id'].')"><button class="btn btn-danger btn-xs"><i class="fa fa-trash-o "></i></button></a>';
            }
            $rowData[] = array($m,
                $row['payment_terms'],
                $row['no_of_days'],
                $row['isBasePaymentTerm'],
                '<div class="btn-wrap text-center">' . $div . '</div>',
                array('id' => $row['id'], 'code' => $row['payment_terms'], 'isActive' => $row['isActive']),);
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionSavePaymentTerm() {
        $model = new MasPaymentTerm();
        if (isset($_POST['MasPaymentTerm'])) {
            $model->created_by = Yii::app()->user->id;
            $model->created_datetime = date('Y-m-d h:i:s');

            if ((int) @$_POST['MasPaymentTerm']['id'] > 0) {
                $model->updated_by = Yii::app()->user->id;
                $model->updated_datetime = date('Y-m-d h:i:s');
                $id = (int) @$_POST['MasPaymentTerm']['id'];
                $model = $model->findByPk($id);
                $audit_type = 'UPDATED';
            } else {
                $audit_type = 'CREATED';
            }
            if ($_POST['MasPaymentTerm']['isBasePaymentTerm'] == "Y") {
                MasPaymentTerm::model()->updateAll(array('isBasePaymentTerm' => 'N'), 'isBasePaymentTerm = "Y"');
            }

            $model->attributes = $_POST['MasPaymentTerm'];
            $model->isBasePaymentTerm = $_POST['MasPaymentTerm']['isBasePaymentTerm'];
            if ($model->validate()) {
                $model->save();
                // inserting to audit log
                AuditLog::saveAuditLogs(
                        'PAYMENT_TERMS', Yii::app()->user->id, $audit_type, " with term: - {$model->payment_terms}  "
                );
                // end audit log 
                $jsonData['status'] = 'success';
                $jsonData['frm'] = $_POST['paymentterm_form'];
                $jsonData['id'] = $model->id;
                $jsonData['from'] = $_POST['from'];
                ;
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actionDisablePaymentterm() {
        date_default_timezone_set("Asia/Dubai");
        $id = $_POST['id'];
        /* $model_c = Customer::model()->findAll(array('condition' =>'customer_currency_id = '.$id.' '));
          $model_com = Company::model()->findAll(array('condition' =>'currency = '.$id.' '));
          $model_cr = Creditnote::model()->findAll(array('condition' =>'currency = '.$id.' '));
          $model_in = Invoice::model()->findAll(array('condition' =>'currency = '.$id.' '));
          $model_l = Lead::model()->findAll(array('condition' =>'currency = '.$id.' '));
          $model_o = Order::model()->findAll(array('condition' =>'currency = '.$id.' '));
          $model_pi = PurchasingInvoice::model()->findAll(array('condition' =>'currency = '.$id.' '));
          $model_po = PurchasingOrder::model()->findAll(array('condition' =>'currency = '.$id.' '));
          $model_q = Quotes::model()->findAll(array('condition' =>'currency = '.$id.' '));
          $model_v = Vendor::model()->findAll(array('condition' =>'vendor_currency_id = '.$id.' '));
          if(empty($model_c) && empty($model_com) && empty($model_cr) && empty($model_in) && empty($model_l) && empty($model_o) && empty($model_pi) && empty($model_po) && empty($model_q) && empty($model_v)){
         */
        if (!empty($id)) {
            $model = new MasPaymentTerm();
            $model = $model->findByPk($id);
            if ($model->isActive == 'N') {
                $model->isActive = 'Y';
            } else {
                $model->isActive = 'N';
            }
            $model->updated_by = Yii::app()->user->id;
            $model->updated_datetime = date('Y-m-d h:i:s');
            $model->save(FALSE);
            echo "success";
        } else {
            echo "fail";
        }
    }

    public function actionDirectAdd() {
        $from = $_POST['from'];
        $code = $_POST['code'];
        $term = $_POST['term'];
        $days = $_POST['days'];
        if ($term != '' && $days != '') {
            $modelPaymentterm = new MasPaymentTerm;
            $modelPaymentterm->created_by = Yii::app()->user->id;
            $modelPaymentterm->created_datetime = date('Y-m-d h:i:s');
            $modelPaymentterm->payment_code = $code;
            $modelPaymentterm->payment_terms = $term;
            $modelPaymentterm->no_of_days = $days;
            if ($modelPaymentterm->save()) {
                if ($modelPaymentterm->payment_code == '') {
                    if ($modelPaymentterm->id < 10) {
                        $code = '0' . $id;
                    } else {
                        $code = $modelPaymentterm->id;
                    }
                    MasPaymentTerm::model()->updateByPk($modelPaymentterm->id, array('payment_code' => 'AE' . $code));
                }
                $data = MasPaymentTerm::getPaymentTerms();
                if ($from == 'customer') {
                    $model = new Customer;
                    $field_name = 'customer_payment_term';
                }
                if ($from == 'quote') {
                    $model = new Quotes;
                    $field_name = 'payment_terms';
                }
                if ($from == 'order') {
                    $model = new Order;
                    $field_name = 'payment_terms';
                }
                if ($from == 'invoice') {
                    $model = new Invoice;
                    $field_name = 'payment_terms';
                }
                if ($from == 'vendor') {
                    $model = new Vendor;
                    $field_name = 'vendor_payment_term';
                }
                $model->$field_name = $modelPaymentterm->id;
                $drop = CHtml::activedropDownList($model, $field_name, $data, array('class' => 'tooltipster', 'data-label' => 'Payment Terms <span style="color:red;">*</span>'));
                $status = array("status" => "success", "drop" => $drop);
                echo CJSON::encode($status);
            } else {
                $error = CActiveForm::validate($modelPaymentterm, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }

}
