<?php

class MasuserdocumenttypeController extends Controller {

    public function accessRules() {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'GetList', 'Create', 'Save', 'Disable'),
                'expression' => '$user->isMember()',
            ),
            array(
                'deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex() {
        $this->render('index');
    }

    /*
     * ajax function to list all unit datatable
     * modified by jisha on 19-6-20. 
     */

    public function actionGetList() {
        $model = new MasUserDocumentType();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];

        $columns = array(
            // datatable column index  => database column name
            0 => 't.id',
            1 => 't.document_name',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = '1=1';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition.=" AND (t.document_name LIKE '%" . $searchString . "%')";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {

            $rowData[] = array($m, $row['document_name'],array('id' => $row['id'],'code'=>$row['document_name'], 'status' => $row->isActive));
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    /*
     * function to create unit details
     * modified by jisha on 19-6-20. 
     */

    public function actionCreate() {
        $id = (int) Yii::app()->request->getParam('id');
        $model = new MasUserDocumentType;
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);
        $this->render('create', array('model' => $model));
    }

    public function actionSave() {
        $model = new MasUserDocumentType();
        if (isset($_POST['MasUserDocumentType'])) {

            if ($_POST['MasUserDocumentType']['id'] > 0) {
                $id = $_POST['MasUserDocumentType']['id'];
                $model = $model->findByPK($id);
            }
             
            $model->attributes = $_POST['MasUserDocumentType'];
            $model->document_name=strtoupper(trim($model->document_name));
            $valid = $model->validate();
        }
        if ($valid) {
            $model->save();

            $model->save();



            $jsonData['status'] = 'success';
            echo CJSON::encode($jsonData);
        } else {
            $error1 = json_decode(CActiveForm::validate($model, '', false), true);
            $error = CJSON::encode(array_merge_recursive($error1));
            if ($error != '[]') {
                echo $error;
            }
        }
    }
    public function actionDisable() {
        $id = Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');
        $model = new MasUserDocumentType();
        $model = $model->findByPk($id);
        $model->isActive = ($status == "Y" ) ? "N" : "Y";
        $model->save();
        echo json_encode(array("status" => "success"));
    }

}
