<?php

class MasgenericController extends Controller {

    public function accessRules() {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index','GetList', 'Create','Save'),
                'expression' => '$user->isMember()',
            ),
            array(
                'deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex() {
        $this->render('index');
    }
    /*
     * ajax function to list all generic datatable
     * modified by jisha on 19-6-20. 
     */

      public function actionGetList() {
        $model  = new MasGeneric();
        $draw   = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];
        $outlet = $_POST['outlet'];
        $generic = $_POST['generic'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.id',
            1 => 't.generic_name',
            2 => 't.id',
            3 => 't.active',
            4 => 't.is_default'
        );
        $filterColumn   = $columns[$_POST['order'][0]['column']];
        $filterOrder    = $_POST['order'][0]['dir'];
        $orderBy        = $filterColumn . " " . $filterOrder;
        $condition      = '1=1';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition.=" AND (t.generic_name LIKE '%" . $searchString . "%' )";
        }
        if($outlet>0){
            $condition.=" AND t.outlet=".$outlet;
        }
        $count          = $model->count(array('condition' => $condition));
        $model          = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal   = $count;
        $recordsFiltered        = $count;
        $data['draw']   = $draw;
        $data['recordsTotal']   = $recordsTotal;
        $data['recordsFiltered']= $recordsFiltered;
        $rowData                = array();
        $m=1;
        foreach ($model as $row)
        {
                if (isset(Yii::app()->user->havePermissionOn['inventory_generic_name_edit']) || Yii::app()->user->authorised_user == 1) { 
                $div= '<button class="btn btn-primary btn-xs" title ="Edit" onclick="loadPopupModal(\'masgeneric/create&id='.$row['id'].'\',\'Edit - '.$row['generic_name'].'\',\'lg\')"><i class="fa fa-edit" aria-hidden="true"></i></button>';
            }
            $rowData[]  = array($m,$row['generic_name'],$div,$row['active'],$row['is_default']);
            $m++;
        } 
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    /*
     * function to create generic details
     * modified by jisha on 19-6-20. 
     */
    public function actionCreate() {
       $id = (int) Yii::app()->request->getParam('id');
        $model = new MasGeneric;
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);
        $this->render('create', array('model' => $model));
    }
    public function actionSave() {
        $model          = new MasGeneric();
        if (isset($_POST['MasGeneric'])) {

            if ($_POST['MasGeneric']['id'] > 0) {
                $id =  $_POST['MasGeneric']['id'];
                $model = $model->findByPK($id);
                $scene = 'update';
                $change_type = 'UPDATED';
            } else {
                $model->created_by = Yii::app()->user->id;
                $model->created_time = date('Y-m-d H:i:s');
                $scene = 'new';
                $change_type = 'CREATED';                
            }
            $model->updated_by = Yii::app()->user->id;
            $model->updated_time =date('Y-m-d H:i:s');
            $model->attributes = $_POST['MasGeneric'];
            $valid=$model->validate();
        }
        if($valid){
            $model->save();
            if($model->is_default=='Y'){
                MasGeneric::model()->updateAll(array( 'is_default' => 'N'),'id!='.$model->id);
            }
            // inserting to audit log
                AuditLog::saveAuditLogs(
                    $modelformmaster->id,
                    Yii::app()->user->id,
                    $change_type,
                    " with ID - {$model->id} "
                );
                // end audit log
            $jsonData['status'] = 'success';
            echo CJSON::encode($jsonData);
        }else {
            $error1 = json_decode(CActiveForm::validate($model, '', false), true);
            $error = CJSON::encode(array_merge_recursive($error1));
            if ($error != '[]'){
                echo $error;    
            }
        }
    }
}
