<?php

class DashboardController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'Create', 'GetLeadGraphs', 'GetQuoteGraphs', 'GetOrderGraphs', 'GettestGraphs', 'GetGraph', 'GetGraphTotals', 'LeadGraphDetails', 'GetLeadOwnerDetail', 'LeadGraphOwnerDetails', 'LeadGetMonthDetails',
                    'GetLeadCountryDetail', 'LeadGraphCountryDetails', 'LeadGetLeadCountryMonthDetails', 'GetLeadSalesGroupDetail', 'LeadGraphSalesGroupDetails',
                    'LeadSalesMonthDetails', 'quotes_graphdetails', 'GetQuoteOwnerDetail', 'GetQuoteCountryDetail', 'GetQuotesSalesGroupDetail',
                    'QuotesGraphOwnerDetails', 'QuotesGraphCountryDetails', 'QuoteGraphSalesGroupDetails', 'QuoteGetMonthDetails', 'GetQuoteMonthDetails',
                    'QuoteSalesMonthDetails', 'Quotation_items', 'order_graphdetails', 'OrderGraphOwnerDetails', 'GetOrderOwnerDetail',
                    'GetOrderCountryDetail', 'GetOrderSalesGroupDetail', 'OrderCountryDetails', 'OrderSalesGroupDetails', 'OrderGetMonthDetails',
                    'GetOrderMonthDetails', 'OrderSalesMonthDetails', 'Order_items', 'invoice_graphdetails', 'GetInvoiceOwnerDetail',
                    'GetInvoiceCountryDetail', 'GetInvoiceSalesGroupDetail', 'invoiceGraphOwnerDetails', 'invoiceCountryDetails',
                    'InvoiceSalesGroupDetails', 'InvoiceGetMonthDetails', 'GetInvoiceMonthDetails', 'InvoiceSalesMonthDetails', 'getInvoiceItems',
                    'GetInvoiceDetail', 'GetMonthlyInvoice', 'loadInvoicesMtdGraph', 'InvoiceYear', 'GetOrderDetail', 'OrderYear', 'loadOrderMtdGraph', 'Current_stock_details',
                    'followups', 'GetLeadOwnerSales', 'Getreceiptall', 'Getpaymentall', 'GetTotalsByAccountPayables', 'GetTotalsByAccountReceivables', 'GetTotalsByPurcahseOrders',
                    'GetTotalsByPurchaseInvoices', 'GetTotalsBySalesOrders', 'GetTotalsBySalesInvoices', 'GetTotalsBySalesLeads', 'GetTotalsBySalesQuotes',
                    'GetProfitCustomerList', 'GetProfitLeadOwnerList', 'GetInvoiceCustomerList', 'Target', 'monthlyprovisonal', 'staging', 'Jomonthdetails', 'JoLeaddetails','MonthlySalesTarget'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex() {

        $this->render('index');
    }

    public function actionStaging() {

        $this->render('index');
    }

    // Uncomment the following methods and override them if needed

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionGetLeadGraphs() {
        //print_r("HI");die();
        $this->renderPartial('lead_graphs');
    }

    public function actionGetQuoteGraphs() {
        $this->render('quotation_graphs');
    }

    public function actionGetOrderGraphs() {
        $this->render('order_graphs');
    }

    public function actionGettestGraphs() {
        $this->render('test_graphs');
    }

    public function actionGetGraph() {

        $page = Yii::app()->request->getparam("page");

        if ($page == 'count_details') {
            $fromdate = Yii::app()->request->getparam("total_count_from_date");
            $todate = Yii::app()->request->getparam("total_count_to_date");

            $arr_pars = array('fromdate' => $fromdate, 'todate' => $todate);
        } else {
            $fromdate = Yii::app()->request->getparam("fromdate");
            $todate = Yii::app()->request->getparam("todate");
            $arr_pars = array('fromdate' => $fromdate, 'todate' => $todate);
        }
        $this->render($page, $arr_pars);
    }

    public function actionGetGraphTotals() {
        $fromdate = Yii::app()->request->getparam("fromdate");
        $todate = Yii::app()->request->getparam("todate");
        $fromdate = str_replace('/', '-', $fromdate);
        $from_date = date("Y-m-d", strtotime($fromdate));
        $todate = str_replace('/', '-', $todate);
        $end_date = date("Y-m-d", strtotime($todate));
        $extra_cndt = '';
        if (Yii::app()->user->authorised_user != 1 && User::isSalesman() == 'Y') {
            $extra_cndt = ' AND t.lead_owner_id=' . Yii::app()->user->id;
        }
        $quote_totals = Quotes::model()->find(array('select' => 'ifnull(sum(grand_total*exchange_rate),0) AS grand_total', 'condition' => 't.isActive="Y" AND (qtn_start_date >= "' . $from_date . '" AND qtn_start_date <= "' . $end_date . '" ' . $extra_cndt . ')'))->grand_total;
        $ord_totals = Order::model()->find(array('select' => 'ifnull(sum(selling_price*exchange_rate),0) AS selling_price', 'condition' => 't.isActive="Y" AND (job_date >= "' . $from_date . '" AND job_date <= "' . $end_date . '") ' . $extra_cndt . ''))->selling_price;
        $inv_totals = Invoice::model()->find(array('select' => 'ifnull(sum(grand_total*exchange_rate),0) AS grand_total', 'condition' => 't.isActive="Y" AND (invoice_date >= "' . $from_date . '" AND invoice_date <= "' . $end_date . '") ' . $extra_cndt . ''))->grand_total;

        $data['qtn_total'] = round($quote_totals, 0);
        ;
        $data['ord_total'] = round($ord_totals, 0);
        ;
        $data['inv_total'] = round($inv_totals, 0);
        ;
        echo json_encode($data);
    }

    public function actionLeadGraphDetails() {
        $type = (int) Yii::app()->request->getParam('type');
        $fromdate = Yii::app()->request->getParam('from_date');
        $todate = Yii::app()->request->getParam('end_date');
        $currentYear = date("Y");
        $fromdate = str_replace('/', '-', $fromdate);
        $from_date = date("Y-m-d", strtotime($fromdate));
        $todate = str_replace('/', '-', $todate);
        $end_date = date("Y-m-d", strtotime($todate));
        $month = date("m", strtotime($fromdate));
        $month_1 = date("m", strtotime($todate));
        $year = date("Y", strtotime($todate));
        $leadextra_cndt = '';
        if (Yii::app()->user->authorised_user != 1 && User::isSalesman() == 'Y') {
            $leadextra_cndt = ' AND lead.lead_owner_id=' . Yii::app()->user->id;
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false);
        if ($type == 1) {
            $graph_lead_owner = Yii::app()->db->createCommand('SELECT CONCAT(user.first_name," ",user.last_name) AS x_value,COUNT(*) AS y_value FROM {{lead}} AS lead
                                                         INNER JOIN ' . MasCompany::MainDB . '.{{user}} AS user ON lead.lead_owner_id=user.id
                                                         WHERE lead.enq_date BETWEEN "' . $from_date . '" AND "' . $end_date . '"  ' . $leadextra_cndt . ' GROUP BY user.id')->queryAll();
            if (!empty($graph_lead_owner)) {
                $plot = '[';
                foreach ($graph_lead_owner as $m => $eachdata) {
                    $color = substr(md5(rand()), 0, 6);
                    $plot .= '{label:"' . $eachdata['x_value'] . '", value:"' . $eachdata['y_value'] . '", color: "#' . $color . '"},';
                }
                $plot .= ']';
            } else {
                $plot = '';
            }
            $this->render('lead_owner_view', array('plot' => $plot, 'from_date' => $from_date, 'end_date' => $end_date));
        } else if ($type == 2) {
            /// Emirate
            $graph_lead_country = Yii::app()->db->createCommand('SELECT COUNT(*) AS qty, COALESCE(emirates.emirates_name, \'Not Specified\') AS label FROM erp_lead AS lead LEFT OUTER JOIN erp_customer AS customer ON lead.customer_id = customer.id LEFT OUTER JOIN erp_mas_emirates_list AS emirates ON customer.customer_emirates_name = emirates.id
                                                        WHERE lead.enq_date BETWEEN "' . $from_date . '" AND "' . $end_date . '" ' . $leadextra_cndt . '  GROUP BY customer.customer_emirates_name')->queryAll();
            if (!empty($graph_lead_country)) {

                $plot = '[';
                foreach ($graph_lead_country as $m => $eachdata) {
                    $color = substr(md5(rand()), 0, 6);
                    $plot .= '{label:"' . $eachdata['label'] . '", value:"' . $eachdata['qty'] . '", color: "#' . $color . '"},';
                }
                $plot .= ']';
            } else {
                $plot = '';
            }
            $this->render('lead_country_view', array('plot' => $plot, 'from_date' => $from_date, 'end_date' => $end_date));
        } else if ($type == 3) {
            // sales group
            $graph_lead_sales_group = Yii::app()->db->createCommand('SELECT COALESCE(sales_group.group_name , \'Unspecified\') AS x_value,COUNT(*) AS y_value FROM {{lead}} AS lead
                                                        LEFT OUTER JOIN {{mas_sales_group}} AS sales_group ON lead.sales_group_id=sales_group.id
                                                        WHERE lead.enq_date BETWEEN "' . $from_date . '" AND "' . $end_date . '"  ' . $leadextra_cndt . ' GROUP BY sales_group.id')->queryAll();
            if (!empty($graph_lead_sales_group)) {
                $plot = '[';
                foreach ($graph_lead_sales_group as $m => $eachdata) {
                    $color = substr(md5(rand()), 0, 6);
                    $plot .= '{label:"' . $eachdata['x_value'] . '", value:"' . $eachdata['y_value'] . '", color: "#' . $color . '"},';
                }
                $plot .= ']';
            } else {
                $plot = '';
            }
            $this->render('lead_sales_group_view', array('plot' => $plot, 'from_date' => $from_date, 'end_date' => $end_date));
        } else if ($type == 4) {
            $year = date("Y", strtotime($todate));
            $currentYear = date("Y");
            $currentmonth = date("m");
            if ($year == $currentYear) {
                $month_1 = $currentmonth;
            }
            $data = array();
            $plot_4 = '[';
            for ($k = $month; $k <= $month_1; $k++) {
                $dateObj = DateTime::createFromFormat('!m', $k);
                $monthName = $dateObj->format('F'); // March
                $graphdata3 = Yii::app()->db->createCommand('SELECT COUNT(id) AS value FROM {{lead}} AS lead  WHERE YEAR(enq_date) = "' . $year . '" AND MONTH(enq_date) = "' . $k . '"  ' . $leadextra_cndt . ' ')->queryAll();

                foreach ($graphdata3 as $i => $eachdata) {
                    $color = substr(md5(rand()), 0, 6);
                    $plot_4 .= '{label:"' . $monthName . '", value:"' . $eachdata['value'] . '", color: "#' . $color . '" },';
                    $data[$k]['month'] = $monthName;
                    $data[$k]['value'] = $eachdata['value'];
                }
            }
            $plot_4 .= ']';
            $this->render('lead_year_view', array('plot' => $plot_4, 'data' => $data));
        }
    }

    /*     * *********************   start - lead Owner **************************************************** */

    public function actionGetLeadOwnerDetail() {
        $lead_graph_details = array();
        //Quotation Owner
//            $fin_month = Yii::app()->user->fin_year;
//            $year = date('Y');
//            $year_next = $year + 1;
//            if($fin_month == 1){
//                $from_date = $year.'-01-01';
//                $end_date = $year.'-12-31';
//            }else{
//                $from_date = $year.'-04-01';
//                $end_date = $year_next.'-03-31';
//            }
        $from_date = Yii::app()->request->getParam('fromdate');
        $end_date = Yii::app()->request->getParam('todate');
        $leadextra_cndt = '';
        if (Yii::app()->user->authorised_user != 1 && User::isSalesman() == 'Y') {
            $leadextra_cndt = ' AND lead.lead_owner_id=' . Yii::app()->user->id;
        }
        $graph_data_quantity = Yii::app()->db->createCommand('SELECT lead.lead_owner_id AS OWNERID,CONCAT(user.first_name," ",user.last_name) AS x_value,COUNT(*) AS y_value FROM {{lead}} AS lead INNER JOIN ' . MasCompany::MainDB . '.{{user}} AS user ON lead.lead_owner_id=user.id  WHERE lead.enq_date BETWEEN "' . $from_date . '" AND "' . $end_date . '"  ' . $leadextra_cndt . ' GROUP BY user.id')->queryAll();
        $plot = '[';
        foreach ($graph_data_quantity as $m => $eachdata) {
            $color = substr(md5(rand()), 0, 6);
            $plot .= '{label:"' . $eachdata['x_value'] . '", value:"' . $eachdata['y_value'] . '", color: "#' . $color . '"},';
            $lead_graph_details[$m]['slno'] = $m + 1;
            $lead_graph_details[$m]['lead_owner'] = $eachdata['x_value'];
            $lead_graph_details[$m]['lead_count'] = $eachdata['y_value'];
            $lead_graph_details[$m]['lead_color'] = "#" . $color;
            $lead_graph_details[$m]['lead_owner_id'] = $eachdata['OWNERID'];
        }
        $plot .= ']';

        foreach ($lead_graph_details as $key => $value) {
            $rowData[] = array($value['slno'], $value['lead_owner'], $value['lead_count'], $value['lead_color'], $value['lead_owner_id']);
        }
        $data['data'] = $rowData;
        $data['plot'] = $plot;
        echo json_encode($data);
    }

    public function actionLeadGraphOwnerDetails() {

        $owner_id = $_POST['user_id'];
//            $currentYear  = date("Y");
        $from_date = Yii::app()->request->getParam('fromdate');
        $end_date = Yii::app()->request->getParam('todate');
        $from_date = strtotime($from_date);
        $end_date = strtotime($end_date);
        $month = date("m", $from_date);
        $month_1 = date("m", $end_date);
        $year = date("Y", $end_date);
        $leadextra_cndt = '';
        if (Yii::app()->user->authorised_user != 1 && User::isSalesman() == 'Y') {
            $leadextra_cndt = ' AND lead.lead_owner_id=' . Yii::app()->user->id;
        }
        $graph_detail = Yii::app()->db->createCommand('SELECT YEAR(lead.enq_date) as y, MONTH(lead.enq_date) as m, COUNT(lead.id) as TOTAL_COUNT,SUM(lead.value) AS TOTAL_AMT FROM {{lead}} AS lead
                                        WHERE YEAR(lead.enq_date) = "' . $year . '" AND MONTH(lead.enq_date) BETWEEN "' . $month . '" AND "' . $month_1 . '" AND lead.lead_owner_id="' . $owner_id . '" ' . $leadextra_cndt . '  GROUP BY y, m ORDER BY y DESC, m ASC')->queryAll();

        $this->render('lead_owner_details', array('graph_detail' => $graph_detail, 'owner_id' => $owner_id));
    }

    public function actionLeadGetMonthDetails() {

        $owner_id = $_POST['ownerid'];
        $month = $_POST['month'];
        $year = $_POST['year'];
        $currentYear = date("Y");
        $leadextra_cndt = '';
        if (Yii::app()->user->authorised_user != 1 && User::isSalesman() == 'Y') {
            $leadextra_cndt = ' AND lead.lead_owner_id=' . Yii::app()->user->id;
        }
        $graph_detail = Yii::app()->db->createCommand('SELECT lead.id, lead.customer_name, lead.customer_id,lead.value,lead.enq_date,lead.closing_date FROM {{lead}} AS lead
                                                WHERE YEAR(lead.enq_date) = "' . $year . '" AND MONTH(lead.enq_date) = "' . $month . '" AND lead.lead_owner_id="' . $owner_id . '" ' . $leadextra_cndt . ' ')->queryAll();

        $this->render('lead_owner_month_details', array('graph_detail' => $graph_detail, 'month' => $month, 'year' => $year));
    }

    /*     * *********************   End - lead Owner *********************************************************** */
    /*     * *********************   start - lead Country **************************************************** */

    public function actionGetLeadCountryDetail() {
        $lead_graph_details = array();
        $from_date = Yii::app()->request->getParam('fromdate');
        $end_date = Yii::app()->request->getParam('todate');
        $leadextra_cndt = '';
        if (Yii::app()->user->authorised_user != 1 && User::isSalesman() == 'Y') {
            $leadextra_cndt = ' AND lead.lead_owner_id=' . Yii::app()->user->id;
        }
        $graph_data_quantity = Yii::app()->db->createCommand('SELECT COUNT(*) AS qty, customer.customer_emirates_name , COALESCE(emirates.emirates_name, \'Not Specified\') AS label FROM erp_lead AS lead LEFT OUTER JOIN erp_customer AS customer ON lead.customer_id = customer.id LEFT OUTER JOIN erp_mas_emirates_list AS emirates ON customer.customer_emirates_name = emirates.id
                                                        WHERE lead.enq_date BETWEEN "' . $from_date . '" AND "' . $end_date . '"  ' . $leadextra_cndt . '  GROUP BY customer.customer_emirates_name')->queryAll();

        $plot = '[';
        foreach ($graph_data_quantity as $m => $eachdata) {
            $color = substr(md5(rand()), 0, 6);
            $plot .= '{label:"' . $eachdata['x_value'] . '", value:"' . $eachdata['y_value'] . '", color: "#' . $color . '"},';
            $lead_graph_details[$m]['slno'] = $m + 1;
            $lead_graph_details[$m]['lead_country'] = $eachdata['label'];
            $lead_graph_details[$m]['lead_count'] = $eachdata['qty'];
            $lead_graph_details[$m]['lead_color'] = "#" . $color;
            $lead_graph_details[$m]['lead_country_id'] = (int) $eachdata['customer_emirates_name'];
        }
        $plot .= ']';

        foreach ($lead_graph_details as $key => $value) {
            $rowData[] = array($value['slno'], $value['lead_country'], $value['lead_count'], $value['lead_color'], $value['lead_country_id']);
        }
        $data['data'] = $rowData;
        $data['plot'] = $plot;
        echo json_encode($data);
    }

    public function actionLeadGraphCountryDetails() {

        $country_id = $_POST['country_id'];
//            $currentYear  = date("Y");
        $from_date = Yii::app()->request->getParam('fromdate');
        $end_date = Yii::app()->request->getParam('todate');
        $from_date = strtotime($from_date);
        $end_date = strtotime($end_date);
        $month = date("m", $from_date);
        $month_1 = date("m", $end_date);
        $year = date("Y", $end_date);
        $leadextra_cndt = '';
        if (Yii::app()->user->authorised_user != 1 && User::isSalesman() == 'Y') {
            $leadextra_cndt = ' AND lead.lead_owner_id=' . Yii::app()->user->id;
        }
        if (!empty($country_id)) {
            $leadextra_cndt .= ' AND emirates.id = ' . $country_id;
        } else {
            // Not specified groups
            $leadextra_cndt .= ' AND (customer.customer_emirates_name IS NULL OR customer.customer_emirates_name = 0) ';
        }
        $graph_detail = Yii::app()->db->createCommand('SELECT YEAR(lead.enq_date) as y, MONTH(lead.enq_date) as m, COUNT(lead.id) as TOTAL_COUNT,SUM(lead.value) AS TOTAL_AMT  FROM {{lead}} AS lead
                                                        LEFT OUTER JOIN {{customer}} AS customer ON lead.customer_id=customer.id
                                                        LEFT OUTER JOIN {{mas_emirates_list}} AS emirates ON customer.customer_emirates_name=emirates.id
                                                        WHERE YEAR(lead.enq_date) = "' . $year . '" AND MONTH(lead.enq_date) BETWEEN "' . $month . '" AND "' . $month_1 . '"   ' . $leadextra_cndt . ' GROUP BY y, m ORDER BY y DESC, m ASC')->queryAll();

        $this->render('lead_country_details', array('graph_detail' => $graph_detail, 'country_id' => $country_id, 'action' => 'view_country_detail'));
    }

    public function actionLeadGetLeadCountryMonthDetails() {

        $country_id = $_POST['country_id'];
        $month = $_POST['month'];
        $year = $_POST['year'];
        $currentYear = date("Y");
        $leadextra_cndt = '';
        if (Yii::app()->user->authorised_user != 1 && User::isSalesman() == 'Y') {
            $leadextra_cndt = ' AND lead.lead_owner_id=' . Yii::app()->user->id;
        }
        if (!empty($country_id)) {
            $leadextra_cndt .= ' AND emirates.id = ' . $country_id;
        } else {
            // Not specified groups
            $leadextra_cndt .= ' AND (customer.customer_emirates_name IS NULL OR customer.customer_emirates_name = 0) ';
        }

        $graph_detail = Yii::app()->db->createCommand('SELECT lead.id,lead.customer_name, lead.customer_id,lead.value,lead.enq_date,lead.closing_date FROM {{lead}} AS lead
                                                        LEFT OUTER JOIN {{customer}} AS customer ON lead.customer_id=customer.id
                                                        LEFT OUTER JOIN {{mas_emirates_list}} AS emirates ON customer.customer_emirates_name=emirates.id
                                                        WHERE YEAR(lead.enq_date) = "' . $year . '" AND MONTH(lead.enq_date) = "' . $month . '" ' . $leadextra_cndt . ' ')->queryAll();

        $this->render('lead_country_details', array('graph_detail' => $graph_detail, 'action' => 'view_country_month_detail', 'month' => $month, 'year' => $year));
    }

    /*     * *********************   End - lead Country *********************************************************** */
    /*     * *********************   start - lead sales group  **************************************************** */

    public function actionGetLeadSalesGroupDetail() {
        $lead_graph_details = array();
//            $fin_month = Yii::app()->user->fin_year;
//            $year = date('Y');
//            $year_next = $year + 1;
//            if($fin_month == 1){
//                $from_date = $year.'-01-01';
//                $end_date = $year.'-12-31';
//            }else{
//                $from_date = $year.'-04-01';
//                $end_date = $year_next.'-03-31';
//            }
        $from_date = Yii::app()->request->getParam('fromdate');
        $end_date = Yii::app()->request->getParam('todate');
        $leadextra_cndt = '';
        if (Yii::app()->user->authorised_user != 1 && User::isSalesman() == 'Y') {
            $leadextra_cndt = ' AND lead.lead_owner_id=' . Yii::app()->user->id;
        }
        $graph_data_quantity = Yii::app()->db->createCommand('SELECT sales_group.id AS SALES_GROUP_ID, COALESCE(sales_group.group_name , \'Unspecified\') AS x_value,COUNT(lead.id) AS y_value FROM {{lead}} AS lead
                                                        LEFT OUTER JOIN {{mas_sales_group}} AS sales_group ON lead.sales_group_id=sales_group.id
                                                        WHERE lead.enq_date BETWEEN "' . $from_date . '" AND "' . $end_date . '"  ' . $leadextra_cndt . ' GROUP BY sales_group.id')->queryAll();

        $plot = '[';
        foreach ($graph_data_quantity as $m => $eachdata) {
            $color = substr(md5(rand()), 0, 6);
            $plot .= '{label:"' . $eachdata['x_value'] . '", value:"' . $eachdata['y_value'] . '", color: "#' . $color . '"},';
            $lead_graph_details[$m]['slno'] = $m + 1;
            $lead_graph_details[$m]['sales_group'] = $eachdata['x_value'];
            $lead_graph_details[$m]['lead_count'] = $eachdata['y_value'];
            $lead_graph_details[$m]['lead_color'] = "#" . $color;
            $lead_graph_details[$m]['sales_group_id'] = $eachdata['SALES_GROUP_ID'];
        }
        $plot .= ']';

        foreach ($lead_graph_details as $key => $value) {
            $rowData[] = array($value['slno'], $value['sales_group'], $value['lead_count'], $value['lead_color'], $value['sales_group_id']);
        }
        $data['data'] = $rowData;
        $data['plot'] = $plot;
        echo json_encode($data);
    }

    public function actionLeadGraphSalesGroupDetails() {

        $group_id = (int) $_POST['group_id'];
        $from_date = Yii::app()->request->getParam('fromdate');
        $end_date = Yii::app()->request->getParam('todate');
        $from_date = strtotime($from_date);
        $end_date = strtotime($end_date);
        $month = date("m", $from_date);
        $month_1 = date("m", $end_date);
        $year = date("Y", $end_date);

        $leadextra_cndt = '';
        if (Yii::app()->user->authorised_user != 1 && User::isSalesman() == 'Y') {
            $leadextra_cndt = ' AND lead.lead_owner_id=' . Yii::app()->user->id;
        }
        if (empty($group_id)) {
            $leadextra_cndt .= " AND (lead.sales_group_id IS NULL OR lead.sales_group_id = 0 ) ";
        } else {
            $leadextra_cndt .= ' AND sales_group.id="' . $group_id . '"  ';
        }

        $graph_detail = Yii::app()->db->createCommand('SELECT YEAR(lead.enq_date) as y, MONTH(lead.enq_date) as m, COUNT(lead.id) as TOTAL_COUNT,SUM(lead.value) AS TOTAL_AMT FROM {{lead}} AS lead
                                                        LEFT OUTER JOIN {{mas_sales_group}} AS sales_group ON lead.sales_group_id=sales_group.id
                                                        WHERE YEAR(lead.enq_date) = "' . $year . '" AND MONTH(lead.enq_date) BETWEEN "' . $month . '" AND "' . $month_1 . '" ' . $leadextra_cndt . ' GROUP BY y, m ORDER BY y DESC, m ASC')->queryAll();

        $this->render('lead_sales_group_details', array('graph_detail' => $graph_detail, 'group_id' => $group_id, 'action' => 'view_sales_group_detail'));
    }

    public function actionLeadSalesMonthDetails() {

        $group_id = (int) $_POST['group_id'];
        $month = $_POST['month'];
        $year = $_POST['year'];
        $currentYear = date("Y");

        $leadextra_cndt = '';
        if (Yii::app()->user->authorised_user != 1 && User::isSalesman() == 'Y') {
            $leadextra_cndt = ' AND lead.lead_owner_id=' . Yii::app()->user->id;
        }
        // '" AND sales_group.id="' . $group_id . '"  '
        if (empty($group_id)) {
            $leadextra_cndt .= " AND (lead.sales_group_id IS NULL OR lead.sales_group_id = 0) ";
        } else {
            $leadextra_cndt .= " AND lead.sales_group_id =  $group_id ";
        }
        $graph_detail = Yii::app()->db->createCommand('SELECT lead.id, lead.customer_name , lead.customer_id,lead.value,lead.enq_date,lead.closing_date FROM {{lead}} AS lead
                                                        LEFT OUTER JOIN {{mas_sales_group}} AS sales_group ON lead.sales_group_id=sales_group.id
                                                        WHERE YEAR(lead.enq_date) = "' . $year . '" AND MONTH(lead.enq_date) = "' . $month . '"' . $leadextra_cndt . ' ')->queryAll();

        $this->render('lead_sales_group_details', array('graph_detail' => $graph_detail, 'action' => 'view_sales_group_month_detail', 'month' => $month, 'year' => $year));
    }

    /*     * *********************   End - lead sales group **************************************************** */

    /*     * *********************   Start  - Quaotation Part **************************************************** */

    //quotes_graphdetails

    public function actionQuotes_graphdetails() {
        $type = (int) Yii::app()->request->getParam('type');
//        $currentYear  = date("Y");
        $fromdate = Yii::app()->request->getParam('from_date');
        $todate = Yii::app()->request->getParam('end_date');
        $currentYear = date("Y");
        $fromdate = str_replace('/', '-', $fromdate);
        $from_date = date("Y-m-d", strtotime($fromdate));
        $todate = str_replace('/', '-', $todate);
        $end_date = date("Y-m-d", strtotime($todate));
        $month = date("m", strtotime($fromdate));
        $month_1 = date("m", strtotime($todate));
        $year = date("Y", strtotime($todate));
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false);
        if ($type == 1) {
            // Lead owner / account manager
            $graph_data_quantity = Yii::app()->db->createCommand('SELECT CONCAT(user.first_name," ",user.last_name) AS x_value,SUM(quotes.selling_price) AS y_value FROM {{quotation}} AS quotes INNER JOIN ' . MasCompany::MainDB . '.{{user}} AS user ON quotes.lead_owner_id=user.id WHERE quotes.quotation_date BETWEEN "' . $from_date . '" AND "' . $end_date . '"  GROUP BY user.id')->queryAll();
            $plot = '[';
            foreach ($graph_data_quantity as $m => $eachdata) {
                $color = substr(md5(rand()), 0, 6);
                $plot .= '{label:"' . $eachdata['x_value'] . '", value:"' . $eachdata['y_value'] . '", color: "#' . $color . '"},';
            }
            $plot .= ']';
            $this->render('quotes_owner_view', array('plot' => $plot, 'from_date' => $from_date, 'end_date' => $end_date));
        } else if ($type == 2) {


            $graphdata = Yii::app()->db->createCommand('SELECT SUM(quotes.grand_total) AS y_value,emirates.emirates_name AS x_value FROM erp_quotation AS quotes
                                                        INNER JOIN {{customer}} AS customer ON quotes.customer_id=customer.id
                                                        INNER JOIN {{mas_emirates_list}} AS emirates ON customer.customer_emirates_name=emirates.id
                                                        WHERE quotes.quotation_date BETWEEN "' . $from_date . '" AND "' . $end_date . '" GROUP BY customer.customer_emirates_name')->queryAll();

            $plot = '[';
            foreach ($graphdata as $m => $eachdata) {
                $color = substr(md5(rand()), 0, 6);
                $plot .= '{label:"' . $eachdata['x_value'] . '", value:"' . $eachdata['y_value'] . '", color: "#' . $color . '"},';
            }
            $plot .= ']';

            $this->render('quotes_country_view', array('plot' => $plot, 'from_date' => $from_date, 'end_date' => $end_date));
        } else if ($type == 3) {


            $graphdata = Yii::app()->db->createCommand('SELECT sales_group.group_name AS x_value,SUM(quotes.grand_total) AS y_value FROM {{quotes}} AS quotes
                                                        INNER JOIN {{mas_sales_group}} AS sales_group ON quotes.sales_group=sales_group.id
                                                        WHERE quotes.qtn_start_date BETWEEN "' . $from_date . '" AND "' . $end_date . '" GROUP BY sales_group.id')->queryAll();

            $plot = '[';
            foreach ($graphdata as $m => $eachdata) {
                $color = substr(md5(rand()), 0, 6);
                $plot .= '{label:"' . $eachdata['x_value'] . '", value:"' . $eachdata['y_value'] . '", color: "#' . $color . '"},';
            }
            $plot .= ']';

            $this->render('quotes_sales_group_view', array('plot' => $plot, 'from_date' => $from_date, 'end_date' => $end_date));
        } else if ($type == 4) {

            $currentYear = date("Y");
            $currentmonth = date("m");
            if ($year == $currentYear) {
                $month_1 = $currentmonth;
            }
            $data = array();
            $plot_4 = '[';
            for ($k = $month; $k <= $month_1; $k++) {
                $dateObj = DateTime::createFromFormat('!m', $k);
                $monthName = $dateObj->format('F'); // March
                $graphdata3 = Yii::app()->db->createCommand('SELECT count(*) as qty, SUM(selling_price * exchange_rate) AS value FROM erp_quotation  WHERE YEAR(quotation_date) = "' . $year . '" AND MONTH(quotation_date) = "' . $k . '"')->queryAll();

                foreach ($graphdata3 as $eachdata) {
                    $color = substr(md5(rand()), 0, 6);
                    $plot_4 .= '{label:"' . $monthName . '", value:"' . $eachdata['value'] . '", color: "#' . $color . '" },';
                    $data[$k]['month'] = $monthName;
                    $data[$k]['value'] = $eachdata['value'];
                    $data[$k]['qty'] = $eachdata['qty'];
                }
            }
            $plot_4 .= ']';

            $this->render('quotes_year_view', array('plot' => $plot_4, 'data' => $data));
        }
    }

    /*     * *********************   start - Quote Owner **************************************************** */

    public function actionGetQuoteOwnerDetail() {
        $lead_graph_details = array();
        $rowData = [];
//            $fin_month = Yii::app()->user->fin_year;
//            $year = date('Y');
//            $year_next = $year + 1;
//            if($fin_month == 1){
//                $from_date = $year.'-01-01';
//                $end_date = $year.'-12-31';
//            }else{
//                $from_date = $year.'-04-01';
//                $end_date = $year_next.'-03-31';
//            }
        $from_date = Yii::app()->request->getParam('fromdate');
        $end_date = Yii::app()->request->getParam('todate');
        $graph_data_quantity = Yii::app()->db->createCommand('SELECT quotes.lead_owner_id AS OWNERID,CONCAT(user.first_name," ",user.last_name) AS x_value,COUNT(*) AS y_value,SUM(quotes.selling_price * quotes.exchange_rate) AS amount FROM erp_quotation AS quotes INNER JOIN ' . MasCompany::MainDB . '.{{user}} AS user ON quotes.lead_owner_id =user.id WHERE quotes.quotation_date BETWEEN "' . $from_date . '" AND "' . $end_date . '" GROUP BY user.id')->queryAll();
        $plot = '[';
        foreach ($graph_data_quantity as $m => $eachdata) {
            $color = substr(md5(rand()), 0, 6);
            $plot .= '{label:"' . $eachdata['x_value'] . '", value:"' . $eachdata['y_value'] . '", color: "#' . $color . '"},';
            $lead_graph_details[$m]['slno'] = $m + 1;
            $lead_graph_details[$m]['quote_owner'] = $eachdata['x_value'];
            $lead_graph_details[$m]['quote_count'] = $eachdata['y_value'];
            $lead_graph_details[$m]['quote_amount'] = $eachdata['amount'];
            $lead_graph_details[$m]['quote_color'] = "#" . $color;
            $lead_graph_details[$m]['quote_owner_id'] = $eachdata['OWNERID'];
        }
        $plot .= ']';

        foreach ($lead_graph_details as $key => $value) {
            $rowData[] = array($value['slno'], $value['quote_owner'], $value['quote_count'], Yii::app()->numberFormatter->formatCurrency($value['quote_amount'], ""), $value['quote_color'], $value['quote_owner_id']);
        }
        $data['data'] = $rowData;
        $data['plot'] = $plot;
        echo json_encode($data);
    }

    public function actionQuotesGraphOwnerDetails() {

        $owner_id = $_POST['user_id'];
//            $currentYear  = date("Y");
        $from_date = Yii::app()->request->getParam('fromdate');
        $end_date = Yii::app()->request->getParam('todate');
        $from_date = strtotime($from_date);
        $end_date = strtotime($end_date);
        $month = date("m", $from_date);
        $month_1 = date("m", $end_date);
        $year = date("Y", $end_date);
        $graph_detail = Yii::app()->db->createCommand('SELECT YEAR(quotes.quotation_date) as y, MONTH(quotes.quotation_date) as m, COUNT(quotes.id) as TOTAL_COUNT,SUM(selling_price * exchange_rate) AS TOTAL_AMT FROM erp_quotation AS quotes
                                        WHERE YEAR(quotes.quotation_date) = "' . $year . '" AND MONTH(quotes.quotation_date) BETWEEN "' . $month . '" AND "' . $month_1 . '" AND quotes.lead_owner_id="' . $owner_id . '" GROUP BY y, m ORDER BY y DESC, m ASC')->queryAll();

        $this->render('quotes_owner_details', array('graph_detail' => $graph_detail, 'owner_id' => $owner_id, 'action' => 'view_quotes_detail'));
    }

    public function actionQuoteGetMonthDetails() {

        $owner_id = $_POST['ownerid'];
        $month = $_POST['month'];
        $year = $_POST['year'];
        $currentYear = date("Y");

        $graph_detail = Yii::app()->db->createCommand('SELECT quotes.id AS quotes_id,quotes.customer_id, (quotes.selling_price * quotes.exchange_rate) as grand_total ,quotes.quotation_date , C.customer_name FROM erp_quotation AS quotes INNER JOIN {{customer}} AS C ON C.id=customer_id
                                                WHERE YEAR(quotes.quotation_date) = "' . $year . '" AND MONTH(quotes.quotation_date) = "' . $month . '" AND quotes.lead_owner_id="' . $owner_id . '"')->queryAll();

        $this->render('quotes_owner_details', array('graph_detail' => $graph_detail, 'month' => $month, 'year' => $year, 'action' => 'view_country_month_detail'));
    }

    public function actionQuotation_items() {

        $quotesid = $_POST['quotesid'];
        $this->render('view_quotesItems', array('quotesid' => $quotesid));
    }

    /*     * *********************   End - Quote Owner *********************************************************** */
    /*     * *********************   start - Quote Country **************************************************** */

    public function actionGetQuoteCountryDetail() {
        $lead_graph_details = array();
        $from_date = Yii::app()->request->getParam('fromdate');
        $end_date = Yii::app()->request->getParam('todate');

        $graph_data_quantity = Yii::app()->db->createCommand('SELECT emirates.id AS emirates_id,COUNT(*) AS y_value,emirates.emirates_name AS x_value,SUM(quotes.grand_total*quotes.exchange_rate) AS amount  FROM {{quotes}} AS quotes
                                                        INNER JOIN {{customer}} AS customer ON quotes.customer_id=customer.id
                                                        INNER JOIN {{mas_emirates_list}} AS emirates ON customer.customer_emirates_name=emirates.id
                                                        WHERE quotes.qtn_start_date BETWEEN "' . $from_date . '" AND "' . $end_date . '" GROUP BY customer.customer_emirates_name')->queryAll();

        $plot = '[';
        foreach ($graph_data_quantity as $m => $eachdata) {
            $color = substr(md5(rand()), 0, 6);
            $plot .= '{label:"' . $eachdata['x_value'] . '", value:"' . $eachdata['y_value'] . '", color: "#' . $color . '"},';
            $lead_graph_details[$m]['slno'] = $m + 1;
            $lead_graph_details[$m]['quotes_country'] = $eachdata['x_value'];
            $lead_graph_details[$m]['quotes_count'] = $eachdata['y_value'];
            $lead_graph_details[$m]['amount'] = $eachdata['amount'];
            $lead_graph_details[$m]['quotes_color'] = "#" . $color;
            $lead_graph_details[$m]['quotes_country_id'] = $eachdata['emirates_id'];
        }
        $plot .= ']';

        foreach ($lead_graph_details as $key => $value) {
            $rowData[] = array($value['slno'], $value['quotes_country'], $value['quotes_count'], Yii::app()->numberFormatter->formatCurrency($value['amount'], ""), $value['quotes_color'], $value['quotes_country_id']);
        }
        $data['data'] = $rowData;
        $data['plot'] = $plot;
        echo json_encode($data);
    }

    public function actionQuotesGraphCountryDetails() {

        $country_id = $_POST['country_id'];
//            $currentYear  = date("Y");
        $from_date = Yii::app()->request->getParam('fromdate');
        $end_date = Yii::app()->request->getParam('todate');
        $from_date = strtotime($from_date);
        $end_date = strtotime($end_date);
        $month = date("m", $from_date);
        $month_1 = date("m", $end_date);
        $year = date("Y", $end_date);
        $graph_detail = Yii::app()->db->createCommand('SELECT YEAR(quotes.qtn_start_date) as y, MONTH(quotes.qtn_start_date) as m, COUNT(quotes.id) as TOTAL_COUNT,SUM(quotes.grand_total) AS TOTAL_AMT  FROM {{quotes}} AS quotes
                                                        INNER JOIN {{customer}} AS customer ON quotes.customer_id=customer.id
                                                        INNER JOIN {{mas_emirates_list}} AS emirates ON customer.customer_emirates_name=emirates.id
                                                        WHERE YEAR(quotes.qtn_start_date) = "' . $year . '" AND MONTH(quotes.qtn_start_date) BETWEEN "' . $month . '" AND "' . $month_1 . '"  AND emirates.id="' . $country_id . '" GROUP BY y, m ORDER BY y DESC, m ASC')->queryAll();

        $this->render('quotes_country_details', array('graph_detail' => $graph_detail, 'country_id' => $country_id, 'action' => 'view_country_detail'));
    }

    public function actionGetQuoteMonthDetails() {

        $country_id = $_POST['country_id'];
        $month = $_POST['month'];
        $year = $_POST['year'];
        $currentYear = date("Y");

        $graph_detail = Yii::app()->db->createCommand('SELECT quotes.id AS quotes_id,quotes.customer_id,quotes.grand_total,quotes.qtn_start_date,quotes.qtn_close_date,customer_name FROM {{quotes}} AS quotes
                                                        INNER JOIN {{customer}} AS customer ON quotes.customer_id=customer.id
                                                        INNER JOIN {{mas_emirates_list}} AS emirates ON customer.customer_emirates_name=emirates.id
                                                        WHERE YEAR(quotes.qtn_start_date) = "' . $year . '" AND MONTH(quotes.qtn_start_date) = "' . $month . '" AND emirates.id="' . $country_id . '"')->queryAll();

        $this->render('quotes_country_details', array('graph_detail' => $graph_detail, 'action' => 'view_country_month_detail', 'month' => $month, 'year' => $year));
    }

    /*     * *********************   End - Quote Country *********************************************************** */
    /*     * *********************   start - Quote sales group **************************************************** */

    public function actionGetQuotesSalesGroupDetail() {

        $lead_graph_details = array();
        $from_date = Yii::app()->request->getParam('fromdate');
        $end_date = Yii::app()->request->getParam('todate');

        $graph_data_quantity = Yii::app()->db->createCommand('SELECT sales_group.id AS SALES_GROUP_ID,sales_group.group_name AS x_value,COUNT(*) AS y_value,SUM(quotes.grand_total*quotes.exchange_rate) AS amount FROM {{quotes}} AS quotes
                                                        INNER JOIN {{mas_sales_group}} AS sales_group ON quotes.sales_group=sales_group.id
                                                        WHERE quotes.qtn_start_date BETWEEN "' . $from_date . '" AND "' . $end_date . '"  GROUP BY sales_group.id')->queryAll();

        $plot = '[';
        foreach ($graph_data_quantity as $m => $eachdata) {
            $color = substr(md5(rand()), 0, 6);
            $plot .= '{label:"' . $eachdata['x_value'] . '", value:"' . $eachdata['y_value'] . '", color: "#' . $color . '"},';
            $lead_graph_details[$m]['slno'] = $m + 1;
            $lead_graph_details[$m]['sales_group'] = $eachdata['x_value'];
            $lead_graph_details[$m]['quotes_count'] = $eachdata['y_value'];
            $lead_graph_details[$m]['amount'] = $eachdata['amount'];
            $lead_graph_details[$m]['quotes_color'] = "#" . $color;
            $lead_graph_details[$m]['sales_group_id'] = $eachdata['SALES_GROUP_ID'];
        }
        $plot .= ']';

        foreach ($lead_graph_details as $key => $value) {
            $rowData[] = array($value['slno'], $value['sales_group'], $value['quotes_count'], Yii::app()->numberFormatter->formatCurrency($value['amount'], ""), $value['quotes_color'], $value['sales_group_id']);
        }
        $data['data'] = $rowData;
        $data['plot'] = $plot;
        echo json_encode($data);
    }

    public function actionQuoteGraphSalesGroupDetails() {

        $group_id = $_POST['group_id'];
        $currentYear = date("Y");

        $graph_detail = Yii::app()->db->createCommand('SELECT YEAR(quotes.qtn_start_date) as y, MONTH(quotes.qtn_start_date) as m, COUNT(quotes.id) as TOTAL_COUNT,SUM(quotes.grand_total) AS TOTAL_AMT FROM {{quotes}} AS quotes
                                                        INNER JOIN {{mas_sales_group}} AS sales_group ON quotes.sales_group=sales_group.id
                                                        WHERE YEAR(quotes.qtn_start_date) = "' . $currentYear . '" AND sales_group.id="' . $group_id . '" GROUP BY y, m ORDER BY y DESC, m ASC')->queryAll();

        $this->render('quotes_sales_group_details', array('graph_detail' => $graph_detail, 'group_id' => $group_id, 'action' => 'view_sales_group_detail'));
    }

    public function actionQuoteSalesMonthDetails() {

        $group_id = $_POST['group_id'];
        $month = $_POST['month'];
        $year = $_POST['year'];
        $currentYear = date("Y");

        $graph_detail = Yii::app()->db->createCommand('SELECT quotes.id AS quotes_id,quotes.customer_id,quotes.grand_total,quotes.qtn_start_date,quotes.qtn_close_date,customer_name FROM {{quotes}} AS quotes
                                                        INNER JOIN {{mas_sales_group}} AS sales_group ON quotes.sales_group=sales_group.id
                                                         INNER JOIN {{customer}} AS customer ON quotes.customer_id=customer.id
                                                        WHERE YEAR(quotes.qtn_start_date) = "' . $year . '" AND MONTH(quotes.qtn_start_date) = "' . $month . '" AND sales_group.id="' . $group_id . '"')->queryAll();

        $this->render('quotes_sales_group_details', array('graph_detail' => $graph_detail, 'action' => 'view_sales_group_month_detail', 'month' => $month, 'year' => $year));
    }

    /*     * *********************   End - Quote sales group **************************************************** */


    /*     * *********************   Start  - Order Part **************************************************** */

    public function actionorder_graphdetails() {
        $type = (int) Yii::app()->request->getParam('type');
        $currentYear = date("Y");
        $fromdate = Yii::app()->request->getParam('from_date');
        $todate = Yii::app()->request->getParam('end_date');
        $fromdate = str_replace('/', '-', $fromdate);
        $from_date = date("Y-m-d", strtotime($fromdate));
        $todate = str_replace('/', '-', $todate);
        $end_date = date("Y-m-d", strtotime($todate));
        $month = date("m", strtotime($fromdate));
        $month_1 = date("m", strtotime($todate));
        $year = date("Y", strtotime($todate));
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false);
        if ($type == 1) {
            $graph_data_quantity = Yii::app()->db->createCommand('SELECT CONCAT(user.first_name," ",user.last_name) AS x_value,sum(selling_price) AS y_value FROM {{job_order}} AS ord INNER JOIN ' . MasCompany::MainDB . '.{{user}} AS user ON ord.lead_owner_id=user.id  WHERE ord.job_date BETWEEN "' . $from_date . '" AND "' . $end_date . '" GROUP BY user.id')->queryAll();
            $plot = '[';
            foreach ($graph_data_quantity as $m => $eachdata) {
                $color = substr(md5(rand()), 0, 6);
                $plot .= '{label:"' . $eachdata['x_value'] . '", value:"' . $eachdata['y_value'] . '", color: "#' . $color . '"},';
            }
            $plot .= ']';
            $this->render('order_owner_view', array('plot' => $plot, 'from_date' => $from_date, 'end_date' => $end_date));
        } else if ($type == 2) {
            $graphdata = Yii::app()->db->createCommand('SELECT sum(selling_price) AS y_value,emirates.emirates_name AS x_value FROM {{job_order}} AS ord
                                                        INNER JOIN {{customer}} AS customer ON ord.customer_id=customer.id
                                                        INNER JOIN {{mas_emirates_list}} AS emirates ON customer.customer_emirates_name=emirates.id
                                                        WHERE ord.job_date BETWEEN "' . $from_date . '" AND "' . $end_date . '" GROUP BY customer.customer_emirates_name')->queryAll();

            $plot = '[';
            foreach ($graphdata as $m => $eachdata) {
                $color = substr(md5(rand()), 0, 6);
                $plot .= '{label:"' . $eachdata['x_value'] . '", value:"' . $eachdata['y_value'] . '", color: "#' . $color . '"},';
            }
            $plot .= ']';

            $this->render('order_country_view', array('plot' => $plot, 'from_date' => $from_date, 'end_date' => $end_date));
        } else if ($type == 3) {
            $graphdata = Yii::app()->db->createCommand('SELECT mas_transport_type.transport_type AS x_value,sum(selling_price) AS y_value FROM {{job_order}} AS ord
                                                        INNER JOIN {{mas_transport_type}} AS mas_transport_type ON ord.transport_type=mas_transport_type.id
                                                        WHERE ord.job_date BETWEEN "' . $from_date . '" AND "' . $end_date . '" GROUP BY mas_transport_type.id')->queryAll();

            $plot = '[';
            foreach ($graphdata as $m => $eachdata) {
                $color = substr(md5(rand()), 0, 6);
                $plot .= '{label:"' . $eachdata['x_value'] . '", value:"' . $eachdata['y_value'] . '", color: "#' . $color . '"},';
            }
            $plot .= ']';

            $this->render('order_sales_group_view', array('plot' => $plot, 'from_date' => $from_date, 'end_date' => $end_date));
        } else if ($type == 4) {
            $currentYear = date("Y");
            $currentmonth = date("m");
            if ($year == $currentYear) {
                $month_1 = $currentmonth;
            }
            $plot = '[';
            for ($k = $month; $k <= $month_1; $k++) {
                $dateObj = DateTime::createFromFormat('!m', $k);
                $monthName = $dateObj->format('F');
                $graphdata3 = Yii::app()->db->createCommand('SELECT sum(selling_price) AS value FROM {{job_order}}  WHERE YEAR(job_date) = "' . $year . '" AND MONTH(job_date) = "' . $k . '"')->queryAll();
                foreach ($graphdata3 as $eachdata) {
                    $color = substr(md5(rand()), 0, 6);
                    $plot .= '{label:"' . $monthName . '", value:"' . $eachdata['value'] . '", color: "#' . $color . '" },';
                }
            }
            $plot .= ']';

            $this->render('order_year_view', array('plot' => $plot, 'from_date' => $from_date, 'end_date' => $end_date));
        }
    }

    /*     * *********************   start - Order Owner **************************************************** */

    public function actionGetOrderOwnerDetail() {
        $lead_graph_details = array();
        $from_date = Yii::app()->request->getParam('fromdate');
        $end_date = Yii::app()->request->getParam('todate');
        $graph_data_quantity = Yii::app()->db->createCommand('SELECT ord.lead_owner_id AS OWNERID,CONCAT(user.first_name," ",user.last_name) AS x_value,COUNT(*) AS y_value,SUM(ord.selling_price*ord.exchange_rate) AS amount FROM {{job_order}} AS ord INNER JOIN ' . MasCompany::MainDB . '.{{user}} AS user ON ord.lead_owner_id=user.id  WHERE ord.job_date BETWEEN "' . $from_date . '" AND "' . $end_date . '" GROUP BY user.id')->queryAll();
        $plot = '[';
        foreach ($graph_data_quantity as $m => $eachdata) {
            $color = substr(md5(rand()), 0, 6);
            $plot .= '{label:"' . $eachdata['x_value'] . '", value:"' . $eachdata['y_value'] . '", color: "#' . $color . '"},';
            $lead_graph_details[$m]['slno'] = $m + 1;
            $lead_graph_details[$m]['order_owner'] = $eachdata['x_value'];
            $lead_graph_details[$m]['order_count'] = $eachdata['y_value'];
            $lead_graph_details[$m]['amount'] = $eachdata['amount'];
            $lead_graph_details[$m]['order_color'] = "#" . $color;
            $lead_graph_details[$m]['order_owner_id'] = $eachdata['OWNERID'];
        }
        $plot .= ']';

        foreach ($lead_graph_details as $key => $value) {
            $rowData[] = array($value['slno'], $value['order_owner'], $value['order_count'], Yii::app()->numberFormatter->formatCurrency($value['amount'], ""), $value['order_color'], $value['order_owner_id']);
        }
        $data['data'] = $rowData;
        $data['plot'] = $plot;
        echo json_encode($data);
    }

    public function actionOrderGraphOwnerDetails() {

        $owner_id = $_POST['user_id'];
        $from_date = Yii::app()->request->getParam('fromdate');
        $end_date = Yii::app()->request->getParam('todate');
        $graph_detail = Yii::app()->db->createCommand('SELECT YEAR(ord.job_date) as y, MONTH(ord.job_date) as m, COUNT(ord.id) as TOTAL_COUNT,SUM(ord.selling_price) AS TOTAL_AMT FROM {{job_order}} AS ord
                                        WHERE ord.job_date BETWEEN "' . $from_date . '" AND "' . $end_date . '" AND ord.lead_owner_id="' . $owner_id . '" GROUP BY y, m ORDER BY y DESC, m ASC')->queryAll();

        $this->render('order_owner_details', array('graph_detail' => $graph_detail, 'owner_id' => $owner_id, 'action' => 'view_quotes_detail'));
    }

    public function actionOrderGetMonthDetails() {

        $owner_id = $_POST['ownerid'];
        $month = $_POST['month'];
        $year = $_POST['year'];
        $currentYear = date("Y");

        $graph_detail = Yii::app()->db->createCommand('SELECT job_order_id AS order_id,customer_id,selling_price,job_date,origin,destination,lead_owner_id,customer_name,agent,awb_no FROM view_job_order_list
                                                WHERE YEAR(job_date) = "' . $year . '" AND MONTH(job_date) = "' . $month . '" AND lead_owner_id="' . $owner_id . '"')->queryAll();

        $this->render('order_owner_details', array('graph_detail' => $graph_detail, 'month' => $month, 'year' => $year, 'action' => 'view_country_month_detail'));
    }

    /* public function actionQuotation_items(){

      $quotesid  = $_POST['quotesid'];
      $this->render('view_quotesItems', array('quotesid' => $quotesid));
      }

      /***********************   End - order Owner *********************************************************** */
    /*     * *********************   start - order Country **************************************************** */

    public function actionGetOrderCountryDetail() {
        $lead_graph_details = array();
        $from_date = Yii::app()->request->getParam('fromdate');
        $end_date = Yii::app()->request->getParam('todate');

        $graph_data_quantity = Yii::app()->db->createCommand('SELECT emirates.id AS emirates_id,COUNT(*) AS y_value,emirates.emirates_name AS x_value,SUM(ord.selling_price*ord.exchange_rate) AS amount FROM {{job_order}} AS ord
                                                        INNER JOIN {{customer}} AS customer ON ord.customer_id=customer.id
                                                        INNER JOIN {{mas_emirates_list}} AS emirates ON customer.customer_emirates_name=emirates.id
                                                        WHERE ord.job_date BETWEEN "' . $from_date . '" AND "' . $end_date . '" GROUP BY customer.customer_emirates_name')->queryAll();

        $plot = '[';
        foreach ($graph_data_quantity as $m => $eachdata) {
            $color = substr(md5(rand()), 0, 6);
            $plot .= '{label:"' . $eachdata['x_value'] . '", value:"' . $eachdata['y_value'] . '", color: "#' . $color . '"},';
            $lead_graph_details[$m]['slno'] = $m + 1;
            $lead_graph_details[$m]['order_country'] = $eachdata['x_value'];
            $lead_graph_details[$m]['order_count'] = $eachdata['y_value'];
            $lead_graph_details[$m]['amount'] = $eachdata['amount'];
            $lead_graph_details[$m]['order_color'] = "#" . $color;
            $lead_graph_details[$m]['order_country_id'] = $eachdata['emirates_id'];
        }
        $plot .= ']';

        foreach ($lead_graph_details as $key => $value) {
            $rowData[] = array($value['slno'], $value['order_country'], $value['order_count'], Yii::app()->numberFormatter->formatCurrency($value['amount'], ''), $value['order_color'], $value['order_country_id']);
        }
        $data['data'] = $rowData;
        $data['plot'] = $plot;
        echo json_encode($data);
    }

    public function actionOrderCountryDetails() {

        $country_id = $_POST['country_id'];
        $from_date = Yii::app()->request->getParam('fromdate');
        $end_date = Yii::app()->request->getParam('todate');
        $graph_detail = Yii::app()->db->createCommand('SELECT YEAR(job_date) as y, MONTH(job_date) as m, COUNT(job_order_id) as TOTAL_COUNT,SUM(selling_price) AS TOTAL_AMT  FROM view_job_order_list
                                                WHERE job_date BETWEEN "' . $from_date . '" AND "' . $end_date . '" AND emirates_id="' . $country_id . '" GROUP BY y, m ORDER BY y DESC, m ASC')->queryAll();

        /* $graph_detail = Yii::app()->db->createCommand('SELECT YEAR(ord.job_date) as y, MONTH(ord.job_date) as m, COUNT(ord.id) as TOTAL_COUNT,SUM(ord.selling_price) AS TOTAL_AMT  FROM {{job_order}} AS ord
          INNER JOIN {{customer}} AS customer ON ord.customer_id=customer.id
          INNER JOIN {{mas_emirates_list}} AS emirates ON customer.customer_emirates_name=emirates.id
          WHERE ord.job_date BETWEEN "' . $from_date . '" AND "' . $end_date . '" AND emirates.id="' . $country_id . '" GROUP BY y, m ORDER BY y DESC, m ASC')->queryAll(); */

        $this->render('order_country_details', array('graph_detail' => $graph_detail, 'country_id' => $country_id, 'action' => 'view_country_detail'));
    }

    public function actionGetOrderMonthDetails() {

        $country_id = $_POST['country_id'];
        $month = $_POST['month'];
        $year = $_POST['year'];
        $currentYear = date("Y");
        $graph_detail = Yii::app()->db->createCommand('SELECT job_order_id AS order_id,customer_id,selling_price,job_date,origin,destination,lead_owner_id,customer_name,agent,awb_no FROM view_job_order_list
                                                WHERE YEAR(job_date) = "' . $year . '" AND MONTH(job_date) = "' . $month . '" AND emirates_id="' . $country_id . '"')->queryAll();

        /* $graph_detail = Yii::app()->db->createCommand('SELECT ord.id AS order_id,ord.customer_id,ord.selling_price AS grand_total,ord.job_date,customer_name FROM {{job_order}} AS ord
          INNER JOIN {{customer}} AS customer ON ord.customer_id=customer.id
          INNER JOIN {{mas_emirates_list}} AS emirates ON customer.customer_emirates_name=emirates.id
          WHERE YEAR(ord.job_date) = "' . $year . '" AND MONTH(ord.job_date) = "' . $month . '" AND emirates.id="' . $country_id . '"')->queryAll(); */


        $this->render('order_country_details', array('graph_detail' => $graph_detail, 'action' => 'view_country_month_detail', 'month' => $month, 'year' => $year));
    }

    /*     * *********************   start - order sales group **************************************************** */

    public function actionGetOrderSalesGroupDetail() {

        $lead_graph_details = array();
        $from_date = Yii::app()->request->getParam('fromdate');
        $end_date = Yii::app()->request->getParam('todate');
        $graph_data_quantity = Yii::app()->db->createCommand('SELECT mas_transport_type.id AS SALES_GROUP_ID,mas_transport_type.transport_type AS x_value,SUM(ord.selling_price*ord.exchange_rate) AS amount,COUNT(ord.id) as y_value FROM {{job_order}} AS ord
                                                        INNER JOIN {{mas_transport_type}} AS mas_transport_type ON ord.transport_type=mas_transport_type.id
                                                        WHERE ord.job_date BETWEEN "' . $from_date . '" AND "' . $end_date . '"  GROUP BY mas_transport_type.id')->queryAll();

        $plot = '[';
        foreach ($graph_data_quantity as $m => $eachdata) {
            $color = substr(md5(rand()), 0, 6);
            $plot .= '{label:"' . $eachdata['x_value'] . '", value:"' . $eachdata['y_value'] . '", color: "#' . $color . '"},';
            $lead_graph_details[$m]['slno'] = $m + 1;
            $lead_graph_details[$m]['sales_group'] = $eachdata['x_value'];
            $lead_graph_details[$m]['order_count'] = $eachdata['y_value'];
            $lead_graph_details[$m]['amount'] = $eachdata['amount'];
            $lead_graph_details[$m]['order_color'] = "#" . $color;
            $lead_graph_details[$m]['sales_group_id'] = $eachdata['SALES_GROUP_ID'];
        }
        $plot .= ']';

        foreach ($lead_graph_details as $key => $value) {
            $rowData[] = array($value['slno'], $value['sales_group'], $value['order_count'], Yii::app()->numberFormatter->formatCurrency($value['amount'], ""), $value['order_color'], $value['sales_group_id']);
        }
        $data['data'] = $rowData;
        $data['plot'] = $plot;
        echo json_encode($data);
    }

    public function actionOrderSalesGroupDetails() {

        $group_id = $_POST['group_id'];
        $from_date = Yii::app()->request->getParam('fromdate');
        $end_date = Yii::app()->request->getParam('todate');
        $graph_detail = Yii::app()->db->createCommand('SELECT YEAR(job_date) as y, MONTH(job_date) as m, COUNT(job_order_id) as TOTAL_COUNT,SUM(selling_price) AS TOTAL_AMT FROM view_job_order_list
                                                WHERE job_date BETWEEN "' . $from_date . '" AND "' . $end_date . '" AND transport_type="' . $group_id . '" GROUP BY y, m ORDER BY y DESC, m ASC ')->queryAll();

        /* $graph_detail = Yii::app()->db->createCommand('SELECT YEAR(ord.job_date) as y, MONTH(ord.job_date) as m, COUNT(ord.id) as TOTAL_COUNT,SUM(ord.selling_price) AS TOTAL_AMT FROM {{job_order}} AS ord
          INNER JOIN {{mas_sales_group}} AS sales_group ON ord.sales_group=sales_group.id
          WHERE ord.job_date BETWEEN "' . $from_date . '" AND "' . $end_date . '" AND sales_group.id="' . $group_id . '" GROUP BY y, m ORDER BY y DESC, m ASC')->queryAll(); */

        $this->render('order_sales_group_details', array('graph_detail' => $graph_detail, 'group_id' => $group_id, 'action' => 'view_sales_group_detail'));
    }

    public function actionOrderSalesMonthDetails() {

        $group_id = $_POST['group_id'];
        $month = $_POST['month'];
        $year = $_POST['year'];
        $currentYear = date("Y");
        $graph_detail = Yii::app()->db->createCommand('SELECT job_order_id AS order_id,customer_id,selling_price,job_date,origin,destination,lead_owner_id,customer_name,agent,awb_no FROM view_job_order_list
                                                WHERE YEAR(job_date) = "' . $year . '" AND MONTH(job_date) = "' . $month . '" AND transport_type="' . $group_id . '"')->queryAll();

        /* $graph_detail = Yii::app()->db->createCommand('SELECT ord.id AS order_id,ord.customer_id,ord.selling_price AS grand_total,ord.job_date,customer_name FROM {{job_order}} AS ord
          INNER JOIN {{customer}} AS customer ON ord.customer_id=customer.id
          INNER JOIN {{mas_sales_group}} AS sales_group ON ord.sales_group=sales_group.id
          WHERE YEAR(ord.job_date) = "' . $year . '" AND MONTH(ord.job_date) = "' . $month . '" AND sales_group.id="' . $group_id . '"')->queryAll(); */

        $this->render('order_sales_group_details', array('graph_detail' => $graph_detail, 'action' => 'view_sales_group_month_detail', 'month' => $month, 'year' => $year));
    }

    /*     * *********************   End - order sales group **************************************************** */
    /*     * *********************   start - order Items **************************************************** */

    public function actionOrder_items() {

        $orderid = $_POST['orderid'];
        $this->render('view_OrderItems', array('orderid' => $orderid));
    }

    /*     * *********************   End - order Items **************************************************** */


    /*     * *********************   Start  - Invoice Part **************************************************** */

    public function actioninvoice_graphdetails() {
        $type = (int) Yii::app()->request->getParam('type');
        $fromdate = Yii::app()->request->getParam('from_date');
        $todate = Yii::app()->request->getParam('end_date');
        $currentYear = date("Y");
        $fromdate = str_replace('/', '-', $fromdate);
        $from_date = date("Y-m-d", strtotime($fromdate));
        $todate = str_replace('/', '-', $todate);
        $end_date = date("Y-m-d", strtotime($todate));
        $month = date("m", strtotime($fromdate));
        $month_1 = date("m", strtotime($todate));
        $year = date("Y", strtotime($todate));
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false);
        if ($type == 1) {
            //$graph_data_quantity = Yii::app()->db->createCommand('SELECT CONCAT(user.first_name," ",user.last_name) AS x_value,COUNT(*) AS y_value FROM {{quotes}} AS quotes INNER JOIN blueskye_erp_boul_evard_main.{{user}} AS user ON quotes.{{user}}_id=user.id INNER JOIN {{master_file}} AS master_file ON quotes.file_id = master_file.id WHERE master_file.current_process_status = "Q"  GROUP BY user.id')->queryAll();
            /* 'SELECT CONCAT(user.first_name," ",user.last_name) AS x_value,sum(grand_total) AS y_value FROM {{invoice}} AS inv
              INNER JOIN {{master_file}} AS filedetail ON inv.file_id=filedetail.id
              INNER JOIN ' . MasCompany::MainDB . '.{{user}} AS user ON filedetail.lead_owner_id=user.id
              WHERE inv.invoice_date BETWEEN "' . $from_date . '" AND "' . $end_date . '" GROUP BY user.id' */
            $SQL = "SELECT COUNT(transaction_id) AS y_value,lead_owner_id,lead_owner_name AS x_value,IFNULL(SUM(invoice_amount - credit_note_amount),0) AS total_amount FROM `view_invoice_creditnote_details` WHERE (transaction_date BETWEEN '" . $from_date . "' AND '" . $end_date . "') OR transaction_date IS NULL GROUP BY lead_owner_id ORDER BY total_amount DESC";
            // echo $SQL;
            $graph_data_quantity = Yii::app()->db->createCommand($SQL)->queryAll();

            $plot = '[';
            foreach ($graph_data_quantity as $m => $eachdata) {
                $color = substr(md5(rand()), 0, 6);
                $plot .= '{label:"' . $eachdata['x_value'] . '", value:"' . $eachdata['y_value'] . '", color: "#' . $color . '"},';
            }
            $plot .= ']';
            $this->render('invoice_owner_view', array('plot' => $plot, 'fromdate' => $from_date, 'todate' => $end_date));
        } else if ($type == 2) {


            $graphdata = Yii::app()->db->createCommand('SELECT sum(grand_total) AS y_value,emirates.emirates_name AS x_value FROM {{invoice}} AS inv
                                                        INNER JOIN {{customer}} AS customer ON inv.customer_id=customer.id
                                                        INNER JOIN {{mas_emirates_list}} AS emirates ON customer.customer_emirates_name=emirates.id
                                                        WHERE YEAR(inv.invoice_date) = "' . $currentYear . '"  GROUP BY customer.customer_emirates_name')->queryAll();

            $plot = '[';
            foreach ($graphdata as $m => $eachdata) {
                $color = substr(md5(rand()), 0, 6);
                $plot .= '{label:"' . $eachdata['x_value'] . '", value:"' . $eachdata['y_value'] . '", color: "#' . $color . '"},';
            }
            $plot .= ']';

            $this->render('invoice_country_view', array('plot' => $plot, 'fromdate' => $from_date, 'todate' => $end_date));
        } else if ($type == 3) {


            $graphdata = Yii::app()->db->createCommand('SELECT sales_group.group_name AS x_value,SUM(inv.grand_total) AS y_value FROM {{invoice}} AS inv
                                                        INNER JOIN {{mas_sales_group}} AS sales_group ON inv.sales_group=sales_group.id
                                                        WHERE YEAR(inv.invoice_date) = "' . $currentYear . '"  GROUP BY sales_group.id')->queryAll();

            $plot = '[';
            foreach ($graphdata as $m => $eachdata) {
                $color = substr(md5(rand()), 0, 6);
                $plot .= '{label:"' . $eachdata['x_value'] . '", value:"' . $eachdata['y_value'] . '", color: "#' . $color . '"},';
            }
            $plot .= ']';

            $this->render('invoice_sales_group_view', array('plot' => $plot, 'fromdate' => $from_date, 'todate' => $end_date));
        } else if ($type == 4) {
            $currentmonth = date("m");
            if ($year == $currentYear) {
                $month_1 = $currentmonth;
            }
            $plot = '[';
            for ($k = $month; $k <= $month_1; $k++) {
                $dateObj = DateTime::createFromFormat('!m', $k);
                $monthName = $dateObj->format('F');
                $graphdata3 = Yii::app()->db->createCommand('SELECT sum(grand_total) AS value FROM {{invoice}}  WHERE YEAR(invoice_date) = "' . $year . '" AND MONTH(invoice_date) = "' . $k . '"')->queryAll();

                foreach ($graphdata3 as $eachdata) {
                    $color = substr(md5(rand()), 0, 6);
                    $plot .= '{label:"' . $monthName . '", value:"' . $eachdata['value'] . '", color: "#' . $color . '" },';
                }
            }
            $plot .= ']';
            $this->render('invoice_current_year', array('plot' => $plot, 'fromdate' => $from_date, 'todate' => $end_date));
        } else if ($type == 5) {
            $currentmonth = (int) Yii::app()->request->getParam('month');

            $graphdata = Yii::app()->db->createCommand('SELECT invoice_no AS x_value,grand_total AS y_value FROM {{invoice}}
                                                        WHERE YEAR(invoice_date) = "' . $currentYear . '" AND MONTH(invoice_date) = "' . $currentmonth . '"')->queryAll();

            $plot = '[';
            foreach ($graphdata as $m => $eachdata) {
                $color = substr(md5(rand()), 0, 6);
                $plot .= '{label:"' . $eachdata['x_value'] . '", value:"' . $eachdata['y_value'] . '", color: "#' . $color . '"},';
            }
            $plot .= ']';

            $this->render('invoice_monthly', array('plot' => $plot, 'currentmonth' => $currentmonth));
        }
    }

    /*     * *********************   start - Invoice Owner **************************************************** */

    public function actionGetInvoiceOwnerDetail() {
        $lead_graph_details = array();
        $from_date = Yii::app()->request->getParam('fromdate');
        $end_date = Yii::app()->request->getParam('todate');
        /* $graph_data_quantity = Yii::app()->db->createCommand('SELECT filedetail.lead_owner_id AS OWNERID,CONCAT(user.first_name," ",user.last_name) AS x_value,COUNT(*) AS y_value,sum(inv.grand_total) as amount FROM {{invoice}} AS inv
          INNER JOIN {{master_file}} AS filedetail ON inv.file_id=filedetail.id
          INNER JOIN ' . MasCompany::MainDB . '.{{user}} AS user ON filedetail.lead_owner_id=user.id  WHERE inv.invoice_date BETWEEN "' . $from_date . '" AND "' . $end_date . '" GROUP BY user.id')->queryAll(); */


        /* $SQL =  'SELECT user.id AS OWNERID,CONCAT(user.first_name," ",user.last_name) AS x_value,COUNT(inv.id) AS y_value,sum(inv.grand_total) as amount FROM ' . MasCompany::MainDB . '.{{user}} AS user
          LEFT JOIN {{invoice}}  AS inv ON user.id=lead_owner_id AND inv.invoice_date BETWEEN "' . $from_date . '" AND "' . $end_date . '"
          INNER JOIN {{mas_user_group}} AS usergroup ON user.user_group_id=usergroup.id WHERE usergroup.is_salesman = "Y" AND user.isActive= "Y" GROUP BY user.id ORDER BY amount DESC'; */

        /* $SQL ='CREATE OR REPLACE VIEW view_invoice_creditnote_details AS SELECT INV.id AS transaction_id,U.id AS lead_owner_id,CONCAT(U.first_name," ",U.last_name) as lead_owner_name,invoice_date AS transaction_date,(grand_total*INV.exchange_rate) AS invoice_amount,0 AS credit_note_amount
          FROM ' . MasCompany::MainDB . '.erp_user as U
          INNER JOIN erp_mas_user_group AS UG ON UG.id=U.user_group_id
          LEFT JOIN erp_invoice AS INV ON lead_owner_id=U.id WHERE UG.is_salesman = "Y" AND U.isActive= "Y"

          UNION ALL

          SELECT CN.id AS transaction_id,U.id AS lead_owner_id,CONCAT(U.first_name," ",U.last_name) as lead_owner_name,credited_date AS transaction_date, 0 AS invoice_amount,(credited_amount*CN.exchange_rate) AS credit_note_amount
          FROM ' . MasCompany::MainDB . '.erp_user as U
          INNER JOIN erp_mas_user_group AS UG ON  UG.id=U.user_group_id
          LEFT JOIN erp_invoice AS INV ON lead_owner_id=U.id
          LEFT JOIN erp_creditnote AS CN ON CN.invoice_id=INV.id
          WHERE UG.is_salesman = "Y" AND U.isActive= "Y"';


          Yii::app()->db->createCommand($SQL)->execute(); */


        $SQL = "SELECT COUNT(transaction_id) AS y_value,lead_owner_id,lead_owner_name AS x_value,IFNULL(SUM(invoice_amount - credit_note_amount),0) AS total_amount FROM `view_invoice_creditnote_details` WHERE (transaction_date BETWEEN '" . $from_date . "' AND '" . $end_date . "') OR transaction_date IS NULL GROUP BY lead_owner_id ORDER BY total_amount DESC";

        $graph_data_quantity = Yii::app()->db->createCommand($SQL)->queryAll();

        //$graph_data_quantity = Yii::app()->db->createCommand('SELECT CONCAT(user.first_name," ",user.last_name) AS x_value,COUNT(*) AS y_value FROM {{job_order}} AS ord INNER JOIN blueskye_erp_boul_evard_main.{{user}} AS user ON ord.{{user}}_id=user.id INNER JOIN {{master_file}} AS master_file ON ord.file_id = master_file.id WHERE master_file.current_process_status = "O"  GROUP BY user.id')->queryAll();
        $plot = '[';
        foreach ($graph_data_quantity as $m => $eachdata) {
            $color = substr(md5(rand()), 0, 6);
            $plot .= '{label:"' . $eachdata['x_value'] . '", value:"' . $eachdata['y_value'] . '", color: "#' . $color . '"},';
            $lead_graph_details[$m]['slno'] = $m + 1;
            $lead_graph_details[$m]['order_owner'] = $eachdata['x_value'];
            $lead_graph_details[$m]['order_count'] = $eachdata['y_value'];
            $lead_graph_details[$m]['amount'] = $eachdata['total_amount'];
            $lead_graph_details[$m]['order_color'] = "#" . $color;
            $lead_graph_details[$m]['order_owner_id'] = $eachdata['lead_owner_id'];
        }
        $plot .= ']';

        foreach ($lead_graph_details as $key => $value) {
            $rowData[] = array($value['slno'], $value['order_owner'], $value['order_count'], Yii::app()->numberFormatter->formatCurrency($value['amount'], ""), $value['order_color'], $value['order_owner_id']);
        }
        $data['data'] = $rowData;
        $data['plot'] = $plot;
        echo json_encode($data);
    }

    public function actioninvoiceGraphOwnerDetails() {

        $owner_id = $_POST['user_id'];
        $fromdate = Yii::app()->request->getParam('fromdate');
        $todate = Yii::app()->request->getParam('todate');
        $fromdate = str_replace('/', '-', $fromdate);
        $from_date = date("Y-m-d", strtotime($fromdate));
        $todate = str_replace('/', '-', $todate);
        $end_date = date("Y-m-d", strtotime($todate));

        $currentYear = date("Y");

        $graph_detail = Yii::app()->db->createCommand('SELECT YEAR(inv.invoice_date) as y, MONTH(inv.invoice_date) as m, COUNT(inv.id) as TOTAL_COUNT,SUM(inv.grand_total) AS TOTAL_AMT FROM {{invoice}} AS inv
                                                      WHERE inv.invoice_date BETWEEN "' . $from_date . '" AND "' . $end_date . '" AND lead_owner_id="' . $owner_id . '" GROUP BY y, m ORDER BY y DESC, m ASC')->queryAll();

        $this->render('invoice_owner_details', array('graph_detail' => $graph_detail, 'owner_id' => $owner_id, 'action' => 'view_quotes_detail'));
    }

    public function actionInvoiceGetMonthDetails() {

        $owner_id = $_POST['ownerid'];
        $month = $_POST['month'];
        $year = $_POST['year'];
        $currentYear = date("Y");

        $graph_detail = Yii::app()->db->createCommand('SELECT inv.id AS invoice_id,inv.customer_id,inv.grand_total,inv.invoice_date,customer_name FROM {{invoice}} AS inv
                                                    INNER JOIN {{customer}} AS customer ON inv.customer_id=customer.id
                                                    WHERE YEAR(inv.invoice_date) = "' . $year . '" AND MONTH(inv.invoice_date) = "' . $month . '" AND inv.lead_owner_id="' . $owner_id . '"')->queryAll();

        $this->render('invoice_owner_details', array('graph_detail' => $graph_detail, 'month' => $month, 'year' => $year, 'action' => 'view_country_month_detail'));
    }

    /*     * *********************   End - Invoice Owner *********************************************************** */

    /*     * *********************   start - Invoice Country **************************************************** */

    public function actionGetInvoiceCountryDetail() {
        $lead_graph_details = array();
        $from_date = Yii::app()->request->getParam('fromdate');
        $end_date = Yii::app()->request->getParam('todate');
        $graph_data_quantity = Yii::app()->db->createCommand('SELECT emirates.id AS emirates_id,COUNT(*) AS y_value,emirates.emirates_name AS x_value,sum(inv.grand_total) as amount FROM {{invoice}} AS inv
                                                        INNER JOIN {{customer}} AS customer ON inv.customer_id=customer.id
                                                        INNER JOIN {{mas_emirates_list}} AS emirates ON customer.customer_emirates_name=emirates.id
                                                        WHERE inv.invoice_date BETWEEN "' . $from_date . '" AND "' . $end_date . '" GROUP BY customer.customer_emirates_name')->queryAll();

        $plot = '[';
        foreach ($graph_data_quantity as $m => $eachdata) {
            $color = substr(md5(rand()), 0, 6);
            $plot .= '{label:"' . $eachdata['x_value'] . '", value:"' . $eachdata['y_value'] . '", color: "#' . $color . '"},';
            $lead_graph_details[$m]['slno'] = $m + 1;
            $lead_graph_details[$m]['order_country'] = $eachdata['x_value'];
            $lead_graph_details[$m]['order_count'] = $eachdata['y_value'];
            $lead_graph_details[$m]['order_count'] = $eachdata['y_value'];
            $lead_graph_details[$m]['amount'] = $eachdata['amount'];
            $lead_graph_details[$m]['order_color'] = "#" . $color;
            $lead_graph_details[$m]['order_country_id'] = $eachdata['emirates_id'];
        }
        $plot .= ']';

        foreach ($lead_graph_details as $key => $value) {
            $rowData[] = array($value['slno'], $value['order_country'], $value['order_count'], Yii::app()->numberFormatter->formatCurrency($value['amount'], ""), $value['order_color'], $value['order_country_id']);
        }
        $data['data'] = $rowData;
        $data['plot'] = $plot;
        echo json_encode($data);
    }

    public function actioninvoiceCountryDetails() {

        $country_id = $_POST['country_id'];
        $from_date = Yii::app()->request->getParam('fromdate');
        $end_date = Yii::app()->request->getParam('todate');
        $graph_detail = Yii::app()->db->createCommand('SELECT YEAR(inv.invoice_date) as y, MONTH(inv.invoice_date) as m, COUNT(inv.id) as TOTAL_COUNT,SUM(inv.grand_total) AS TOTAL_AMT  FROM {{invoice}} AS inv
                                                        INNER JOIN {{customer}} AS customer ON inv.customer_id=customer.id
                                                        INNER JOIN {{mas_emirates_list}} AS emirates ON customer.customer_emirates_name=emirates.id
                                                        WHERE inv.invoice_date BETWEEN "' . $from_date . '" AND "' . $end_date . '" AND emirates.id="' . $country_id . '" GROUP BY y, m ORDER BY y DESC, m ASC')->queryAll();

        $this->render('invoice_country_details', array('graph_detail' => $graph_detail, 'country_id' => $country_id, 'action' => 'view_country_detail'));
    }

    public function actionGetInvoiceMonthDetails() {

        $country_id = $_POST['country_id'];
        $month = $_POST['month'];
        $year = $_POST['year'];
        $currentYear = date("Y");

        $graph_detail = Yii::app()->db->createCommand('SELECT inv.id AS invoice_id,inv.customer_id,inv.grand_total,inv.invoice_date,customer_name FROM {{invoice}} AS inv
                                                        INNER JOIN {{customer}} AS customer ON inv.customer_id=customer.id
                                                        INNER JOIN {{mas_emirates_list}} AS emirates ON customer.customer_emirates_name=emirates.id
                                                        WHERE YEAR(inv.invoice_date) = "' . $year . '" AND MONTH(inv.invoice_date) = "' . $month . '" AND emirates.id="' . $country_id . '"')->queryAll();

        $this->render('invoice_country_details', array('graph_detail' => $graph_detail, 'action' => 'view_country_month_detail', 'month' => $month, 'year' => $year));
    }

    /*     * *********************   start - invoice sales group **************************************************** */

    public function actionGetInvoiceSalesGroupDetail() {

        $lead_graph_details = array();
//            $currentYear  = date("Y");
        $from_date = Yii::app()->request->getParam('fromdate');
        $end_date = Yii::app()->request->getParam('todate');
        $graph_data_quantity = Yii::app()->db->createCommand('SELECT sales_group.id AS SALES_GROUP_ID,sales_group.group_name AS x_value,SUM(inv.grand_total) AS y_value,COUNT(*) AS inv_count FROM {{invoice}} AS inv
                                                        INNER JOIN {{mas_sales_group}} AS sales_group ON inv.sales_group=sales_group.id
                                                        WHERE inv.invoice_date BETWEEN "' . $from_date . '" AND "' . $end_date . '"  GROUP BY sales_group.id')->queryAll();

        $plot = '[';
        foreach ($graph_data_quantity as $m => $eachdata) {
            $color = substr(md5(rand()), 0, 6);
            $plot .= '{label:"' . $eachdata['x_value'] . '", value:"' . $eachdata['y_value'] . '", color: "#' . $color . '"},';
            $lead_graph_details[$m]['slno'] = $m + 1;
            $lead_graph_details[$m]['sales_group'] = $eachdata['x_value'];
            $lead_graph_details[$m]['amount'] = $eachdata['y_value'];
            $lead_graph_details[$m]['order_count'] = $eachdata['inv_count'];
            $lead_graph_details[$m]['order_color'] = "#" . $color;
            $lead_graph_details[$m]['sales_group_id'] = $eachdata['SALES_GROUP_ID'];
        }
        $plot .= ']';

        foreach ($lead_graph_details as $key => $value) {
            $rowData[] = array($value['slno'], $value['sales_group'], $value['order_count'], Yii::app()->numberFormatter->formatCurrency($value['amount'], ""), $value['order_color'], $value['sales_group_id']);
        }
        $data['data'] = $rowData;
        $data['plot'] = $plot;
        echo json_encode($data);
    }

    public function actionInvoiceSalesGroupDetails() {

        $group_id = $_POST['group_id'];
        $currentYear = date("Y");

        $graph_detail = Yii::app()->db->createCommand('SELECT YEAR(inv.invoice_date) as y, MONTH(inv.invoice_date) as m, COUNT(inv.id) as TOTAL_COUNT,SUM(inv.grand_total) AS TOTAL_AMT FROM {{invoice}} AS inv
                                                        INNER JOIN {{mas_sales_group}} AS sales_group ON inv.sales_group=sales_group.id
                                                        WHERE YEAR(inv.invoice_date) = "' . $currentYear . '" AND sales_group.id="' . $group_id . '" GROUP BY y, m ORDER BY y DESC, m ASC')->queryAll();

        $this->render('invoice_sales_group_details', array('graph_detail' => $graph_detail, 'group_id' => $group_id, 'action' => 'view_sales_group_detail'));
    }

    public function actionInvoiceSalesMonthDetails() {

        $group_id = $_POST['group_id'];
        $month = $_POST['month'];
        $year = $_POST['year'];
        $currentYear = date("Y");

        $graph_detail = Yii::app()->db->createCommand('SELECT inv.id AS invoice_id,inv.customer_id,inv.grand_total,inv.invoice_date,customer_name FROM {{invoice}} AS inv
                                                        INNER JOIN {{mas_sales_group}} AS sales_group ON inv.sales_group=sales_group.id
                                                        INNER JOIN {{customer}} AS customer ON inv.customer_id=customer.id
                                                        WHERE YEAR(inv.invoice_date) = "' . $year . '" AND MONTH(inv.invoice_date) = "' . $month . '" AND sales_group.id="' . $group_id . '"')->queryAll();

        $this->render('invoice_sales_group_details', array('graph_detail' => $graph_detail, 'action' => 'view_sales_group_month_detail', 'month' => $month, 'year' => $year));
    }

    /*     * *********************   End - invoice sales group **************************************************** */
    /*     * *********************   start - invoice Items **************************************************** */

    public function actiongetInvoiceItems() {

        $invoice_id = $_POST['invoice_id'];
        $this->render('view_InvoiceItems', array('invoice_id' => $invoice_id));
    }

    /*     * *********************   End - order Items **************************************************** */

    public function actionGetInvoiceDetail() {

        $lead_graph_details = array();
        $currentYear = date("Y");
        $currentmonth = date("m");
        $from_date = Yii::app()->request->getParam('fromdate');
        $end_date = Yii::app()->request->getParam('todate');
        $month = date("m", strtotime($from_date));
        $month_1 = date("m", strtotime($end_date));
        $year = date("Y", strtotime($end_date));
        if ($year == $currentYear) {
            $month_1 = $currentmonth;
        }
        $m = 1;
        $plot = '[';
        for ($k = $month; $k <= $month_1; $k++) {
            $dateObj = DateTime::createFromFormat('!m', $k);
            $monthName = $dateObj->format('F');
            $graphdata3 = Yii::app()->db->createCommand('SELECT sum(grand_total) AS value,count(id) as inv_count FROM {{invoice}}  WHERE YEAR(invoice_date) = "' . $year . '" AND MONTH(invoice_date) = "' . $k . '"')->queryAll();

            foreach ($graphdata3 as $eachdata) {
                $color = substr(md5(rand()), 0, 6);
                $plot .= '{label:"' . $monthName . '", value:"' . $eachdata['value'] . '", color: "#' . $color . '" },';
                $invoice_color = "#" . $color;
                $rowData[] = array($m++, $monthName, $eachdata['inv_count'], Yii::app()->numberFormatter->formatCurrency($eachdata['value'], ""), $k, $year, $invoice_color);
            }
        }
        $plot .= ']';
//            $graph_data_quantity = Yii::app()->db->createCommand('SELECT invoice_no AS x_value,grand_total AS y_value,invoice_date FROM {{invoice}}  WHERE YEAR(invoice_date) = "'.$currentYear.'"')->queryAll();
//            $plot = '[';
//           foreach($graph_data_quantity as  $m=>$eachdata ){
//                $color = substr(md5(rand()), 0, 6);
//                $plot .= '{label:"'.$eachdata['x_value'].'", value:"'.$eachdata['y_value'].'", color: "#'.$color.'"},';
//                $lead_graph_details[$m]['slno']=$m+1;
//                $lead_graph_details[$m]['invoice_no']=$eachdata['x_value'];
//                $lead_graph_details[$m]['invoice_amount']=$eachdata['y_value'];
//                $lead_graph_details[$m]['invoice_date']=$eachdata['invoice_date'];
//                $lead_graph_details[$m]['invoice_color']="#".$color;
//            }
//            $plot .= ']';
//
//            foreach ($lead_graph_details as $key => $value) {
//                $rowData[]=array($value['slno'],$value['invoice_no'],date('d/m/Y', strtotime($value['invoice_date'])),$value['invoice_amount'],$value['invoice_color']);
//            }
        $data['data'] = $rowData;
        $data['plot'] = $plot;
        echo json_encode($data);
    }

    public function actionGetMonthlyInvoice() {

        $lead_graph_details = array();
        $currentYear = date("Y");

        $currentmonth = $_POST['month'];
        $graph_data_quantity = Yii::app()->db->createCommand('SELECT invoice_no AS x_value,grand_total AS y_value,invoice_date FROM {{invoice}}  WHERE YEAR(invoice_date) = "' . $currentYear . '" AND MONTH(invoice_date) = "' . $currentmonth . '"')->queryAll();
        $plot = '[';
        foreach ($graph_data_quantity as $m => $eachdata) {
            $color = substr(md5(rand()), 0, 6);
            $plot .= '{label:"' . $eachdata['x_value'] . '", value:"' . $eachdata['y_value'] . '", color: "#' . $color . '"},';
            $lead_graph_details[$m]['slno'] = $m + 1;
            $lead_graph_details[$m]['invoice_no'] = $eachdata['x_value'];
            $lead_graph_details[$m]['invoice_amount'] = $eachdata['y_value'];
            $lead_graph_details[$m]['invoice_date'] = $eachdata['invoice_date'];
            $lead_graph_details[$m]['invoice_color'] = "#" . $color;
        }
        $plot .= ']';

        foreach ($lead_graph_details as $key => $value) {
            $rowData[] = array($value['slno'], $value['invoice_no'], date('d/m/Y', strtotime($value['invoice_date'])), $value['invoice_amount'], $value['invoice_color']);
        }
        $data['data'] = $rowData;
        $data['plot'] = $plot;
        echo json_encode($data);
    }

    public function actionInvoiceYear() {

        $month = $_POST['month'];
        $year = $_POST['year'];
        $model_invoice = Yii::app()->db->createCommand('SELECT id AS invoice_id,invoice_no,grand_total,invoice_date FROM {{invoice}}  WHERE YEAR(invoice_date) = "' . $year . '" AND MONTH(invoice_date) = "' . $month . '"')->queryAll();
        $this->render('invoice_details_month', array('model_invoice' => $model_invoice));
    }

    public function actionGetOrderDetail() {

        $lead_graph_details = array();
        $currentYear = date("Y");
        $currentmonth = date("m");
        $from_date = Yii::app()->request->getParam('fromdate');
        $end_date = Yii::app()->request->getParam('todate');
        $month = date("m", strtotime($from_date));
        $month_1 = date("m", strtotime($end_date));
        $year = date("Y", strtotime($end_date));
        if ($year == $currentYear) {
            $month_1 = $currentmonth;
        }
        $m = 1;
        $plot = '[';
        for ($k = $month; $k <= $month_1; $k++) {
            $dateObj = DateTime::createFromFormat('!m', $k);
            $monthName = $dateObj->format('F');
            $graphdata3 = Yii::app()->db->createCommand('SELECT count(id) as x_value,sum(selling_price*exchange_rate) AS value FROM {{job_order}}  WHERE YEAR(job_date) = "' . $year . '" AND MONTH(job_date) = "' . $k . '"')->queryAll();

            foreach ($graphdata3 as $eachdata) {
                $color = substr(md5(rand()), 0, 6);
                $plot .= '{label:"' . $monthName . '", value:"' . $eachdata['x_value'] . '", color: "#' . $color . '" },';
                $invoice_color = "#" . $color;
                $rowData[] = array($m++, $monthName, $eachdata['x_value'], Yii::app()->numberFormatter->formatCurrency($eachdata['value'], ""), $k, $year, $invoice_color);
            }
        }
        $plot .= ']';
        $data['data'] = $rowData;
        $data['plot'] = $plot;
        echo json_encode($data);
    }

    public function actionOrderYear() {

        $month = $_POST['month'];
        $year = $_POST['year'];
        $model_order = Yii::app()->db->createCommand('SELECT job_order_id AS order_id,customer_id,selling_price,job_date,origin,destination,lead_owner_id,customer_name,agent,awb_no FROM view_job_order_list
                                                WHERE YEAR(job_date) = "' . $year . '" AND MONTH(job_date) = "' . $month . '"')->queryAll();
        $this->render('order_details_month', array('model_order' => $model_order));
    }

//
//       public function actionloadInvoicesMtdGraph(){
//            $currentYear  = date("Y");
//            $currentmonth  =$_POST['month'];
//            $graphdata4 = Yii::app()->db->createCommand('SELECT CONCAT(user.first_name," ",user.last_name) AS lead_ownername,user.id AS leadowner_id FROM {{invoice}} AS inv
//                                                           INNER JOIN {{master_file}} AS filedetail ON inv.file_id=filedetail.id
//                                                        INNER JOIN '.MasCompany::MainDB.'.{{user}} AS user ON filedetail.lead_owner_id=user.id
//                                                        WHERE YEAR(inv.invoice_date)="'.$currentYear.'" AND MONTH(inv.invoice_date)="'.$currentmonth.'" GROUP BY user.id')->queryAll();
//
//            $plot = '{ "xScale" : "ordinal", "yScale": "linear",  "main":[{ "className": ".pizza","data": [';
//
//
//            foreach($graphdata4 as $eachdata ){
//                    $total  =Yii::app()->db->createCommand('SELECT  sum(inv.grand_total) FROM {{invoice}} AS inv
//                                                               INNER JOIN {{master_file}} AS filedetail ON inv.file_id=filedetail.id
//                                                            INNER JOIN '.MasCompany::MainDB.'.{{user}} AS user ON filedetail.lead_owner_id=user.id
//                                                            WHERE YEAR(inv.invoice_date)="'.$currentYear.'" AND MONTH(inv.invoice_date)="'.$currentmonth.'" AND user.id="'.$eachdata['leadowner_id'].'"')->queryScalar();
//                    $plot .= '{"x":"'.$eachdata['lead_ownername'].'", "y":'.$total.'},';
//            }
//
//            $plot .= ']';
//            $plot .= ' }]';
//            $plot .= ' };';
//           $data['plot'] = $plot;
//           echo json_encode($data);
//     }
    public function actionloadInvoicesMtdGraph() {
        $month = explode("-", $_POST['month']);
        $currentyear = $month[0];
        $currentmonth = $month[1];
        $this->render('invoice_mtd_graph', array('currentyear' => $currentyear, 'currentmonth' => $currentmonth));
    }

    public function actionloadOrderMtdGraph() {
        $month = explode("-", $_POST['month']);
        $currentyear = $month[0];
        $currentmonth = $month[1];
        $this->render('order_mtd_graph', array('currentyear' => $currentyear, 'currentmonth' => $currentmonth));
    }

    //  public function actionCurrent_stock_details(){
    //     $query = 'SELECT G.brand AS brand, G.stock_value AS quantity FROM (SELECT
    //     B.product_class AS brand,
    //     SUM(P.quantity) * S.rate AS stock_value
    //     FROM crm_product_location P LEFT JOIN crm_store S ON S.id = P.stock_id
    //     LEFT JOIN crm_product_class B ON S.brand_class_id = B.id GROUP BY S.id ) AS G GROUP BY G.brand';
    // $graphdata4 = Yii::app()->db->createCommand($query)->queryAll();
    //     $plot = '[';
    //     foreach($graphdata4 as $eachdata ){
    //         $color = substr(md5(rand()), 0, 6);
    //         $plot .= '{label:"'.$eachdata['brand'].'", value:"'.$eachdata['quantity'].'", color: "#'.$color.'"},';
    //     }
    //     $plot .= ']';
    //      $this->render('stock_details_view', array('plot' => $plot,'graphdata4' => $graphdata4));
    //  }
    public function actionFollowUps() {
        $this->render('reminder_index');
    }

    public function actionGetLeadOwnerSales() {
        $from_date = Yii::app()->request->getparam("from_date");
        $to_date = Yii::app()->request->getparam("to_date");
        $this->render('lead_owner_todays_sales', array('from_date' => $from_date, 'to_date' => $to_date));
    }

    public function actionGetreceiptall() {
        $from_date = Yii::app()->request->getparam("from_date");
        $to_date = Yii::app()->request->getparam("to_date");
        $this->render('total_receipts', array('from_date' => $from_date, 'to_date' => $to_date));
    }

    public function actionGetpaymentall() {
        $from_date = Yii::app()->request->getparam("from_date");
        $to_date = Yii::app()->request->getparam("to_date");
        $this->render('total_payments', array('from_date' => $from_date, 'to_date' => $to_date));
    }

    public function actionGetTotalsByAccountPayables() {
        $from_date = Yii::app()->request->getparam("from_date");
        $to_date = Yii::app()->request->getparam("to_date");
        $this->render('total_account_payables', array('from_date' => $from_date, 'to_date' => $to_date));
    }

    public function actionGetTotalsByAccountReceivables() {
        $from_date = Yii::app()->request->getparam("from_date");
        $to_date = Yii::app()->request->getparam("to_date");
        $this->render('total_account_receivables', array('from_date' => $from_date, 'to_date' => $to_date));
    }

    public function actionGetTotalsByPurcahseOrders() {
        $from_date = Yii::app()->request->getparam("from_date");
        $to_date = Yii::app()->request->getparam("to_date");
        $this->render('total_purchase_order_list', array('from_date' => $from_date, 'to_date' => $to_date));
    }

    public function actionGetTotalsByPurchaseInvoices() {
        $from_date = Yii::app()->request->getparam("from_date");
        $to_date = Yii::app()->request->getparam("to_date");
        $this->render('total_purchase_invoice_list', array('from_date' => $from_date, 'to_date' => $to_date));
    }

    public function actionGetTotalsBySalesOrders() {
        $from_date = Yii::app()->request->getparam("from_date");
        $to_date = Yii::app()->request->getparam("to_date");
        $this->render('total_sales_order_list', array('from_date' => $from_date, 'to_date' => $to_date));
    }

    public function actionGetTotalsBySalesInvoices() {
        $from_date = Yii::app()->request->getparam("from_date");
        $to_date = Yii::app()->request->getparam("to_date");
        $this->render('total_sales_invoice_list', array('from_date' => $from_date, 'to_date' => $to_date));
    }

    public function actionGetTotalsBySalesLeads() {
        $from_date = Yii::app()->request->getparam("from_date");
        $to_date = Yii::app()->request->getparam("to_date");
        $this->render('total_sales_leads_list', array('from_date' => $from_date, 'to_date' => $to_date));
    }

    public function actionGetTotalsBySalesQuotes() {
        $from_date = Yii::app()->request->getparam("from_date");
        $to_date = Yii::app()->request->getparam("to_date");
        $this->render('total_sales_quotes_list', array('from_date' => $from_date, 'to_date' => $to_date));
    }

    public function actionGetProfitCustomerList() {
        $this->render('profit_customer_list');
    }

    public function actionGetProfitLeadOwnerList() {
        $this->render('profit_lead_owner_list');
    }

    public function actionGetInvoiceCustomerList() {
        $this->render('top_invoice_customer_list');
    }

    public function actionTarget() {
        $this->render('target_table');
    }

    public function actionMonthlyprovisonal() {
        $this->render('monthly_provisional');
    }

    public function actionJoLeaddetails() {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('jo_lead_details');
    }

    public function actionJomonthdetails() {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('jo_month_details');
    }
    public function actionMonthlySalesTarget() {
        $month = Yii::app()->request->getparam("month");
        $year = Yii::app()->request->getparam("year");
        if($month=='' && $year==''){
            $month = (int) date("m");
            $current_year = (int) date("Y");
        }
        $this->render('monthly_sales_target',array('sel_year'=>$year,'sel_month'=>$month));
    }

}
