<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("deleteWarehouse", "function deleteWarehouse(id){
    var r = confirm('Are you sure to delete this?');
        if(r==true)
        {
            jQuery.ajax({
              'type'  : 'post',
              'data'  : 'id=' + id,
              'url'  : $('#liveSite').val()+'index.php?r=warehouse/deleteWarehouse',
              'cache': false,
              'success':function(data){
                if(data=='fail'){
                   t8.error('Warehouse used in Inventory, Deletion failed!');
                }else {
                    location.href=$('#liveSite').val()+'index.php?r=warehouse/index';
                    t8.success('Warehouse Deleted!');
                }
               }
            });
        }

   
};", CClientScript::POS_HEAD);

$cs = Yii::app()->getClientScript();
$baseUrl = Yii::app()->baseUrl;

$cs->registerScript("loadWarehouse", '
        $(document).ready(function() {

        var table_id ="#tbl_warehouse_details";
        var table = $(table_id).DataTable({
         "columnDefs": [ { 
                                "targets": [3],  
                                  "visible": false,
                                   }  ], 
          "rowCallback": function ( row, data ) {
                           if ( data[3] == "Y" )  {  
                                $("td", row).addClass("bg-payment");

                              }else{
                                  $("td", row).addClass("bg-test");
                              }    
                  },            

            scrollY         : "380px",
           // scrollX         : "true",
           // scrollCollapse  : true,
            pageLength      : 50,
			processing: true,
            ajax: {
                url: "' . Yii::app()->createUrl('warehouse/GetWarehouseList') . '",
                type: "POST",
                cache : false,
            },
            serverSide:     true,
            fixedColumns:   true,
			processing: true,
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            }
        } );
        $(".dataTables_scrollFoot").hide();
    });', CClientScript::POS_HEAD);
?>
<section class="panel">
    <header class="panel-heading clearfix panel-theame">
        <i class="material-icons">domain</i> WAREHOUSE
        <div class="pull-right">
            <?php if (Yii::app()->user->authorised_user == 1) { ?>

                <button class="btn btn-sm btn-theme" onclick="loadPopupModal('warehouse/create', 'Add New Warehouse', 'lg')"><i class="fa fa-plus"></i> ADD</button>
            <?php } ?>
        </div>
    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_warehouse_details">
                <thead>
                    <tr>
                        <th>Sl.No</th>
                        <th>Warehouse</th>
                        <th>Actions</th>


                    </tr>
                </thead>
                <tfoot>
                    <tr>
                        <th>Sl.No</th>
                        <th>Warehouse</th>
                        <th>Action</th>

                    </tr>
                </tfoot>
            </table>
        </div>
    </div>
</section>
