<?php
$cs = Yii::app()->getClientScript();
$baseUrl = Yii::app()->baseUrl;
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'excel-upload-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
    ));


?>
         

<div class="row">
<ul class="clearfix form-ul material">
    <li class="col-sm-6">
        <?php echo $form->hiddenField($model, 'id');?>					
        <?php echo $form->textField($model, 'pricing_group',array('data-label'=>'Pricing Group <span style="color:red;">*<span> ')); ?>
        <?php echo $form->error($model,'pricing_group'); ?>
    </li>
    <li class="col-sm-6">  
                <?php echo $form->labelEx($model,'price_list_file_name',array('label'=>'Document <span style="color:red;"><span>'));?>
                <?php echo $form->hiddenField($model,'price_list_file_name'); ?>
                    <?php
                    $allowedExtensions = array("csv");
                    $this->widget('ext.EAjaxUpload.EAjaxUpload', array(
                        'id' => rand(),
                        'config' => array(
                            'action' => Yii::app()->createUrl(Yii::app()->controller->id . '/upload',
                                array('folder' => 'uploads/pricelist')),
                            'multiple' => false,
                            'allowedExtensions' => $allowedExtensions,
                            'sizeLimit' => 8 * 1024 * 1024,
                            'onStart' => "js:function(){}",
                            'class' => 'pull-right',
                            'onComplete' => "js:function(id, fileName, responseJSON){
                                 $('#PricingGroup_price_list_file_name').val(responseJSON.filename);
                                $('.qq-upload-list').html(responseJSON.filename);
                            }",
                            )));
                    
                    if($model->id>0 && $model->price_list_file_name!=""){
                ?>
                
                <div><span style="color:red;"><?php echo $model->price_list_file_name;?></span></div>
                <?php 
                    }
                ?>
                      
       
    </li>
    <li class="col-sm-6">        
        <?php echo $form->dropDownList($model, 'default_pricing_group',array('N'=>'No','Y'=>'Yes'),array('data-label'=>'Want to make it As Default?<span style="color:red;">*<span> ')); ?>
        <?php echo $form->error($model,'default_pricing_group'); ?>
    </li>
    
    <li class="col-sm-6">        
        <?php echo $form->textArea($model, 'description',array('data-label'=>'Description')); ?>
        <?php echo $form->error($model,'description'); ?>
    </li>
     <li class="col-sm-6">
        <?php echo CHtml::link("<i class='fa fa-download'></i> Download Format", Yii::app()->createUrl('salespricinggroup/DownloadSalesPriceBrandClassList'),array('class'=>'btn btn-link')); ?>
     </li>
</ul>
</div>
<div class="modal-footer">
         <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>        
     
        <?php
               $url = Yii::app()->createUrl('salespricinggroup/SaveSalesPricingGroupBrandClass');
                echo CHtml::ajaxSubmitButton('Save', $url, array(
                            'dataType' => 'json',
                            'type' => 'post',
                            'success' => 'function(data) {
                                var id= data.id;
                                if(data.status=="success"){  
                                     t8.success("Saved Successfully!");
                                     $(".x.close").click();
                                     reloadTable("#tbl_salesgroup");
//                                     location.reload();
                                } else { 
                                    $("#excel-upload-form .enquiry-save-btn").prop("disabled", false);
                                    $("#excel-upload-form .enquiry-save-btn").removeClass("btn_loading").addClass("btn-theme");
                                     $.each(data, function(key, val) {
                                            $("#excel-upload-form #"+key+"_em_").text(val).show(); 
                                            t8.error(""+val+""); 
                                        }); 
                                } 
                            }',
                            'beforeSend' => 'function(){
                                $("#excel-upload-form .enquiry-save-btn").prop("disabled", true);                                
                                $("#excel-upload-form .enquiry-save-btn").removeClass("btn-theme").addClass("btn_loding");
                                
                                var file         = $("#SalesPriceGroup_sales_price_group_file_name").val();
                                if(file==""){
                                    t8.error("Please Upload a csv file"); 
                                    return false;
                                }

                               $(".toast8-error").hide();
                            }',
                            'complete' => 'function(){
                                
                            }'
                                
                    ), array('id' => 'mybtn' . rand(), 'class' => 'enquiry-save-btn btn btn-theme'));
          
    ?>
             <?php //} ?>   
    </div>


<?php $this->endWidget(); ?>
