<?php

class RequisitionController extends Controller
{
	public $layout = 'layout';
	public function accessRules() {
		return array(
				array('allow', // allow all users to perform 'index' and 'view' actions
						'actions' => array('login', 'error', 'logout', 'Forgotpassword', 'Recover', 'companyFieldDetails'),
						'users' => array('*'),
				),
				array('allow', // allow authenticated user to perform 'create' and 'update' actions
						'actions' => array('Index','Create','SaveRequisition','GetRequisitionList','GetProducts','UploadProfilePhoto','DeleteRequisitionItem','GetDocumentList','PrintRequistionReportPDF','CreateNote','SaveNote','GetNotesList'),
						'expression' => '$user->isMember()',
				),
				array('deny', // deny all users
						'users' => array('*'),
				),
		);
	}
	
	public function filters() {
		return array('accessControl'); // perform access control for CRUD operations
	}
	
	
	public function actionIndex()
	{
		$this->render('index');
        }
        public function actionCreate()
        {  
            $model = new PurchasingRequisition();
            $modelRequisitionItems = array(new PurchasingRequisitionStockItem);
            $modelDocument = new Document();
            $modelNotes = new FileNotes();
            $modelVendor = new Vendor();
            $modelMaster =  new MasterFile();
            $modelNonStock = array(new PurchasingRequisitionNonStockItem);
            $id = (int) Yii::app()->request->getParam('id');
             if ($id > 0) {
                $model = $model->findByPk($id);
                $modelRequisitionItems = PurchasingRequisitionStockItem::model()->findAll(array('condition'=>'t.purchasing_requisition_id = "'.$id.'"'));
               // $modelRequisitionItems->stock_item_quantity = 1;

                if(empty($modelRequisitionItems))
                {
                    $modelRequisitionItems = array(new PurchasingRequisitionStockItem);
                }
                $modelMaster = MasterFile::model()->find(array('condition'=>'t.id = "'.$model->file_id.'"'));
            }
             if ($id > 0) {
              //  $model = $model->findByPk($id);
                $modelNonStock = PurchasingRequisitionNonStockItem::model()->findAll(array('condition'=>'t.purchasing_requisition_id = "'.$id.'"'));
                if(empty($modelNonStock))
                {
                    $modelNonStock = array(new PurchasingRequisitionNonStockItem);
                }
                $modelMaster = MasterFile::model()->find(array('condition'=>'t.id = "'.$model->file_id.'"'));
            }
            
            Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->render('create', array('model' => $model,'modelMaster'=>$modelMaster,'modelRequisitionItems'=>$modelRequisitionItems,'modelDocument'=>$modelDocument,'modelNonStock'=>$modelNonStock,'modelVendor'=>$modelVendor,'modelNotes'=>$modelNotes,'id' => $id));
        }
         function actionSaveRequisition() {
           
                                $model = new PurchasingRequisition();
                                $modelMaster = new MasterFile();
                                $modelDocument = new Document();
                                $modelNonStock = new PurchasingRequisitionNonStockItem();
                                $modelNotes = new FileNotes();
            /*         * ********** START Code for Save ************** */
            if (isset($_POST['PurchasingRequisition'])) 
                               {
                                if ((int) @$_POST['MasterFile']['id'] > 0) 
                                {
                                $id = (int) @$_POST['MasterFile']['id'];
                                $modelMaster = $modelMaster->findByPk($id);
                                } 
                            else 
                                {
                                $model->vendor_id=$_POST['PurchasingRequisition']['customer_id'];
                                $modelMaster->customer_id = $_POST['PurchasingRequisition']['customer_id'];
                                $modelMaster->crm_user_id = Yii::app()->user->id;
                                $modelMaster->save(false);
                                }

                if ((int) @$_POST['PurchasingRequisition']['id'] > 0) {
                    $model->id = (int) $_POST['PurchasingRequisition']['id'];
                    $model = $model->findByPK($model->id);
                    $model->updated_by = Yii::app()->user->id;
                    $model->updated_datetime = date('Y-m-d h:i:s');
                } else {
                    $model->crm_user_id = Yii::app()->user->id;
                    $model->created_by = Yii::app()->user->id;
                    $model->created_datetime = date('Y-m-d h:i:s');
                }
                $model->connected_file = $_POST['PurchasingRequisition']['connected_file'];
                $model->attributes = $_POST['PurchasingRequisition'];
                $model->file_id = $modelMaster->id;
                if ($_POST['PurchasingRequisition']['requisition_date'] != '' && $_POST['PurchasingRequisition']['requisition_date'] != '0000-00-00') {
                       $model->requisition_date = str_replace('/', '-', $_POST['PurchasingRequisition']['requisition_date']);
                       $model->requisition_date = date("Y-m-d h:i", strtotime($model->requisition_date));
                }
                if ($_POST['PurchasingRequisition']['required_date'] != '' && $_POST['PurchasingRequisition']['required_date'] != '0000-00-00') {
                       $model->required_date = str_replace('/', '-',$_POST['PurchasingRequisition']['required_date']);
                       $model->required_date = date("Y-m-d h:i", strtotime($model->required_date));
                }
                if ($model->save()) {  
                    
                     if (!empty($_POST['PurchasingRequisitionStockItem'])) {

                         foreach ($_POST['PurchasingRequisitionStockItem'] as $k => $rowItem) {
                           if(empty($rowItem['id']))
                           {
                                $modelPurchaseReqItem[$k] = new PurchasingRequisitionStockItem();
                           }else{
                               $modelPurchaseReqItem[$k] = PurchasingRequisitionStockItem::model()->findByPk($rowItem['id']);
        
                           }
                            $modelPurchaseReqItem[$k]->purchasing_requisition_id = $model->id;
                            $modelPurchaseReqItem[$k]->stock_item_id = $rowItem['stock_item_id'];
                            $modelPurchaseReqItem[$k]->stock_item_quantity = $rowItem['stock_item_quantity'];
                            $modelPurchaseReqItem[$k]->stock_item_name = $rowItem['stock_item_name'];
                            $modelPurchaseReqItem[$k]->stock_item_description = $rowItem['stock_item_description'];
                            $modelPurchaseReqItem[$k]->stock_item_unit = $rowItem['stock_item_unit']; 
                            $modelPurchaseReqItem[$k]->save(false);
                         }
                     }  
                      if (!empty($_POST['PurchasingRequisitionNonStockItem'])) 
                        {   
//                          print_r($_POST['PurchasingRequisitionNonStockItem']);die;
                          foreach ($_POST['PurchasingRequisitionNonStockItem'] as $k => $rowItem) {
                           if(empty($rowItem['id']))
                           {
                                $modelNonStock = new PurchasingRequisitionNonStockItem();
                           }else{
                               $modelNonStock = PurchasingRequisitionNonStockItem::model()->findByPk($rowItem['id']);
        
                           }
                            $modelNonStock->purchasing_requisition_id = $model->id;
                            $modelNonStock->non_stock_item_quantity = $rowItem['non_stock_item_quantity'];
                            $modelNonStock->non_stock_item_name = $rowItem['non_stock_item_name'];
                            $modelNonStock->non_stock_item_description = $rowItem['non_stock_item_description'];
                            $modelNonStock->non_stock_item_unit = $rowItem['non_stock_item_unit']; 
                            $modelNonStock->save(false);
                         }
                      
                                 
                      }
//                     
                      
                      
                      
                      
                      
                }
                
                
                 if (!empty($_POST['FileNotes'])) 
                        {   
                       if ((int) @$_POST['FileNotes']['id'] > 0) 
                                {
                                $id = (int) @$_POST['FileNotes']['id'];
                                $modelNotes->updated_by = Yii::app()->user->id;
                                $modelNotes->updated_datetime = date('Y-m-d h:i:s');
                                $modelNotes = $modelNotes->findByPk($id);
                               
                                } 
                            else 
                                {
                                $modelNotes->created_by = Yii::app()->user->id;
                                $modelNotes->created_datetime = date('Y-m-d h:i:s');
                                $modelNotes->notes=$_POST['FileNotes']['notes'];
                                
                                $modelNotes->crm_user_id = Yii::app()->user->id;
                                $modelNotes->customer_vendor_id = $model->vendor_id;
                                $modelNotes->customer_vendor_type=2;
                                $modelNotes->file_note_from=1;
                                $modelNotes->file_id=$model->file_id;
                                $modelNotes->save(false);
                                }
                     $modelNotes->attributes = $_POST['FileNotes'];
                     $modelNotes->save(false);           
                     }
                  
                     
                     
                     
                     
                     
                    
                        if(!empty($_POST['Icon']))
                        {
                                                 
                              $arr_doc_photos = $_POST['Icon']['file'];

                                if (!empty($arr_doc_photos)) {

                                    $modelDocument->document_name = implode(',', $arr_doc_photos);
                                    //$modelDocument->save(false);
                                }
                            $modelDocument->file_id = $modelMaster->id;
                            $modelDocument->uploaded_from =  "P_R";
                            $modelDocument->save(false);  
                   
                        }
                   
                   
              

               
                    $jsonData['status'] = 'success';
                    $jsonData['frm'] = $_POST['requisition-form'];
                    $jsonData['id'] = $model->id;
                    echo CJSON::encode($jsonData);

                } else {
                    $error2 = json_decode(CActiveForm::validate($model, '', false), true);
                    $error = CJSON::encode($error2);
                    if ($error != '[]')
                        echo $error;
                }
            
    }
      public function actionGetRequisitionList() {

        $model = new PurchasingRequisition();


        $draw = $_POST['draw'];

        $offset = $_POST['start'];

        $limit = $_POST['length'];

        $columns = array(

            // datatable column index  => database column name

            1 => 't.file_id',

            2 => 't.file_title',
            3 => 't.notes',

            4 => 't.requisition_date',

            5 => 't.required_date',

        );

        $filterColumn = $columns[$_POST['order'][0]['column']];

        $filterOrder = $_POST['order'][0]['dir'];

        $orderBy = $filterColumn . " " . $filterOrder;

        

        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {

            $searchString = $_POST['search']['value'];

            $condition = "And( t.file_title LIKE '%" . $searchString . "%' OR t.requisition_date LIKE '%" . $searchString . "%' )";

        }

        $count = $model->count(array('condition' => $condition));

        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset));

        $recordsTotal = $count;

        $recordsFiltered = $count;

        $data['draw'] = $draw;

        $data['recordsTotal'] = $recordsTotal;

        $data['recordsFiltered'] = $recordsFiltered;

        $rowData = array();

        $i = 1;
     
        
        
       
        foreach ($model as $row) {
             $req_date=date("d/m/Y", strtotime($row->requisition_date));
            $required_date=date("d/m/Y", strtotime($row->required_date));

            $rowData[] = array($row['file_id'],$row['id'], $row['file_title'],$row['notes'],$req_date, $required_date,
            '<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'requisition/create&id=' . $row['id'] . '&file_id=' . $row['file_id'] . '\',\'Edit Requisition - ' . $row['file_id'] . '\',\'lg\')" title="Edit"><i class="fa fa-pencil" aria-hidden="true"></i></i></button>
            <button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'requisition/create&id='.$row['id'].'&file_id='.$row['file_id'].'\',\'Convert\',\'xl\')" title="Convert "><i class="fa fa-retweet"></i></button>
<a class="btn btn-primary btn-xs" title="Print Requistion List" target="_blank" href="/development/newcumuluserp/index.php?r=requisition/PrintRequistionReportPDF&id=' . $row['id'] .' "><i class="fa fa-file-pdf-o" aria-hidden="true"></i></a>');
            $i++;

        }

        $data['data'] = $rowData;

        echo json_encode($data);

    }
     public function actionGetProducts() {
        $from = $_GET['frm'];
        $searchTerm = $_GET['term'];
        $condition = 'part_number LIKE "%' . $searchTerm . '%"';
        $model = new Store();
        $model = $model->findAll(array('select' => 'id,part_number,description,unit_id', 'condition' => $condition));
        $i = 0;
        foreach ($model as $eachModel) {
            $data[$i]['value'] = $eachModel->id;
            $data[$i]['label'] = $eachModel->part_number;
            $data[$i]['description'] = $eachModel->description;
            $data[$i]['unit_id'] = $eachModel->unit->id;
            $data[$i]['unit_name'] = $eachModel->unit->symbol;
           
            $i++;
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }
    public function actionDeleteRequisitionItem() {

        $id = $_POST['id'];

        $model = new PurchasingRequisitionStockItem();

        $model->deleteByPk($id);

        $jsonData['status'] = 'success';

        $jsonData['id'] = $id;

        echo CJSON::encode($jsonData);

    }
     public function actionGetDocumentList() {

        $model = new Document();

        $draw = $_POST['draw'];

        $offset = $_POST['start'];

        $limit = $_POST['length'];

        $columns = array(

            // datatable column index  => database column name

            1 => 't.file_id',

            2 => 't.file_title',
            3 => 't.notes',

            4 => 't.requisition_date',

            5 => 't.required_date',

        );

        $filterColumn = $columns[$_POST['order'][0]['column']];

        $filterOrder = $_POST['order'][0]['dir'];

        $orderBy = $filterColumn . " " . $filterOrder;

        $condition = 't.isActive="Y" and t.file_id = "'.$_POST['file_id'].'"';

        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {

            $searchString = $_POST['search']['value'];

            $condition .= "And( t.file_id LIKE '%" . $searchString . "%')";

        }

        $count = $model->count(array('condition' => $condition));

        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset));

        $recordsTotal = $count;

        $recordsFiltered = $count;

        $data['draw'] = $draw;

        $data['recordsTotal'] = $recordsTotal;

        $data['recordsFiltered'] = $recordsFiltered;

        $rowData = array();

        $i = 1;

        foreach ($model as $row) {

            $rowData[] = array($row['file_id']."/".$row['id'], $row['document_name'],$row['uploaded_from']);

            $i++;

        }

        $data['data'] = $rowData;

        echo json_encode($data);

    }
    public function actionPrintRequistionReportPDF() {

        //$model = new PurchasingRequisition();
        $id = Yii::app()->request->getParam('id');
       if($id>0)
       {
           $model = PurchasingRequisition::model()->findByPk($id);
        }
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.requisition_list', array('model' => $model, 'id' => $id, 'title' => $title),true));
        $mPDF1->Output($htmlTemplate, 'I');
    }
     public function actionGetNotesList()

        {
                $id = $_POST['id'];
                $model=new FileNotes();

                $draw    = $_POST['draw'];

                $offset = $_POST['start'];

                $limit  = $_POST['length'];

                $columns = array(

                // datatable column index  => database column name
                    0 => 'id',

                   1 =>'notes',

                    

                   

                   );

                $filterColumn = $columns[$_POST['order'][0]['column']];

                $filterOrder  = $_POST['order'][0]['dir'];

                $orderBy   = $filterColumn." ".$filterOrder;
                if($id ==''){
                    $id=0;
               }
                $condition = 't.file_id="'.$id.'"';
                if(isset($_POST['search']['value']) && $_POST['search']['value']!="")

                {

                  $searchString = $_POST['search']['value'];

                  $condition.=" and (notes LIKE '%".$searchString."%')";

                }

                $count = $model->count(array('condition'=>$condition));

                $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>$orderBy));

                $recordsTotal = $count;

                $recordsFiltered = $count;

                $data['draw'] = $draw;

                $data['recordsTotal'] = $recordsTotal;

                $data['recordsFiltered'] = $recordsFiltered;

                $rowData=array();

                $m = 1;

               

                foreach ($model as $row)

                {

                    $rowData[]=array($m,$row->notes);

                    $m++;

                }

                $data['data'] = $rowData;

                echo json_encode($data);

        }
         public function actionCreateNote()

        {

            $model=new FileNotes();
//
//            $id = 30;//(int) Yii::app()->request->getParam('id');
//            echo $id;
            $file_id = (int) Yii::app()->request->getParam('file_id');
            $vendor_id = (int) Yii::app()->request->getParam('vendor_id');
//            echo $notes_id;
//            if($id>0){
//
//                $model=$model->findByPk($id);
//
//            }

                Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);

            $this->render('note_add_details_2', array('modelNotes' => $model,'file_id' => $file_id,'vendor_id'=>$vendor_id));

        }
    
     public function actionSaveNote()

        {
            $modelNotes = new FileNotes();
           
            if (!empty($_POST['FileNotes'])) 
                        {   
                       if ((int) @$_POST['FileNotes']['id'] > 0) 
                                {
                                $id = (int) @$_POST['FileNotes']['id'];
                                $modelNotes->updated_by = Yii::app()->user->id;
                                $modelNotes->updated_datetime = date('Y-m-d h:i:s');
                                $modelNotes = $modelNotes->findByPk($id);
                               
                                } 
                            else 
                                {
                                $modelNotes->created_by = Yii::app()->user->id;
                                $modelNotes->created_datetime = date('Y-m-d h:i:s');
                                $modelNotes->notes=$_POST['FileNotes']['notes'];
                                
                                $modelNotes->crm_user_id = Yii::app()->user->id;
                                $modelNotes->customer_vendor_id = $_POST['vendor_id'];
                                $modelNotes->customer_vendor_type=2;
                                $modelNotes->file_note_from=1;
                                $modelNotes->file_id=$_POST['file_id'];
                                $modelNotes->save(false);
                                }
                     $modelNotes->attributes = $_POST['FileNotes'];
                     $modelNotes->save(false);
                     
                    $jsonData['status'] = 'success';
                    $jsonData['frm'] = $_POST['requisition-form'];
                    $jsonData['id'] = $model->id;
                    echo CJSON::encode($jsonData);

               
                     
                     
                     
                     
                     
                     
                     
                     
                     }
                  
          

         
        }
}