<?php 
$model=new Deposit();
$condition="1=1";
if($from_date!="" && $to_date!=""){
    $date_from = str_replace('/', '-',$from_date);
    $date_from = date("Y-m-d", strtotime($date_from));
    
    $date_to = str_replace('/', '-',$to_date);
    $date_to = date("Y-m-d", strtotime($date_to));
    
    $condition="(issued_date>='".$date_from."' AND issued_date<='".$date_to."')";
}
if(!empty($status)){
    if($status==1){
        $condition.=" AND payment_delivery_date='0000-00-00'";
    }
    if($status==2){
        $condition.=" AND payment_delivery_date<>'0000-00-00'";
    }
    if($status==3){
        $condition.=" AND (doc_submitted_date<>'0000-00-00' AND payment_collection_date='0000-00-00')";
    }
    if($status==4){
        $condition.=" AND (payment_collection_date<>'0000-00-00' AND payment_delivery_date='0000-00-00')";
    }
}
$model  =$model->with('cus')->findAll(array('condition'=>$condition));
?>


<div class="panel">
    <div class="panel-heading panel-theme clearfix report-head">
        <p>Security Deposit List</p>
    <div class="pull-right">
            <div class="filter_details">
            
            <?php
                if($from_date !=''){
                    ?>
                        <div class="filter-item">
                            <label>From Date:</label>
                            <?php echo $from_date ?>
                        </div>
                    <?php
                }
            ?>
                <?php
                if($to_date !=''){
                    ?>
                        <div class="filter-item">
                            <label>To Date :</label>
                            <?php echo $to_date ?>
                        </div>
                    
                    <?php
                }
            ?>
            </div>
    </div>
    </div>
    <div class="panel-body">
        <div class="table-responsive">
            

            <table id="tbl_inventory_table" class="table table-fixed table-bordered table-primary dataTable">
                <thead>
                    <tr>
                        <th>&nbsp;Customer&nbsp;</th>
                        <th>Invoice No</th>
                        <th>BOE</th>
                        <th>Amount</th>
                        <th>Issued Date</th>
                        <th>Expiry Date</th>
                        <th>Statement#</th>
                        <th>Doc Submitted Date</th>
                        <th>Customs Submitted Date</th>
                        <th>Receipt#</th>
                        <th>Payment Collected Date</th>
                        <th>Payment Bank/Cheque</th>
                        <th>Delivered On</th>
                        <th>Delivered Bank/Cheque</th>
                        
                        
                    </tr>
                </thead>
                <tbody>
                    
                <?php
                    if(count($model)>0){
                        foreach($model as $eachItem){
                            ?>
                            <tr>
                                <td><?php echo $eachItem->cus->customer_name;?></td>
                                <td><?php echo $eachItem->invoice_no;?></td>
                                <td><?php echo $eachItem->bill_of_entry;?></td>
                                <td><?php echo $eachItem->amount;?></td>
                                <td><?php echo ($eachItem->issued_date!="0000-00-00")?date("d/m/Y",strtotime($eachItem->issued_date)):"";?></td>
                                <td><?php echo ($eachItem->expiry_date!="0000-00-00")?date("d/m/Y",strtotime($eachItem->expiry_date)):"";?></td>
                                <td><?php echo $eachItem->statement_no;?></td>
                                <td><?php echo ($eachItem->doc_submitted_date!="0000-00-00")?date("d/m/Y",strtotime($eachItem->doc_submitted_date)):"";?></td>
                                <td><?php echo ($eachItem->customs_submitted_date!="0000-00-00")?date("d/m/Y",strtotime($eachItem->customs_submitted_date)):"";?></td>
                                <td><?php echo $eachItem->receipt_no;?></td>
                                <td><?php echo ($eachItem->payment_collection_date!="0000-00-00")?date("d/m/Y",strtotime($eachItem->payment_collection_date)):"";?></td>
                                <td><?php echo $eachItem->collected_cheque_no;?></td>
                                <td><?php echo ($eachItem->payment_delivery_date!="0000-00-00")?date("d/m/Y",strtotime($eachItem->payment_delivery_date)):"";?></td>
                                <td><?php echo $eachItem->delivered_cheque_no;?></td>
                            </tr>
                            <?php
                        }
            	    }
            		else 
            		{
            			echo '<tr class = "' . $class . '"><td colspan="14">No Result Found</td></tr>';
            		}
                    ?>
					            </tbody>
            </table>
      
	    <div class="space">
	        <input type="hidden" id="deposit_from_date" name="deposit_from_date" value="<?php echo $from_date; ?>">
                    <input type="hidden" id="deposit_to_date" name="deposit_to_date" value="<?php echo $to_date; ?>">
                    <input type="hidden" id="deposit_status" name="deposit_status" value="<?php echo $status; ?>">
	        
	    </div>
                    <div class="col-6">Created By : 
                            <span><?php echo Yii::app()->user->fullname; ?></span> </div>
                    <div class="col-6 cell-right">Created On : 
                            <span><?php $h = "4";// Hour for time zone goes here e.g. +7 or -4, just remove the + or -
                                        $hm = $h * 60;
                                        $ms = $hm * 60;
                                        $gmdate = gmdate("m/d/Y g:i:s A", time()+($ms));
                                        echo $gmdate;
                                        // echo date('Y/m/d H:i:s') ?></span> </div>
						   <br>
	  
	  
            <div class="btn-wrap text-center">
                <button type="button" class="btn btn-theme" onclick="exportDeposit();">Export Excel</button>
            </div>
        </div>
    </div>
</div>
<?php
$cs = Yii::app()->getClientScript();

$cs->registerScript("exportDeposit", "function exportDeposit()
{
  var from_date     = $('#deposit_from_date').val();
  var to_date       = $('#deposit_to_date').val();
  var status        = $('#deposit_status').val();
  var param         = '&from_date='+from_date+'&to_date='+to_date+'&status='+status;
  //alert(param);
  var url           = $('#liveSite').val()+'index.php?r=excel/exportdepositlist'+param;
  window.open(url, '_blank');
}", CClientScript::POS_HEAD);
?>