<div class="panel">
    <div class="panel-heading panel-theme clearfix report-head">
        List of Orders
        <div class="pull-right">
            <div class="filter_details">
            
            <?php
                if($order_from_date !=''){
                    ?>
                        <div class="filter-item">
                            <label>Order From :</label>
                            <?php echo $order_from_date ?>
                        </div>
                    <?php
                }
            ?>
                <?php
                if($order_to_date !=''){
                    ?>
                        <div class="filter-item">
                            <label>Order To :</label>
                            <?php echo $order_to_date ?>
                        </div>
                    
                    <?php
                }
            ?>
               
                <?php
                if($vendor_id !=''){
                    ?>
                        <div class="filter-item">
                            <label>Vendor :</label>
                            <?php $v= Vendor::model()->findByPK($vendor_id);
                                  echo $v->vendor_name; ?>
                        </div>
                    
                    <?php
                }
            ?>
                <?php
                if($project_id !=''){
                    ?>
                        <div class="filter-item">
                            <label>Project :</label>
                            <?php $p = MasProject::model()->findByPK($project_id);
                                  echo $p->project_title; ?>
                        </div>
                    <?php
                }
            ?>
             
            </div>
        </div>
    </div>
    <div class="panel-body">
        <div class="table-responsive">
            <table id="tbl_order_table" class="table table-fixed table-bordered table-primary dataTable">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>PO No</th>
                        <th>File No</th>
                        <th>Title</th>
                       <th>Vendor</th>
                        <th>Order Date</th>
                        <th>Grand Total</th>
                        <th>Grand Total(BC)</th>
                        <th>Actions</th>

                    </tr>
                </thead>
                <tbody>
                    <?php
        $condition = '1=1'; ;
            if($order_from_date != ''){
                $order_from_date = str_replace('/', '-', $order_from_date);
                $order_from_date = date('Y-m-d',strtotime($order_from_date));
                $condition .= ' AND t.order_date >="'.$order_from_date.'"';
            }
            if($order_to_date != ''){
                $order_to_date = str_replace('/', '-', $order_to_date);
                $order_to_date = date('Y-m-d',strtotime($order_to_date));
                $condition .= ' AND t.order_date <="'.$order_to_date.'"';
            }
            
            if($vendor_id != ''){
                $condition .= ' AND t.vendor_id ="' . $vendor_id.'"';
            }
            if($project_id != ''){
                $condition .= ' AND t.project_id ="' . $project_id.'"';
            }
           
            $total=0;
            $model_order = PurchasingOrder::model()->with('vendor_details')->findAll(array('condition'=>$condition));
        foreach ($model_order as $i => $model) {
            ?>
                        <input type="hidden" id="order_from_date" name="order_from_date" value="<?php echo $order_from_date;?>">
                        <input type="hidden" id="order_to_date" name="order_to_date" value="<?php echo $order_to_date;?>">
                        <input type="hidden" id="project_id" name="project_id" value="<?php echo $project_id;?>">
                        <input type="hidden" id="vendor_id" name="vendor_id" value="<?php echo $vendor_id;?>">
                        <tr>
                            <td>
                                <?php echo $i+1;?>
                            </td>
                            <td>
                                <?php echo $model->id;?>
                            </td>
                            <td>
                                <?php echo $model->file_id;?>
                            </td><td>
                                <?php echo $model->title;?>
                            </td>
                            <td class="nw">
                                <?php echo $model->vendor_details->vendor_name;?>
                            </td>
                            
                            <?php if($model->order_date!='0000-00-00'){ ?>
                            <td>
                                <?php echo date("d/m/Y", strtotime($model->order_date));?>
                            </td>
                            <?php }else{ ?>
                            <td>&nbsp;</td>
                            <?php } ?>
                            <td class="text-right">
                                <?php echo $model->currencyname->currency_code." ";?><?php echo Yii::app()->numberFormatter->formatCurrency($model->stock_grand_total+$model->nonstock_grandtotal,"");?>
                            </td>
                            <?php $model_currency = MasCurrency::model()->findByPk($model->currencyname->id);
                            $grand_total=$model->stock_grand_total+$model->nonstock_grandtotal;
                $total_bc = $grand_total*$model_currency->exchange_rate;
                $total += $total_bc?>
                            <td class="text-right">
                                <?php echo Yii::app()->numberFormatter->formatCurrency($total_bc, " ");?>
                            </td>
                            <td class="text-center">
                    
                    <a class="btn btn-primary btn-xs" title="Print PDF" target="_blank" href="index.php?r=purchasingorder/PrintOrderReportPDF&id=<?php echo $model->id; ?>"><i class="fa fa-file-pdf-o" aria-hidden="true"></i></a>
                </td>

                        </tr>
                        <?php }  ?>

                        <tr>
                            <td colspan="7"class="text-right"><b> Total</b></td>
                            <td class="text-right"><b> <?php echo Yii::app()->numberFormatter->formatCurrency($total, " "); ?></b> </td>
                            <td></td>
                        </tr>
                </tbody>
            </table>
            <br>
            <div class="btn-wrap text-center">
                <?php
              echo CHtml::link('Export PDF',array('reports/PrintPurchaseOrderReportPDF','order_from_date'=>$order_from_date,'order_to_date'=>$order_to_date,'vendor_id'=>$vendor_id,'project_id'=>$project_id), array('title'=>'Print Purchase Order List','target'=>'_blank','class' =>  'btn btn-theme')); ?>
                 
            </div>
        </div>
    </div>
</div>
<?php $cs = Yii::app()->getClientScript();

$cs->registerScript("excelOrderList", "function excelOrderList(){
  var url= '" . Yii::app()->createUrl('reports/PrintOrderExcel') . "';

  var order_from_date = $('#order_from_date').val();
            var order_to_date = $('#order_to_date').val();
            var delivery_from_date = $('#delivery_from_date').val();
            var delivery_to_date = $('#delivery_to_date').val();
            var customer_id = $('#customer_id').val();
            var sales_group = $('#sales_group').val();
            var payment_terms = $('#payment_terms').val();
            var type_of_contract = $('#type_of_contract').val();

    window.open($('#liveSite').val()+'index.php?r=reports/PrintOrderExcel&order_from_date='+order_from_date+'&order_to_date='+order_to_date+'&delivery_from_date='+delivery_from_date+'&delivery_to_date='+delivery_to_date+'&customer_id='+customer_id+'&sales_group='+sales_group+'&payment_terms='+payment_terms+'&type_of_contract='+type_of_contract, '_blank');

}", CClientScript::POS_HEAD);
$cs->registerScript("excelEnquiryListId", "function excelEnquiryListId(id){

    var url= '" . Yii::app()->createUrl('reports/PrintEnquiryExcelId') . "';

    var enquiry_id = id;

    var start_date = $('#start_date').val();

    var end_date = $('#end_date').val();

    var status = $('#status').val();

    window.open($('#liveSite').val()+'index.php?r=reports/PrintEnquiryExcelId&start_date='+start_date+'&end_date='+end_date+'&status='+status+'&enquiry_id='+enquiry_id, '_blank');

}", CClientScript::POS_HEAD);
