<div class="panel">
    <div class="panel-heading panel-theme clearfix report-head">
        List of Quotations
    </div>
    <div class="panel-body">
        <div class="table-responsive">
        <table id="tbl_quote_table" class="table table-fixed table-bordered table-primary dataTable">
	<thead>
   		<tr>
   		<th>No</th>
                <th>Qtn No</th>
                <th>File No</th>
                <th>Company Name</th>
                <th>Currency</th>
                <th>Lead Owner</th>
                <th>Quotation Date</th>
                <th>Validity Date</th>
                <th>Expected Order Date</th>
                <th>Sales Group</th>
                <th>Probability</th>
                <th>Status</th>
                <th>Grand Total(BC)</th>
                <?php
                if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["quotes_pdf"])){
                ?>
                <th>Actions</th>
                <?php
                }
                ?>
                </tr>
        </thead>
        <tbody>
        <?php
        $condition = 'code like "'.$data.'"';
        if($start!='')
        {
        $start = str_replace('/', '-', $start);
        $start = date('Y-m-d',strtotime($start));
        $condition.=' AND qtn_date>="'.$start.'"';    
        }
        if($end!='')
        {
        $end = str_replace('/', '-', $end);
        $end = date('Y-m-d',strtotime($end));
        $condition.=' AND qtn_date<="'.$end.'"';       
        }
        if($customer_id!='')
        {
        $condition.=' AND company_id="'.$customer_id.'"';      
        }
            $total=0;
            $model_quote = Quotes::model()->with('file','customer','customercontact')->findAll(array('condition'=>$condition));
        foreach ($model_quote as $i => $model) {
            ?>
  	 	<tr>
  	 	<td><?php echo $i+1;?></td>
                <td><?php echo $model->id;?></td>
                <td><?php echo $model->file_id;?></td>
            
  	 	<td class="nw"><?php echo $model->customer->customer_name;?></td>
                <td><?php echo $model->currencyname->currency_code;?></td>
                 <td class="nw"><?php echo $model->file->leadowner->first_name." ".$model->file->leadowner->last_name;?></td>
              
                <?php if($model->qtn_date!='0000-00-00'){ ?>
                <td><?php echo date("d/m/Y", strtotime($model->qtn_date));?></td>
                <?php }else{ ?>
                <td>&nbsp;</td>
                <?php } ?>
                <?php if($model->qtn_validity!='0000-00-00'){ ?>
                <td><?php echo date("d/m/Y", strtotime($model->qtn_validity));?></td>
                <?php }else{ ?>
                <td>&nbsp;</td>
                <?php } ?>

                <?php if($model->expected_order_date!='0000-00-00'){ ?>
                <td><?php echo date("d/m/Y", strtotime($model->expected_order_date));?></td>
                <?php }else{ ?>
                <td>&nbsp;</td>
                <?php } ?>
               
                <td class="nw"><?php echo $model->salesgroup->group_name;?></td>
                <td><?php echo $model->probability->probability;?></td>
                <?php
                      if($model->status == 'Y')
                       $state="Open";
                      if($model->status == 'C')
                       $state="Closed";
                      if($model->status == 'O')
                       $state="Others";
                      if($model->status == 'L')
                       $state="Lost";
                    ?>
                <td><?php echo $state;?></td>
                  <?php $model_currency = MasCurrency::model()->findByPk($model->currency);
                $total_bc = $model->grand_total*$model_currency->exchange_rate;
                $total += $total_bc?>
                <td class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency($total_bc, " ");?></td>
                <?php
                if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["quotes_pdf"])){
                ?>
                <td>
                    <a class="btn btn-primary btn-xs" title="Print Quotation" target="_blank" href="index.php?r=quotation/PrintQuotationReportPDF&id=<?php echo $model->id; ?> "><i class="fa fa-file-pdf-o" aria-hidden="true"></i></a>
                </td>
                <?php
                }
                ?>

                </tr>
                <?php } ?>
                <tr>
                    <td colspan="12"> </td>
                    <td class="text-right"><b> <?php echo Yii::app()->numberFormatter->formatCurrency($total, " "); ?></b> </td>
                </tr>
        </tbody>
        </table>
            <br>
             <div class="btn-wrap text-center">
              <?php
              echo CHtml::link('Export PDF',array('reports/PrintQuoteReportPDF','qtn_start_from_date'=>$qtn_start_from_date,'qtn_start_to_date'=>$qtn_start_to_date,'qtn_validity_from_date'=>$qtn_validity_from_date,'qtn_validity_to_date'=>$qtn_validity_to_date,'customer_id'=>$customer_id,'leadowner_id'=>$leadowner_id,'sales_group'=>$sales_group,'status'=>$status), array('title'=>'Print Quote List','target'=>'_blank','class' =>  'btn btn-theme')); ?>

        </div>
        </div>
    </div>
</div>
<?php $cs = Yii::app()->getClientScript();

$cs->registerScript("excelQuoteList", "function excelQuoteList(){

    var url= '" . Yii::app()->createUrl('reports/PrintQuoteExcel') . "';
    var qtn_start_from_date = $('#qtn_start_from_date').val();
            var qtn_start_to_date = $('#qtn_start_to_date').val();
            var qtn_close_from_date = $('#qtn_close_from_date').val();
            var qtn_close_to_date = $('#qtn_close_to_date').val();
            var qtn_delivery_from_date = $('#qtn_delivery_from_date').val();
            var qtn_delivery_to_date = $('#qtn_delivery_to_date').val();
            var customer_id = $('#customer_id').val();
            var leadowner_id = $('#leadowner_id').val();
            var sales_group = $('#sales_group').val();
            var payment_terms = $('#payment_terms').val();
            var type_of_contract = $('#type_of_contract').val();
            var status = $('#status').val();
    window.open($('#liveSite').val()+'index.php?r=reports/PrintQuoteExcel&qtn_start_from_date='+qtn_start_from_date+'&qtn_start_to_date='+qtn_start_to_date+'&qtn_close_from_date='+qtn_close_from_date+'&qtn_close_to_date='+qtn_close_to_date+'&qtn_delivery_from_date='+qtn_delivery_from_date+'&qtn_delivery_to_date='+qtn_delivery_to_date+'&customer_id='+customer_id+'&leadowner_id='+leadowner_id+'&sales_group='+sales_group+'&payment_terms='+payment_terms+'&type_of_contract='+type_of_contract+'&status='+status, '_blank');

}", CClientScript::POS_HEAD);
//$cs->registerScript("excelEnquiryListId", "function excelEnquiryListId(id){
//
//    var url= '" . Yii::app()->createUrl('reports/PrintEnquiryExcelId') . "';
//
//    var enquiry_id = id;
//
//    var start_date = $('#start_date').val();
//
//    var end_date = $('#end_date').val();
//
//    var status = $('#status').val();
//
//    window.open($('#liveSite').val()+'index.php?r=reports/PrintEnquiryExcelId&start_date='+start_date+'&end_date='+end_date+'&status='+status+'&enquiry_id='+enquiry_id, '_blank');
//
//}", CClientScript::POS_HEAD);