<div class="panel">
    <div class="panel-heading panel-theme clearfix report-head ">
        Stock Ledger
        <div class="pull-right">
            <div class="filter_details">
            
            <?php
                if($from_date !=''){
                    ?>
                        <div class="filter-item">
                            <label> From :</label>
                            <?php echo $from_date ?>
                        </div>
                    <?php
                }
             ?>
            <?php
                if($to_date !=''){
                    ?>
                        <div class="filter-item">
                            <label> To :</label>
                            <?php echo $to_date ?>
                        </div>
                    <?php
                }
             ?>
             <?php
                if($customer_id !=''){
                    ?>
                        <div class="filter-item">
                            <label>Customer/Vendor :</label>
                            <?php $c = StockLedger::model()->find(array('condition'=>'customer_vendor_id ='.$customer_id));
                                  echo $c->customer_vendor_name	; ?>
                        </div>
                    <?php
                }
                if($type != ''){
                    ?>
                        <div class="filter-item">
                            <label>Type :</label>
                            <?php $type_des = StockLedger::getTypeDes($type);
                                  echo $type_des; ?>
                        </div>
                    <?php
                
                }
                if($id != ''){
                    ?>
                        <div class="filter-item">
                            <label>T No :</label>
                            <?php echo $id; ?>
                        </div>
                    <?php
                
                }
                if($part_no != ''){
                    ?>
                        <div class="filter-item">
                            <label>Part No :</label>
                            <?php echo $part_no; ?>
                        </div>
                    <?php
                
                }
             ?>
                
            </div>
        </div>
    </div>
    <div class="panel-body">
        <div class="table-responsive">
            <table id="tbl_invoice_table" class="table table-fixed table-bordered table-primary dataTable">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Date</th>
                        <th>Part No</th>
                        <th>Generic Name</th> 
                <th>Brand</th>
                        <th>Description</th>
                        <th>T No</th>
                        <th>Type</th>
                        <th>In Qty</th>
                        <th>Out Qty</th>
                        <th>Customer/Vendor</th>                        
                        
                    </tr>
                </thead>
                <tbody>
                    <?php 
        $condition = '1=1'; ;
            if($from_date != ''){
                $from_date = str_replace('/', '-', $from_date);
                $from_date = date('Y-m-d',strtotime($from_date));
                $condition .= ' AND t.transaction_date >="'.$from_date.'"';
            }
            if($to_date != ''){
                $to_date = str_replace('/', '-', $to_date);
                $to_date = date('Y-m-d',strtotime($to_date));
                $condition .= ' AND t.transaction_date <="'.$to_date.'"';
            }
            if($part_no != ''){

                $condition .= ' AND t.part_no="'.$part_no.'"';
            }
            if($id != ''){

                $condition .= ' AND t.master_table_id ="'.$id.'"';
            }
            if($customer_id != ''){

                $condition .= ' AND t.customer_vendor_id ="'.$customer_id.'"';
            }
            if($type != ''){
                if ($type== 'D,DO') {
                    $condition .= ' AND t.type IN ("D","DO")';
                }else if($type== 'QC,PR'){
                    $condition .= ' AND t.type IN ("QC","PR")';
                }
                else
                    $condition .= ' AND t.type ="'.$type.'"';
            }
            
             $total=0;
            $model_stock = StockLedger::model()->findAll(array('condition'=>$condition));
            $total_in=0;$total_out=0;
        foreach ($model_stock as $i => $model) {
            ?>
                        <tr>
                            <td>
                                <?php echo $i+1;?>
                            </td>
                            <?php if($model->transaction_date!='0000-00-00'){ ?>
                            <td>
                                <?php echo date("d/m/Y", strtotime($model->transaction_date));?>
                            </td>
                            <?php }else{ ?>
                            <td>&nbsp;</td>
                            <?php } ?>
                            
                            <td>
                                <?php echo $model->part_no;?>
                            </td>
                            <?php  $model_generic = MasGeneric::model()->find(array('condition'=>'t.id="'.$model->generic_name.'"'));?>
  	 	                   <td><?php echo $model_generic->generic_name;?></td>   
                            <td><?php echo $model->stock->brand_detail->product_class;?></td>  
                            <td>
                                <?php echo $model->description;?>
                            </td>
                            <td>
                                <?php echo $model->ref_no;?>
                            </td>
                            <td>
                                <?php 
                                if($model->type =='D'||$model->type =='DO')
                                    echo 'Sales';
                                else if($model->type =='PR'||$model->type =='QC')
                                    echo 'Purchase';
                                else
                                echo $model->type_description;?>
                            </td>
                            <td  class="text-right">
                            <?php 
                                $total_in +=$model->in_qty;
                                echo  Yii::app()->numberFormatter->formatCurrency($model->in_qty," ");?>
                            </td>
                            <td  class="text-right">
                            <?php 
                                $total_out +=$model->out_qty;
                                echo Yii::app()->numberFormatter->formatCurrency($model->out_qty," ");?></td>                           
                            <td>
                                <?php echo $model->customer_vendor_name;?>
                            </td>                 
                            
                          
                        </tr>
                        <?php }  
                        $net = (float)$total_in-(float)$total_out;
                        ?>
                        <tr>
                            <td colspan="8"></td>
                            <td class="text-right"><b><?php 
                            echo  Yii::app()->numberFormatter->formatCurrency($total_in," ");?></b></td>
                            <td class="text-right"><b><?php echo  Yii::app()->numberFormatter->formatCurrency($total_out," ");?></b></td>
                            <td class="text-right"><b><?php echo  Yii::app()->numberFormatter->formatCurrency($net," ");?></b></td>
                        </tr>
                        
                </tbody>
            </table>
            <br>
            <div class="btn-wrap text-center">
                <?php
              echo CHtml::link('Export PDF',array('invreports/PrintInvStockLedgerReportPDF','from_date'=>$from_date,'to_date'=>$to_date,'customer_id'=>$customer_id,'type'=>$type,'part_no'=>$part_no), array('title'=>'Print Stock Ledger','target'=>'_blank','class' =>  'btn btn-theme')); ?>
                    
            </div>
        </div>
    </div>
</div>