
<div class="panel">
    <div class="panel-heading panel-theme clearfix">
        <p>Daily Exit Invoice Report</p>
        <div class="pull-right">
            <div class="filter_details">
            
            <?php
                if($from_date !=''){
                    ?>
                        <div class="filter-item">
                            <label>From Date:</label>
                            <?php echo $from_date ?>
                        </div>
                    <?php
                }
            ?>
                <?php
                if($to_date !=''){
                    ?>
                        <div class="filter-item">
                            <label>To Date :</label>
                            <?php echo $to_date ?>
                        </div>
                    
                    <?php
                }
            ?>
                <?php
                if($customer_id >0){
                    ?>
                        <div class="filter-item">
                            <label>Customer :</label>
                            <?php echo Customer::model()->findByPk($customer_id)->customer_name; ?>
                        </div>
                    
                    <?php
                }
            ?>
            </div>
    </div>
    </div>
    <div class="panel-body">
        <div class="table-responsive">
            
            <table id="tbl_inventory_table" class="table table-fixed table-bordered table-primary dataTable">
                <thead>
                    <tr>
                        <th>Customer</th>
                        <th>Invoice Date</th>
                        <th>Total Cash Collected</th>
                        <th>To be Deposited in Bank</th>
                        <th>Balance Amount</th>

                        
                    </tr>
                </thead>
                <tbody>
                   <?php
                $toalval = 0;
                $condition = '1=1';
                ;
                $type_id = $type;
                if ($from_date != '') {
                    $form_from_date = str_replace('/', '-', $from_date);
                    $form_from_date = date('Y-m-d',strtotime($form_from_date));
                    $condition.= " AND exitinv.invoice_date>='" . $form_from_date . "'";
                }

                if ($to_date != '') {
                    $form_to_date = str_replace('/', '-', $to_date);
                    $form_to_date = date('Y-m-d',strtotime($form_to_date));
                    $condition .= " AND exitinv.invoice_date<='" .$form_to_date . "'";
                }
                if ($customer_id > 0 ) {
                    $condition.= " AND exitinv.customer_id=" . $customer_id;

                }
                if(Yii::app()->user->mas_company_code=="ALMAS"){
                    $SQL = "SELECT customer_id, invoice_date, SUM(amount+vat_amount) AS total_amount, SUM(commission) AS total_commission , customer.customer_name AS customer_name
                		FROM `crm_exit_invoice` AS exitinv
                		INNER JOIN `crm_exit_invoice_item` AS item ON exitinv.id=exit_invoice_id
                		INNER JOIN crm_customer AS customer ON exitinv.customer_id =customer.id
                            WHERE ".$condition." GROUP BY exitinv.customer_id,invoice_date";
                }
                else{
                    $SQL = "SELECT customer_id, invoice_date, SUM(amount+vat_amount) AS total_amount, SUM(commission) AS total_commission , customer.customer_name AS customer_name
                		FROM `crm_exit_invoice` AS exitinv
                		INNER JOIN `crm_exit_invoice_item` AS item ON exitinv.id=exit_invoice_id
                		INNER JOIN crm_customer AS customer ON exitinv.customer_id =customer.id
                            WHERE ".$condition." GROUP BY exitinv.id,invoice_date";
                }
                $model_dailyexit = Yii::app()->db->createCommand($SQL)->queryAll();
                $cnt=0;
                $grand_total=0;
                $total_commission=0;
                foreach ($model_dailyexit as $i => $invoice_details) {
                    ?>

                    <tr>
                        <td><?php echo $invoice_details['customer_name'] ?></td>
                        <td><?php echo strftime('%d/%m/%Y',strtotime($invoice_details['invoice_date'])); ?></td>
                        <td class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency($invoice_details['total_amount'],""); ?></td>
                        <td class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency($invoice_details['total_commission'],""); ?></td>
                        <td class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency(($invoice_details['total_amount'] - $invoice_details['total_commission']),""); ?></td>
                    </tr>
                    <?php 
                        $grand_total+=$invoice_details['total_amount'];
                        $total_commission+=$invoice_details['total_commission'];            			
                        $cnt++;
                    } 
                    if ($cnt > 0) {?>
                            <tr>
                                <td>&nbsp;</td>
                                <td>&nbsp;</td>
                                <td class="text-right"><b><?= Yii::app()->numberFormatter->formatCurrency($grand_total,"");?></b></td>
                                <td class="text-right"><b><?= Yii::app()->numberFormatter->formatCurrency($total_commission,"");?></b></td>
                                <td class="text-right"><b><?= Yii::app()->numberFormatter->formatCurrency(($grand_total - $total_commission),"");?></b></td>
                            </tr>
            	<?php }
            		else 
            		{
            			echo '<tr class = "' . $class . '"><td colspan="4">No Result Found</td></tr>';
            		}
                    ?>             </tbody>
            </table>
            <input type="hidden" id="dext_customer_id" name="customer_id" value="<?php echo $customer_id; ?>">
            <input type="hidden" id="dext_from_date" name="from_date" value="<?php echo $form_from_date; ?>">
            <input type="hidden" id="dext_to_date" name="to_date" value="<?php echo $form_to_date; ?>">

            <div class="space"></div>
                    <div class="col-6">Created By : 
                            <span><?php echo Yii::app()->user->fullname; ?></span> </div>
                    <div class="col-6 cell-right">Created On : 
                            <span><?php
                                                        $h = "4";// Hour for time zone goes here e.g. +7 or -4, just remove the + or -
$hm = $h * 60;
$ms = $hm * 60;
$gmdate = gmdate("m/d/Y g:i:s A", time()+($ms));
echo $gmdate;
                           // echo date('Y/m/d H:i:s') ?></span> </div>
            <br>
            <div class="btn-wrap text-center">
                <button type="button" class="btn btn-theme" onclick="excelexitinv();">Export Excel</button>
            </div>
        </div>
    </div>
</div>
<?php
$cs = Yii::app()->getClientScript();

$cs->registerScript("excelexitinv", "function excelexitinv()
{
  var customer_id = $('#dailyexit_customer_id').val();
  var from_date = $('#dailyexit_from_date').val();
  var to_date = $('#dailyexit_to_date').val();
  var param = '&to_date=' + to_date + '&from_date=' + from_date+ '&customer_id=' + customer_id;
  var url = $('#liveSite').val() + 'index.php?r=excel/dailyexit'+param;
  window.open(url, '_blank');
}", CClientScript::POS_HEAD);