<?php



class PurchasingOrderController extends Controller

{

	public $layout = 'layout';

	public function accessRules() {

		return array(

				array('allow', // allow all users to perform 'index' and 'view' actions

						'actions' => array('login', 'error', 'logout', 'Forgotpassword', 'Recover', 'companyFieldDetails'),

						'users' => array('*'),

				),

				array('allow', // allow authenticated user to perform 'create' and 'update' actions

						'actions' => array('Index','Create','SaveOrder','GetOrderList','DeleteDocument','GetDocumentList','UploadDocuments','PrintOrderReportPDF'),

                                                'expression' => '$user->isMember()',

				),

				array('deny', // deny all users

						'users' => array('*'),

				),

		);

	}

        public function filters() {

		return array('accessControl'); // perform access control for CRUD operations

	}

	

	

	public function actionIndex()

	{

		$this->render('index');

        }
         public function actionCreate()

	{
            $model = new PurchasingOrder();
            $req_id = (int) Yii::app()->request->getParam('req_id');
            $file_id = (int) Yii::app()->request->getParam('file_id');
            $id = (int) Yii::app()->request->getParam('id');
            $modelEnquiryNonStockItem = array(new PurchasingOrderNonStockItem);
            $modelEnquiryStockItem = array(new PurchasingOrderStockItem);
            $modelOrderAdditions = array(new PurchasingOrderAddition);
            $modelOrderDeduction = array(new PurchasingOrderDeduction);
            $modelOrderNonstockAdditions = array(new PurchasingOrderNonstockAdditions);
            $modelOrderNonstockDeductions = array(new PurchasingOrderNonstockDeductions);
            $modelDocument = new Document();
            $modelNotes = new FileNotes();
            if($req_id > 0)
                {
                    $modelEnquiry=PurchasingEnquiry::model()->findByPk($req_id);
                     foreach ($modelEnquiry->items as $i => $eachItem) {
                        $modelEnquiryStockItem[$i] = new PurchasingOrderStockItem;
                        $modelEnquiryStockItem[$i]->stock_item_id = $eachItem->stock_item_id;
                        $modelEnquiryStockItem[$i]->stock_item_name = $eachItem->stock_item_name;
                        $modelEnquiryStockItem[$i]->stock_item_description = $eachItem->stock_item_description;
                        $modelEnquiryStockItem[$i]->stock_item_unit = $eachItem->stock_item_unit;
                        $modelEnquiryStockItem[$i]->stock_item_quantity = $eachItem->stock_item_quantity;
 
                    }
                     foreach ($modelEnquiry->nonstockitems as $i => $eachItem1) {
                        $modelEnquiryNonStockItem[$i] = new PurchasingOrderNonStockItem;
                        $modelEnquiryNonStockItem[$i]->id = $eachItem1->id;
                        $modelEnquiryNonStockItem[$i]->non_stock_item_name = $eachItem1->non_stock_item_name;
                        $modelEnquiryNonStockItem[$i]->non_stock_item_description = $eachItem1->non_stock_item_description;
                        $modelEnquiryNonStockItem[$i]->non_stock_item_unit = $eachItem1->non_stock_item_unit;
                        $modelEnquiryNonStockItem[$i]->non_stock_item_quantity = $eachItem1->non_stock_item_quantity;              
                    }  
                }
                
            if($id >0)
            {
                $model=$model->findByPk($id);
                $modelEnquiryStockItem = PurchasingOrderStockItem::model()->findAll(array('condition'=>'purchasing_order_id="'.$id.'"')); 
                    if(empty($modelEnquiryStockItem)){
                             $modelEnquiryStockItem = array(new PurchasingOrderStockItem);
                    }
                  
                    $modelEnquiryNonStockItem = PurchasingOrderNonStockItem::model()->findAll(array('condition'=>'purchasing_order_id="'.$id.'"')); 
                    if(empty($modelEnquiryNonStockItem)){
                             $modelEnquiryNonStockItem = array(new PurchasingOrderNonStockItem);
                    }
                    $modelOrderAdditions  = PurchasingOrderAddition::model()->findAll(array('condition'=>'purchasing_order_id="'.$id.'"')); 
                    if(empty($modelOrderAdditions)){
                             $modelOrderAdditions = array(new PurchasingOrderAddition);
                    }
                    $modelOrderDeduction  = PurchasingOrderDeduction::model()->findAll(array('condition'=>'purchasing_order_id="'.$id.'"')); 
                    if(empty($modelOrderDeduction)){
                             $modelOrderDeduction = array(new PurchasingOrderDeduction);
                    }
                    $modelOrderNonstockAdditions  = PurchasingOrderNonstockAdditions::model()->findAll(array('condition'=>'purchasing_order_id="'.$id.'"')); 
                    if(empty($modelOrderNonstockAdditions)){
                             $modelOrderNonstockAdditions = array(new PurchasingOrderNonstockAdditions);
                    }
                    $modelOrderNonstockDeductions  = PurchasingOrderNonstockDeductions::model()->findAll(array('condition'=>'purchasing_order_id="'.$id.'"')); 
                    if(empty($modelOrderNonstockDeductions)){
                             $modelOrderNonstockDeductions = array(new PurchasingOrderNonstockDeductions);
                    }
            }
            Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false , 'jquery-2.1.4.min.js' => false);
            $this->render('create',array('model'=>$model,'file_id'=>$file_id,'modelEnquiry'=>$modelEnquiry,
                                            'modelEnquiryStockItem'=>$modelEnquiryStockItem,
                                            'modelEnquiryNonStockItem'=>$modelEnquiryNonStockItem,
                                            'modelDocument'=>$modelDocument,'modelNotes'=>$modelNotes,
                                            'modelOrderAdditions'=>$modelOrderAdditions,
                                            'modelOrderDeduction'=>$modelOrderDeduction,
                                            'modelOrderNonstockAdditions'=>$modelOrderNonstockAdditions,
                                            'modelOrderNonstockDeductions'=>$modelOrderNonstockDeductions));
        }   
        public function actionSaveOrder()
        {
            $file_id = $_POST['hid_file_id'];
            $modelOrder = new PurchasingOrder;
            $modelOrderStockItem = array(new PurchasingOrderStockItem);
            $modelOrderNonStockItem = array(new PurchasingOrderNonStockItem);
            $order_id = (int) Yii::app()->request->getParam('id');
            $modelNotes = new FileNotes();
            $modelDocument = new Document();
            
        if ($order_id > 0) {
            $modelOrder = $modelOrder->findByPK($order_id);
            $modelOrder->attributes = $_POST['PurchasingOrders'];
            $modelOrder->file_id = $_POST['hid_file_id'];
            $modelOrderItem = $modelOrder->items;          
        }
        if (isset($_POST['PurchasingOrder'])) {
            if ((int) $_POST['PurchasingOrder']['id'] > 0) {
                $modelOrder = $modelOrder->findByPK($_POST['PurchasingOrder']['id']);
                $modelOrder->scenario = 'update';
            }
            $modelOrder->attributes = $_POST['PurchasingOrder'];
            $modelOrder->currency = $_POST['PurchasingOrder']['currency'];
            $modelOrder->crm_user_id = Yii::app()->user->id;
             if($_POST['PurchasingOrder']['order_date']!='00/00/0000')
                {
                        $modelOrder->order_date = str_replace('/', '-', $_POST['PurchasingOrder']['order_date']);
                        $modelOrder->order_date= date("Y-m-d", strtotime($modelOrder->order_date));
                }
                if($_POST['PurchasingOrder']['expected_delivery_date']!='00/00/0000')
                {
                        $modelOrder->expected_delivery_date = str_replace('/', '-', $_POST['PurchasingOrder']['expected_delivery_date']);
                        $modelOrder->expected_delivery_date= date("Y-m-d", strtotime($modelOrder->expected_delivery_date));
                }
                if($_POST['PurchasingOrder']['required_date']!='00/00/0000')
                {
                        $modelOrder->required_date = str_replace('/', '-', $_POST['PurchasingOrder']['required_date']);
                        $modelOrder->required_date= date("Y-m-d", strtotime($modelOrder->required_date));
                }
                $modelOrder->file_id = $_POST['hid_file_id'];

            if ($modelOrder->validate()){
                                   
                           if($modelOrder->save())
                           {
                               if (!empty($_POST['PurchasingOrderStockItem'])) {

                                    foreach ($_POST['PurchasingOrderStockItem'] as $k => $rowItem) {
                                               if(empty($rowItem['id']))
                                               {
                                                   $modelOrderStockItem[$k] = new PurchasingOrderStockItem();
                                               }else{
                                                   $modelOrderStockItem[$k] = PurchasingOrderStockItem::model()->findByPk($rowItem['id']);
                                               }
                                               $modelOrderStockItem[$k]->purchasing_order_id = $modelOrder->id;
                                               $modelOrderStockItem[$k]->stock_item_id = $rowItem['stock_item_id'];
                                               $modelOrderStockItem[$k]->stock_item_quantity = $rowItem['stock_item_quantity'];
                                               $modelOrderStockItem[$k]->stock_item_name = $rowItem['stock_item_name'];
                                               $modelOrderStockItem[$k]->stock_item_description = $rowItem['stock_item_description'];
                                               $modelOrderStockItem[$k]->stock_item_unit = $rowItem['stock_item_unit'];
                                               $modelOrderStockItem[$k]->stock_item_rate = $rowItem['stock_item_rate'];
                                               $modelOrderStockItem[$k]->stock_item_amount = $rowItem['stock_item_amount'];
                                               $stockgrand_total += $rowItem['stock_item_amount'];
                                               $modelOrderStockItem[$k]->save(false);
                                    }
                                }
                                if (!empty($_POST['PurchasingOrderNonStockItem'])) {

                                    foreach ($_POST['PurchasingOrderNonStockItem'] as $k => $rowItem) {
                                               if(empty($rowItem['id']))
                                               {
                                                   $modelOrderNonStockItem[$k] = new PurchasingOrderNonStockItem();
                                               }else{
                                                   $modelOrderNonStockItem[$k] = PurchasingOrderNonStockItem::model()->findByPk($rowItem['id']);
                                               }
                                               $modelOrderNonStockItem[$k]->purchasing_order_id = $modelOrder->id;
                                               $modelOrderNonStockItem[$k]->non_stock_item_quantity = $rowItem['non_stock_item_quantity'];
                                               $modelOrderNonStockItem[$k]->non_stock_item_name  = $rowItem['non_stock_item_name'];
                                               $modelOrderNonStockItem[$k]->non_stock_item_description  = $rowItem['non_stock_item_description'];
                                               $modelOrderNonStockItem[$k]->non_stock_item_unit  = $rowItem['non_stock_item_unit']; 
                                               $modelOrderNonStockItem[$k]->non_stock_item_rate  = $rowItem['non_stock_item_rate']; 
                                               $modelOrderNonStockItem[$k]->non_stock_item_amount  = $rowItem['non_stock_item_amount']; 
                                               $nonstock_grandtotal += $rowItem['non_stock_item_amount'];
                                               $modelOrderNonStockItem[$k]->save(false);
                                    }
                                }
                                if (!empty($_POST['PurchasingOrderAddition'])) {

                                    foreach ($_POST['PurchasingOrderAddition'] as $k => $rowItem) {
                                               if(empty($rowItem['id']))
                                               {
                                                   $modelPurchasingOrderAddition[$k] = new PurchasingOrderAddition();
                                               }else{
                                                   $modelPurchasingOrderAddition[$k] = PurchasingOrderAddition::model()->findByPk($rowItem['id']);
                                               }
                                               $modelPurchasingOrderAddition[$k]->purchasing_order_id = $modelOrder->id;
                                               $modelPurchasingOrderAddition[$k]->particular_value  = $rowItem['particular_value'];
                                               $modelPurchasingOrderAddition[$k]->calculated_value = $rowItem['calculated_value'];
                                               $modelPurchasingOrderAddition[$k]->particular   = $rowItem['particular'];
                                               $nonstock_grandtotal += $rowItem['calculated_value'];
                                               $modelPurchasingOrderAddition[$k]->save(false);
                                    }
                                }
                                if (!empty($_POST['PurchasingOrderDeduction'])) {

                                    foreach ($_POST['PurchasingOrderDeduction'] as $k => $rowItem) {
                                               if(empty($rowItem['id']))
                                               {
                                                   $modelPurchasingOrderDeduction[$k] = new PurchasingOrderDeduction();
                                               }else{
                                                   $modelPurchasingOrderDeduction[$k] = PurchasingOrderDeduction::model()->findByPk($rowItem['id']);
                                               }
                                               $modelPurchasingOrderDeduction[$k]->purchasing_order_id = $modelOrder->id;
                                               $modelPurchasingOrderDeduction[$k]->particular_value  = $rowItem['particular_value'];
                                               $modelPurchasingOrderDeduction[$k]->calculated_value = $rowItem['calculated_value'];
                                               $modelPurchasingOrderDeduction[$k]->particular   = $rowItem['particular'];
                                               $nonstock_grandtotal -= $rowItem['calculated_value'];
                                               $modelPurchasingOrderDeduction[$k]->save(false);
                                    }
                                }
                                if (!empty($_POST['PurchasingOrderNonstockAdditions'])) {

                                    foreach ($_POST['PurchasingOrderNonstockAdditions'] as $k => $rowItem) {
                                               if(empty($rowItem['id']))
                                               {
                                                   $modelPurchasingOrderNonstockAddition[$k] = new PurchasingOrderNonstockAdditions();
                                               }else{
                                                   $modelPurchasingOrderNonstockAddition[$k] = PurchasingOrderNonstockAdditions::model()->findByPk($rowItem['id']);
                                               }
                                               $modelPurchasingOrderNonstockAddition[$k]->purchasing_order_id = $modelOrder->id;
                                               $modelPurchasingOrderNonstockAddition[$k]->particular_value  = $rowItem['particular_value'];
                                               $modelPurchasingOrderNonstockAddition[$k]->calculated_value = $rowItem['calculated_value'];
                                               $modelPurchasingOrderNonstockAddition[$k]->particular   = $rowItem['particular'];
                                               $grand_total += $rowItem['calculated_value'];
                                               $modelPurchasingOrderNonstockAddition[$k]->save(false);
                                    }
                                }
                                if (!empty($_POST['PurchasingOrderNonstockDeductions'])) {

                                    foreach ($_POST['PurchasingOrderNonstockDeductions'] as $k => $rowItem) {
                                               if(empty($rowItem['id']))
                                               {
                                                   $modelPurchasingOrderNonstockDeduction[$k] = new PurchasingOrderNonstockDeductions();
                                               }else{
                                                   $modelPurchasingOrderNonstockDeduction[$k] = PurchasingOrderNonstockDeductions::model()->findByPk($rowItem['id']);
                                               }
                                               $modelPurchasingOrderNonstockDeduction[$k]->purchasing_order_id = $modelOrder->id;
                                               $modelPurchasingOrderNonstockDeduction[$k]->particular_value  = $rowItem['particular_value'];
                                               $modelPurchasingOrderNonstockDeduction[$k]->calculated_value = $rowItem['calculated_value'];
                                               $modelPurchasingOrderNonstockDeduction[$k]->particular   = $rowItem['particular'];
                                               $grand_total -= $rowItem['calculated_value'];
                                               $modelPurchasingOrderNonstockDeduction[$k]->save(false);
                                    }
                                }
                                
               
                            }
                            if (!empty($_POST['FileNotes'])) 
                                        {   
                                       if ((int) @$_POST['FileNotes']['id'] > 0) 
                                                {
                                                $id = (int) @$_POST['FileNotes']['id'];
                                                $modelNotes->updated_by = Yii::app()->user->id;
                                                $modelNotes->updated_datetime = date('Y-m-d h:i:s');
                                                $modelNotes = $modelNotes->findByPk($id);

                                                } 
                                            else 
                                                {
                                                $modelNotes->created_by = Yii::app()->user->id;
                                                $modelNotes->created_datetime = date('Y-m-d h:i:s');
                                                $modelNotes->notes=$_POST['FileNotes']['notes'];

                                                $modelNotes->crm_user_id = Yii::app()->user->id;
                                                $modelNotes->customer_vendor_id = $modelOrder->vendor_id;
                                                $modelNotes->customer_vendor_type=2;
                                                $modelNotes->file_note_from=1;
                                                $modelNotes->file_id=$_POST['hid_file_id'];
                                                $modelNotes->save(false);
                                                }
                                     $modelNotes->attributes = $_POST['FileNotes'];
                                     $modelNotes->save(false);           
                                     }
                      if(!empty($_POST['Icon']))
                                 {
                                        if ((int) @$_POST['Document']['id'] > 0) {
                                          $id = (int) @$_POST['Document']['id'];
                                          $modelDocument = Document::model()->findByPk($id);
                                          $modelDocument->updated_by = Yii::app()->user->id;
                                          $modelDocument->updated_datetime = date('Y-m-d h:i:s');
                                          
//                                         
                                          $arr_doc_photos = $_POST['Icon']['file'];
                                        if (!empty($arr_doc_photos)) {
                                                    Document::model()->updateByPk($modelDocument->id, array('document_name' => 'JA'));
                                               }
                                          }
                                        else {
                                                $modelDocument = new Document;
                                                
                                                $arr_doc_photos = $_POST['Icon']['file'];
                                                if (!empty($arr_doc_photos)) {
                                                  $modelDocument->uploaded_from =  "P_R";
                                                 }
                                            $modelDocument->file_id = $_POST['hid_file_id'];
                                            $modelDocument->created_by = Yii::app()->user->id;
                                            $modelDocument->created_datetime = date('Y-m-d h:i:s');
                                        }
                                            $modelDocument->document_name = implode(',', $arr_doc_photos);
                                            $modelDocument->save(false);           
                              }
                $modelOrder->updateByPk($modelOrder->id, array('stock_grand_total' => $stockgrand_total));
                $modelOrder->updateByPk($modelOrder->id, array('nonstock_grandtotal' => $nonstock_grandtotal));
                MasterFile::model()->updateByPk($file_id, array('current_process_status'=>"P_O"));
                $jsonData['id'] = $modelOrder->id;
                $jsonData['order'] = $modelOrder;
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
   
            } else {
                echo "test";
                 $error2 = json_decode(CActiveForm::validate($modelOrder, '', false), true);
                    $error = CJSON::encode($error2);
                    if ($error != '[]')
                        echo $error;
            }
        }
    }
    public function actionGetOrderList() {

        $model = new PurchasingOrder();


        $draw = $_POST['draw'];

        $offset = $_POST['start'];

        $limit = $_POST['length'];

        $columns = array(
            // datatable column index  => database column name
            1 => 't.file_id',
            2 => 't.file_title',
            3 => 't.notes',
            4 => 't.order_date',
            5 => 't.required_date',
            6 =>'t.connected_file',
        );

        $filterColumn = $columns[$_POST['order'][0]['column']];

        $filterOrder = $_POST['order'][0]['dir'];

        $orderBy = $filterColumn . " " . $filterOrder;

        
        $condition = "1=1";
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {

            $searchString = $_POST['search']['value'];

            $condition .= "And( t.file_title LIKE '%" . $searchString . "%' OR t.order_date LIKE '%" . $searchString . "%' )";

        }

        $count = $model->with('file')->count(array('condition' => $condition));

        $model = $model->with('file')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset));

        $recordsTotal = $count;

        $recordsFiltered = $count;

        $data['draw'] = $draw;

        $data['recordsTotal'] = $recordsTotal;

        $data['recordsFiltered'] = $recordsFiltered;

        $rowData = array();

        $i = 1;
     
        
        
       
        foreach ($model as $row) {
             $req_date=date("d/m/Y", strtotime($row->order_date));
            $required_date=date("d/m/Y", strtotime($row->required_date));

            $rowData[] = array($row['file_id'],$row['id'], $row['title'],$req_date, $required_date,
            '<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'purchasingorder/create&id=' . $row['id'] . '&file_id=' . $row['file_id'] . '\',\'Edit Order - ' . $row['file_id'] . '\',\'xl\')" title="Edit"><i class="fa fa-pencil" aria-hidden="true"></i></i></button>
            <a class="btn btn-primary btn-xs" title="Print Order" target="_blank" href="/development/newcumuluserp/index.php?r=purchasingorder/PrintOrderReportPDF&id=' . $row['id'] .' "><i class="fa fa-file-pdf-o" aria-hidden="true"></i></a>');
            
         
            
            
            $i++;

        }

        $data['data'] = $rowData;

        echo json_encode($data);

    }
    public function actionDeleteDocument() {
        $id = $_POST['id'];
        $modelDocument = new Document();
        $modelDocument->deleteByPk($id);
        echo "success";
    }
    public function actionGetDocumentList()

	{

		 $model=new Document();
               
               // echo $file_id;
                $draw    = $_POST['draw'];
                $offset = $_POST['start'];
                $limit  = $_POST['length'];
                                $columns = array(
                // datatable column index  => database column name
                   0=>'t.file_id',                 
                   1 =>'t.document_name',
                   2=>'t.created_by',
                   3=>'t.created_datetime',
                   
                   );
                $filterColumn = $columns[$_POST['order'][0]['column']];
                $filterOrder  = $_POST['order'][0]['dir'];
                $orderBy   = $filterColumn." ".$filterOrder;
                 $condition = 't.isActive="Y" and t.file_id = "'.$_POST['file_id'].'"';
                if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
                {
                  $searchString = $_POST['search']['value'];
                  $condition.=" and (document_name LIKE '%".$searchString."%')";
                }
                $count = $model->count(array('condition'=>$condition));
                $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>$orderBy));
                $recordsTotal = $count;
                $recordsFiltered = $count;
                $data['draw'] = $draw;
                $data['recordsTotal'] = $recordsTotal;
                $data['recordsFiltered'] = $recordsFiltered;
                $rowData=array();
                $m=1;
                foreach ($model as $row)
                {
                    $model2 = User::model()->find(array('condition'=>'t.id = "'.$row['created_by'].'"'));
                    $rowData[]=array($m,$row['document_name'],$model2->username,date("d/m/Y h:m:s",strtotime($row['created_datetime'])),
              '<div class="btn-wrap text-center">'
              .'<a href ="#" class="btn btn-danger btn-xs" onclick="deleteDocument(' . $row['id'] . ')"><i class="fa fa-trash-o "></i></a></div>');
                    $m++;
                }
                $data['data'] = $rowData;
                echo json_encode($data);
	}
         public function actionPrintOrderReportPDF() {

        $model = new PurchasingOrder();
        $id = Yii::app()->request->getParam('id');
       if($id>0)
       {
           $model = PurchasingOrder::model()->findByPk($id);
        }
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.order_list_individual', array('model' => $model, 'id' => $id, 'title' => $title),true));
        $mPDF1->Output($htmlTemplate, 'I');
    }
}     
