<?php
$cs = Yii::app()->getClientScript();
$baseUrl = Yii::app()->baseUrl;

$cs->registerScript("load", '$(document).ready(function() {

        var table_id ="#tbl_refund";
        var table = $(table_id).DataTable({
            scrollY         : "380px",
            pageLength      : 50,
			processing: true,
            ajax: {
                url: "' . Yii::app()->createUrl('refund/GetList') . '",
                type: "POST",
                cache : false,
            },
            serverSide:     true,
            fixedColumns:   true,
			processing: true,
        } );
        $(".dataTables_scrollFoot").hide();
    });', CClientScript::POS_HEAD);
    ?>
    <section class="panel">
        <header class="panel-heading clearfix panel-theame">
            <i class="fa fa-send"></i> Refund    
            <div class="pull-right">
                <input type="text" id="refund_from_date" name="refund_from_date" class="datepicker" placeholder="From Date" value="<?php echo date('d/m/Y');?>">
                <input type="text" id="refund_to_date" name="refund_to_date" class="datepicker" placeholder="To Date" value="<?php echo date('d/m/Y');?>">
                <button class="btn btn-sm btn-theme" onclick="exportRefund();"> Export to Excel</button>
                <button class="btn btn-sm btn-theme" onclick="loadPopupModal('refund/create','Add New Refund','lg')"><i class="fa fa-plus"></i> ADD</button>
            </div>
        </header>
        <div class="panel-body">
            <div class="custom-data-table">
                <table class="table table-hover table-bordered personal-task" id="tbl_refund">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Customer</th>
                            <th>Invoice No</th>
                            <th>BOE</th>
                            <th>Amount</th>
                            <th>Requested Date</th>
                            <th>Received Date</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tfoot>
                        <tr>
                            <th>#</th>
                            <th>Customer</th>
                            <th>Invoice No</th>
                            <th>BOE</th>
                            <th>Amount</th>
                            <th>Requested Date</th>
                            <th>Received Date</th>
                            <th>Actions</th>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </section>
    <?php
$cs = Yii::app()->getClientScript();

$cs->registerScript("exportRefund", "function exportRefund()
{
  var from_date     = $('#refund_from_date').val();
  var to_date       = $('#refund_to_date').val();
  var param         = '&from_date='+from_date+'&to_date='+to_date;
  //alert(param);
  var url           = $('#liveSite').val()+'index.php?r=excel/exportrefundlist'+param;
  window.open(url, '_blank');
}", CClientScript::POS_HEAD);
?>
